/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.inbound.option;

import java.util.ArrayList;
import java.util.List;
import link.thingscloud.freeswitch.esl.IEslEventListener;
import link.thingscloud.freeswitch.esl.ServerConnectionListener;
import link.thingscloud.freeswitch.esl.inbound.listener.EventListener;
import link.thingscloud.freeswitch.esl.inbound.listener.ServerOptionListener;
import link.thingscloud.freeswitch.esl.inbound.option.ServerAddrOption;
import link.thingscloud.freeswitch.esl.inbound.option.ServerOption;
import link.thingscloud.freeswitch.esl.util.StringUtils;

public class InboundClientOption {
    private int sndBufSize = 65535;
    private int rcvBufSize = 65535;
    private int workerGroupThread = Runtime.getRuntime().availableProcessors() * 2;
    private int publicExecutorThread = Runtime.getRuntime().availableProcessors() * 2;
    private int privateExecutorThread = Runtime.getRuntime().availableProcessors() * 2;
    private int callbackExecutorThread = Runtime.getRuntime().availableProcessors() * 2;
    private int defaultTimeoutSeconds = 5;
    private String defaultPassword = "ClueCon";
    private int readTimeoutSeconds = 30;
    private int readerIdleTimeSeconds = 25;
    private boolean disablePublicExecutor = false;
    private boolean performance = false;
    private long performanceCostTime = 200L;
    private boolean eventPerformance = false;
    private long eventPerformanceCostTime = 200L;
    private ServerOptionListener serverOptionListener = null;
    private ServerConnectionListener serverConnectionListener = null;
    private final List<ServerOption> serverOptions = new ArrayList<ServerOption>();
    private final ServerAddrOption serverAddrOption = new ServerAddrOption(this.serverOptions);
    private final List<IEslEventListener> listeners = new ArrayList<IEslEventListener>();
    private EventListener eventListener = null;
    private final List<String> events = new ArrayList<String>();

    public int sndBufSize() {
        return this.sndBufSize;
    }

    public InboundClientOption sndBufSize(int sndBufSize) {
        this.sndBufSize = sndBufSize;
        return this;
    }

    public int rcvBufSize() {
        return this.rcvBufSize;
    }

    public InboundClientOption rcvBufSize(int rcvBufSize) {
        this.rcvBufSize = rcvBufSize;
        return this;
    }

    public int workerGroupThread() {
        return this.workerGroupThread;
    }

    public InboundClientOption workerGroupThread(int workerGroupThread) {
        this.workerGroupThread = workerGroupThread;
        return this;
    }

    public int publicExecutorThread() {
        return this.publicExecutorThread;
    }

    public InboundClientOption publicExecutorThread(int publicExecutorThread) {
        this.publicExecutorThread = publicExecutorThread;
        return this;
    }

    public int privateExecutorThread() {
        return this.privateExecutorThread;
    }

    public InboundClientOption privateExecutorThread(int privateExecutorThread) {
        this.privateExecutorThread = privateExecutorThread;
        return this;
    }

    public int callbackExecutorThread() {
        return this.callbackExecutorThread;
    }

    public InboundClientOption callbackExecutorThread(int callbackExecutorThread) {
        this.callbackExecutorThread = callbackExecutorThread;
        return this;
    }

    public int defaultTimeoutSeconds() {
        return this.defaultTimeoutSeconds;
    }

    public InboundClientOption defaultTimeoutSeconds(int defaultTimeoutSeconds) {
        this.defaultTimeoutSeconds = defaultTimeoutSeconds;
        return this;
    }

    public String defaultPassword() {
        return this.defaultPassword;
    }

    public InboundClientOption defaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
        return this;
    }

    public int readTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public InboundClientOption readTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return this;
    }

    public int readerIdleTimeSeconds() {
        return this.readerIdleTimeSeconds;
    }

    public InboundClientOption readerIdleTimeSeconds(int readerIdleTimeSeconds) {
        this.readerIdleTimeSeconds = readerIdleTimeSeconds;
        return this;
    }

    public boolean disablePublicExecutor() {
        return this.disablePublicExecutor;
    }

    public InboundClientOption disablePublicExecutor(boolean disablePublicExecutor) {
        this.disablePublicExecutor = disablePublicExecutor;
        return this;
    }

    public boolean performance() {
        return this.performance;
    }

    public InboundClientOption performance(boolean performance) {
        this.performance = performance;
        return this;
    }

    public long performanceCostTime() {
        return this.performanceCostTime;
    }

    public InboundClientOption performanceCostTime(long performanceCostTime) {
        this.performanceCostTime = performanceCostTime;
        return this;
    }

    public boolean eventPerformance() {
        return this.eventPerformance;
    }

    public InboundClientOption eventPerformance(boolean eventPerformance) {
        this.eventPerformance = eventPerformance;
        return this;
    }

    public long eventPerformanceCostTime() {
        return this.eventPerformanceCostTime;
    }

    public InboundClientOption eventPerformanceCostTime(long eventPerformanceCostTime) {
        this.eventPerformanceCostTime = eventPerformanceCostTime;
        return this;
    }

    public ServerOptionListener serverOptionListener() {
        return this.serverOptionListener;
    }

    public InboundClientOption serverOptionListener(ServerOptionListener serverOptionListener) {
        this.serverOptionListener = serverOptionListener;
        return this;
    }

    public ServerConnectionListener serverConnectionListener() {
        return this.serverConnectionListener;
    }

    public InboundClientOption serverConnectionListener(ServerConnectionListener serverConnectionListener) {
        this.serverConnectionListener = serverConnectionListener;
        return this;
    }

    public ServerAddrOption serverAddrOption() {
        return this.serverAddrOption;
    }

    public List<ServerOption> serverOptions() {
        return this.serverOptions;
    }

    public InboundClientOption addServerOption(ServerOption serverOption) {
        for (ServerOption option : this.serverOptions) {
            if (!StringUtils.equals(option.addr(), serverOption.addr())) continue;
            return this;
        }
        this.serverOptions.add(serverOption);
        if (this.serverOptionListener != null) {
            this.serverOptionListener.onAdded(serverOption);
        }
        return this;
    }

    public InboundClientOption removeServerOption(ServerOption serverOption) {
        this.serverOptions.remove(serverOption);
        if (this.serverOptionListener != null) {
            this.serverOptionListener.onRemoved(serverOption);
        }
        return this;
    }

    public InboundClientOption addListener(IEslEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public InboundClientOption removeListener(IEslEventListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public List<IEslEventListener> listeners() {
        return this.listeners;
    }

    public EventListener eventListener() {
        return this.eventListener;
    }

    public InboundClientOption eventListener(EventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    public List<String> events() {
        return this.events;
    }

    public InboundClientOption addEvents(String ... addEvents) {
        if (addEvents == null) {
            return this;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String addEvent : addEvents) {
            if (this.events().contains(addEvent)) continue;
            list.add(addEvent);
        }
        if (!list.isEmpty()) {
            this.events.addAll(list);
            if (this.eventListener != null) {
                this.eventListener.addEvents(list);
            }
        }
        return this;
    }

    public InboundClientOption cancelEvents() {
        if (!this.events.isEmpty()) {
            if (this.eventListener != null) {
                this.eventListener.cancelEvents();
            }
            this.events.clear();
        }
        return this;
    }

    public String toString() {
        return "InboundClientOption(sndBufSize=" + this.sndBufSize + ", rcvBufSize=" + this.rcvBufSize + ", workerGroupThread=" + this.workerGroupThread + ", publicExecutorThread=" + this.publicExecutorThread + ", privateExecutorThread=" + this.privateExecutorThread + ", callbackExecutorThread=" + this.callbackExecutorThread + ", defaultTimeoutSeconds=" + this.defaultTimeoutSeconds + ", defaultPassword=" + this.defaultPassword + ", readTimeoutSeconds=" + this.readTimeoutSeconds + ", readerIdleTimeSeconds=" + this.readerIdleTimeSeconds + ", disablePublicExecutor=" + this.disablePublicExecutor + ", performance=" + this.performance + ", performanceCostTime=" + this.performanceCostTime + ", eventPerformance=" + this.eventPerformance + ", eventPerformanceCostTime=" + this.eventPerformanceCostTime + ", serverOptionListener=" + this.serverOptionListener + ", serverConnectionListener=" + this.serverConnectionListener + ", serverOptions=" + this.serverOptions + ", serverAddrOption=" + this.serverAddrOption + ", listeners=" + this.listeners + ", eventListener=" + this.eventListener + ", events=" + this.events + ")";
    }
}

