/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.transport.message;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import link.thingscloud.freeswitch.esl.exception.EslDecoderException;
import link.thingscloud.freeswitch.esl.transport.message.EslHeaders;
import link.thingscloud.freeswitch.esl.transport.message.EslMessage;
import link.thingscloud.freeswitch.esl.transport.util.ByteBuilder;
import link.thingscloud.freeswitch.esl.transport.util.HeaderParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EslFrameDecoder
extends ReplayingDecoder<State> {
    private static final Logger log = LoggerFactory.getLogger(EslFrameDecoder.class);
    private static final byte LF = 10;
    private final int maxHeaderSize;
    private EslMessage currentMessage;
    private boolean treatUnknownHeadersAsBody = false;

    public EslFrameDecoder(int maxHeaderSize) {
        super((Object)State.READ_HEADER);
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        this.maxHeaderSize = maxHeaderSize;
    }

    public EslFrameDecoder(int maxHeaderSize, boolean treatUnknownHeadersAsBody) {
        this(maxHeaderSize);
        this.treatUnknownHeadersAsBody = treatUnknownHeadersAsBody;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        log.trace("decode() : state [{}]", this.state());
        switch ((State)((Object)this.state())) {
            case READ_HEADER: {
                if (this.currentMessage == null) {
                    this.currentMessage = new EslMessage();
                }
                boolean reachedDoubleLF = false;
                while (!reachedDoubleLF) {
                    String headerLine = this.readToLineFeedOrFail(buffer, this.maxHeaderSize);
                    log.trace("read header line [{}]", (Object)headerLine);
                    if (!headerLine.isEmpty()) {
                        String[] headerParts = HeaderParser.splitHeader(headerLine);
                        EslHeaders.Name headerName = EslHeaders.Name.fromLiteral(headerParts[0]);
                        if (headerName == null) {
                            if (this.treatUnknownHeadersAsBody) {
                                this.currentMessage.addBodyLine(headerLine);
                            } else {
                                throw new IllegalStateException("Unhandled ESL header [" + headerParts[0] + "]");
                            }
                        }
                        this.currentMessage.addHeader(headerName, headerParts[1]);
                    } else {
                        reachedDoubleLF = true;
                    }
                    this.checkpoint();
                }
                if (this.currentMessage.hasContentLength()) {
                    this.checkpoint((Object)State.READ_BODY);
                    log.trace("have content-length, decoding body ..");
                    return;
                }
                this.checkpoint((Object)State.READ_HEADER);
                EslMessage decodedMessage = this.currentMessage;
                this.currentMessage = null;
                out.add(decodedMessage);
                return;
            }
            case READ_BODY: {
                int contentLength = this.currentMessage.getContentLength();
                ByteBuf bodyBytes = buffer.readBytes(contentLength);
                log.trace("read [{}] body bytes", (Object)bodyBytes.writerIndex());
                while (bodyBytes.isReadable()) {
                    String bodyLine = this.readLine(bodyBytes, contentLength);
                    log.trace("read body line [{}]", (Object)bodyLine);
                    this.currentMessage.addBodyLine(bodyLine);
                }
                if (bodyBytes.refCnt() > 0) {
                    ReferenceCountUtil.safeRelease((Object)bodyBytes);
                }
                this.checkpoint((Object)State.READ_HEADER);
                EslMessage decodedMessage = this.currentMessage;
                this.currentMessage = null;
                out.add(decodedMessage);
                return;
            }
        }
        throw new EslDecoderException("Illegal state: [" + this.state() + "]");
    }

    private String readToLineFeedOrFail(ByteBuf buffer, int maxLineLegth) {
        ByteBuilder builder = ByteBuilder.newBuilder();
        byte nextByte;
        while ((nextByte = buffer.readByte()) != 10) {
            if (builder.length() >= maxLineLegth) {
                throw new TooLongFrameException("ESL header line is longer than " + maxLineLegth + " bytes.");
            }
            builder.append(nextByte);
        }
        return builder.string();
    }

    private String readLine(ByteBuf buffer, int maxLineLength) {
        ByteBuilder builder = ByteBuilder.newBuilder();
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (nextByte == 10) {
                return builder.string();
            }
            if (builder.length() >= maxLineLength) {
                throw new TooLongFrameException("ESL message line is longer than " + maxLineLength + " bytes.");
            }
            builder.append(nextByte);
        }
        return builder.string();
    }

    protected static enum State {
        READ_HEADER,
        READ_BODY;

    }
}

