/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.helper;

import java.util.List;
import java.util.Map;
import link.thingscloud.freeswitch.esl.transport.event.EslEvent;
import link.thingscloud.freeswitch.esl.transport.message.EslHeaders;
import link.thingscloud.freeswitch.esl.transport.message.EslMessage;

public class EslHelper {
    private EslHelper() {
    }

    public static String formatEslEvent(EslEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("#").append(System.lineSeparator());
        sb.append("## message header : ").append(System.lineSeparator());
        Map<EslHeaders.Name, String> messageHeaders = event.getMessageHeaders();
        for (Map.Entry<EslHeaders.Name, String> entry : messageHeaders.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(System.lineSeparator());
        }
        sb.append("## event header : ").append(System.lineSeparator());
        Map<String, String> eventHeaders = event.getEventHeaders();
        for (Map.Entry<String, String> entry : eventHeaders.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(System.lineSeparator());
        }
        sb.append("## event body lines : ").append(System.lineSeparator());
        List<String> list = event.getEventBodyLines();
        for (String eventBodyLine : list) {
            sb.append(eventBodyLine).append(System.lineSeparator());
        }
        sb.append("#").append(System.lineSeparator());
        return sb.toString();
    }

    public static String formatEslMessage(EslMessage message) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("#").append(System.lineSeparator());
        sb.append("## message header : ").append(System.lineSeparator());
        Map<EslHeaders.Name, String> headers = message.getHeaders();
        for (Map.Entry<EslHeaders.Name, String> entry : headers.entrySet()) {
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue()).append(System.lineSeparator());
        }
        sb.append("## event body lines : ").append(System.lineSeparator());
        List<String> eventBodyLines = message.getBodyLines();
        for (String eventBodyLine : eventBodyLines) {
            sb.append(eventBodyLine).append(System.lineSeparator());
        }
        sb.append("#").append(System.lineSeparator());
        return sb.toString();
    }
}

