/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.esl.inbound.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import link.thingscloud.freeswitch.esl.helper.EslHelper;
import link.thingscloud.freeswitch.esl.inbound.listener.ChannelEventListener;
import link.thingscloud.freeswitch.esl.transport.event.EslEvent;
import link.thingscloud.freeswitch.esl.transport.message.EslHeaders;
import link.thingscloud.freeswitch.esl.transport.message.EslMessage;
import link.thingscloud.freeswitch.esl.util.RemotingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundChannelHandler
extends SimpleChannelInboundHandler<EslMessage> {
    private static final Logger log = LoggerFactory.getLogger(InboundChannelHandler.class);
    private static final String MESSAGE_TERMINATOR = "\n\n";
    private static final String LINE_TERMINATOR = "\n";
    private final Lock syncLock = new ReentrantLock();
    private final Queue<SyncCallback> syncCallbacks = new ConcurrentLinkedQueue<SyncCallback>();
    private final ChannelEventListener listener;
    private final ExecutorService publicExecutor;
    private final ExecutorService privateExecutor;
    private final boolean disablePublicExecutor;
    private Channel channel;
    private String remoteAddr;
    private final boolean isTraceEnabled = log.isTraceEnabled();

    public InboundChannelHandler(ChannelEventListener listener, ExecutorService publicExecutor, ExecutorService privateExecutor, boolean disablePublicExecutor) {
        this.listener = listener;
        this.publicExecutor = publicExecutor;
        this.privateExecutor = privateExecutor;
        this.disablePublicExecutor = disablePublicExecutor;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channel = ctx.channel();
        this.remoteAddr = RemotingUtil.socketAddress2String(this.channel.remoteAddress());
        log.debug("channelActive remoteAddr : {}", (Object)this.remoteAddr);
        this.listener.onChannelActive(this.remoteAddr, this);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        log.debug("channelInactive remoteAddr : {}", (Object)this.remoteAddr);
        this.listener.onChannelClosed(this.remoteAddr);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            log.debug("userEventTriggered remoteAddr : {}, evt state : {} ", (Object)this.remoteAddr, (Object)((IdleStateEvent)evt).state());
            this.publicExecutor.execute(() -> this.sendAsyncCommand("bgapi status"));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("exceptionCaught remoteAddr : {}, cause : ", (Object)this.remoteAddr, (Object)cause);
    }

    protected void channelRead0(ChannelHandlerContext ctx, EslMessage msg) {
        String contentType;
        if (this.isTraceEnabled) {
            log.trace("channelRead0 esl message : {}", (Object)EslHelper.formatEslMessage(msg));
        }
        if ((contentType = msg.getContentType()).equals("text/event-plain") || contentType.equals("text/event-xml")) {
            EslEvent eslEvent = new EslEvent(msg);
            this.handleEslEvent(eslEvent);
        } else {
            this.handleEslMessage(msg);
        }
    }

    private void handleEslMessage(EslMessage message) {
        String contentType;
        log.debug("Received message: [{}]", (Object)message);
        switch (contentType = message.getContentType()) {
            case "api/response": {
                log.debug("Api response received [{}]", (Object)message);
                Objects.requireNonNull(this.syncCallbacks.poll()).handle(message);
                break;
            }
            case "command/reply": {
                log.debug("Command reply received [{}]", (Object)message);
                Objects.requireNonNull(this.syncCallbacks.poll()).handle(message);
                break;
            }
            case "auth/request": {
                log.debug("Auth request received [{}]", (Object)message);
                this.privateExecutor.execute(() -> this.listener.handleAuthRequest(this.remoteAddr, this));
                break;
            }
            case "text/disconnect-notice": {
                log.debug("Disconnect notice received [{}]", (Object)message);
                this.publicExecutor.execute(() -> this.listener.handleDisconnectNotice(this.remoteAddr));
                break;
            }
            case "text/rude-rejection": {
                log.debug("Rude rejection received [{}]", (Object)message);
                this.publicExecutor.execute(() -> this.listener.handleRudeRejection(this.remoteAddr));
                break;
            }
            default: {
                log.warn("Unexpected message content type [{}]", (Object)contentType);
            }
        }
    }

    private void handleEslEvent(EslEvent event) {
        if (this.disablePublicExecutor) {
            this.listener.handleEslEvent(this.remoteAddr, event);
        } else {
            this.publicExecutor.execute(() -> this.listener.handleEslEvent(this.remoteAddr, event));
        }
    }

    public EslMessage sendSyncSingleLineCommand(String command) {
        if (this.isTraceEnabled) {
            log.trace("sendSyncSingleLineCommand command : {}", (Object)command);
        }
        SyncCallback callback = new SyncCallback();
        this.syncLock.lock();
        try {
            this.syncCallbacks.add(callback);
            this.channel.writeAndFlush((Object)(command + MESSAGE_TERMINATOR));
        }
        finally {
            this.syncLock.unlock();
        }
        return callback.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EslMessage sendSyncMultiLineCommand(List<String> commandLines) {
        SyncCallback callback = new SyncCallback();
        StringBuilder sb = new StringBuilder();
        for (String line : commandLines) {
            sb.append(line);
            sb.append(LINE_TERMINATOR);
        }
        sb.append(LINE_TERMINATOR);
        if (this.isTraceEnabled) {
            log.trace("sendSyncMultiLineCommand command : {}", (Object)sb.toString());
        }
        this.syncLock.lock();
        try {
            this.syncCallbacks.add(callback);
            this.channel.writeAndFlush((Object)sb.toString());
        }
        finally {
            this.syncLock.unlock();
        }
        return callback.get();
    }

    public String sendAsyncCommand(String command) {
        EslMessage response = this.sendSyncSingleLineCommand(command);
        if (this.isTraceEnabled) {
            log.trace("sendAsyncCommand command : {}, response : {}", (Object)command, (Object)response);
        }
        if (response.hasHeader(EslHeaders.Name.JOB_UUID)) {
            return response.getHeaderValue(EslHeaders.Name.JOB_UUID);
        }
        log.warn("sendAsyncCommand command : {}, response : {}", (Object)command, (Object)EslHelper.formatEslMessage(response));
        throw new IllegalStateException("Missing Job-UUID header in bgapi response");
    }

    public ChannelFuture close() {
        return this.channel.close();
    }

    static class SyncCallback {
        private final CountDownLatch latch = new CountDownLatch(1);
        private EslMessage response;

        SyncCallback() {
        }

        EslMessage get() {
            try {
                log.trace("awaiting latch ... ");
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            log.trace("returning response [{}]", (Object)this.response);
            return this.response;
        }

        void handle(EslMessage response) {
            this.response = response;
            log.trace("releasing latch for response [{}]", (Object)response);
            this.latch.countDown();
        }
    }
}

