/*
 * Decompiled with CFR 0.152.
 */
package live.ditto;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoLogCallback;
import live.ditto.DittoLogLevel;
import live.ditto.internal.swig.ffi.CLogLevel_t;
import live.ditto.internal.swig.ffi.LoggerCb;
import live.ditto.internal.swig.ffi.dittoffi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\"\u0010\u001e\u001a\u00020\u00132\u001a\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020 H\u0007J\u0012\u0010!\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010#\u001a\u00020\u0013H\u0007R*\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR*\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00118F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Llive/ditto/DittoLogger;", "Llive/ditto/internal/swig/ffi/LoggerCb;", "()V", "newValue", "", "emojiLogLevelHeadingsEnabled", "getEmojiLogLevelHeadingsEnabled$annotations", "getEmojiLogLevelHeadingsEnabled", "()Z", "setEmojiLogLevelHeadingsEnabled", "(Z)V", "enabled", "getEnabled$annotations", "getEnabled", "setEnabled", "logCb", "Lkotlin/Function2;", "Llive/ditto/DittoLogLevel;", "", "", "minimumLogLevel", "getMinimumLogLevel$annotations", "getMinimumLogLevel", "()Llive/ditto/DittoLogLevel;", "setMinimumLogLevel", "(Llive/ditto/DittoLogLevel;)V", "ffiCustomLog", "cLogLevel", "Llive/ditto/internal/swig/ffi/CLogLevel_t;", "msg", "setCustomLogCallback", "logCallback", "Llive/ditto/DittoLogCallback;", "setLogFile", "logFile", "unsetCustomLogCallback", "dittocpp_release"})
public final class DittoLogger
extends LoggerCb {
    @NotNull
    public static final DittoLogger INSTANCE = new DittoLogger();
    @Nullable
    private static Function2<? super DittoLogLevel, ? super String, Unit> logCb;

    private DittoLogger() {
    }

    @JvmStatic
    public static final void setLogFile(@Nullable String logFile) {
        byte status = dittoffi.ditto_logger_set_log_file(logFile);
        if (status == -1) {
            String errMsg = dittoffi.ditto_error_message();
            throw new IOException("Failed to set the logfile to `" + logFile + "`: " + errMsg);
        }
    }

    public static final boolean getEnabled() {
        return dittoffi.ditto_logger_enabled_get();
    }

    public static final void setEnabled(boolean newValue) {
        dittoffi.ditto_logger_enabled(newValue);
    }

    @JvmStatic
    public static /* synthetic */ void getEnabled$annotations() {
    }

    @NotNull
    public static final DittoLogLevel getMinimumLogLevel() {
        CLogLevel_t cLogLevel_t = dittoffi.ditto_logger_minimum_log_level_get();
        Intrinsics.checkNotNullExpressionValue((Object)cLogLevel_t, (String)"ditto_logger_minimum_log_level_get()");
        return DittoLogLevel.Companion.fromCLogLevel(cLogLevel_t);
    }

    public static final void setMinimumLogLevel(@NotNull DittoLogLevel newValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)newValue), (String)"newValue");
        dittoffi.ditto_logger_minimum_log_level(newValue.toCLogLevel());
    }

    @JvmStatic
    public static /* synthetic */ void getMinimumLogLevel$annotations() {
    }

    public static final boolean getEmojiLogLevelHeadingsEnabled() {
        return dittoffi.ditto_logger_emoji_headings_enabled_get();
    }

    public static final void setEmojiLogLevelHeadingsEnabled(boolean newValue) {
        dittoffi.ditto_logger_emoji_headings_enabled(newValue);
    }

    @JvmStatic
    public static /* synthetic */ void getEmojiLogLevelHeadingsEnabled$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCustomLogCallback(@Nullable Function2<? super DittoLogLevel, ? super String, Unit> logCallback) {
        DittoLogger dittoLogger = this;
        synchronized (dittoLogger) {
            boolean bl = false;
            if (logCallback != null) {
                logCb = logCallback;
                this.registerCustomLogCb();
            } else {
                this.unregisterCustomLogCb();
                logCb = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    public static final void setCustomLogCallback(@NotNull DittoLogCallback logCb) {
        Intrinsics.checkNotNullParameter((Object)logCb, (String)"logCb");
        INSTANCE.setCustomLogCallback((Function2<? super DittoLogLevel, ? super String, Unit>)((Function2)new Function2<DittoLogLevel, String, Unit>(logCb){
            final /* synthetic */ DittoLogCallback $logCb;
            {
                this.$logCb = $logCb;
                super(2);
            }

            public final void invoke(@NotNull DittoLogLevel logLevel, @NotNull String msg) {
                Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                this.$logCb.log(logLevel, msg);
            }
        }));
    }

    @JvmStatic
    public static final void unsetCustomLogCallback() {
        INSTANCE.setCustomLogCallback(null);
    }

    @Override
    public void ffiCustomLog(@NotNull CLogLevel_t cLogLevel, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)cLogLevel, (String)"cLogLevel");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Function2<? super DittoLogLevel, ? super String, Unit> function2 = logCb;
        Intrinsics.checkNotNull(function2);
        function2.invoke((Object)DittoLogLevel.Companion.fromCLogLevel(cLogLevel), (Object)msg);
    }

    static {
        dittoffi.ditto_logger_init();
    }
}

