/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.internal;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0017\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\t\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\r\u001a\u0004\b\u000e\u0010\u000bR\u001b\u0010\u0010\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Llive/ditto/internal/HostSystem;", "", "properties", "Ljava/util/Properties;", "(Ljava/util/Properties;)V", "hostName", "", "getHostName", "()Ljava/lang/String;", "isAndroid", "", "()Z", "isAndroid$delegate", "Lkotlin/Lazy;", "isLinux", "isLinux$delegate", "isMacOS", "isMacOS$delegate", "isTesting", "setTesting", "(Z)V", "getProperties", "()Ljava/util/Properties;", "arch", "printProperties", "", "systemArchitectureTriple", "tempDirectory", "Ljava/io/File;", "dittocpp_release"})
public final class HostSystem {
    @NotNull
    private final Properties properties;
    private boolean isTesting;
    @NotNull
    private final Lazy isMacOS$delegate;
    @NotNull
    private final Lazy isLinux$delegate;
    @NotNull
    private final Lazy isAndroid$delegate;

    @JvmOverloads
    public HostSystem(@NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"currentThread().stackTrace");
        for (StackTraceElement element : stackTraceElementArray) {
            String string = element.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.className");
            if (!StringsKt.startsWith$default((String)string, (String)"org.junit.", (boolean)false, (int)2, null)) continue;
            this.isTesting = true;
            break;
        }
        this.isMacOS$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ HostSystem this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                String osName = this.this$0.getProperties().getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)osName, (String)"osName");
                return StringsKt.contains((CharSequence)osName, (CharSequence)"mac", (boolean)true);
            }
        }));
        this.isLinux$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ HostSystem this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                String osName = this.this$0.getProperties().getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)osName, (String)"osName");
                return StringsKt.contains((CharSequence)osName, (CharSequence)"linux", (boolean)true);
            }
        }));
        this.isAndroid$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ HostSystem this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                String javaVendor = this.this$0.getProperties().getProperty("java.vendor");
                Intrinsics.checkNotNullExpressionValue((Object)javaVendor, (String)"javaVendor");
                return StringsKt.contains((CharSequence)javaVendor, (CharSequence)"android", (boolean)true);
            }
        }));
    }

    public /* synthetic */ HostSystem(Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Properties properties2 = System.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"getProperties()");
            properties = properties2;
        }
        this(properties);
    }

    @NotNull
    public final Properties getProperties() {
        return this.properties;
    }

    public final boolean isTesting() {
        return this.isTesting;
    }

    public final void setTesting(boolean bl) {
        this.isTesting = bl;
    }

    public final void printProperties() {
        this.properties.list(System.out);
    }

    public final boolean isMacOS() {
        Lazy lazy = this.isMacOS$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isLinux() {
        Lazy lazy = this.isLinux$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isAndroid() {
        Lazy lazy = this.isAndroid$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final String arch() {
        String string = this.properties.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties.getProperty(\"os.arch\")");
        return string;
    }

    @NotNull
    public final String getHostName() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            String string = localhost.getHostName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localhost.hostName");
            return string;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "Unknown";
        }
    }

    @Nullable
    public final String systemArchitectureTriple() {
        if (this.isMacOS()) {
            return this.arch() + "-apple-darwin";
        }
        if (this.isLinux()) {
            return this.arch() + "-unknown-linux-gnu";
        }
        return null;
    }

    @NotNull
    public final File tempDirectory() {
        File file;
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        File tmpDir = file;
        tmpDir = new File(tmpDir, "dittoffiJNI");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    @JvmOverloads
    public HostSystem() {
        this(null, 1, null);
    }
}

