/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoError;
import live.ditto.internal.HostSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\u0006\u0010\u000e\u001a\u00020\bJ\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/internal/NativeLibraryLoader;", "", "system", "Llive/ditto/internal/HostSystem;", "(Llive/ditto/internal/HostSystem;)V", "getSystem", "()Llive/ditto/internal/HostSystem;", "copyFileUsingStream", "", "is", "Ljava/io/InputStream;", "dest", "Ljava/io/File;", "loadAndroid", "loadDitto", "loadNativeLibraryFromBuildDir", "loadNativeLibraryFromJar", "dittocpp_release"})
public final class NativeLibraryLoader {
    @NotNull
    private final HostSystem system;

    @JvmOverloads
    public NativeLibraryLoader(@NotNull HostSystem system) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        this.system = system;
    }

    public /* synthetic */ NativeLibraryLoader(HostSystem hostSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            hostSystem = new HostSystem(null, 1, null);
        }
        this(hostSystem);
    }

    @NotNull
    public final HostSystem getSystem() {
        return this.system;
    }

    public final void loadDitto() {
        if (this.system.isAndroid()) {
            this.loadAndroid();
        } else if (this.system.isTesting()) {
            this.loadNativeLibraryFromBuildDir();
        } else {
            this.loadNativeLibraryFromJar();
        }
    }

    private final void loadAndroid() {
        try {
            System.loadLibrary("ditto");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Native library failed to load. \n" + e);
            throw new DittoError.FatalError("Native library failed to load.\n" + e);
        }
    }

    private final void loadNativeLibraryFromBuildDir() {
        String libName = "libditto.dylib";
        String relativePath = new File("../dittojava/build").getPath();
        String str = null;
        try {
            str = new File(relativePath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        String libPath = str + "/native/x86_64-apple-darwin/" + libName;
        try {
            System.load(libPath);
            return;
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Native library failed to load. \n" + e);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void loadNativeLibraryFromJar() {
        String libName = "libditto.dylib";
        String libPath = "native/" + this.system.systemArchitectureTriple() + "/" + libName;
        ClassLoader classLoader = NativeLibraryLoader.class.getClassLoader();
        if (classLoader != null) {
            ClassLoader it = classLoader;
            boolean bl = false;
            URL url = it.getResource(libPath);
            System.out.println((Object)("Loading native library at path: " + url));
            try {
                File tmpDir = this.system.tempDirectory();
                tmpDir.deleteOnExit();
                File nativeLibTmpFile = new File(tmpDir, libName);
                nativeLibTmpFile.deleteOnExit();
                InputStream sourceStream = it.getResourceAsStream(libPath);
                Intrinsics.checkNotNullExpressionValue((Object)sourceStream, (String)"sourceStream");
                this.copyFileUsingStream(sourceStream, nativeLibTmpFile);
                System.load(nativeLibTmpFile.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println("Failed to copy native library to temp directory. \n" + e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Native library failed to load. \n" + e);
                System.exit(2);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyFileUsingStream(InputStream is, File dest) throws IOException {
        OutputStream os = new FileOutputStream(dest);
        try {
            byte[] buffer = new byte[1024];
            int length = 0;
            while (true) {
                int n;
                int it = n = is.read(buffer);
                boolean bl = false;
                length = it;
                if (n > 0) {
                    os.write(buffer, 0, length);
                    continue;
                }
                break;
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    @JvmOverloads
    public NativeLibraryLoader() {
        this(null, 1, null);
    }
}

