/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoLog;
import live.ditto.transports.DittoBluetoothManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u000fH\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Llive/ditto/transports/AppLifecycleListener;", "Landroidx/lifecycle/LifecycleObserver;", "manager", "Llive/ditto/transports/DittoBluetoothManager;", "(Llive/ditto/transports/DittoBluetoothManager;)V", "lastRestartTime", "", "getLastRestartTime", "()J", "setLastRestartTime", "(J)V", "Ljava/lang/ref/WeakReference;", "getManager", "()Ljava/lang/ref/WeakReference;", "onMoveToBackground", "", "onMoveToForeground", "dittocpp_release"})
public final class AppLifecycleListener
implements LifecycleObserver {
    @NotNull
    private final WeakReference<DittoBluetoothManager> manager;
    private long lastRestartTime;

    public AppLifecycleListener(@NotNull DittoBluetoothManager manager2) {
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        this.manager = new WeakReference<DittoBluetoothManager>(manager2);
        this.lastRestartTime = System.currentTimeMillis();
    }

    @NotNull
    public final WeakReference<DittoBluetoothManager> getManager() {
        return this.manager;
    }

    public final long getLastRestartTime() {
        return this.lastRestartTime;
    }

    public final void setLastRestartTime(long l) {
        this.lastRestartTime = l;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public final void onMoveToForeground() {
        DittoLog.d$default("AppLifecycle", "To foreground", null, 4, null);
        DittoBluetoothManager dittoBluetoothManager = (DittoBluetoothManager)this.manager.get();
        if (dittoBluetoothManager != null) {
            dittoBluetoothManager.setInForeground$dittocpp_release(true);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public final void onMoveToBackground() {
        DittoLog.d$default("AppLifecycle", "To background", null, 4, null);
        DittoBluetoothManager dittoBluetoothManager = (DittoBluetoothManager)this.manager.get();
        if (dittoBluetoothManager != null) {
            dittoBluetoothManager.setInForeground$dittocpp_release(false);
        }
    }
}

