/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.AdvertisingSet;
import android.bluetooth.le.AdvertisingSetCallback;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import live.ditto.DittoLog;
import live.ditto.internal.swig.ffi.BleDataType_t;
import live.ditto.internal.swig.ffi.BluetoothLeRadioRust;
import live.ditto.internal.swig.ffi.ConnectState_t;
import live.ditto.internal.swig.ffi.OnlineState_t;
import live.ditto.internal.swig.ffi.SendResult_t;
import live.ditto.internal.swig.ffi.TransportCondition_t;
import live.ditto.internal.swig.ffi.slice_mut_uint8_t;
import live.ditto.transports.BluetoothPlatform;
import live.ditto.transports.DittoBluetoothManager;
import live.ditto.transports.DittoSyncPermissions;
import live.ditto.transports.L2capConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0000\u0018\u0000 \u0087\u00012\u00020\u0001:\u0002\u0087\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010P\u001a\u00020;H\u0016J\b\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020R2\u0006\u0010T\u001a\u00020LH\u0016J\u000e\u0010U\u001a\u00020R2\u0006\u0010V\u001a\u00020(J\u0010\u0010W\u001a\u00020R2\u0006\u0010T\u001a\u00020LH\u0016J\u0006\u0010X\u001a\u00020RJ\u0006\u0010Y\u001a\u00020RJ\u0006\u0010Z\u001a\u00020RJ\u0006\u0010[\u001a\u00020RJ\u001a\u0010\\\u001a\u0004\u0018\u00010/2\u0006\u0010V\u001a\u00020(2\u0006\u0010]\u001a\u00020\bH\u0002J\b\u0010^\u001a\u00020_H\u0016J\b\u0010`\u001a\u00020_H\u0016J\b\u0010a\u001a\u00020RH\u0002J\b\u0010b\u001a\u00020RH\u0003J\b\u0010c\u001a\u00020RH\u0002J\b\u0010d\u001a\u00020RH\u0002J\b\u0010e\u001a\u00020RH\u0002J\b\u0010f\u001a\u00020RH\u0002J\u0010\u0010g\u001a\u00020\u001e2\u0006\u0010]\u001a\u00020LH\u0002J\u0010\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020LH\u0002J\u0010\u0010j\u001a\u00020L2\u0006\u0010k\u001a\u00020\u001eH\u0002J \u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020L2\u0006\u0010q\u001a\u00020LH\u0016J\u0018\u0010r\u001a\u00020\u00052\u0006\u0010p\u001a\u00020L2\u0006\u0010q\u001a\u00020sH\u0016J\u0018\u0010t\u001a\u00020\u00052\u0006\u0010T\u001a\u00020L2\u0006\u0010q\u001a\u00020sH\u0016J\u0006\u0010u\u001a\u00020RJ\r\u0010v\u001a\u00020RH\u0000\u00a2\u0006\u0002\bwJ\b\u0010x\u001a\u00020RH\u0002J\b\u0010y\u001a\u00020RH\u0002J\u0018\u0010z\u001a\u00020\u00052\u0006\u0010p\u001a\u00020L2\u0006\u0010q\u001a\u00020LH\u0016J\u0018\u0010{\u001a\u00020\u00052\u0006\u0010T\u001a\u00020L2\u0006\u0010q\u001a\u00020LH\u0016J\u000e\u0010|\u001a\u00020R2\u0006\u0010*\u001a\u00020+J\b\u0010}\u001a\u00020RH\u0002J\u0018\u0010~\u001a\u00020R2\u0006\u0010K\u001a\u00020L2\u0006\u0010\u007f\u001a\u00020\u001eH\u0016J\t\u0010\u0080\u0001\u001a\u00020RH\u0003J\u001a\u0010\u0081\u0001\u001a\u00020R2\u0006\u0010K\u001a\u00020L2\u0007\u0010\u0082\u0001\u001a\u00020\u001eH\u0016J\t\u0010\u0083\u0001\u001a\u00020RH\u0016J\t\u0010\u0084\u0001\u001a\u00020RH\u0016J\u0011\u0010\u0085\u0001\u001a\u00020R2\u0006\u0010V\u001a\u00020(H\u0002J!\u0010\u0086\u0001\u001a\u00020m2\u0006\u0010n\u001a\u00020o2\u0006\u0010T\u001a\u00020L2\u0006\u0010q\u001a\u00020LH\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00110$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020(0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020-0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00110$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002080$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002080$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u001a\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u0004\u0018\u00010IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u0004\u0018\u00010LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u0004\u0018\u00010OX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Llive/ditto/transports/BluetoothPlatform;", "Llive/ditto/internal/swig/ffi/BluetoothLeRadioRust;", "manager", "Llive/ditto/transports/DittoBluetoothManager;", "requestMtu", "", "(Llive/ditto/transports/DittoBluetoothManager;I)V", "CHAR_UUID_ANNOUNCE", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "CHAR_UUID_CONTROL_READ", "CHAR_UUID_CONTROL_WRITE", "CHAR_UUID_PSM", "CHAR_UUID_READ", "CHAR_UUID_WRITE", "CLIENT_CHARACTERISTIC_CONFIG", "NOT_ACCEPTED_NO_WAIT", "", "WRITE_DELAY_MS", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "getAdapter", "()Landroid/bluetooth/BluetoothAdapter;", "adsetCallback", "Landroid/bluetooth/le/AdvertisingSetCallback;", "advertiseCallback", "Landroid/bluetooth/le/AdvertiseCallback;", "advertiser", "Landroid/bluetooth/le/BluetoothLeAdvertiser;", "advertisingAnnounce", "", "advertisingSet", "Landroid/bluetooth/le/AdvertisingSet;", "backgroundThread", "Landroid/os/HandlerThread;", "centralMTUs", "Ljava/util/concurrent/ConcurrentHashMap;", "clientL2capChannels", "Llive/ditto/transports/L2capConnection;", "connectionAttemptStartTimes", "Landroid/bluetooth/BluetoothGatt;", "connections", "context", "Landroid/content/Context;", "controlNotifyDescriptors", "Landroid/bluetooth/BluetoothGattDescriptor;", "controlReadChar", "Landroid/bluetooth/BluetoothGattCharacteristic;", "disconnectionAttemptStartTimes", "gattCallback", "Landroid/bluetooth/BluetoothGattCallback;", "gattServer", "Landroid/bluetooth/BluetoothGattServer;", "handler", "Landroid/os/Handler;", "heardCentrals", "Landroid/bluetooth/BluetoothDevice;", "heardPeripherals", "isAdvertising", "", "isScanning", "l2capServer", "Landroid/bluetooth/BluetoothServerSocket;", "getManager", "()Llive/ditto/transports/DittoBluetoothManager;", "peripheralMTUs", "readChar", "getRequestMtu", "()I", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "scanningAnnounce", "serverCallback", "Landroid/bluetooth/BluetoothGattServerCallback;", "serverL2capChannels", "serviceUuid", "", "use2MPhy", "watchdogTimer", "Ljava/util/Timer;", "appIsInForeground", "close", "", "connectPeripheral", "peripheralUuid", "disconnectGatt", "gatt", "disconnectPeripheral", "doStartAdvertising", "doStartScanning", "doStopAdvertising", "doStopScanning", "findCharacteristicOnGatt", "uuid", "getAdvertisingState", "Llive/ditto/internal/swig/ffi/OnlineState_t;", "getScanningState", "initAdvertiseCallback", "initAdvertiseSetCallback", "initGattCallback", "initScanCallback", "initServerCallback", "initWatchdog", "makeAddressFromUuidBytes", "makeUuid", "uuidBytes", "makeUuidBytesFromAddress", "address", "notifyToCentral", "Llive/ditto/internal/swig/ffi/SendResult_t;", "sendType", "Llive/ditto/internal/swig/ffi/BleDataType_t;", "centralUuid", "data", "readL2capFromCentral", "Llive/ditto/internal/swig/ffi/slice_mut_uint8_t;", "readL2capFromPeripheral", "refreshPermissions", "reportDisabled", "reportDisabled$dittocpp_release", "retryAdvertisingAfterDelay", "retryScanningAfterDelay", "sendL2capToCentral", "sendL2capToPeripheral", "setContext", "startAdvertiser", "startAdvertising", "localName", "startAdvertisingSet", "startScanning", "announce", "stopAdvertising", "stopScanning", "writeOurAnnounceToGatt", "writeToPeripheral", "Companion", "dittocpp_release"})
public final class BluetoothPlatform
extends BluetoothLeRadioRust {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DittoBluetoothManager manager;
    private final int requestMtu;
    @Nullable
    private Context context;
    @Nullable
    private BluetoothGattServer gattServer;
    @Nullable
    private BluetoothLeAdvertiser advertiser;
    @Nullable
    private ScanCallback scanCallback;
    @Nullable
    private BluetoothGattCallback gattCallback;
    @Nullable
    private BluetoothGattServerCallback serverCallback;
    @Nullable
    private AdvertiseCallback advertiseCallback;
    @RequiresApi(value=26)
    @Nullable
    private AdvertisingSetCallback adsetCallback;
    @RequiresApi(value=26)
    @Nullable
    private AdvertisingSet advertisingSet;
    @Nullable
    private HandlerThread backgroundThread;
    @Nullable
    private Handler handler;
    @Nullable
    private Timer watchdogTimer;
    private final long NOT_ACCEPTED_NO_WAIT;
    private final UUID CHAR_UUID_WRITE;
    private final UUID CHAR_UUID_CONTROL_WRITE;
    private final UUID CHAR_UUID_READ;
    private final UUID CHAR_UUID_CONTROL_READ;
    private final UUID CHAR_UUID_ANNOUNCE;
    private final UUID CHAR_UUID_PSM;
    private final UUID CLIENT_CHARACTERISTIC_CONFIG;
    @NotNull
    private String advertisingAnnounce;
    @NotNull
    private String scanningAnnounce;
    @Nullable
    private BluetoothGattCharacteristic readChar;
    @Nullable
    private BluetoothGattCharacteristic controlReadChar;
    @NotNull
    private final ConcurrentHashMap<String, BluetoothDevice> heardPeripherals;
    @NotNull
    private final ConcurrentHashMap<String, BluetoothDevice> heardCentrals;
    @NotNull
    private final ConcurrentHashMap<String, BluetoothGatt> connections;
    @NotNull
    private final ConcurrentHashMap<String, L2capConnection> clientL2capChannels;
    @NotNull
    private final ConcurrentHashMap<String, L2capConnection> serverL2capChannels;
    @Nullable
    private BluetoothServerSocket l2capServer;
    @NotNull
    private final ConcurrentHashMap<BluetoothGatt, Long> connectionAttemptStartTimes;
    @NotNull
    private final ConcurrentHashMap<BluetoothGatt, Long> disconnectionAttemptStartTimes;
    @NotNull
    private final ConcurrentHashMap<String, BluetoothGattDescriptor> controlNotifyDescriptors;
    @NotNull
    private final ConcurrentHashMap<String, Integer> centralMTUs;
    @NotNull
    private final ConcurrentHashMap<String, Integer> peripheralMTUs;
    private boolean isScanning;
    private boolean isAdvertising;
    private final long WRITE_DELAY_MS;
    private boolean use2MPhy;
    @Nullable
    private byte[] serviceUuid;
    @NotNull
    private static String TAG = "BluetoothPlatform";

    public BluetoothPlatform(@NotNull DittoBluetoothManager manager2, int requestMtu) {
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        this.manager = manager2;
        this.requestMtu = requestMtu;
        this.CHAR_UUID_WRITE = UUID.fromString("21098FDF-EEBF-4A35-8A90-FA7E31F54635");
        this.CHAR_UUID_CONTROL_WRITE = UUID.fromString("CA1E82B6-749A-4ED1-A3E4-75E587CA58BE");
        this.CHAR_UUID_READ = UUID.fromString("95F293B1-1923-470F-B8EB-7612679B1EDF");
        this.CHAR_UUID_CONTROL_READ = UUID.fromString("4C5B8FF9-AF58-41E2-A705-43E6250D8903");
        this.CHAR_UUID_ANNOUNCE = UUID.fromString("B69BEE36-D205-48FC-9D71-7DACD797BB7A");
        this.CHAR_UUID_PSM = UUID.fromString("0FE9EE12-1604-4FA7-938A-7C3AD185B6F6");
        this.CLIENT_CHARACTERISTIC_CONFIG = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
        this.advertisingAnnounce = "";
        this.scanningAnnounce = "";
        this.heardPeripherals = new ConcurrentHashMap();
        this.heardCentrals = new ConcurrentHashMap();
        this.connections = new ConcurrentHashMap();
        this.clientL2capChannels = new ConcurrentHashMap();
        this.serverL2capChannels = new ConcurrentHashMap();
        this.connectionAttemptStartTimes = new ConcurrentHashMap();
        this.disconnectionAttemptStartTimes = new ConcurrentHashMap();
        this.controlNotifyDescriptors = new ConcurrentHashMap();
        this.centralMTUs = new ConcurrentHashMap();
        this.peripheralMTUs = new ConcurrentHashMap();
        this.WRITE_DELAY_MS = 5L;
    }

    @NotNull
    public final DittoBluetoothManager getManager() {
        return this.manager;
    }

    public final int getRequestMtu() {
        return this.requestMtu;
    }

    private final BluetoothAdapter getAdapter() {
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        Object object = context.getSystemService("bluetooth");
        BluetoothManager bluetoothManager = object instanceof BluetoothManager ? (BluetoothManager)object : null;
        if (bluetoothManager == null) {
            return null;
        }
        BluetoothManager bluetoothManager2 = bluetoothManager;
        BluetoothAdapter adapter = bluetoothManager2.getAdapter();
        if (adapter == null) {
            DittoLog.w$default(TAG, "BluetoothAdapter is null", null, 4, null);
        }
        return adapter;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.initWatchdog();
        HandlerThread handlerThread = this.backgroundThread = new HandlerThread("ditto-ble");
        Intrinsics.checkNotNull((Object)handlerThread);
        handlerThread.start();
        HandlerThread handlerThread2 = this.backgroundThread;
        Intrinsics.checkNotNull((Object)handlerThread2);
        Looper looper = handlerThread2.getLooper();
        this.handler = new Handler(looper);
    }

    @Override
    public synchronized void connectPeripheral(@NotNull byte[] peripheralUuid) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        DittoLog.d$default(TAG, "Asked to connect to peripheral", null, 4, null);
        BluetoothAdapter adapter = this.getAdapter();
        if (adapter == null) {
            DittoLog.w$default(TAG, "Ignoring request to connect to BLE Peripheral because adapter doesn't exist", null, 4, null);
            return;
        }
        if (adapter.getState() != 12) {
            DittoLog.d$default(TAG, "Ignoring request to connect to BLE Peripheral because adapter state is not STATE_ON", null, 4, null);
            return;
        }
        Ref.ObjectRef gatt = new Ref.ObjectRef();
        gatt.element = this.connections.get(this.makeAddressFromUuidBytes(peripheralUuid));
        if (gatt.element != null && this.connectionAttemptStartTimes.get(gatt.element) != null) {
            DittoLog.w$default(TAG, "Ignoring connection request to existing attempt", null, 4, null);
            return;
        }
        BluetoothDevice device = this.heardPeripherals.get(this.makeAddressFromUuidBytes(peripheralUuid));
        BluetoothGattCallback callback = this.gattCallback;
        if (device == null || callback == null) {
            return;
        }
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.connectPeripheral$lambda-1(gatt, device, this, callback));
    }

    @Override
    public synchronized void disconnectPeripheral(@NotNull byte[] peripheralUuid) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        DittoLog.w$default(TAG, "Asked to disconnect peripheral uuid " + this.makeAddressFromUuidBytes(peripheralUuid), null, 4, null);
        BluetoothGatt gatt = this.connections.get(this.makeAddressFromUuidBytes(peripheralUuid));
        if (gatt != null) {
            this.disconnectGatt(gatt);
        }
    }

    public final synchronized void disconnectGatt(@NotNull BluetoothGatt gatt) {
        Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.disconnectGatt$lambda-2(this, gatt));
        DittoLog.w$default(TAG, "Arming disconnect watchdog", null, 4, null);
        ((Map)this.disconnectionAttemptStartTimes).put(gatt, SystemClock.elapsedRealtime());
    }

    @Override
    @NotNull
    public OnlineState_t getAdvertisingState() {
        OnlineState_t onlineState_t;
        if (this.isAdvertising) {
            OnlineState_t onlineState_t2 = OnlineState_t.ONLINE_STATE_ONLINE;
            onlineState_t = onlineState_t2;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t2, (String)"ONLINE_STATE_ONLINE");
        } else {
            OnlineState_t onlineState_t3 = OnlineState_t.ONLINE_STATE_GOING_OFFLINE;
            onlineState_t = onlineState_t3;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t3, (String)"ONLINE_STATE_GOING_OFFLINE");
        }
        return onlineState_t;
    }

    @Override
    @NotNull
    public OnlineState_t getScanningState() {
        OnlineState_t onlineState_t;
        if (this.isScanning) {
            OnlineState_t onlineState_t2 = OnlineState_t.ONLINE_STATE_ONLINE;
            onlineState_t = onlineState_t2;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t2, (String)"ONLINE_STATE_ONLINE");
        } else {
            OnlineState_t onlineState_t3 = OnlineState_t.ONLINE_STATE_GOING_OFFLINE;
            onlineState_t = onlineState_t3;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t3, (String)"ONLINE_STATE_GOING_OFFLINE");
        }
        return onlineState_t;
    }

    @Override
    @NotNull
    public synchronized SendResult_t notifyToCentral(@NotNull BleDataType_t sendType, @NotNull byte[] centralUuid, @NotNull byte[] data) {
        SendResult_t sendResult_t;
        Intrinsics.checkNotNullParameter((Object)sendType, (String)"sendType");
        Intrinsics.checkNotNullParameter((Object)centralUuid, (String)"centralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BluetoothDevice device = this.heardCentrals.get(this.makeAddressFromUuidBytes(centralUuid));
        if (device != null && this.gattServer != null) {
            SendResult_t sendResult_t2;
            Ref.BooleanRef result = new Ref.BooleanRef();
            Ref.BooleanRef exception = new Ref.BooleanRef();
            Ref.ObjectRef characteristic = new Ref.ObjectRef();
            characteristic.element = this.readChar;
            if (Intrinsics.areEqual((Object)sendType, (Object)BleDataType_t.BLE_DATA_TYPE_CONTROL)) {
                characteristic.element = this.controlReadChar;
            }
            Object object = characteristic.element;
            Intrinsics.checkNotNull((Object)object);
            ((BluetoothGattCharacteristic)object).setValue(data);
            Ref.ObjectRef notifySemaphore = new Ref.ObjectRef();
            notifySemaphore.element = new Semaphore(1);
            ((Semaphore)notifySemaphore.element).acquire();
            Context context = this.context;
            Intrinsics.checkNotNull((Object)context);
            new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.notifyToCentral$lambda-5(this, exception, notifySemaphore, result, device, characteristic, centralUuid));
            ((Semaphore)notifySemaphore.element).acquire();
            if (exception.element) {
                SendResult_t sendResult_t3;
                SendResult_t it = sendResult_t3 = new SendResult_t();
                boolean bl = false;
                it.setWait_for_ready(true);
                it.setAccepted(false);
                return sendResult_t3;
            }
            SendResult_t it = sendResult_t2 = new SendResult_t();
            boolean bl = false;
            it.setWait_for_ready(true);
            it.setAccepted(result.element);
            return sendResult_t2;
        }
        SendResult_t it = sendResult_t = new SendResult_t();
        boolean bl = false;
        it.setAccepted(true);
        it.setWait_for_ready(false);
        return sendResult_t;
    }

    @Override
    public void startAdvertising(@NotNull byte[] serviceUuid, @NotNull String localName) {
        Intrinsics.checkNotNullParameter((Object)serviceUuid, (String)"serviceUuid");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        this.isAdvertising = true;
        this.serviceUuid = serviceUuid;
        this.advertisingAnnounce = localName;
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.startAdvertising$lambda-9(this));
    }

    public final void doStartAdvertising() {
        BluetoothManager bluetoothManager;
        if (this.gattServer != null) {
            return;
        }
        if (this.serviceUuid == null) {
            return;
        }
        if (this.context != null) {
            Context context = this.context;
            Intrinsics.checkNotNull((Object)context);
            if (!(new DittoSyncPermissions(context).missingBluetoothServerPermissions$dittocpp_release().length == 0)) {
                DittoLog.e$default(TAG, "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check both AndroidManifest.xml and calls to ActivityCompat.requestPermissions(). <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                Handler handler = this.handler;
                if (handler != null) {
                    handler.post(() -> BluetoothPlatform.doStartAdvertising$lambda-10(this));
                }
                this.retryAdvertisingAfterDelay();
                return;
            }
        }
        DittoLog.d$default(TAG, "Starting advertising", null, 4, null);
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        Object object = context.getSystemService("bluetooth");
        BluetoothManager bluetoothManager2 = bluetoothManager = object instanceof BluetoothManager ? (BluetoothManager)object : null;
        if (bluetoothManager == null || bluetoothManager.getAdapter() == null) {
            this.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_HARDWARE);
            return;
        }
        this.initServerCallback();
        this.gattServer = bluetoothManager.openGattServer(this.context, this.serverCallback);
        if (this.gattServer != null) {
            Intrinsics.checkNotNull((Object)this.serviceUuid);
            BluetoothGattService service = new BluetoothGattService(this.makeUuid(this.serviceUuid), 0);
            this.readChar = new BluetoothGattCharacteristic(this.CHAR_UUID_READ, 16, 1);
            this.controlReadChar = new BluetoothGattCharacteristic(this.CHAR_UUID_CONTROL_READ, 16, 1);
            BluetoothGattCharacteristic writeChar = new BluetoothGattCharacteristic(this.CHAR_UUID_WRITE, 4, 16);
            BluetoothGattCharacteristic controlWriteChar = new BluetoothGattCharacteristic(this.CHAR_UUID_CONTROL_WRITE, 4, 16);
            BluetoothGattCharacteristic announceChar = new BluetoothGattCharacteristic(this.CHAR_UUID_ANNOUNCE, 8, 16);
            BluetoothGattDescriptor dataDescriptor = new BluetoothGattDescriptor(this.CLIENT_CHARACTERISTIC_CONFIG, 17);
            BluetoothGattDescriptor controlDescriptor = new BluetoothGattDescriptor(this.CLIENT_CHARACTERISTIC_CONFIG, 17);
            BluetoothGattCharacteristic psmChar = new BluetoothGattCharacteristic(this.CHAR_UUID_PSM, 2, 1);
            BluetoothGattCharacteristic bluetoothGattCharacteristic = this.readChar;
            Intrinsics.checkNotNull((Object)bluetoothGattCharacteristic);
            bluetoothGattCharacteristic.addDescriptor(dataDescriptor);
            BluetoothGattCharacteristic bluetoothGattCharacteristic2 = this.controlReadChar;
            Intrinsics.checkNotNull((Object)bluetoothGattCharacteristic2);
            bluetoothGattCharacteristic2.addDescriptor(controlDescriptor);
            service.addCharacteristic(this.readChar);
            service.addCharacteristic(this.controlReadChar);
            service.addCharacteristic(writeChar);
            service.addCharacteristic(controlWriteChar);
            service.addCharacteristic(announceChar);
            if (Build.VERSION.SDK_INT >= 29) {
                service.addCharacteristic(psmChar);
            }
            BluetoothGattServer bluetoothGattServer = this.gattServer;
            Intrinsics.checkNotNull((Object)bluetoothGattServer);
            bluetoothGattServer.addService(service);
            if (Build.VERSION.SDK_INT >= 29) {
                new Thread(() -> BluetoothPlatform.doStartAdvertising$lambda-12(this)).start();
            }
        } else {
            this.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
        }
    }

    private final void startAdvertiser() {
        Intrinsics.checkNotNull((Object)this.serviceUuid);
        UUID sUuid = this.makeUuid(this.serviceUuid);
        AdvertiseSettings settings = new AdvertiseSettings.Builder().setConnectable(true).setTxPowerLevel(this.manager.getConfig().getAdvertisementPower().legacyPowerLevel$dittocpp_release()).setAdvertiseMode(this.manager.getConfig().getAdvertisementInterval().legacyAdvertisementInterval$dittocpp_release()).setTimeout(0).build();
        AdvertiseData data = new AdvertiseData.Builder().addServiceUuid(new ParcelUuid(sUuid)).setIncludeDeviceName(false).build();
        AdvertiseData.Builder builder = new AdvertiseData.Builder().setIncludeDeviceName(false);
        String string = this.advertisingAnnounce;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        AdvertiseData data2 = builder.addManufacturerData(0, byArray).build();
        DittoLog.d$default(TAG, "startAdvertising", null, 4, null);
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.startAdvertiser$lambda-13(this, settings, data, data2));
    }

    @RequiresApi(value=26)
    private final void startAdvertisingSet() {
        Intrinsics.checkNotNull((Object)this.serviceUuid);
        UUID sUuid = this.makeUuid(this.serviceUuid);
        AdvertiseData data = new AdvertiseData.Builder().addServiceUuid(new ParcelUuid(sUuid)).setIncludeDeviceName(false).build();
        AdvertiseData.Builder builder = new AdvertiseData.Builder().setIncludeDeviceName(false);
        String string = this.advertisingAnnounce;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        AdvertiseData data2 = builder.addManufacturerData(0, byArray).build();
        AdvertisingSetParameters adsetparams = new AdvertisingSetParameters.Builder().setConnectable(true).setScannable(true).setLegacyMode(true).build();
        DittoLog.d$default(TAG, "startAdvertiser using AdvertisingSet", null, 4, null);
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.startAdvertisingSet$lambda-14(this, adsetparams, data, data2));
    }

    @Override
    public void stopAdvertising() {
        this.isAdvertising = false;
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.stopAdvertising$lambda-15(this));
    }

    /*
     * WARNING - void declaration
     */
    public final void doStopAdvertising() {
        void $this$mapTo$iv$iv;
        Object server;
        BluetoothLeAdvertiser bluetoothLeAdvertiser = this.advertiser;
        if (bluetoothLeAdvertiser != null) {
            AdvertisingSetCallback callback;
            BluetoothLeAdvertiser advertiser = bluetoothLeAdvertiser;
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 26) {
                AdvertisingSetCallback advertisingSetCallback = this.adsetCallback;
                if (advertisingSetCallback != null) {
                    callback = advertisingSetCallback;
                    boolean bl2 = false;
                    advertiser.stopAdvertisingSet(callback);
                }
                this.adsetCallback = null;
                this.advertisingSet = null;
            } else {
                AdvertiseCallback advertiseCallback = this.advertiseCallback;
                if (advertiseCallback != null) {
                    callback = advertiseCallback;
                    boolean bl3 = false;
                    advertiser.stopAdvertising((AdvertiseCallback)callback);
                }
                this.advertiseCallback = null;
            }
            this.advertiser = null;
        }
        BluetoothGattServer bluetoothGattServer = this.gattServer;
        if (bluetoothGattServer != null) {
            server = bluetoothGattServer;
            boolean bl = false;
            server.clearServices();
            server.close();
            this.serverCallback = null;
            this.gattServer = null;
        }
        Map $this$map$iv = this.serverL2capChannels;
        boolean $i$f$map = false;
        server = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ((L2capConnection)it.getValue()).close();
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.serverL2capChannels.clear();
        BluetoothServerSocket bluetoothServerSocket = this.l2capServer;
        if (bluetoothServerSocket != null) {
            bluetoothServerSocket.close();
        }
        this.l2capServer = null;
    }

    public final void refreshPermissions() {
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.refreshPermissions$lambda-21(this));
    }

    @Override
    public void startScanning(@NotNull byte[] serviceUuid, @NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)serviceUuid, (String)"serviceUuid");
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        DittoLog.i$default(TAG, "Asked to start scanning", null, 4, null);
        this.serviceUuid = serviceUuid;
        this.scanningAnnounce = announce;
        this.isScanning = true;
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.startScanning$lambda-22(this));
    }

    public final void doStartScanning() {
        block9: {
            block8: {
                BluetoothLeScanner scanner;
                if (!this.isScanning) {
                    return;
                }
                if (this.serviceUuid == null) {
                    return;
                }
                Context context = this.context;
                if (context != null && !(new DittoSyncPermissions(context).missingBluetoothClientPermissions$dittocpp_release().length == 0)) {
                    DittoLog.e$default(TAG, "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check both AndroidManifest.xml and calls to ActivityCompat.requestPermissions(). <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                    Handler handler = this.handler;
                    if (handler != null) {
                        handler.post(() -> BluetoothPlatform.doStartScanning$lambda-23(this));
                    }
                    this.retryScanningAfterDelay();
                    return;
                }
                Intrinsics.checkNotNull((Object)this.serviceUuid);
                UUID service = this.makeUuid(this.serviceUuid);
                ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(service)).build();
                ArrayList<ScanFilter> filterList = new ArrayList<ScanFilter>();
                filterList.add(filter);
                ScanSettings settings = new ScanSettings.Builder().setReportDelay(0L).setScanMode(2).build();
                this.initGattCallback();
                BluetoothAdapter adapter = this.getAdapter();
                if (adapter == null) {
                    Handler handler = this.handler;
                    if (handler != null) {
                        handler.post(() -> BluetoothPlatform.doStartScanning$lambda-24(this));
                    }
                    return;
                }
                if (Build.VERSION.SDK_INT >= 26 && adapter.isLe2MPhySupported()) {
                    this.use2MPhy = true;
                }
                if ((scanner = adapter.getBluetoothLeScanner()) == null) break block8;
                this.initScanCallback();
                Handler handler = this.handler;
                if (handler != null) {
                    handler.post(() -> BluetoothPlatform.doStartScanning$lambda-25(this));
                }
                DittoLog.i$default(TAG, "Android Bluetooth starting scanning, assuming success", null, 4, null);
                adapter.getBluetoothLeScanner().startScan((List)filterList, settings, this.scanCallback);
                break block9;
            }
            DittoLog.i$default(TAG, "Android Bluetooth not starting scanning because hardware is disabled", null, 4, null);
            Handler handler = this.handler;
            if (handler == null) break block9;
            handler.post(() -> BluetoothPlatform.doStartScanning$lambda-26(this));
        }
    }

    @Override
    public void stopScanning() {
        this.isScanning = false;
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.stopScanning$lambda-27(this));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void doStopScanning() {
        void $this$mapTo$iv$iv;
        Object callback;
        BluetoothAdapter adapter = this.getAdapter();
        if (adapter == null) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post(() -> BluetoothPlatform.doStopScanning$lambda-28(this));
            }
            return;
        }
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post(() -> BluetoothPlatform.doStopScanning$lambda-29(this));
            }
            return;
        }
        ScanCallback scanCallback = this.scanCallback;
        if (scanCallback != null) {
            callback = scanCallback;
            boolean bl = false;
            scanner.stopScan(callback);
        }
        this.scanCallback = null;
        Map $this$map$iv = this.clientL2capChannels;
        boolean $i$f$map = false;
        callback = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ((L2capConnection)it.getValue()).close();
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.clientL2capChannels.clear();
    }

    @Override
    @NotNull
    public synchronized SendResult_t writeToPeripheral(@NotNull BleDataType_t sendType, @NotNull byte[] peripheralUuid, @NotNull byte[] data) {
        SendResult_t sendResult_t;
        Intrinsics.checkNotNullParameter((Object)sendType, (String)"sendType");
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BluetoothGatt gatt = this.connections.get(this.makeAddressFromUuidBytes(peripheralUuid));
        if (gatt == null) {
            SendResult_t sendResult_t2;
            DittoLog.w$default(TAG, "Asked to write to unknown Gatt", null, 4, null);
            SendResult_t it = sendResult_t2 = new SendResult_t();
            boolean bl = false;
            it.setWait_for_ready(false);
            it.setAccepted(false);
            return sendResult_t2;
        }
        UUID charUuid = this.CHAR_UUID_WRITE;
        if (Intrinsics.areEqual((Object)sendType, (Object)BleDataType_t.BLE_DATA_TYPE_CONTROL)) {
            charUuid = this.CHAR_UUID_CONTROL_WRITE;
        }
        UUID uUID = charUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"charUuid");
        BluetoothGattCharacteristic meshDataChar = this.findCharacteristicOnGatt(gatt, uUID);
        if (meshDataChar == null) {
            SendResult_t bl;
            DittoLog.w$default(TAG, "Asked to write to a Gatt that didn't have the Write char", null, 4, null);
            SendResult_t it = bl = new SendResult_t();
            boolean bl2 = false;
            it.setWait_for_ready(false);
            it.setAccepted(false);
            return bl;
        }
        meshDataChar.setWriteType(1);
        meshDataChar.setValue(data);
        Ref.ObjectRef writeSemaphore = new Ref.ObjectRef();
        writeSemaphore.element = new Semaphore(1);
        ((Semaphore)writeSemaphore.element).acquire();
        Ref.BooleanRef result = new Ref.BooleanRef();
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.writeToPeripheral$lambda-34(result, gatt, meshDataChar, writeSemaphore));
        ((Semaphore)writeSemaphore.element).acquire();
        SendResult_t it = sendResult_t = new SendResult_t();
        boolean bl = false;
        it.setWait_for_ready(true);
        it.setAccepted(result.element);
        return sendResult_t;
    }

    @Override
    public int readL2capFromCentral(@NotNull byte[] centralUuid, @NotNull slice_mut_uint8_t data) {
        L2capConnection maybeConn;
        Intrinsics.checkNotNullParameter((Object)centralUuid, (String)"centralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        L2capConnection l2capConnection = maybeConn = this.serverL2capChannels.get(this.makeAddressFromUuidBytes(centralUuid));
        if (l2capConnection != null) {
            L2capConnection conn = l2capConnection;
            boolean bl = false;
            byte[] byArray = conn.read((int)data.getCapacity());
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl2 = false;
                data.setValue(it);
                return it.length;
            }
            return -2;
        }
        return -1;
    }

    @Override
    public int sendL2capToCentral(@NotNull byte[] centralUuid, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)centralUuid, (String)"centralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        L2capConnection maybeConn = this.serverL2capChannels.get(this.makeAddressFromUuidBytes(centralUuid));
        if (maybeConn != null) {
            L2capConnection conn = maybeConn;
            boolean bl = false;
            if (conn.send(data)) {
                return data.length;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int readL2capFromPeripheral(@NotNull byte[] peripheralUuid, @NotNull slice_mut_uint8_t data) {
        L2capConnection maybeConn;
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        L2capConnection l2capConnection = maybeConn = this.clientL2capChannels.get(this.makeAddressFromUuidBytes(peripheralUuid));
        if (l2capConnection != null) {
            L2capConnection conn = l2capConnection;
            boolean bl = false;
            byte[] byArray = conn.read((int)data.getCapacity());
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl2 = false;
                data.setValue(it);
                return it.length;
            }
            return -2;
        }
        return -1;
    }

    @Override
    public int sendL2capToPeripheral(@NotNull byte[] peripheralUuid, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        L2capConnection maybeConn = this.clientL2capChannels.get(this.makeAddressFromUuidBytes(peripheralUuid));
        if (maybeConn != null) {
            L2capConnection conn = maybeConn;
            boolean bl = false;
            if (conn.send(data)) {
                return data.length;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public boolean appIsInForeground() {
        return this.manager.getInForeground$dittocpp_release();
    }

    @Override
    public void close() {
        super.close();
        this.stopScanning();
        this.stopAdvertising();
        Timer timer = this.watchdogTimer;
        if (timer != null) {
            timer.cancel();
        }
        this.watchdogTimer = null;
        this.handler = null;
        this.gattCallback = null;
        HandlerThread handlerThread = this.backgroundThread;
        if (handlerThread != null) {
            handlerThread.quit();
        }
        this.backgroundThread = null;
        this.dropBleServerTransport();
        this.dropBleClientTransport();
    }

    public final void reportDisabled$dittocpp_release() {
        Handler handler = this.handler;
        if (handler != null) {
            handler.post(() -> BluetoothPlatform.reportDisabled$lambda-42(this));
        }
        this.advertisingStateChanged(this.getAdvertisingState(), TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
    }

    private final UUID makeUuid(byte[] uuidBytes) {
        ByteBuffer bb = ByteBuffer.wrap(uuidBytes);
        return new UUID(bb.getLong(), bb.getLong());
    }

    private final byte[] makeUuidBytesFromAddress(String address) {
        List list;
        CharSequence charSequence = address;
        Regex regex = new Regex(":");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray;
        byte[] uuid = new byte[16];
        for (int i = 0; i < 16; ++i) {
            if (i > 5) {
                uuid[i] = 0;
                continue;
            }
            int hex = Integer.parseInt(parts[i], 16);
            uuid[i] = (byte)hex;
        }
        return uuid;
    }

    private final String makeAddressFromUuidBytes(byte[] uuid) {
        String string = "%02X:%02X:%02X:%02X:%02X:%02X";
        Object[] objectArray = new Object[]{uuid[0], uuid[1], uuid[2], uuid[3], uuid[4], uuid[5]};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private final BluetoothGattCharacteristic findCharacteristicOnGatt(BluetoothGatt gatt, UUID uuid) {
        for (BluetoothGattService service : gatt.getServices()) {
            for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
                if (!Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)uuid)) continue;
                return characteristic;
            }
        }
        return null;
    }

    private final void initScanCallback() {
        this.scanCallback = new ScanCallback(this){
            final /* synthetic */ BluetoothPlatform this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @NotNull ScanResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                BluetoothAdapter adapter = BluetoothPlatform.access$getAdapter(this.this$0);
                if (adapter != null && adapter.getState() == 12) {
                    Object object;
                    Object object2;
                    String string = result.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.device.address");
                    byte[] uuid = BluetoothPlatform.access$makeUuidBytesFromAddress(this.this$0, string);
                    ScanRecord scanRecord = result.getScanRecord();
                    if (scanRecord == null) {
                        return;
                    }
                    ScanRecord record = scanRecord;
                    String localName = record.getDeviceName();
                    byte[] manuData = record.getManufacturerSpecificData(0);
                    float rssi = result.getRssi();
                    Ref.ObjectRef announce = new Ref.ObjectRef();
                    if (manuData != null) {
                        object2 = manuData;
                        Charset charset = Charset.defaultCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                        object = charset;
                        announce.element = new String((byte[])object2, (Charset)object);
                    } else {
                        announce.element = localName;
                    }
                    Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                    if (handler != null) {
                        handler.post(() -> initScanCallback.1.onScanResult$lambda-0(this.this$0, uuid, announce, rssi));
                    }
                    object2 = BluetoothPlatform.access$getHeardPeripherals$p(this.this$0);
                    String string2 = result.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.device.address");
                    object = string2;
                    BluetoothDevice bluetoothDevice = result.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"result.device");
                    BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                    object2.put(object, bluetoothDevice2);
                }
            }

            public void onScanFailed(int errorCode) {
                DittoLog.e$default(BluetoothPlatform.Companion.getTAG(), "Ditto Bluetooth LE sync is restricted due to missing Bluetooth or ACCESS_FINE_LOCATION permissions. Please check both manifest and call to ActivityCompat.requestPermissions(). <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                if (handler != null) {
                    handler.post(() -> initScanCallback.1.onScanFailed$lambda-1(this.this$0));
                }
                BluetoothPlatform.access$retryScanningAfterDelay(this.this$0);
            }

            public void onBatchScanResults(@NotNull List<ScanResult> results) {
                Intrinsics.checkNotNullParameter(results, (String)"results");
                DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Received batch scan results unexpectedly", null, 4, null);
            }

            private static final void onScanResult$lambda-0(BluetoothPlatform this$0, byte[] $uuid, Ref.ObjectRef $announce, float $rssi) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$uuid, (String)"$uuid");
                Intrinsics.checkNotNullParameter((Object)$announce, (String)"$announce");
                this$0.advertisementHeard($uuid, (String)$announce.element, $rssi);
            }

            private static final void onScanFailed$lambda-1(BluetoothPlatform this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_CENTRAL_PERMISSION);
            }
        };
    }

    private final void retryScanningAfterDelay() {
        this.scanCallback = null;
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).postDelayed(() -> BluetoothPlatform.retryScanningAfterDelay$lambda-44(this), 10000L);
    }

    private final void retryAdvertisingAfterDelay() {
        BluetoothGattServer bluetoothGattServer = this.gattServer;
        if (bluetoothGattServer != null) {
            bluetoothGattServer.clearServices();
        }
        BluetoothGattServer bluetoothGattServer2 = this.gattServer;
        if (bluetoothGattServer2 != null) {
            bluetoothGattServer2.close();
        }
        this.gattServer = null;
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).postDelayed(() -> BluetoothPlatform.retryAdvertisingAfterDelay$lambda-45(this), 10000L);
    }

    private final void initGattCallback() {
        this.gattCallback = new BluetoothGattCallback(this){
            final /* synthetic */ BluetoothPlatform this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConnectionStateChange(@NotNull BluetoothGatt gatt, int status, int newState) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                BluetoothGatt existingGatt = (BluetoothGatt)BluetoothPlatform.access$getConnections$p(this.this$0).get(gatt.getDevice().getAddress());
                if (!Intrinsics.areEqual((Object)existingGatt, (Object)gatt)) {
                    if (newState == 2) {
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Cleaning up a wayward BluetoothGatt", null, 4, null);
                        this.this$0.disconnectGatt(gatt);
                    }
                    return;
                }
                switch (newState) {
                    case 0: {
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler != null) {
                            handler.post(() -> initGattCallback.1.onConnectionStateChange$lambda-0(this.this$0, gatt));
                        }
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Disconnected from remote peripheral", null, 4, null);
                        BluetoothPlatform.access$getConnections$p(this.this$0).remove(gatt.getDevice().getAddress());
                        BluetoothPlatform.access$getDisconnectionAttemptStartTimes$p(this.this$0).remove(gatt);
                        BluetoothPlatform.access$getConnectionAttemptStartTimes$p(this.this$0).remove(gatt);
                        L2capConnection l2capConnection = (L2capConnection)BluetoothPlatform.access$getClientL2capChannels$p(this.this$0).remove(gatt.getDevice().getAddress());
                        if (l2capConnection != null) {
                            L2capConnection it = l2capConnection;
                            boolean bl = false;
                            it.close();
                        }
                        Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)context);
                        new Handler(context.getMainLooper()).post(() -> initGattCallback.1.onConnectionStateChange$lambda-2(gatt));
                        break;
                    }
                    case 3: {
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler != null) {
                            handler.post(() -> initGattCallback.1.onConnectionStateChange$lambda-3(this.this$0, gatt));
                        }
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Disconnecting from remote peripheral", null, 4, null);
                        break;
                    }
                    case 2: {
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Connected to remote peripheral, discovering services", null, 4, null);
                        Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)context);
                        new Handler(context.getMainLooper()).post(() -> initGattCallback.1.onConnectionStateChange$lambda-4(this.this$0, gatt));
                    }
                }
            }

            public void onServicesDiscovered(@NotNull BluetoothGatt gatt, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                UUID uUID = BluetoothPlatform.access$getCHAR_UUID_READ$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"CHAR_UUID_READ");
                BluetoothGattCharacteristic readChar = BluetoothPlatform.access$findCharacteristicOnGatt(this.this$0, gatt, uUID);
                if (readChar == null) {
                    DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Read characteristic was null", null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                    return;
                }
                BluetoothGattDescriptor dataNotify = readChar.getDescriptor(BluetoothPlatform.access$getCLIENT_CHARACTERISTIC_CONFIG$p(this.this$0));
                if (dataNotify == null) {
                    DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Failed to find/save notify descriptor for connecting device", null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                    return;
                }
                Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                Intrinsics.checkNotNull((Object)context);
                new Handler(context.getMainLooper()).post(() -> initGattCallback.1.onServicesDiscovered$lambda-5(gatt, readChar));
                UUID uUID2 = BluetoothPlatform.access$getCHAR_UUID_CONTROL_READ$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"CHAR_UUID_CONTROL_READ");
                BluetoothGattCharacteristic readControlChar = BluetoothPlatform.access$findCharacteristicOnGatt(this.this$0, gatt, uUID2);
                if (readControlChar == null) {
                    DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Read control characteristic was null", null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                    return;
                }
                BluetoothGattDescriptor controlNotify = readControlChar.getDescriptor(BluetoothPlatform.access$getCLIENT_CHARACTERISTIC_CONFIG$p(this.this$0));
                if (controlNotify == null) {
                    DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Failed to find/save notify descriptor for connecting device", null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                    return;
                }
                Context context2 = BluetoothPlatform.access$getContext$p(this.this$0);
                Intrinsics.checkNotNull((Object)context2);
                new Handler(context2.getMainLooper()).post(() -> initGattCallback.1.onServicesDiscovered$lambda-6(gatt, readControlChar));
                Map map = BluetoothPlatform.access$getControlNotifyDescriptors$p(this.this$0);
                String string = gatt.getDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                String string2 = string;
                BluetoothGattDescriptor bluetoothGattDescriptor = controlNotify;
                map.put(string2, bluetoothGattDescriptor);
                dataNotify.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                DittoLog.i$default(BluetoothPlatform.Companion.getTAG(), "Subscribing to READ", null, 4, null);
                Context context3 = BluetoothPlatform.access$getContext$p(this.this$0);
                Intrinsics.checkNotNull((Object)context3);
                new Handler(context3.getMainLooper()).post(() -> initGattCallback.1.onServicesDiscovered$lambda-7(gatt, dataNotify));
            }

            public void onCharacteristicWrite(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                    Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                    if (Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_ANNOUNCE$p(this.this$0))) {
                        BluetoothPlatform.access$getConnectionAttemptStartTimes$p(this.this$0).remove(gatt);
                        String string = gatt.getDevice().getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                        byte[] peripheral = BluetoothPlatform.access$makeUuidBytesFromAddress(this.this$0, string);
                        boolean l2capAvailable = BluetoothPlatform.access$getClientL2capChannels$p(this.this$0).containsKey(gatt.getDevice().getAddress());
                        Log.d((String)BluetoothPlatform.Companion.getTAG(), (String)("Connection sequence completed. L2CAP available: " + l2capAvailable));
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler != null) {
                            handler.post(() -> initGattCallback.1.onCharacteristicWrite$lambda-8(this.this$0, peripheral, l2capAvailable, gatt));
                        }
                    }
                    Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                    if (handler == null) break block2;
                    handler.postDelayed(() -> initGattCallback.1.onCharacteristicWrite$lambda-9(this.this$0, gatt), BluetoothPlatform.access$getWRITE_DELAY_MS$p(this.this$0));
                }
            }

            public void onCharacteristicRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                if (Build.VERSION.SDK_INT >= 29 && characteristic.getUuid().equals(BluetoothPlatform.access$getCHAR_UUID_PSM$p(this.this$0)) && status == 0 && characteristic.getValue().length == 2) {
                    int msb = UInt.constructor-impl((int)(UByte.constructor-impl((byte)characteristic.getValue()[0]) & 0xFF));
                    int lsb = UInt.constructor-impl((int)(UByte.constructor-impl((byte)characteristic.getValue()[1]) & 0xFF));
                    int psm = UInt.constructor-impl((int)(UInt.constructor-impl((int)(msb << 8)) + lsb));
                    BluetoothSocket bluetoothSocket = gatt.getDevice().createInsecureL2capChannel(psm);
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothSocket, (String)"gatt.device.createInsecureL2capChannel(psm)");
                    BluetoothSocket socket = bluetoothSocket;
                    try {
                        socket.connect();
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "L2CAP client: connected to remote channel for address " + gatt.getDevice().getAddress(), null, 4, null);
                        String string = gatt.getDevice().getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                        byte[] uuidBytes = BluetoothPlatform.access$makeUuidBytesFromAddress(this.this$0, string);
                        L2capConnection conn = new L2capConnection(uuidBytes, socket, false, new WeakReference<BluetoothPlatform>(this.this$0));
                        BluetoothPlatform.access$getClientL2capChannels$p(this.this$0).put(gatt.getDevice().getAddress(), conn);
                    }
                    catch (Exception e) {
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "L2CAP client: exception connecting to remote psm " + e, null, 4, null);
                    }
                    BluetoothPlatform.access$writeOurAnnounceToGatt(this.this$0, gatt);
                }
                if (status != 0) {
                    DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Discovered PSM char but failed to read it; disconnecting", null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                }
            }

            public void onCharacteristicChanged(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                    Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                    BluetoothGatt existingGatt = (BluetoothGatt)BluetoothPlatform.access$getConnections$p(this.this$0).get(gatt.getDevice().getAddress());
                    if (!Intrinsics.areEqual((Object)existingGatt, (Object)gatt)) {
                        this.this$0.disconnectGatt(gatt);
                        return;
                    }
                    byte[] value = characteristic.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    if (value.length == 0) {
                        return;
                    }
                    String string = gatt.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                    byte[] peripheral = BluetoothPlatform.access$makeUuidBytesFromAddress(this.this$0, string);
                    Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                    if (handler == null) break block2;
                    handler.post(() -> initGattCallback.1.onCharacteristicChanged$lambda-10(characteristic, this.this$0, peripheral, value));
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void onDescriptorWrite(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattDescriptor descriptor, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "onDescriptorWrite - status " + status + " char_uuid " + descriptor.getCharacteristic().getUuid(), null, 4, null);
                if (status != 0) {
                    DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Unable to subscribe to the characteristic", null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                    return;
                }
                if (Intrinsics.areEqual((Object)descriptor.getCharacteristic().getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_READ$p(this.this$0))) {
                    BluetoothGattDescriptor controlDescriptor = (BluetoothGattDescriptor)BluetoothPlatform.access$getControlNotifyDescriptors$p(this.this$0).get(gatt.getDevice().getAddress());
                    if (controlDescriptor != null) {
                        controlDescriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                        DittoLog.i$default(BluetoothPlatform.Companion.getTAG(), "Subscribing to CONTROL_READ", null, 4, null);
                        Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)context);
                        new Handler(context.getMainLooper()).post(() -> initGattCallback.1.onDescriptorWrite$lambda-11(gatt, controlDescriptor));
                        return;
                    }
                    DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Unable to find cached notify descriptor for peripheral", null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                    return;
                }
                if (!Intrinsics.areEqual((Object)descriptor.getCharacteristic().getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_CONTROL_READ$p(this.this$0))) return;
                UUID uUID = BluetoothPlatform.access$getCHAR_UUID_PSM$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"CHAR_UUID_PSM");
                BluetoothGattCharacteristic psmChar = BluetoothPlatform.access$findCharacteristicOnGatt(this.this$0, gatt, uUID);
                if (psmChar != null && Build.VERSION.SDK_INT >= 29) {
                    gatt.readCharacteristic(psmChar);
                    return;
                }
                BluetoothPlatform.access$writeOurAnnounceToGatt(this.this$0, gatt);
            }

            public void onReadRemoteRssi(@NotNull BluetoothGatt gatt, int rssi, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
            }

            public void onMtuChanged(@NotNull BluetoothGatt gatt, int mtu, int status) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                    Ref.IntRef mtu2 = new Ref.IntRef();
                    mtu2.element = mtu;
                    DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "GattCallback: MTU changed to " + mtu2.element, null, 4, null);
                    if (status != 0) break block1;
                    mtu2.element -= 3;
                    Map map = BluetoothPlatform.access$getPeripheralMTUs$p(this.this$0);
                    String string = gatt.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                    String string2 = string;
                    Integer n = mtu2.element;
                    map.put(string2, n);
                    Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                    if (handler != null) {
                        handler.post(() -> initGattCallback.1.onMtuChanged$lambda-12(this.this$0, gatt, mtu2));
                    }
                }
            }

            private static final void onConnectionStateChange$lambda-0(BluetoothPlatform this$0, BluetoothGatt $gatt) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                String string = $gatt.getDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                this$0.connectionStateChanged(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string), ConnectState_t.CONNECT_STATE_DISCONNECTED, false, 0);
            }

            private static final void onConnectionStateChange$lambda-2(BluetoothGatt $gatt) {
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                $gatt.close();
            }

            private static final void onConnectionStateChange$lambda-3(BluetoothPlatform this$0, BluetoothGatt $gatt) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                String string = $gatt.getDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                this$0.connectionStateChanged(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string), ConnectState_t.CONNECT_STATE_DISCONNECTING, false, 0);
            }

            private static final void onConnectionStateChange$lambda-4(BluetoothPlatform this$0, BluetoothGatt $gatt) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                if (Build.VERSION.SDK_INT >= 26 && BluetoothPlatform.access$getUse2MPhy$p(this$0)) {
                    $gatt.setPreferredPhy(2, 2, 0);
                }
                $gatt.discoverServices();
            }

            private static final void onServicesDiscovered$lambda-5(BluetoothGatt $gatt, BluetoothGattCharacteristic $readChar) {
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                $gatt.setCharacteristicNotification($readChar, true);
            }

            private static final void onServicesDiscovered$lambda-6(BluetoothGatt $gatt, BluetoothGattCharacteristic $readControlChar) {
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                $gatt.setCharacteristicNotification($readControlChar, true);
            }

            private static final void onServicesDiscovered$lambda-7(BluetoothGatt $gatt, BluetoothGattDescriptor $dataNotify) {
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                $gatt.writeDescriptor($dataNotify);
            }

            private static final void onCharacteristicWrite$lambda-8(BluetoothPlatform this$0, byte[] $peripheral, boolean $l2capAvailable, BluetoothGatt $gatt) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$peripheral, (String)"$peripheral");
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                Integer n = (Integer)BluetoothPlatform.access$getPeripheralMTUs$p(this$0).get($gatt.getDevice().getAddress());
                if (n == null) {
                    n = 20;
                }
                this$0.connectionStateChanged($peripheral, ConnectState_t.CONNECT_STATE_CONNECTED, $l2capAvailable, ((Number)n).intValue());
            }

            private static final void onCharacteristicWrite$lambda-9(BluetoothPlatform this$0, BluetoothGatt $gatt) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                String string = $gatt.getDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                this$0.peripheralReadyToSend(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string));
            }

            private static final void onCharacteristicChanged$lambda-10(BluetoothGattCharacteristic $characteristic, BluetoothPlatform this$0, byte[] $peripheral, byte[] $value) {
                Intrinsics.checkNotNullParameter((Object)$characteristic, (String)"$characteristic");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$peripheral, (String)"$peripheral");
                if (Intrinsics.areEqual((Object)$characteristic.getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_READ$p(this$0))) {
                    this$0.receivedFromPeripheral($peripheral, BleDataType_t.BLE_DATA_TYPE_MESH_DATA, $value);
                } else if (Intrinsics.areEqual((Object)$characteristic.getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_CONTROL_READ$p(this$0))) {
                    this$0.receivedFromPeripheral($peripheral, BleDataType_t.BLE_DATA_TYPE_CONTROL, $value);
                } else {
                    DittoLog.w$default(BluetoothPlatform.Companion.getTAG(), "Unexpectedly received characteristic changed for " + $characteristic.getUuid(), null, 4, null);
                }
            }

            private static final void onDescriptorWrite$lambda-11(BluetoothGatt $gatt, BluetoothGattDescriptor $controlDescriptor) {
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                $gatt.writeDescriptor($controlDescriptor);
            }

            private static final void onMtuChanged$lambda-12(BluetoothPlatform this$0, BluetoothGatt $gatt, Ref.IntRef $mtu) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                Intrinsics.checkNotNullParameter((Object)$mtu, (String)"$mtu");
                String string = $gatt.getDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                this$0.peripheralMtuUpdated(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string), $mtu.element);
            }
        };
    }

    private final void writeOurAnnounceToGatt(BluetoothGatt gatt) {
        UUID uUID = this.CHAR_UUID_ANNOUNCE;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"CHAR_UUID_ANNOUNCE");
        BluetoothGattCharacteristic announceChar = this.findCharacteristicOnGatt(gatt, uUID);
        if (announceChar == null) {
            DittoLog.w$default(TAG, "Unable to find ANNOUNCE characteristic on peripheral", null, 4, null);
            this.disconnectGatt(gatt);
            return;
        }
        announceChar.setWriteType(2);
        announceChar.setValue(this.scanningAnnounce);
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        new Handler(context.getMainLooper()).post(() -> BluetoothPlatform.writeOurAnnounceToGatt$lambda-46(gatt, announceChar));
        DittoLog.d$default(TAG, "Writing announce string", null, 4, null);
    }

    private final void initServerCallback() {
        if (this.serverCallback == null) {
            this.serverCallback = new BluetoothGattServerCallback(this){
                final /* synthetic */ BluetoothPlatform this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onConnectionStateChange(@NotNull BluetoothDevice device, int status, int newState) {
                    Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                    Map map = BluetoothPlatform.access$getHeardCentrals$p(this.this$0);
                    String string = device.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    map.put(string, device);
                    switch (newState) {
                        case 0: {
                            Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                            if (handler != null) {
                                handler.post(() -> initServerCallback.1.onConnectionStateChange$lambda-0(this.this$0, device));
                            }
                            DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Central disconnected", null, 4, null);
                            L2capConnection l2capConnection = (L2capConnection)BluetoothPlatform.access$getServerL2capChannels$p(this.this$0).remove(device.getAddress());
                            if (l2capConnection != null) {
                                L2capConnection it = l2capConnection;
                                boolean bl = false;
                                it.close();
                            }
                            break;
                        }
                        case 2: {
                            DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Central connected", null, 4, null);
                        }
                    }
                }

                public void onServiceAdded(int status, @NotNull BluetoothGattService service) {
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Service added, starting BluetoothLeAdvertiser", null, 4, null);
                    if (Build.VERSION.SDK_INT >= 26) {
                        BluetoothPlatform.access$initAdvertiseSetCallback(this.this$0);
                    } else {
                        BluetoothPlatform.access$initAdvertiseCallback(this.this$0);
                    }
                    BluetoothAdapter adapter = BluetoothPlatform.access$getAdapter(this.this$0);
                    if (adapter == null) {
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler != null) {
                            handler.post(() -> initServerCallback.1.onServiceAdded$lambda-2(this.this$0));
                        }
                        return;
                    }
                    BluetoothPlatform.access$setAdvertiser$p(this.this$0, adapter.getBluetoothLeAdvertiser());
                    if (BluetoothPlatform.access$getAdvertiser$p(this.this$0) == null) {
                        DittoLog.i$default(BluetoothPlatform.Companion.getTAG(), "Bluetooth advertiser not available, probably disabled", null, 4, null);
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler != null) {
                            handler.post(() -> initServerCallback.1.onServiceAdded$lambda-3(this.this$0));
                        }
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 26) {
                        BluetoothPlatform.access$startAdvertisingSet(this.this$0);
                    } else {
                        BluetoothPlatform.access$startAdvertiser(this.this$0);
                    }
                }

                public void onCharacteristicReadRequest(@NotNull BluetoothDevice device, int requestId, int offset, @NotNull BluetoothGattCharacteristic characteristic) {
                    Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                    Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                    if (characteristic.getUuid().equals(BluetoothPlatform.access$getCHAR_UUID_PSM$p(this.this$0)) && BluetoothPlatform.access$getL2capServer$p(this.this$0) != null && Build.VERSION.SDK_INT >= 29) {
                        BluetoothServerSocket bluetoothServerSocket = BluetoothPlatform.access$getL2capServer$p(this.this$0);
                        Intrinsics.checkNotNull((Object)bluetoothServerSocket);
                        int psm = bluetoothServerSocket.getPsm();
                        byte msb = (byte)(psm >> 8);
                        byte lsb = (byte)(psm & 0xFF);
                        byte[] byArray = new byte[]{msb, lsb};
                        byte[] psmBytes = byArray;
                        Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)context);
                        new Handler(context.getMainLooper()).post(() -> initServerCallback.1.onCharacteristicReadRequest$lambda-4(this.this$0, device, requestId, offset, psmBytes));
                    } else {
                        Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)context);
                        new Handler(context.getMainLooper()).post(() -> initServerCallback.1.onCharacteristicReadRequest$lambda-5(this.this$0, device, requestId));
                    }
                }

                public void onCharacteristicWriteRequest(@NotNull BluetoothDevice device, int requestId, @NotNull BluetoothGattCharacteristic characteristic, boolean preparedWrite, boolean responseNeeded, int offset, @NotNull byte[] value) {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        if (responseNeeded) {
                            Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                            Intrinsics.checkNotNull((Object)context);
                            new Handler(context.getMainLooper()).post(() -> initServerCallback.1.onCharacteristicWriteRequest$lambda-6(this.this$0, device, requestId, offset, value));
                        }
                        if (value.length == 0) {
                            return;
                        }
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler == null) break block2;
                        handler.post(() -> initServerCallback.1.onCharacteristicWriteRequest$lambda-8(characteristic, this.this$0, device, value));
                    }
                }

                public void onDescriptorWriteRequest(@NotNull BluetoothDevice device, int requestId, @NotNull BluetoothGattDescriptor descriptor, boolean preparedWrite, boolean responseNeeded, int offset, @NotNull byte[] value) {
                    block5: {
                        Integer mtu;
                        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Descriptor written", null, 4, null);
                        if (responseNeeded) {
                            Context context = BluetoothPlatform.access$getContext$p(this.this$0);
                            Intrinsics.checkNotNull((Object)context);
                            new Handler(context.getMainLooper()).post(() -> initServerCallback.1.onDescriptorWriteRequest$lambda-9(this.this$0, device, requestId, offset, value));
                        }
                        boolean subscribed = Arrays.equals(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE, value);
                        if (!Intrinsics.areEqual((Object)descriptor.getCharacteristic().getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_READ$p(this.this$0))) break block5;
                        if (!subscribed) {
                            Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                            if (handler != null) {
                                handler.post(() -> initServerCallback.1.onDescriptorWriteRequest$lambda-10(this.this$0, device));
                            }
                        }
                        if ((mtu = (Integer)BluetoothPlatform.access$getCentralMTUs$p(this.this$0).get(device.getAddress())) != null) {
                            Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                            if (handler != null) {
                                handler.post(() -> initServerCallback.1.onDescriptorWriteRequest$lambda-11(this.this$0, device, mtu));
                            }
                        }
                    }
                }

                public void onMtuChanged(@NotNull BluetoothDevice device, int mtu) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                        Ref.IntRef mtu2 = new Ref.IntRef();
                        mtu2.element = mtu;
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "GattServerCallback: MTU changed to " + mtu2.element, null, 4, null);
                        mtu2.element -= 3;
                        Map map = BluetoothPlatform.access$getCentralMTUs$p(this.this$0);
                        String string = device.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                        String string2 = string;
                        Integer n = mtu2.element;
                        map.put(string2, n);
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler == null) break block0;
                        handler.post(() -> initServerCallback.1.onMtuChanged$lambda-12(this.this$0, device, mtu2));
                    }
                }

                public void onPhyUpdate(@NotNull BluetoothDevice device, int txPhy, int rxPhy, int status) {
                    Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                    String tx = this.phyCodeToString(txPhy);
                    String rx = this.phyCodeToString(rxPhy);
                    DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "GattServerCallback onPhyUpdate: txPhy " + tx + " rxPhy " + rx, null, 4, null);
                }

                private final String phyCodeToString(int code) {
                    if (code == 1) {
                        return "PHY_LE_1M";
                    }
                    if (code == 2) {
                        return "PHY_LE_2M";
                    }
                    if (code == 3) {
                        return "PHY_LE_CODED";
                    }
                    return "PHY Code: " + code;
                }

                public void onNotificationSent(@NotNull BluetoothDevice device, int status) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler == null) break block0;
                        handler.postDelayed(() -> initServerCallback.1.onNotificationSent$lambda-13(this.this$0, device), BluetoothPlatform.access$getWRITE_DELAY_MS$p(this.this$0));
                    }
                }

                private static final void onConnectionStateChange$lambda-0(BluetoothPlatform this$0, BluetoothDevice $device) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    String string = $device.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    this$0.centralUnsubscribed(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string));
                }

                private static final void onServiceAdded$lambda-2(BluetoothPlatform this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_HARDWARE);
                }

                private static final void onServiceAdded$lambda-3(BluetoothPlatform this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
                }

                private static final void onCharacteristicReadRequest$lambda-4(BluetoothPlatform this$0, BluetoothDevice $device, int $requestId, int $offset, byte[] $psmBytes) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                        Intrinsics.checkNotNullParameter((Object)$psmBytes, (String)"$psmBytes");
                        BluetoothGattServer bluetoothGattServer = BluetoothPlatform.access$getGattServer$p(this$0);
                        if (bluetoothGattServer == null) break block0;
                        bluetoothGattServer.sendResponse($device, $requestId, 0, $offset, $psmBytes);
                    }
                }

                private static final void onCharacteristicReadRequest$lambda-5(BluetoothPlatform this$0, BluetoothDevice $device, int $requestId) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                        BluetoothGattServer bluetoothGattServer = BluetoothPlatform.access$getGattServer$p(this$0);
                        if (bluetoothGattServer == null) break block0;
                        bluetoothGattServer.sendResponse($device, $requestId, 257, 0, new byte[0]);
                    }
                }

                private static final void onCharacteristicWriteRequest$lambda-6(BluetoothPlatform this$0, BluetoothDevice $device, int $requestId, int $offset, byte[] $value) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                        BluetoothGattServer bluetoothGattServer = BluetoothPlatform.access$getGattServer$p(this$0);
                        if (bluetoothGattServer == null) break block0;
                        bluetoothGattServer.sendResponse($device, $requestId, 0, $offset, $value);
                    }
                }

                private static final void onCharacteristicWriteRequest$lambda-8$lambda-7(BluetoothPlatform this$0, BluetoothDevice $device, byte[] $value) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                    boolean l2capAvailable = BluetoothPlatform.access$getServerL2capChannels$p(this$0).containsKey($device.getAddress());
                    Log.d((String)BluetoothPlatform.Companion.getTAG(), (String)("Central finished connecting uuid " + $device.getAddress() + ". L2CAP available: " + l2capAvailable));
                    String string = $device.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    byte[] byArray = BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string);
                    Integer n = (Integer)BluetoothPlatform.access$getCentralMTUs$p(this$0).get($device.getAddress());
                    if (n == null) {
                        n = 20;
                    }
                    this$0.centralFinishedConnecting(byArray, $value, l2capAvailable, ((Number)n).intValue());
                }

                private static final void onCharacteristicWriteRequest$lambda-8(BluetoothGattCharacteristic $characteristic, BluetoothPlatform this$0, BluetoothDevice $device, byte[] $value) {
                    block2: {
                        block3: {
                            block1: {
                                Intrinsics.checkNotNullParameter((Object)$characteristic, (String)"$characteristic");
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                                Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                                if (!Intrinsics.areEqual((Object)$characteristic.getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_WRITE$p(this$0))) break block1;
                                String string = $device.getAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                                this$0.receivedFromCentral(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string), BleDataType_t.BLE_DATA_TYPE_MESH_DATA, $value);
                                break block2;
                            }
                            if (!Intrinsics.areEqual((Object)$characteristic.getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_CONTROL_WRITE$p(this$0))) break block3;
                            String string = $device.getAddress();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                            this$0.receivedFromCentral(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string), BleDataType_t.BLE_DATA_TYPE_CONTROL, $value);
                            break block2;
                        }
                        if (!Intrinsics.areEqual((Object)$characteristic.getUuid(), (Object)BluetoothPlatform.access$getCHAR_UUID_ANNOUNCE$p(this$0))) break block2;
                        Handler handler = BluetoothPlatform.access$getHandler$p(this$0);
                        if (handler != null) {
                            handler.postDelayed(() -> initServerCallback.1.onCharacteristicWriteRequest$lambda-8$lambda-7(this$0, $device, $value), 100L);
                        }
                    }
                }

                private static final void onDescriptorWriteRequest$lambda-9(BluetoothPlatform this$0, BluetoothDevice $device, int $requestId, int $offset, byte[] $value) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                        BluetoothGattServer bluetoothGattServer = BluetoothPlatform.access$getGattServer$p(this$0);
                        if (bluetoothGattServer == null) break block0;
                        bluetoothGattServer.sendResponse($device, $requestId, 0, $offset, $value);
                    }
                }

                private static final void onDescriptorWriteRequest$lambda-10(BluetoothPlatform this$0, BluetoothDevice $device) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    String string = $device.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    this$0.centralUnsubscribed(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string));
                }

                private static final void onDescriptorWriteRequest$lambda-11(BluetoothPlatform this$0, BluetoothDevice $device, Integer $mtu) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    String string = $device.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    this$0.centralMtuUpdated(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string), $mtu);
                }

                private static final void onMtuChanged$lambda-12(BluetoothPlatform this$0, BluetoothDevice $device, Ref.IntRef $mtu) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    Intrinsics.checkNotNullParameter((Object)$mtu, (String)"$mtu");
                    String string = $device.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    this$0.centralMtuUpdated(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string), $mtu.element);
                }

                private static final void onNotificationSent$lambda-13(BluetoothPlatform this$0, BluetoothDevice $device) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    String string = $device.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    this$0.centralReadyToSend(BluetoothPlatform.access$makeUuidBytesFromAddress(this$0, string));
                }
            };
        }
    }

    private final void initAdvertiseCallback() {
        if (this.advertiseCallback == null) {
            this.advertiseCallback = new AdvertiseCallback(this){
                final /* synthetic */ BluetoothPlatform this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onStartSuccess(@NotNull AdvertiseSettings settingsInEffect) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)settingsInEffect, (String)"settingsInEffect");
                        DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Advertising start success", null, 4, null);
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler == null) break block0;
                        handler.post(() -> initAdvertiseCallback.1.onStartSuccess$lambda-0(this.this$0));
                    }
                }

                public void onStartFailure(int errorCode) {
                    block0: {
                        DittoLog.e$default(BluetoothPlatform.Companion.getTAG(), "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check manifest. <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler == null) break block0;
                        handler.post(() -> initAdvertiseCallback.1.onStartFailure$lambda-1(this.this$0));
                    }
                }

                private static final void onStartSuccess$lambda-0(BluetoothPlatform this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
                }

                private static final void onStartFailure$lambda-1(BluetoothPlatform this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_PERIPHERAL_PERMISSION);
                }
            };
        }
    }

    @RequiresApi(value=26)
    private final void initAdvertiseSetCallback() {
        if (this.adsetCallback == null) {
            this.adsetCallback = new AdvertisingSetCallback(this){
                final /* synthetic */ BluetoothPlatform this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onAdvertisingSetStarted(@Nullable AdvertisingSet advertisingSet, int txPower, int status) {
                    block2: {
                        block1: {
                            DittoLog.d$default(BluetoothPlatform.Companion.getTAG(), "Advertising start success", null, 4, null);
                            if (status != 0) break block1;
                            Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                            if (handler != null) {
                                handler.post(() -> initAdvertiseSetCallback.1.onAdvertisingSetStarted$lambda-0(this.this$0));
                            }
                            BluetoothPlatform.access$setAdvertisingSet$p(this.this$0, advertisingSet);
                            break block2;
                        }
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler == null) break block2;
                        handler.post(() -> initAdvertiseSetCallback.1.onAdvertisingSetStarted$lambda-1(this.this$0));
                    }
                }

                public void onAdvertisingSetStopped(@Nullable AdvertisingSet advertisingSet) {
                    block0: {
                        DittoLog.e$default(BluetoothPlatform.Companion.getTAG(), "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check manifest. <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                        Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                        if (handler == null) break block0;
                        handler.post(() -> initAdvertiseSetCallback.1.onAdvertisingSetStopped$lambda-2(this.this$0));
                    }
                }

                public void onScanResponseDataSet(@Nullable AdvertisingSet advertisingSet, int status) {
                    super.onScanResponseDataSet(advertisingSet, status);
                }

                private static final void onAdvertisingSetStarted$lambda-0(BluetoothPlatform this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
                }

                private static final void onAdvertisingSetStarted$lambda-1(BluetoothPlatform this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_GOING_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_GENERIC_FAILURE);
                }

                private static final void onAdvertisingSetStopped$lambda-2(BluetoothPlatform this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_PERIPHERAL_PERMISSION);
                }
            };
        }
    }

    private final void initWatchdog() {
        Timer timer;
        String string = "ditto-ble-watchdog";
        boolean bl = false;
        long l = 0L;
        long l2 = 1000L;
        Timer timer2 = timer = TimersKt.timer((String)string, (boolean)bl);
        timer2.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ BluetoothPlatform this$0;
            {
                this.this$0 = bluetoothPlatform;
            }

            public void run() {
                long date;
                BluetoothGatt gatt;
                TimerTask $this$initWatchdog_u24lambda_u2d47 = this;
                boolean bl = false;
                long now = SystemClock.elapsedRealtime();
                for (Map.Entry<K, V> entry : ((Map)BluetoothPlatform.access$getConnectionAttemptStartTimes$p(this.this$0)).entrySet()) {
                    gatt = (BluetoothGatt)entry.getKey();
                    date = ((Number)entry.getValue()).longValue();
                    if (now - date <= 30000L) continue;
                    DittoLog.w$default(BluetoothPlatform.access$getTAG$cp(), "BLE connect watchdog fired for gatt " + gatt.getDevice().getAddress(), null, 4, null);
                    this.this$0.disconnectGatt(gatt);
                    BluetoothPlatform.access$getConnectionAttemptStartTimes$p(this.this$0).remove(gatt);
                }
                for (Map.Entry<K, V> entry : ((Map)BluetoothPlatform.access$getDisconnectionAttemptStartTimes$p(this.this$0)).entrySet()) {
                    gatt = (BluetoothGatt)entry.getKey();
                    date = ((Number)entry.getValue()).longValue();
                    DittoLog.w$default(BluetoothPlatform.access$getTAG$cp(), "Checking a disconnect watchdog - now " + now + " date " + date, null, 4, null);
                    if (now - date <= 5000L) continue;
                    DittoLog.w$default(BluetoothPlatform.access$getTAG$cp(), "BLE disconnect watchdog fired for gatt " + gatt.getDevice().getAddress(), null, 4, null);
                    BluetoothPlatform.access$getDisconnectionAttemptStartTimes$p(this.this$0).remove(gatt);
                    if (Build.VERSION.SDK_INT >= 33) continue;
                    Handler handler = BluetoothPlatform.access$getHandler$p(this.this$0);
                    if (handler != null) {
                        handler.post(new Runnable(this.this$0){
                            final /* synthetic */ BluetoothPlatform this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final void run() {
                                this.this$0.advertisingStateChanged(this.this$0.getAdvertisingState(), TransportCondition_t.TRANSPORT_CONDITION_TEMPORARILY_UNAVAILABLE);
                                this.this$0.scanningStateChanged(this.this$0.getScanningState(), TransportCondition_t.TRANSPORT_CONDITION_TEMPORARILY_UNAVAILABLE);
                            }
                        });
                    }
                    this.this$0.getManager().requestReset();
                }
            }
        }, l, l2);
        this.watchdogTimer = timer;
    }

    private static final void connectPeripheral$lambda-1$lambda-0(BluetoothPlatform this$0, Ref.ObjectRef $gatt) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
        Object object = $gatt.element;
        Intrinsics.checkNotNull((Object)object);
        String string = ((BluetoothGatt)object).getDevice().getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt!!.device.address");
        this$0.connectionStateChanged(this$0.makeUuidBytesFromAddress(string), ConnectState_t.CONNECT_STATE_CONNECTING, false, 0);
    }

    private static final void connectPeripheral$lambda-1(Ref.ObjectRef $gatt, BluetoothDevice $device, BluetoothPlatform this$0, BluetoothGattCallback $callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            DittoLog.d$default(TAG, "connectGatt", null, 4, null);
            $gatt.element = $device.connectGatt(this$0.context, false, $callback, 2);
            Map map = this$0.connections;
            String string = $device.getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
            String string2 = string;
            Object object = $gatt.element;
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            map.put(string2, object2);
            Map map2 = this$0.connectionAttemptStartTimes;
            Object object3 = $gatt.element;
            Intrinsics.checkNotNull((Object)object3);
            map2.put(object3, SystemClock.elapsedRealtime());
            Handler handler = this$0.handler;
            if (handler == null) break block0;
            handler.post(() -> BluetoothPlatform.connectPeripheral$lambda-1$lambda-0(this$0, $gatt));
        }
    }

    private static final void disconnectGatt$lambda-2(BluetoothPlatform this$0, BluetoothGatt $gatt) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
        UUID uUID = this$0.CHAR_UUID_READ;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"CHAR_UUID_READ");
        BluetoothGattCharacteristic readChar = this$0.findCharacteristicOnGatt($gatt, uUID);
        if (readChar != null) {
            $gatt.setCharacteristicNotification(readChar, false);
        }
        UUID uUID2 = this$0.CHAR_UUID_CONTROL_READ;
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"CHAR_UUID_CONTROL_READ");
        BluetoothGattCharacteristic controlChar = this$0.findCharacteristicOnGatt($gatt, uUID2);
        if (controlChar != null) {
            $gatt.setCharacteristicNotification(controlChar, false);
        }
        $gatt.disconnect();
    }

    private static final void notifyToCentral$lambda-5$lambda-4(BluetoothPlatform this$0, byte[] $centralUuid) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$centralUuid, (String)"$centralUuid");
        this$0.centralUnsubscribed($centralUuid);
    }

    private static final void notifyToCentral$lambda-5(BluetoothPlatform this$0, Ref.BooleanRef $exception, Ref.ObjectRef $notifySemaphore, Ref.BooleanRef $result, BluetoothDevice $device, Ref.ObjectRef $characteristic, byte[] $centralUuid) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        Intrinsics.checkNotNullParameter((Object)$notifySemaphore, (String)"$notifySemaphore");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$characteristic, (String)"$characteristic");
        Intrinsics.checkNotNullParameter((Object)$centralUuid, (String)"$centralUuid");
        try {
            BluetoothGattServer bluetoothGattServer = this$0.gattServer;
            if (bluetoothGattServer != null) {
                BluetoothGattServer it = bluetoothGattServer;
                boolean bl = false;
                $result.element = it.notifyCharacteristicChanged($device, (BluetoothGattCharacteristic)$characteristic.element, false);
            }
        }
        catch (NullPointerException e) {
            DittoLog.w$default(TAG, "System-generated exception notifyToCentral - assume unsubscribed", null, 4, null);
            Handler handler = this$0.handler;
            if (handler != null) {
                handler.post(() -> BluetoothPlatform.notifyToCentral$lambda-5$lambda-4(this$0, $centralUuid));
            }
            $exception.element = true;
        }
        ((Semaphore)$notifySemaphore.element).release();
    }

    private static final void startAdvertising$lambda-9(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStartAdvertising();
    }

    private static final void doStartAdvertising$lambda-10(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_PERIPHERAL_PERMISSION);
    }

    private static final void doStartAdvertising$lambda-12(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BluetoothAdapter bluetoothAdapter = this$0.getAdapter();
        if (bluetoothAdapter == null) {
            return;
        }
        BluetoothAdapter it = bluetoothAdapter;
        boolean bl = false;
        BluetoothAdapter adapter = it;
        try {
            BluetoothServerSocket listener;
            BluetoothServerSocket bluetoothServerSocket = adapter.listenUsingInsecureL2capChannel();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothServerSocket, (String)"adapter.listenUsingInsecureL2capChannel()");
            this$0.l2capServer = listener = bluetoothServerSocket;
            while (true) {
                BluetoothSocket socket = listener.accept();
                String string = socket.getRemoteDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"socket.remoteDevice.address");
                byte[] uuidBytes = this$0.makeUuidBytesFromAddress(string);
                Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket");
                L2capConnection conn = new L2capConnection(uuidBytes, socket, true, new WeakReference<BluetoothPlatform>(this$0));
                this$0.serverL2capChannels.put(socket.getRemoteDevice().getAddress(), conn);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private static final void startAdvertiser$lambda-13(BluetoothPlatform this$0, AdvertiseSettings $settings, AdvertiseData $data, AdvertiseData $data2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            BluetoothLeAdvertiser bluetoothLeAdvertiser = this$0.advertiser;
            if (bluetoothLeAdvertiser == null) break block0;
            bluetoothLeAdvertiser.startAdvertising($settings, $data, $data2, this$0.advertiseCallback);
        }
    }

    private static final void startAdvertisingSet$lambda-14(BluetoothPlatform this$0, AdvertisingSetParameters $adsetparams, AdvertiseData $data, AdvertiseData $data2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            BluetoothLeAdvertiser bluetoothLeAdvertiser = this$0.advertiser;
            if (bluetoothLeAdvertiser == null) break block0;
            bluetoothLeAdvertiser.startAdvertisingSet($adsetparams, $data, $data2, null, null, 0, 0, this$0.adsetCallback);
        }
    }

    private static final void stopAdvertising$lambda-15(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStopAdvertising();
    }

    private static final void refreshPermissions$lambda-21(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStopScanning();
        this$0.doStartScanning();
    }

    private static final void startScanning$lambda-22(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStartScanning();
    }

    private static final void doStartScanning$lambda-23(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_CENTRAL_PERMISSION);
    }

    private static final void doStartScanning$lambda-24(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_HARDWARE);
    }

    private static final void doStartScanning$lambda-25(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
    }

    private static final void doStartScanning$lambda-26(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
    }

    private static final void stopScanning$lambda-27(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStopScanning();
    }

    private static final void doStopScanning$lambda-28(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_HARDWARE);
    }

    private static final void doStopScanning$lambda-29(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
    }

    private static final void writeToPeripheral$lambda-34(Ref.BooleanRef $result, BluetoothGatt $gatt, BluetoothGattCharacteristic $meshDataChar, Ref.ObjectRef $writeSemaphore) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$writeSemaphore, (String)"$writeSemaphore");
        $result.element = $gatt.writeCharacteristic($meshDataChar);
        ((Semaphore)$writeSemaphore.element).release();
    }

    private static final void reportDisabled$lambda-42(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(this$0.getScanningState(), TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
    }

    private static final void retryScanningAfterDelay$lambda-44(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isScanning && this$0.scanCallback == null) {
            this$0.doStartScanning();
        }
    }

    private static final void retryAdvertisingAfterDelay$lambda-45(BluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isAdvertising && this$0.gattServer == null) {
            this$0.doStartAdvertising();
        }
    }

    private static final void writeOurAnnounceToGatt$lambda-46(BluetoothGatt $gatt, BluetoothGattCharacteristic $announceChar) {
        Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
        if (!$gatt.writeCharacteristic($announceChar)) {
            DittoLog.w$default(TAG, "Error requesting announce characteristic write", null, 4, null);
        }
    }

    public static final /* synthetic */ BluetoothAdapter access$getAdapter(BluetoothPlatform $this) {
        return $this.getAdapter();
    }

    public static final /* synthetic */ byte[] access$makeUuidBytesFromAddress(BluetoothPlatform $this, String address) {
        return $this.makeUuidBytesFromAddress(address);
    }

    public static final /* synthetic */ Handler access$getHandler$p(BluetoothPlatform $this) {
        return $this.handler;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getHeardPeripherals$p(BluetoothPlatform $this) {
        return $this.heardPeripherals;
    }

    public static final /* synthetic */ void access$retryScanningAfterDelay(BluetoothPlatform $this) {
        $this.retryScanningAfterDelay();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getConnections$p(BluetoothPlatform $this) {
        return $this.connections;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDisconnectionAttemptStartTimes$p(BluetoothPlatform $this) {
        return $this.disconnectionAttemptStartTimes;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getConnectionAttemptStartTimes$p(BluetoothPlatform $this) {
        return $this.connectionAttemptStartTimes;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getClientL2capChannels$p(BluetoothPlatform $this) {
        return $this.clientL2capChannels;
    }

    public static final /* synthetic */ Context access$getContext$p(BluetoothPlatform $this) {
        return $this.context;
    }

    public static final /* synthetic */ BluetoothGattCharacteristic access$findCharacteristicOnGatt(BluetoothPlatform $this, BluetoothGatt gatt, UUID uuid) {
        return $this.findCharacteristicOnGatt(gatt, uuid);
    }

    public static final /* synthetic */ UUID access$getCHAR_UUID_READ$p(BluetoothPlatform $this) {
        return $this.CHAR_UUID_READ;
    }

    public static final /* synthetic */ UUID access$getCLIENT_CHARACTERISTIC_CONFIG$p(BluetoothPlatform $this) {
        return $this.CLIENT_CHARACTERISTIC_CONFIG;
    }

    public static final /* synthetic */ UUID access$getCHAR_UUID_CONTROL_READ$p(BluetoothPlatform $this) {
        return $this.CHAR_UUID_CONTROL_READ;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getControlNotifyDescriptors$p(BluetoothPlatform $this) {
        return $this.controlNotifyDescriptors;
    }

    public static final /* synthetic */ UUID access$getCHAR_UUID_ANNOUNCE$p(BluetoothPlatform $this) {
        return $this.CHAR_UUID_ANNOUNCE;
    }

    public static final /* synthetic */ long access$getWRITE_DELAY_MS$p(BluetoothPlatform $this) {
        return $this.WRITE_DELAY_MS;
    }

    public static final /* synthetic */ UUID access$getCHAR_UUID_PSM$p(BluetoothPlatform $this) {
        return $this.CHAR_UUID_PSM;
    }

    public static final /* synthetic */ void access$writeOurAnnounceToGatt(BluetoothPlatform $this, BluetoothGatt gatt) {
        $this.writeOurAnnounceToGatt(gatt);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPeripheralMTUs$p(BluetoothPlatform $this) {
        return $this.peripheralMTUs;
    }

    public static final /* synthetic */ boolean access$getUse2MPhy$p(BluetoothPlatform $this) {
        return $this.use2MPhy;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getHeardCentrals$p(BluetoothPlatform $this) {
        return $this.heardCentrals;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getServerL2capChannels$p(BluetoothPlatform $this) {
        return $this.serverL2capChannels;
    }

    public static final /* synthetic */ void access$initAdvertiseSetCallback(BluetoothPlatform $this) {
        $this.initAdvertiseSetCallback();
    }

    public static final /* synthetic */ void access$initAdvertiseCallback(BluetoothPlatform $this) {
        $this.initAdvertiseCallback();
    }

    public static final /* synthetic */ void access$setAdvertiser$p(BluetoothPlatform $this, BluetoothLeAdvertiser bluetoothLeAdvertiser) {
        $this.advertiser = bluetoothLeAdvertiser;
    }

    public static final /* synthetic */ BluetoothLeAdvertiser access$getAdvertiser$p(BluetoothPlatform $this) {
        return $this.advertiser;
    }

    public static final /* synthetic */ void access$startAdvertisingSet(BluetoothPlatform $this) {
        $this.startAdvertisingSet();
    }

    public static final /* synthetic */ void access$startAdvertiser(BluetoothPlatform $this) {
        $this.startAdvertiser();
    }

    public static final /* synthetic */ BluetoothServerSocket access$getL2capServer$p(BluetoothPlatform $this) {
        return $this.l2capServer;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCentralMTUs$p(BluetoothPlatform $this) {
        return $this.centralMTUs;
    }

    public static final /* synthetic */ BluetoothGattServer access$getGattServer$p(BluetoothPlatform $this) {
        return $this.gattServer;
    }

    public static final /* synthetic */ UUID access$getCHAR_UUID_WRITE$p(BluetoothPlatform $this) {
        return $this.CHAR_UUID_WRITE;
    }

    public static final /* synthetic */ UUID access$getCHAR_UUID_CONTROL_WRITE$p(BluetoothPlatform $this) {
        return $this.CHAR_UUID_CONTROL_WRITE;
    }

    public static final /* synthetic */ void access$setAdvertisingSet$p(BluetoothPlatform $this, AdvertisingSet advertisingSet) {
        $this.advertisingSet = advertisingSet;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llive/ditto/transports/BluetoothPlatform$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public final void setTAG(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            TAG = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

