/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.transports.WiFiDirectFeature;
import live.ditto.transports.WiFiDirectPlatform;
import live.ditto.transports.WifiDirectPlatformLeaderListener;
import live.ditto.transports.WifiDirectPlatformPeerListener;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Llive/ditto/transports/WiFiDirectBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "platform", "Llive/ditto/transports/WiFiDirectPlatform;", "manager", "Landroid/net/wifi/p2p/WifiP2pManager;", "channel", "Landroid/net/wifi/p2p/WifiP2pManager$Channel;", "leaderMode", "", "(Llive/ditto/transports/WiFiDirectPlatform;Landroid/net/wifi/p2p/WifiP2pManager;Landroid/net/wifi/p2p/WifiP2pManager$Channel;Z)V", "peerListListener", "Landroid/net/wifi/p2p/WifiP2pManager$PeerListListener;", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "dittocpp_release"})
@WiFiDirectFeature
public final class WiFiDirectBroadcastReceiver
extends BroadcastReceiver {
    @NotNull
    private final WiFiDirectPlatform platform;
    @NotNull
    private final WifiP2pManager manager;
    @NotNull
    private final WifiP2pManager.Channel channel;
    private final boolean leaderMode;
    @NotNull
    private final WifiP2pManager.PeerListListener peerListListener;

    public WiFiDirectBroadcastReceiver(@NotNull WiFiDirectPlatform platform, @NotNull WifiP2pManager manager2, @NotNull WifiP2pManager.Channel channel, boolean leaderMode) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.platform = platform;
        this.manager = manager2;
        this.channel = channel;
        this.leaderMode = leaderMode;
        this.peerListListener = arg_0 -> WiFiDirectBroadcastReceiver.peerListListener$lambda-1(this, arg_0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"MissingPermission", "NewApi"})
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String string = intent.getAction();
        if (string == null) return;
        switch (string.hashCode()) {
            case -1394739139: {
                if (string.equals("android.net.wifi.p2p.PEERS_CHANGED")) break;
                return;
            }
            case 1695662461: {
                if (!string.equals("android.net.wifi.p2p.STATE_CHANGED")) return;
                if (intent.getIntExtra("wifi_p2p_state", -1) == 2) {
                    if (this.leaderMode) {
                        this.platform.createGroup();
                        return;
                    }
                    this.platform.discoverPeers();
                    return;
                }
                WifiDirectPlatformPeerListener wifiDirectPlatformPeerListener = this.platform.getPeerListener();
                if (wifiDirectPlatformPeerListener != null) {
                    wifiDirectPlatformPeerListener.onFailure();
                }
                WifiDirectPlatformLeaderListener wifiDirectPlatformLeaderListener = this.platform.getLeaderListener();
                if (wifiDirectPlatformLeaderListener == null) return;
                wifiDirectPlatformLeaderListener.onFailure();
                return;
            }
        }
        this.manager.requestPeers(this.channel, this.peerListListener);
    }

    /*
     * WARNING - void declaration
     */
    private static final void peerListListener$lambda-1(WiFiDirectBroadcastReceiver this$0, WifiP2pDeviceList peerList) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Collection refreshedPeers = peerList.getDeviceList();
        if (!Intrinsics.areEqual((Object)refreshedPeers, this$0.platform.getPeers())) {
            this$0.platform.getPeers().clear();
            List<WifiP2pDevice> list = this$0.platform.getPeers();
            Intrinsics.checkNotNullExpressionValue((Object)refreshedPeers, (String)"refreshedPeers");
            list.addAll(refreshedPeers);
            if (!this$0.leaderMode && this$0.platform.getNeedToJoinGroup()) {
                void $this$mapTo$iv$iv;
                Collection collection = peerList.getDeviceList();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"peerList.deviceList");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void peer;
                    WifiP2pDevice wifiP2pDevice = (WifiP2pDevice)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(peer.deviceName);
                }
                Set deviceNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                WifiDirectPlatformPeerListener wifiDirectPlatformPeerListener = this$0.platform.getPeerListener();
                if (wifiDirectPlatformPeerListener != null) {
                    wifiDirectPlatformPeerListener.onPeersAvailable(deviceNames);
                }
            }
        }
        if (this$0.platform.getPeers().isEmpty()) {
            return;
        }
    }
}

