/*
 * Decompiled with CFR 0.152.
 */
package live.ditto;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ReplaceWith;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.internal.swig.ffi.SWIGTYPE_p_dittoffi_error;
import live.ditto.internal.swig.ffi.dittoffi;
import live.ditto.internal.swig.ffi.dittoffi_error_code_t;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0012\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\t\u001a\u001b\u001c\u001d\u001e\u001f !\"\u00a8\u0006#"}, d2={"Llive/ditto/DittoError;", "", "()V", "message", "", "getMessage", "()Ljava/lang/String;", "getLocalizedMessage", "ActivationError", "ActivationErrorReason", "AuthenticationError", "AuthenticationErrorReason", "BusError", "BusErrorReason", "Companion", "FatalError", "InternalError", "InternalErrorReason", "PresenceError", "PresenceErrorReason", "StoreError", "StoreErrorReason", "TransportError", "TransportErrorReason", "ValidationError", "ValidationErrorReason", "Llive/ditto/DittoError$ActivationError;", "Llive/ditto/DittoError$AuthenticationError;", "Llive/ditto/DittoError$BusError;", "Llive/ditto/DittoError$FatalError;", "Llive/ditto/DittoError$InternalError;", "Llive/ditto/DittoError$PresenceError;", "Llive/ditto/DittoError$StoreError;", "Llive/ditto/DittoError$TransportError;", "Llive/ditto/DittoError$ValidationError;", "dittocpp_release"})
public abstract class DittoError
extends Throwable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private DittoError() {
    }

    @Override
    @NotNull
    public String getLocalizedMessage() {
        String string = this.getMessage();
        if (string == null) {
            string = "An unknown error occurred.";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String getMessage() {
        Object object;
        DittoError dittoError = this;
        if (dittoError instanceof ActivationError) {
            ActivationErrorReason activationErrorReason = ((ActivationError)this).getReason();
            if (activationErrorReason instanceof ActivationErrorReason.LicenseTokenExpired) {
                object = ((ActivationErrorReason.LicenseTokenExpired)((ActivationError)this).getReason()).getMessage();
                return object;
            } else if (activationErrorReason instanceof ActivationErrorReason.LicenseTokenVerificationFailed) {
                object = ((ActivationErrorReason.LicenseTokenVerificationFailed)((ActivationError)this).getReason()).getMessage();
                return object;
            } else if (activationErrorReason instanceof ActivationErrorReason.LicenseTokenUnsupportedFutureVersion) {
                object = ((ActivationErrorReason.LicenseTokenUnsupportedFutureVersion)((ActivationError)this).getReason()).getMessage();
                return object;
            } else {
                if (!(activationErrorReason instanceof ActivationErrorReason.NotActivatedError)) throw new NoWhenBranchMatchedException();
                object = ((ActivationErrorReason.NotActivatedError)((ActivationError)this).getReason()).getMessage();
            }
            return object;
        } else {
            if (dittoError instanceof AuthenticationError) {
                if (!(((AuthenticationError)this).getReason() instanceof AuthenticationErrorReason.FailedToAuthenticate)) throw new NoWhenBranchMatchedException();
                return "Failed to authenticate with the remote server.";
            }
            if (dittoError instanceof BusError) {
                BusErrorReason busErrorReason = ((BusError)this).getReason();
                if (busErrorReason instanceof BusErrorReason.SendBeforeCompletion) {
                    return "Sent a bus message with the same destination/reliability before the previous send completed.";
                }
                if (busErrorReason instanceof BusErrorReason.SendFailed) {
                    return "Failed to send bus message.";
                }
                if (busErrorReason instanceof BusErrorReason.OpenStreamFailed) {
                    return "Failed to open a stream to the requested peer.";
                }
                if (busErrorReason instanceof BusErrorReason.StreamClosedByRemote) {
                    return "The remote peer closed this BusStream.";
                }
                if (busErrorReason instanceof BusErrorReason.StreamClosedByLocal) {
                    return "The local peer closed this BusStream.";
                }
                if (busErrorReason instanceof BusErrorReason.StreamFailed) {
                    return "This BusStream closed due to a communication failure.";
                }
                if (busErrorReason instanceof BusErrorReason.ReliablePayloadTooLarge) {
                    return "Bus message cannot be sent as the payload is too large (max 1 MB)";
                }
                if (busErrorReason instanceof BusErrorReason.UnreliablePayloadTooLarge) {
                    return "Bus message cannot be sent as the payload is too large (max 128 kB)";
                }
                if (!(busErrorReason instanceof BusErrorReason.QueueFull)) throw new NoWhenBranchMatchedException();
                return "Bus message cannot be sent as the queue is full.";
            }
            if (dittoError instanceof InternalError) {
                InternalErrorReason internalErrorReason = ((InternalError)this).getReason();
                if (internalErrorReason instanceof InternalErrorReason.NativeReferenceMissing) {
                    object = ((InternalErrorReason.NativeReferenceMissing)((InternalError)this).getReason()).getMessage();
                    return object;
                } else {
                    if (!(internalErrorReason instanceof InternalErrorReason.WeakReferenceCleared)) throw new NoWhenBranchMatchedException();
                    object = ((InternalErrorReason.WeakReferenceCleared)((InternalError)this).getReason()).getMessage();
                }
                return object;
            } else if (dittoError instanceof PresenceError) {
                PresenceErrorReason presenceErrorReason = ((PresenceError)this).getReason();
                if (presenceErrorReason instanceof PresenceErrorReason.FailedToDecodeJson) {
                    object = "Error parsing presence JSON: " + ((PresenceErrorReason.FailedToDecodeJson)((PresenceError)this).getReason()).getError().getLocalizedMessage();
                    return object;
                } else {
                    if (!(presenceErrorReason instanceof PresenceErrorReason.JsonParsingError)) throw new NoWhenBranchMatchedException();
                    object = "Error parsing presence JSON: " + ((PresenceErrorReason.JsonParsingError)((PresenceError)this).getReason()).getMessage();
                }
                return object;
            } else if (dittoError instanceof StoreError) {
                StoreErrorReason storeErrorReason = ((StoreError)this).getReason();
                if (storeErrorReason instanceof StoreErrorReason.AttachmentCopyTargetAlreadyExists) {
                    object = "The target file for the attachment copy already exists. Error: " + ((StoreErrorReason.AttachmentCopyTargetAlreadyExists)((StoreError)this).getReason()).getError().getLocalizedMessage() + ".";
                    return object;
                } else if (storeErrorReason instanceof StoreErrorReason.AttachmentDataRetrievalError) {
                    object = "The attachment data failed to be retrieved. Full error: " + ((StoreErrorReason.AttachmentDataRetrievalError)((StoreError)this).getReason()).getError() + ".";
                    return object;
                } else if (storeErrorReason instanceof StoreErrorReason.AttachmentFileCopyError) {
                    object = "The attachment file failed to be copied. Full error: " + ((StoreErrorReason.AttachmentFileCopyError)((StoreError)this).getReason()).getError() + ".";
                    return object;
                } else if (storeErrorReason instanceof StoreErrorReason.BackendError) {
                    object = "An error occurred with the storage backend: " + ((StoreErrorReason.BackendError)((StoreError)this).getReason()).getMessage() + ".";
                    return object;
                } else if (storeErrorReason instanceof StoreErrorReason.CrdtError) {
                    object = ((StoreErrorReason.CrdtError)((StoreError)this).getReason()).getMessage();
                    return object;
                } else if (storeErrorReason instanceof StoreErrorReason.DocumentContentEncodingFailed) {
                    String string;
                    Exception exception = ((StoreErrorReason.DocumentContentEncodingFailed)((StoreError)this).getReason()).getError();
                    if (exception != null) {
                        Exception it = exception;
                        boolean bl = false;
                        string = "Error: " + it.getLocalizedMessage();
                    } else {
                        string = null;
                    }
                    String errorString = string;
                    object = "The provided document content failed to be encoded. " + errorString;
                    return object;
                } else {
                    if (storeErrorReason instanceof StoreErrorReason.DocumentNotFound) {
                        return "The document with the provided identifier could not be found.";
                    }
                    if (storeErrorReason instanceof StoreErrorReason.FailedToCopyAttachment) {
                        object = "The attachment failed to be copied. Error: " + ((StoreErrorReason.FailedToCopyAttachment)((StoreError)this).getReason()).getError().getLocalizedMessage() + ".";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToDecodeCounter) {
                        object = "Failed to decode Counter. Error: " + ((StoreErrorReason.FailedToDecodeCounter)((StoreError)this).getReason()).getMessage() + ".";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToDecodeData) {
                        String string;
                        Exception exception = ((StoreErrorReason.FailedToDecodeData)((StoreError)this).getReason()).getError();
                        if (exception != null) {
                            Exception it = exception;
                            boolean bl = false;
                            string = "Error: " + it.getLocalizedMessage();
                        } else {
                            string = null;
                        }
                        String errorString = string;
                        object = "The data could not be decoded. " + errorString;
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToDecodeDocument) {
                        object = "The document could not be decoded. Error: " + ((StoreErrorReason.FailedToDecodeDocument)((StoreError)this).getReason()).getError().getLocalizedMessage() + ".";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToDecodeValue) {
                        object = "Failed to decode value. Error: " + ((StoreErrorReason.FailedToDecodeValue)((StoreError)this).getReason()).getError().getLocalizedMessage() + ".";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToEncodeValue) {
                        object = "Failed to encode value: " + ((StoreErrorReason.FailedToEncodeValue)((StoreError)this).getReason()).getValue() + ". Error: " + ((StoreErrorReason.FailedToEncodeValue)((StoreError)this).getReason()).getMessage() + ".";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToGetDocumentData) {
                        object = "The document's data at the path " + ((StoreErrorReason.FailedToGetDocumentData)((StoreError)this).getReason()).getPath() + " could not be obtained.";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToGetDocumentIDData) {
                        object = "The document ID's data at the path " + ((StoreErrorReason.FailedToGetDocumentIDData)((StoreError)this).getReason()).getPath() + " could not be obtained.";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.FailedToInitializeDittoDirectory) {
                        object = "The directory that Ditto attempted to use for its persisted data could not be initialized. Error: " + ((StoreErrorReason.FailedToInitializeDittoDirectory)((StoreError)this).getReason()).getError().getLocalizedMessage() + ".";
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.InvalidCrdtType) {
                        object = "An invalid CRDT type was encountered. Error: " + ((StoreErrorReason.InvalidCrdtType)((StoreError)this).getReason()).getMessage();
                        return object;
                    } else if (storeErrorReason instanceof StoreErrorReason.InvalidDocumentStructure) {
                        object = "The document's internal representation was invalid: " + ((StoreErrorReason.InvalidDocumentStructure)((StoreError)this).getReason()).getCbor();
                        return object;
                    } else {
                        if (storeErrorReason instanceof StoreErrorReason.InvalidLiveQueryId) {
                            return "The live query did not obtain a valid identifier.";
                        }
                        if (storeErrorReason instanceof StoreErrorReason.InvalidValueForCrdt) {
                            object = "An invalid value was encountered for a corresponding CRDT type.Error: " + ((StoreErrorReason.InvalidValueForCrdt)((StoreError)this).getReason()).getMessage();
                            return object;
                        } else {
                            if (storeErrorReason instanceof StoreErrorReason.NoIdPresentInDocument) {
                                return "The document did not have an `_id` when attempting to decode it.";
                            }
                            if (storeErrorReason instanceof StoreErrorReason.NonStringKeyInDocument) {
                                object = "The document, represented as a CBOR map, had a key that was not a string: " + ((StoreErrorReason.NonStringKeyInDocument)((StoreError)this).getReason()).getKey();
                                return object;
                            } else {
                                if (Intrinsics.areEqual((Object)storeErrorReason, (Object)StoreErrorReason.QueryArgumentsInvalid.INSTANCE)) {
                                    return "The provided query arguments were invalid.";
                                }
                                if (storeErrorReason instanceof StoreErrorReason.QueryCompilationFailed) {
                                    object = "Compilation of the provided query failed. Query: " + ((StoreErrorReason.QueryCompilationFailed)((StoreError)this).getReason()).getQuery() + ".";
                                    return object;
                                } else if (storeErrorReason instanceof StoreErrorReason.QueryError) {
                                    object = ((StoreErrorReason.QueryError)((StoreError)this).getReason()).getMessage();
                                    return object;
                                } else if (storeErrorReason instanceof StoreErrorReason.QueryInvalid) {
                                    object = ((StoreErrorReason.QueryInvalid)((StoreError)this).getReason()).getMessage();
                                    return object;
                                } else {
                                    if (!(storeErrorReason instanceof StoreErrorReason.QueryNotSupported)) throw new NoWhenBranchMatchedException();
                                    object = ((StoreErrorReason.QueryNotSupported)((StoreError)this).getReason()).getMessage();
                                }
                            }
                        }
                    }
                }
                return object;
            } else if (dittoError instanceof TransportError) {
                TransportErrorReason transportErrorReason = ((TransportError)this).getReason();
                if (transportErrorReason instanceof TransportErrorReason.FailedToDecodeTransportDiagnostics) {
                    object = "Decoding of transport diagnostics data failed. Error: " + ((TransportErrorReason.FailedToDecodeTransportDiagnostics)((TransportError)this).getReason()).getError().getLocalizedMessage() + ".";
                    return object;
                } else {
                    if (!(transportErrorReason instanceof TransportErrorReason.IncorrectPlatformTransportConfig)) throw new NoWhenBranchMatchedException();
                    object = "The provided transport config is for the wrong platform. " + ((TransportError)this).getReason();
                }
                return object;
            } else if (dittoError instanceof ValidationError) {
                ValidationErrorReason validationErrorReason = ((ValidationError)this).getReason();
                if (validationErrorReason instanceof ValidationErrorReason.DepthLimitExceeded) {
                    return "Metadata depth limit exceeded.";
                }
                if (validationErrorReason instanceof ValidationErrorReason.InternalSubsystemUnavailable) {
                    return "The Ditto internal observability subsystem is unavailable";
                }
                if (validationErrorReason instanceof ValidationErrorReason.NotAMap) {
                    return "Metadata failed parsing.";
                }
                if (validationErrorReason instanceof ValidationErrorReason.SizeLimitExceeded) {
                    return "Metadata size limit exceeded.";
                }
                if (!(validationErrorReason instanceof ValidationErrorReason.UnknownSyncScope)) throw new NoWhenBranchMatchedException();
                object = "Unknown sync scope: " + ((ValidationError)this).getReason();
                return object;
            } else {
                if (!(dittoError instanceof FatalError)) throw new NoWhenBranchMatchedException();
                object = ((FatalError)this).getMessage();
            }
        }
        return object;
    }

    public /* synthetic */ DittoError(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Llive/ditto/DittoError$Companion;", "", "()V", "fromFfiError", "Llive/ditto/DittoError;", "ffiError", "Llive/ditto/internal/swig/ffi/SWIGTYPE_p_dittoffi_error;", "fromFfiError$dittocpp_release", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DittoError fromFfiError$dittocpp_release(@NotNull SWIGTYPE_p_dittoffi_error ffiError) {
            DittoError dittoError;
            Intrinsics.checkNotNullParameter((Object)ffiError, (String)"ffiError");
            String string = dittoffi.dittoffi_error_description(ffiError);
            String description = string == null ? "No description given." : string;
            dittoffi_error_code_t dittoffi_error_code_t2 = dittoffi.dittoffi_error_code(ffiError);
            if (Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_CRDT)) {
                dittoError = new StoreError(StoreErrorReason.NoIdPresentInDocument.INSTANCE);
            } else if (Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_DQL_INVALID_QUERY_ARGS)) {
                dittoError = new StoreError(StoreErrorReason.QueryArgumentsInvalid.INSTANCE);
            } else if (Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_DQL_QUERY_COMPILATION)) {
                dittoError = new StoreError(new StoreErrorReason.QueryInvalid(description));
            } else if (Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_DQL_UNSUPPORTED)) {
                dittoError = new StoreError(new StoreErrorReason.QueryNotSupported(description));
            } else {
                if (Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_JS_FLOATING_STORE_OPERATION)) {
                    String string2 = "Internal inconsistency, Ditto Core returned an error solely meant for the JS SDK.";
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }
                dittoError = Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_STORE_DATABASE) ? (DittoError)new StoreError(new StoreErrorReason.BackendError(description)) : (Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_STORE_DOCUMENT_NOT_FOUND) ? (DittoError)new StoreError(StoreErrorReason.DocumentNotFound.INSTANCE) : (Intrinsics.areEqual((Object)dittoffi_error_code_t2, (Object)dittoffi_error_code_t.DITTOFFI_ERROR_CODE_STORE_QUERY) ? (DittoError)new StoreError(new StoreErrorReason.QueryError(description)) : (DittoError)new FatalError(description)));
            }
            DittoError sdkError = dittoError;
            dittoffi.dittoffi_error_free(ffiError);
            return sdkError;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$ActivationError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$ActivationErrorReason;", "(Llive/ditto/DittoError$ActivationErrorReason;)V", "getReason", "()Llive/ditto/DittoError$ActivationErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class ActivationError
    extends DittoError {
        @NotNull
        private final ActivationErrorReason reason;

        public ActivationError(@NotNull ActivationErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final ActivationErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final ActivationErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final ActivationError copy(@NotNull ActivationErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new ActivationError(reason);
        }

        public static /* synthetic */ ActivationError copy$default(ActivationError activationError, ActivationErrorReason activationErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                activationErrorReason = activationError.reason;
            }
            return activationError.copy(activationErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "ActivationError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActivationError)) {
                return false;
            }
            ActivationError activationError = (ActivationError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)activationError.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$AuthenticationError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$AuthenticationErrorReason;", "(Llive/ditto/DittoError$AuthenticationErrorReason;)V", "getReason", "()Llive/ditto/DittoError$AuthenticationErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class AuthenticationError
    extends DittoError {
        @NotNull
        private final AuthenticationErrorReason reason;

        public AuthenticationError(@NotNull AuthenticationErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final AuthenticationErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final AuthenticationErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final AuthenticationError copy(@NotNull AuthenticationErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new AuthenticationError(reason);
        }

        public static /* synthetic */ AuthenticationError copy$default(AuthenticationError authenticationError, AuthenticationErrorReason authenticationErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                authenticationErrorReason = authenticationError.reason;
            }
            return authenticationError.copy(authenticationErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "AuthenticationError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationError)) {
                return false;
            }
            AuthenticationError authenticationError = (AuthenticationError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)authenticationError.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$BusError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$BusErrorReason;", "(Llive/ditto/DittoError$BusErrorReason;)V", "getReason", "()Llive/ditto/DittoError$BusErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class BusError
    extends DittoError {
        @NotNull
        private final BusErrorReason reason;

        public BusError(@NotNull BusErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final BusErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final BusErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final BusError copy(@NotNull BusErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new BusError(reason);
        }

        public static /* synthetic */ BusError copy$default(BusError busError, BusErrorReason busErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                busErrorReason = busError.reason;
            }
            return busError.copy(busErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "BusError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BusError)) {
                return false;
            }
            BusError busError = (BusError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)busError.reason);
        }
    }

    @Deprecated(message="This error is no longer thrown. Catch FatalError if you want to handle these error cases.", replaceWith=@ReplaceWith(expression="FatalError", imports={}))
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$InternalError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$InternalErrorReason;", "(Llive/ditto/DittoError$InternalErrorReason;)V", "getReason", "()Llive/ditto/DittoError$InternalErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class InternalError
    extends DittoError {
        @NotNull
        private final InternalErrorReason reason;

        public InternalError(@NotNull InternalErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final InternalErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final InternalErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final InternalError copy(@NotNull InternalErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new InternalError(reason);
        }

        public static /* synthetic */ InternalError copy$default(InternalError internalError, InternalErrorReason internalErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                internalErrorReason = internalError.reason;
            }
            return internalError.copy(internalErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "InternalError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InternalError)) {
                return false;
            }
            InternalError internalError = (InternalError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)internalError.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$FatalError;", "Llive/ditto/DittoError;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
    public static final class FatalError
    extends DittoError {
        @NotNull
        private final String message;

        public FatalError(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super((DefaultConstructorMarker)null);
            this.message = message;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.getMessage();
        }

        @NotNull
        public final FatalError copy(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new FatalError(message);
        }

        public static /* synthetic */ FatalError copy$default(FatalError fatalError, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = fatalError.getMessage();
            }
            return fatalError.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "FatalError(message=" + this.getMessage() + ")";
        }

        public int hashCode() {
            return this.getMessage().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FatalError)) {
                return false;
            }
            FatalError fatalError = (FatalError)other;
            return Intrinsics.areEqual((Object)this.getMessage(), (Object)fatalError.getMessage());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$PresenceError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$PresenceErrorReason;", "(Llive/ditto/DittoError$PresenceErrorReason;)V", "getReason", "()Llive/ditto/DittoError$PresenceErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class PresenceError
    extends DittoError {
        @NotNull
        private final PresenceErrorReason reason;

        public PresenceError(@NotNull PresenceErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final PresenceErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final PresenceErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final PresenceError copy(@NotNull PresenceErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new PresenceError(reason);
        }

        public static /* synthetic */ PresenceError copy$default(PresenceError presenceError, PresenceErrorReason presenceErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                presenceErrorReason = presenceError.reason;
            }
            return presenceError.copy(presenceErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "PresenceError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PresenceError)) {
                return false;
            }
            PresenceError presenceError = (PresenceError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)presenceError.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$StoreErrorReason;", "(Llive/ditto/DittoError$StoreErrorReason;)V", "getReason", "()Llive/ditto/DittoError$StoreErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class StoreError
    extends DittoError {
        @NotNull
        private final StoreErrorReason reason;

        public StoreError(@NotNull StoreErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final StoreErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final StoreErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final StoreError copy(@NotNull StoreErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new StoreError(reason);
        }

        public static /* synthetic */ StoreError copy$default(StoreError storeError, StoreErrorReason storeErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                storeErrorReason = storeError.reason;
            }
            return storeError.copy(storeErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "StoreError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StoreError)) {
                return false;
            }
            StoreError storeError = (StoreError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)storeError.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$TransportError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$TransportErrorReason;", "(Llive/ditto/DittoError$TransportErrorReason;)V", "getReason", "()Llive/ditto/DittoError$TransportErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class TransportError
    extends DittoError {
        @NotNull
        private final TransportErrorReason reason;

        public TransportError(@NotNull TransportErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final TransportErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final TransportErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final TransportError copy(@NotNull TransportErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new TransportError(reason);
        }

        public static /* synthetic */ TransportError copy$default(TransportError transportError, TransportErrorReason transportErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                transportErrorReason = transportError.reason;
            }
            return transportError.copy(transportErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "TransportError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransportError)) {
                return false;
            }
            TransportError transportError = (TransportError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)transportError.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$ValidationError;", "Llive/ditto/DittoError;", "reason", "Llive/ditto/DittoError$ValidationErrorReason;", "(Llive/ditto/DittoError$ValidationErrorReason;)V", "getReason", "()Llive/ditto/DittoError$ValidationErrorReason;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class ValidationError
    extends DittoError {
        @NotNull
        private final ValidationErrorReason reason;

        public ValidationError(@NotNull ValidationErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.reason = reason;
        }

        @NotNull
        public final ValidationErrorReason getReason() {
            return this.reason;
        }

        @NotNull
        public final ValidationErrorReason component1() {
            return this.reason;
        }

        @NotNull
        public final ValidationError copy(@NotNull ValidationErrorReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new ValidationError(reason);
        }

        public static /* synthetic */ ValidationError copy$default(ValidationError validationError, ValidationErrorReason validationErrorReason, int n, Object object) {
            if ((n & 1) != 0) {
                validationErrorReason = validationError.reason;
            }
            return validationError.copy(validationErrorReason);
        }

        @Override
        @NotNull
        public String toString() {
            return "ValidationError(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidationError)) {
                return false;
            }
            ValidationError validationError = (ValidationError)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)validationError.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Llive/ditto/DittoError$ActivationErrorReason;", "", "()V", "LicenseTokenExpired", "LicenseTokenUnsupportedFutureVersion", "LicenseTokenVerificationFailed", "NotActivatedError", "Llive/ditto/DittoError$ActivationErrorReason$LicenseTokenExpired;", "Llive/ditto/DittoError$ActivationErrorReason$LicenseTokenUnsupportedFutureVersion;", "Llive/ditto/DittoError$ActivationErrorReason$LicenseTokenVerificationFailed;", "Llive/ditto/DittoError$ActivationErrorReason$NotActivatedError;", "dittocpp_release"})
    public static abstract class ActivationErrorReason {
        private ActivationErrorReason() {
        }

        public /* synthetic */ ActivationErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$ActivationErrorReason$NotActivatedError;", "Llive/ditto/DittoError$ActivationErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class NotActivatedError
        extends ActivationErrorReason {
            @NotNull
            private final String message;

            public NotActivatedError(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final NotActivatedError copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new NotActivatedError(message);
            }

            public static /* synthetic */ NotActivatedError copy$default(NotActivatedError notActivatedError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = notActivatedError.message;
                }
                return notActivatedError.copy(string);
            }

            @NotNull
            public String toString() {
                return "NotActivatedError(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotActivatedError)) {
                    return false;
                }
                NotActivatedError notActivatedError = (NotActivatedError)other;
                return Intrinsics.areEqual((Object)this.message, (Object)notActivatedError.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$ActivationErrorReason$LicenseTokenExpired;", "Llive/ditto/DittoError$ActivationErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class LicenseTokenExpired
        extends ActivationErrorReason {
            @NotNull
            private final String message;

            public LicenseTokenExpired(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final LicenseTokenExpired copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new LicenseTokenExpired(message);
            }

            public static /* synthetic */ LicenseTokenExpired copy$default(LicenseTokenExpired licenseTokenExpired, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = licenseTokenExpired.message;
                }
                return licenseTokenExpired.copy(string);
            }

            @NotNull
            public String toString() {
                return "LicenseTokenExpired(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LicenseTokenExpired)) {
                    return false;
                }
                LicenseTokenExpired licenseTokenExpired = (LicenseTokenExpired)other;
                return Intrinsics.areEqual((Object)this.message, (Object)licenseTokenExpired.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$ActivationErrorReason$LicenseTokenVerificationFailed;", "Llive/ditto/DittoError$ActivationErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class LicenseTokenVerificationFailed
        extends ActivationErrorReason {
            @NotNull
            private final String message;

            public LicenseTokenVerificationFailed(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final LicenseTokenVerificationFailed copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new LicenseTokenVerificationFailed(message);
            }

            public static /* synthetic */ LicenseTokenVerificationFailed copy$default(LicenseTokenVerificationFailed licenseTokenVerificationFailed, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = licenseTokenVerificationFailed.message;
                }
                return licenseTokenVerificationFailed.copy(string);
            }

            @NotNull
            public String toString() {
                return "LicenseTokenVerificationFailed(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LicenseTokenVerificationFailed)) {
                    return false;
                }
                LicenseTokenVerificationFailed licenseTokenVerificationFailed = (LicenseTokenVerificationFailed)other;
                return Intrinsics.areEqual((Object)this.message, (Object)licenseTokenVerificationFailed.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$ActivationErrorReason$LicenseTokenUnsupportedFutureVersion;", "Llive/ditto/DittoError$ActivationErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class LicenseTokenUnsupportedFutureVersion
        extends ActivationErrorReason {
            @NotNull
            private final String message;

            public LicenseTokenUnsupportedFutureVersion(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final LicenseTokenUnsupportedFutureVersion copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new LicenseTokenUnsupportedFutureVersion(message);
            }

            public static /* synthetic */ LicenseTokenUnsupportedFutureVersion copy$default(LicenseTokenUnsupportedFutureVersion licenseTokenUnsupportedFutureVersion, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = licenseTokenUnsupportedFutureVersion.message;
                }
                return licenseTokenUnsupportedFutureVersion.copy(string);
            }

            @NotNull
            public String toString() {
                return "LicenseTokenUnsupportedFutureVersion(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LicenseTokenUnsupportedFutureVersion)) {
                    return false;
                }
                LicenseTokenUnsupportedFutureVersion licenseTokenUnsupportedFutureVersion = (LicenseTokenUnsupportedFutureVersion)other;
                return Intrinsics.areEqual((Object)this.message, (Object)licenseTokenUnsupportedFutureVersion.message);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0001\u0004\u00a8\u0006\u0005"}, d2={"Llive/ditto/DittoError$AuthenticationErrorReason;", "", "()V", "FailedToAuthenticate", "Llive/ditto/DittoError$AuthenticationErrorReason$FailedToAuthenticate;", "dittocpp_release"})
    public static abstract class AuthenticationErrorReason {
        private AuthenticationErrorReason() {
        }

        public /* synthetic */ AuthenticationErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$AuthenticationErrorReason$FailedToAuthenticate;", "Llive/ditto/DittoError$AuthenticationErrorReason;", "()V", "dittocpp_release"})
        public static final class FailedToAuthenticate
        extends AuthenticationErrorReason {
            @NotNull
            public static final FailedToAuthenticate INSTANCE = new FailedToAuthenticate();

            private FailedToAuthenticate() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\t\u0003\u0004\u0005\u0006\u0007\b\t\n\u000bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\t\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Llive/ditto/DittoError$BusErrorReason;", "", "()V", "OpenStreamFailed", "QueueFull", "ReliablePayloadTooLarge", "SendBeforeCompletion", "SendFailed", "StreamClosedByLocal", "StreamClosedByRemote", "StreamFailed", "UnreliablePayloadTooLarge", "Llive/ditto/DittoError$BusErrorReason$OpenStreamFailed;", "Llive/ditto/DittoError$BusErrorReason$QueueFull;", "Llive/ditto/DittoError$BusErrorReason$ReliablePayloadTooLarge;", "Llive/ditto/DittoError$BusErrorReason$SendBeforeCompletion;", "Llive/ditto/DittoError$BusErrorReason$SendFailed;", "Llive/ditto/DittoError$BusErrorReason$StreamClosedByLocal;", "Llive/ditto/DittoError$BusErrorReason$StreamClosedByRemote;", "Llive/ditto/DittoError$BusErrorReason$StreamFailed;", "Llive/ditto/DittoError$BusErrorReason$UnreliablePayloadTooLarge;", "dittocpp_release"})
    public static abstract class BusErrorReason {
        private BusErrorReason() {
        }

        public /* synthetic */ BusErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$SendBeforeCompletion;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class SendBeforeCompletion
        extends BusErrorReason {
            @NotNull
            public static final SendBeforeCompletion INSTANCE = new SendBeforeCompletion();

            private SendBeforeCompletion() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$SendFailed;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class SendFailed
        extends BusErrorReason {
            @NotNull
            public static final SendFailed INSTANCE = new SendFailed();

            private SendFailed() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$OpenStreamFailed;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class OpenStreamFailed
        extends BusErrorReason {
            @NotNull
            public static final OpenStreamFailed INSTANCE = new OpenStreamFailed();

            private OpenStreamFailed() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$StreamClosedByRemote;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class StreamClosedByRemote
        extends BusErrorReason {
            @NotNull
            public static final StreamClosedByRemote INSTANCE = new StreamClosedByRemote();

            private StreamClosedByRemote() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$StreamClosedByLocal;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class StreamClosedByLocal
        extends BusErrorReason {
            @NotNull
            public static final StreamClosedByLocal INSTANCE = new StreamClosedByLocal();

            private StreamClosedByLocal() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$StreamFailed;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class StreamFailed
        extends BusErrorReason {
            @NotNull
            public static final StreamFailed INSTANCE = new StreamFailed();

            private StreamFailed() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$ReliablePayloadTooLarge;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class ReliablePayloadTooLarge
        extends BusErrorReason {
            @NotNull
            public static final ReliablePayloadTooLarge INSTANCE = new ReliablePayloadTooLarge();

            private ReliablePayloadTooLarge() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$UnreliablePayloadTooLarge;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class UnreliablePayloadTooLarge
        extends BusErrorReason {
            @NotNull
            public static final UnreliablePayloadTooLarge INSTANCE = new UnreliablePayloadTooLarge();

            private UnreliablePayloadTooLarge() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$BusErrorReason$QueueFull;", "Llive/ditto/DittoError$BusErrorReason;", "()V", "dittocpp_release"})
        public static final class QueueFull
        extends BusErrorReason {
            @NotNull
            public static final QueueFull INSTANCE = new QueueFull();

            private QueueFull() {
                super(null);
            }
        }
    }

    @Deprecated(message="These reasons are no longer used. See FatalError.message.")
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Llive/ditto/DittoError$InternalErrorReason;", "", "()V", "NativeReferenceMissing", "WeakReferenceCleared", "Llive/ditto/DittoError$InternalErrorReason$NativeReferenceMissing;", "Llive/ditto/DittoError$InternalErrorReason$WeakReferenceCleared;", "dittocpp_release"})
    public static abstract class InternalErrorReason {
        private InternalErrorReason() {
        }

        public /* synthetic */ InternalErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Deprecated(message="These reasons are no longer used. See FatalError.message.")
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$InternalErrorReason$NativeReferenceMissing;", "Llive/ditto/DittoError$InternalErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class NativeReferenceMissing
        extends InternalErrorReason {
            @NotNull
            private final String message;

            public NativeReferenceMissing(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final NativeReferenceMissing copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new NativeReferenceMissing(message);
            }

            public static /* synthetic */ NativeReferenceMissing copy$default(NativeReferenceMissing nativeReferenceMissing, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = nativeReferenceMissing.message;
                }
                return nativeReferenceMissing.copy(string);
            }

            @NotNull
            public String toString() {
                return "NativeReferenceMissing(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NativeReferenceMissing)) {
                    return false;
                }
                NativeReferenceMissing nativeReferenceMissing = (NativeReferenceMissing)other;
                return Intrinsics.areEqual((Object)this.message, (Object)nativeReferenceMissing.message);
            }
        }

        @Deprecated(message="These reasons are no longer used. See FatalError.message.")
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$InternalErrorReason$WeakReferenceCleared;", "Llive/ditto/DittoError$InternalErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class WeakReferenceCleared
        extends InternalErrorReason {
            @NotNull
            private final String message;

            public WeakReferenceCleared(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final WeakReferenceCleared copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new WeakReferenceCleared(message);
            }

            public static /* synthetic */ WeakReferenceCleared copy$default(WeakReferenceCleared weakReferenceCleared, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = weakReferenceCleared.message;
                }
                return weakReferenceCleared.copy(string);
            }

            @NotNull
            public String toString() {
                return "WeakReferenceCleared(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WeakReferenceCleared)) {
                    return false;
                }
                WeakReferenceCleared weakReferenceCleared = (WeakReferenceCleared)other;
                return Intrinsics.areEqual((Object)this.message, (Object)weakReferenceCleared.message);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Llive/ditto/DittoError$PresenceErrorReason;", "", "()V", "FailedToDecodeJson", "JsonParsingError", "Llive/ditto/DittoError$PresenceErrorReason$FailedToDecodeJson;", "Llive/ditto/DittoError$PresenceErrorReason$JsonParsingError;", "dittocpp_release"})
    public static abstract class PresenceErrorReason {
        private PresenceErrorReason() {
        }

        public /* synthetic */ PresenceErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$PresenceErrorReason$FailedToDecodeJson;", "Llive/ditto/DittoError$PresenceErrorReason;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class FailedToDecodeJson
        extends PresenceErrorReason {
            @NotNull
            private final Throwable error;

            public FailedToDecodeJson(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @NotNull
            public final Throwable component1() {
                return this.error;
            }

            @NotNull
            public final FailedToDecodeJson copy(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new FailedToDecodeJson(error);
            }

            public static /* synthetic */ FailedToDecodeJson copy$default(FailedToDecodeJson failedToDecodeJson, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = failedToDecodeJson.error;
                }
                return failedToDecodeJson.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "FailedToDecodeJson(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToDecodeJson)) {
                    return false;
                }
                FailedToDecodeJson failedToDecodeJson = (FailedToDecodeJson)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failedToDecodeJson.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$PresenceErrorReason$JsonParsingError;", "Llive/ditto/DittoError$PresenceErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class JsonParsingError
        extends PresenceErrorReason {
            @NotNull
            private final String message;

            public JsonParsingError(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final JsonParsingError copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new JsonParsingError(message);
            }

            public static /* synthetic */ JsonParsingError copy$default(JsonParsingError jsonParsingError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = jsonParsingError.message;
                }
                return jsonParsingError.copy(string);
            }

            @NotNull
            public String toString() {
                return "JsonParsingError(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JsonParsingError)) {
                    return false;
                }
                JsonParsingError jsonParsingError = (JsonParsingError)other;
                return Intrinsics.areEqual((Object)this.message, (Object)jsonParsingError.message);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u001b\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u001b\u001e\u001f !\"#$%&'()*+,-./012345678\u00a8\u00069"}, d2={"Llive/ditto/DittoError$StoreErrorReason;", "", "()V", "AttachmentCopyTargetAlreadyExists", "AttachmentDataRetrievalError", "AttachmentFileCopyError", "BackendError", "CrdtError", "DocumentContentEncodingFailed", "DocumentNotFound", "FailedToCopyAttachment", "FailedToDecodeCounter", "FailedToDecodeData", "FailedToDecodeDocument", "FailedToDecodeValue", "FailedToEncodeValue", "FailedToGetDocumentData", "FailedToGetDocumentIDData", "FailedToInitializeDittoDirectory", "InvalidCrdtType", "InvalidDocumentStructure", "InvalidLiveQueryId", "InvalidValueForCrdt", "NoIdPresentInDocument", "NonStringKeyInDocument", "QueryArgumentsInvalid", "QueryCompilationFailed", "QueryError", "QueryInvalid", "QueryNotSupported", "Llive/ditto/DittoError$StoreErrorReason$AttachmentCopyTargetAlreadyExists;", "Llive/ditto/DittoError$StoreErrorReason$AttachmentDataRetrievalError;", "Llive/ditto/DittoError$StoreErrorReason$AttachmentFileCopyError;", "Llive/ditto/DittoError$StoreErrorReason$BackendError;", "Llive/ditto/DittoError$StoreErrorReason$CrdtError;", "Llive/ditto/DittoError$StoreErrorReason$DocumentContentEncodingFailed;", "Llive/ditto/DittoError$StoreErrorReason$DocumentNotFound;", "Llive/ditto/DittoError$StoreErrorReason$FailedToCopyAttachment;", "Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeCounter;", "Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeData;", "Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeDocument;", "Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeValue;", "Llive/ditto/DittoError$StoreErrorReason$FailedToEncodeValue;", "Llive/ditto/DittoError$StoreErrorReason$FailedToGetDocumentData;", "Llive/ditto/DittoError$StoreErrorReason$FailedToGetDocumentIDData;", "Llive/ditto/DittoError$StoreErrorReason$FailedToInitializeDittoDirectory;", "Llive/ditto/DittoError$StoreErrorReason$InvalidCrdtType;", "Llive/ditto/DittoError$StoreErrorReason$InvalidDocumentStructure;", "Llive/ditto/DittoError$StoreErrorReason$InvalidLiveQueryId;", "Llive/ditto/DittoError$StoreErrorReason$InvalidValueForCrdt;", "Llive/ditto/DittoError$StoreErrorReason$NoIdPresentInDocument;", "Llive/ditto/DittoError$StoreErrorReason$NonStringKeyInDocument;", "Llive/ditto/DittoError$StoreErrorReason$QueryArgumentsInvalid;", "Llive/ditto/DittoError$StoreErrorReason$QueryCompilationFailed;", "Llive/ditto/DittoError$StoreErrorReason$QueryError;", "Llive/ditto/DittoError$StoreErrorReason$QueryInvalid;", "Llive/ditto/DittoError$StoreErrorReason$QueryNotSupported;", "dittocpp_release"})
    public static abstract class StoreErrorReason {
        private StoreErrorReason() {
        }

        public /* synthetic */ StoreErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreErrorReason$AttachmentCopyTargetAlreadyExists;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "Lkotlin/io/FileAlreadyExistsException;", "(Lkotlin/io/FileAlreadyExistsException;)V", "getError", "()Lkotlin/io/FileAlreadyExistsException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class AttachmentCopyTargetAlreadyExists
        extends StoreErrorReason {
            @NotNull
            private final FileAlreadyExistsException error;

            public AttachmentCopyTargetAlreadyExists(@NotNull FileAlreadyExistsException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final FileAlreadyExistsException getError() {
                return this.error;
            }

            @NotNull
            public final FileAlreadyExistsException component1() {
                return this.error;
            }

            @NotNull
            public final AttachmentCopyTargetAlreadyExists copy(@NotNull FileAlreadyExistsException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new AttachmentCopyTargetAlreadyExists(error);
            }

            public static /* synthetic */ AttachmentCopyTargetAlreadyExists copy$default(AttachmentCopyTargetAlreadyExists attachmentCopyTargetAlreadyExists, FileAlreadyExistsException fileAlreadyExistsException, int n, Object object) {
                if ((n & 1) != 0) {
                    fileAlreadyExistsException = attachmentCopyTargetAlreadyExists.error;
                }
                return attachmentCopyTargetAlreadyExists.copy(fileAlreadyExistsException);
            }

            @NotNull
            public String toString() {
                return "AttachmentCopyTargetAlreadyExists(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AttachmentCopyTargetAlreadyExists)) {
                    return false;
                }
                AttachmentCopyTargetAlreadyExists attachmentCopyTargetAlreadyExists = (AttachmentCopyTargetAlreadyExists)other;
                return Intrinsics.areEqual((Object)this.error, (Object)attachmentCopyTargetAlreadyExists.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\t\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Llive/ditto/DittoError$StoreErrorReason$AttachmentDataRetrievalError;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/Exception;)V", "getError", "()Ljava/lang/Exception;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class AttachmentDataRetrievalError
        extends StoreErrorReason {
            @NotNull
            private final Exception error;

            public AttachmentDataRetrievalError(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Exception getError() {
                return this.error;
            }

            @NotNull
            public final Exception component1() {
                return this.error;
            }

            @NotNull
            public final AttachmentDataRetrievalError copy(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new AttachmentDataRetrievalError(error);
            }

            public static /* synthetic */ AttachmentDataRetrievalError copy$default(AttachmentDataRetrievalError attachmentDataRetrievalError, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    exception = attachmentDataRetrievalError.error;
                }
                return attachmentDataRetrievalError.copy(exception);
            }

            @NotNull
            public String toString() {
                return "AttachmentDataRetrievalError(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AttachmentDataRetrievalError)) {
                    return false;
                }
                AttachmentDataRetrievalError attachmentDataRetrievalError = (AttachmentDataRetrievalError)other;
                return Intrinsics.areEqual((Object)this.error, (Object)attachmentDataRetrievalError.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\t\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Llive/ditto/DittoError$StoreErrorReason$AttachmentFileCopyError;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/Exception;)V", "getError", "()Ljava/lang/Exception;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class AttachmentFileCopyError
        extends StoreErrorReason {
            @NotNull
            private final Exception error;

            public AttachmentFileCopyError(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Exception getError() {
                return this.error;
            }

            @NotNull
            public final Exception component1() {
                return this.error;
            }

            @NotNull
            public final AttachmentFileCopyError copy(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new AttachmentFileCopyError(error);
            }

            public static /* synthetic */ AttachmentFileCopyError copy$default(AttachmentFileCopyError attachmentFileCopyError, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    exception = attachmentFileCopyError.error;
                }
                return attachmentFileCopyError.copy(exception);
            }

            @NotNull
            public String toString() {
                return "AttachmentFileCopyError(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AttachmentFileCopyError)) {
                    return false;
                }
                AttachmentFileCopyError attachmentFileCopyError = (AttachmentFileCopyError)other;
                return Intrinsics.areEqual((Object)this.error, (Object)attachmentFileCopyError.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$BackendError;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class BackendError
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public BackendError(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final BackendError copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new BackendError(message);
            }

            public static /* synthetic */ BackendError copy$default(BackendError backendError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = backendError.message;
                }
                return backendError.copy(string);
            }

            @NotNull
            public String toString() {
                return "BackendError(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BackendError)) {
                    return false;
                }
                BackendError backendError = (BackendError)other;
                return Intrinsics.areEqual((Object)this.message, (Object)backendError.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$CrdtError;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class CrdtError
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public CrdtError(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final CrdtError copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new CrdtError(message);
            }

            public static /* synthetic */ CrdtError copy$default(CrdtError crdtError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = crdtError.message;
                }
                return crdtError.copy(string);
            }

            @NotNull
            public String toString() {
                return "CrdtError(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CrdtError)) {
                    return false;
                }
                CrdtError crdtError = (CrdtError)other;
                return Intrinsics.areEqual((Object)this.message, (Object)crdtError.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\b\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0003J\u001b\u0010\t\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Llive/ditto/DittoError$StoreErrorReason$DocumentContentEncodingFailed;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/Exception;)V", "getError", "()Ljava/lang/Exception;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class DocumentContentEncodingFailed
        extends StoreErrorReason {
            @Nullable
            private final Exception error;

            public DocumentContentEncodingFailed(@Nullable Exception error) {
                super(null);
                this.error = error;
            }

            @Nullable
            public final Exception getError() {
                return this.error;
            }

            @Nullable
            public final Exception component1() {
                return this.error;
            }

            @NotNull
            public final DocumentContentEncodingFailed copy(@Nullable Exception error) {
                return new DocumentContentEncodingFailed(error);
            }

            public static /* synthetic */ DocumentContentEncodingFailed copy$default(DocumentContentEncodingFailed documentContentEncodingFailed, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    exception = documentContentEncodingFailed.error;
                }
                return documentContentEncodingFailed.copy(exception);
            }

            @NotNull
            public String toString() {
                return "DocumentContentEncodingFailed(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error == null ? 0 : this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DocumentContentEncodingFailed)) {
                    return false;
                }
                DocumentContentEncodingFailed documentContentEncodingFailed = (DocumentContentEncodingFailed)other;
                return Intrinsics.areEqual((Object)this.error, (Object)documentContentEncodingFailed.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$StoreErrorReason$DocumentNotFound;", "Llive/ditto/DittoError$StoreErrorReason;", "()V", "dittocpp_release"})
        public static final class DocumentNotFound
        extends StoreErrorReason {
            @NotNull
            public static final DocumentNotFound INSTANCE = new DocumentNotFound();

            private DocumentNotFound() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToCopyAttachment;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "Ljava/io/IOException;", "(Ljava/io/IOException;)V", "getError", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class FailedToCopyAttachment
        extends StoreErrorReason {
            @NotNull
            private final IOException error;

            public FailedToCopyAttachment(@NotNull IOException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final IOException getError() {
                return this.error;
            }

            @NotNull
            public final IOException component1() {
                return this.error;
            }

            @NotNull
            public final FailedToCopyAttachment copy(@NotNull IOException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new FailedToCopyAttachment(error);
            }

            public static /* synthetic */ FailedToCopyAttachment copy$default(FailedToCopyAttachment failedToCopyAttachment, IOException iOException, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = failedToCopyAttachment.error;
                }
                return failedToCopyAttachment.copy(iOException);
            }

            @NotNull
            public String toString() {
                return "FailedToCopyAttachment(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToCopyAttachment)) {
                    return false;
                }
                FailedToCopyAttachment failedToCopyAttachment = (FailedToCopyAttachment)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failedToCopyAttachment.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeCounter;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class FailedToDecodeCounter
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public FailedToDecodeCounter(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final FailedToDecodeCounter copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new FailedToDecodeCounter(message);
            }

            public static /* synthetic */ FailedToDecodeCounter copy$default(FailedToDecodeCounter failedToDecodeCounter, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = failedToDecodeCounter.message;
                }
                return failedToDecodeCounter.copy(string);
            }

            @NotNull
            public String toString() {
                return "FailedToDecodeCounter(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToDecodeCounter)) {
                    return false;
                }
                FailedToDecodeCounter failedToDecodeCounter = (FailedToDecodeCounter)other;
                return Intrinsics.areEqual((Object)this.message, (Object)failedToDecodeCounter.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeData;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "data", "", "(Ljava/lang/Exception;[B)V", "getData", "()[B", "getError", "()Ljava/lang/Exception;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class FailedToDecodeData
        extends StoreErrorReason {
            @Nullable
            private final Exception error;
            @NotNull
            private final byte[] data;

            public FailedToDecodeData(@Nullable Exception error, @NotNull byte[] data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super(null);
                this.error = error;
                this.data = data;
            }

            @Nullable
            public final Exception getError() {
                return this.error;
            }

            @NotNull
            public final byte[] getData() {
                return this.data;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type live.ditto.DittoError.StoreErrorReason.FailedToDecodeData");
                FailedToDecodeData cfr_ignored_0 = (FailedToDecodeData)other;
                if (!Intrinsics.areEqual((Object)this.error, (Object)((FailedToDecodeData)other).error)) {
                    return false;
                }
                return Arrays.equals(this.data, ((FailedToDecodeData)other).data);
            }

            public int hashCode() {
                Exception exception = this.error;
                int result = exception != null ? exception.hashCode() : 0;
                result = 31 * result + Arrays.hashCode(this.data);
                return result;
            }

            @Nullable
            public final Exception component1() {
                return this.error;
            }

            @NotNull
            public final byte[] component2() {
                return this.data;
            }

            @NotNull
            public final FailedToDecodeData copy(@Nullable Exception error, @NotNull byte[] data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return new FailedToDecodeData(error, data);
            }

            public static /* synthetic */ FailedToDecodeData copy$default(FailedToDecodeData failedToDecodeData, Exception exception, byte[] byArray, int n, Object object) {
                if ((n & 1) != 0) {
                    exception = failedToDecodeData.error;
                }
                if ((n & 2) != 0) {
                    byArray = failedToDecodeData.data;
                }
                return failedToDecodeData.copy(exception, byArray);
            }

            @NotNull
            public String toString() {
                return "FailedToDecodeData(error=" + this.error + ", data=" + Arrays.toString(this.data) + ")";
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeDocument;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class FailedToDecodeDocument
        extends StoreErrorReason {
            @NotNull
            private final Throwable error;

            public FailedToDecodeDocument(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @NotNull
            public final Throwable component1() {
                return this.error;
            }

            @NotNull
            public final FailedToDecodeDocument copy(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new FailedToDecodeDocument(error);
            }

            public static /* synthetic */ FailedToDecodeDocument copy$default(FailedToDecodeDocument failedToDecodeDocument, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = failedToDecodeDocument.error;
                }
                return failedToDecodeDocument.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "FailedToDecodeDocument(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToDecodeDocument)) {
                    return false;
                }
                FailedToDecodeDocument failedToDecodeDocument = (FailedToDecodeDocument)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failedToDecodeDocument.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToDecodeValue;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class FailedToDecodeValue
        extends StoreErrorReason {
            @NotNull
            private final Throwable error;

            public FailedToDecodeValue(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @NotNull
            public final Throwable component1() {
                return this.error;
            }

            @NotNull
            public final FailedToDecodeValue copy(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new FailedToDecodeValue(error);
            }

            public static /* synthetic */ FailedToDecodeValue copy$default(FailedToDecodeValue failedToDecodeValue, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = failedToDecodeValue.error;
                }
                return failedToDecodeValue.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "FailedToDecodeValue(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToDecodeValue)) {
                    return false;
                }
                FailedToDecodeValue failedToDecodeValue = (FailedToDecodeValue)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failedToDecodeValue.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToGetDocumentData;", "Llive/ditto/DittoError$StoreErrorReason;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class FailedToGetDocumentData
        extends StoreErrorReason {
            @NotNull
            private final String path;

            public FailedToGetDocumentData(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                super(null);
                this.path = path;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final FailedToGetDocumentData copy(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return new FailedToGetDocumentData(path);
            }

            public static /* synthetic */ FailedToGetDocumentData copy$default(FailedToGetDocumentData failedToGetDocumentData, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = failedToGetDocumentData.path;
                }
                return failedToGetDocumentData.copy(string);
            }

            @NotNull
            public String toString() {
                return "FailedToGetDocumentData(path=" + this.path + ")";
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToGetDocumentData)) {
                    return false;
                }
                FailedToGetDocumentData failedToGetDocumentData = (FailedToGetDocumentData)other;
                return Intrinsics.areEqual((Object)this.path, (Object)failedToGetDocumentData.path);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToGetDocumentIDData;", "Llive/ditto/DittoError$StoreErrorReason;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class FailedToGetDocumentIDData
        extends StoreErrorReason {
            @NotNull
            private final String path;

            public FailedToGetDocumentIDData(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                super(null);
                this.path = path;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final FailedToGetDocumentIDData copy(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return new FailedToGetDocumentIDData(path);
            }

            public static /* synthetic */ FailedToGetDocumentIDData copy$default(FailedToGetDocumentIDData failedToGetDocumentIDData, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = failedToGetDocumentIDData.path;
                }
                return failedToGetDocumentIDData.copy(string);
            }

            @NotNull
            public String toString() {
                return "FailedToGetDocumentIDData(path=" + this.path + ")";
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToGetDocumentIDData)) {
                    return false;
                }
                FailedToGetDocumentIDData failedToGetDocumentIDData = (FailedToGetDocumentIDData)other;
                return Intrinsics.areEqual((Object)this.path, (Object)failedToGetDocumentIDData.path);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToEncodeValue;", "Llive/ditto/DittoError$StoreErrorReason;", "value", "", "message", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "dittocpp_release"})
        public static final class FailedToEncodeValue
        extends StoreErrorReason {
            @NotNull
            private final Object value;
            @NotNull
            private final String message;

            public FailedToEncodeValue(@NotNull Object value, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.value = value;
                this.message = message;
            }

            @NotNull
            public final Object getValue() {
                return this.value;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final Object component1() {
                return this.value;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @NotNull
            public final FailedToEncodeValue copy(@NotNull Object value, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new FailedToEncodeValue(value, message);
            }

            public static /* synthetic */ FailedToEncodeValue copy$default(FailedToEncodeValue failedToEncodeValue, Object object, String string, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = failedToEncodeValue.value;
                }
                if ((n & 2) != 0) {
                    string = failedToEncodeValue.message;
                }
                return failedToEncodeValue.copy(object, string);
            }

            @NotNull
            public String toString() {
                return "FailedToEncodeValue(value=" + this.value + ", message=" + this.message + ")";
            }

            public int hashCode() {
                int result = this.value.hashCode();
                result = result * 31 + this.message.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToEncodeValue)) {
                    return false;
                }
                FailedToEncodeValue failedToEncodeValue = (FailedToEncodeValue)other;
                if (!Intrinsics.areEqual((Object)this.value, (Object)failedToEncodeValue.value)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.message, (Object)failedToEncodeValue.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreErrorReason$FailedToInitializeDittoDirectory;", "Llive/ditto/DittoError$StoreErrorReason;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class FailedToInitializeDittoDirectory
        extends StoreErrorReason {
            @NotNull
            private final Throwable error;

            public FailedToInitializeDittoDirectory(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @NotNull
            public final Throwable component1() {
                return this.error;
            }

            @NotNull
            public final FailedToInitializeDittoDirectory copy(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new FailedToInitializeDittoDirectory(error);
            }

            public static /* synthetic */ FailedToInitializeDittoDirectory copy$default(FailedToInitializeDittoDirectory failedToInitializeDittoDirectory, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = failedToInitializeDittoDirectory.error;
                }
                return failedToInitializeDittoDirectory.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "FailedToInitializeDittoDirectory(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToInitializeDittoDirectory)) {
                    return false;
                }
                FailedToInitializeDittoDirectory failedToInitializeDittoDirectory = (FailedToInitializeDittoDirectory)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failedToInitializeDittoDirectory.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$InvalidCrdtType;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class InvalidCrdtType
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public InvalidCrdtType(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final InvalidCrdtType copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new InvalidCrdtType(message);
            }

            public static /* synthetic */ InvalidCrdtType copy$default(InvalidCrdtType invalidCrdtType, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = invalidCrdtType.message;
                }
                return invalidCrdtType.copy(string);
            }

            @NotNull
            public String toString() {
                return "InvalidCrdtType(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InvalidCrdtType)) {
                    return false;
                }
                InvalidCrdtType invalidCrdtType = (InvalidCrdtType)other;
                return Intrinsics.areEqual((Object)this.message, (Object)invalidCrdtType.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreErrorReason$InvalidDocumentStructure;", "Llive/ditto/DittoError$StoreErrorReason;", "cbor", "", "([B)V", "getCbor", "()[B", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class InvalidDocumentStructure
        extends StoreErrorReason {
            @NotNull
            private final byte[] cbor;

            public InvalidDocumentStructure(@NotNull byte[] cbor) {
                Intrinsics.checkNotNullParameter((Object)cbor, (String)"cbor");
                super(null);
                this.cbor = cbor;
            }

            @NotNull
            public final byte[] getCbor() {
                return this.cbor;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type live.ditto.DittoError.StoreErrorReason.InvalidDocumentStructure");
                InvalidDocumentStructure cfr_ignored_0 = (InvalidDocumentStructure)other;
                return Arrays.equals(this.cbor, ((InvalidDocumentStructure)other).cbor);
            }

            public int hashCode() {
                return Arrays.hashCode(this.cbor);
            }

            @NotNull
            public final byte[] component1() {
                return this.cbor;
            }

            @NotNull
            public final InvalidDocumentStructure copy(@NotNull byte[] cbor) {
                Intrinsics.checkNotNullParameter((Object)cbor, (String)"cbor");
                return new InvalidDocumentStructure(cbor);
            }

            public static /* synthetic */ InvalidDocumentStructure copy$default(InvalidDocumentStructure invalidDocumentStructure, byte[] byArray, int n, Object object) {
                if ((n & 1) != 0) {
                    byArray = invalidDocumentStructure.cbor;
                }
                return invalidDocumentStructure.copy(byArray);
            }

            @NotNull
            public String toString() {
                return "InvalidDocumentStructure(cbor=" + Arrays.toString(this.cbor) + ")";
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$InvalidLiveQueryId;", "Llive/ditto/DittoError$StoreErrorReason;", "id", "", "(I)V", "getId", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "dittocpp_release"})
        public static final class InvalidLiveQueryId
        extends StoreErrorReason {
            private final int id;

            public InvalidLiveQueryId(int id) {
                super(null);
                this.id = id;
            }

            public final int getId() {
                return this.id;
            }

            public final int component1() {
                return this.id;
            }

            @NotNull
            public final InvalidLiveQueryId copy(int id) {
                return new InvalidLiveQueryId(id);
            }

            public static /* synthetic */ InvalidLiveQueryId copy$default(InvalidLiveQueryId invalidLiveQueryId, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = invalidLiveQueryId.id;
                }
                return invalidLiveQueryId.copy(n);
            }

            @NotNull
            public String toString() {
                return "InvalidLiveQueryId(id=" + this.id + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.id);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InvalidLiveQueryId)) {
                    return false;
                }
                InvalidLiveQueryId invalidLiveQueryId = (InvalidLiveQueryId)other;
                return this.id == invalidLiveQueryId.id;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$InvalidValueForCrdt;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class InvalidValueForCrdt
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public InvalidValueForCrdt(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final InvalidValueForCrdt copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new InvalidValueForCrdt(message);
            }

            public static /* synthetic */ InvalidValueForCrdt copy$default(InvalidValueForCrdt invalidValueForCrdt, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = invalidValueForCrdt.message;
                }
                return invalidValueForCrdt.copy(string);
            }

            @NotNull
            public String toString() {
                return "InvalidValueForCrdt(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InvalidValueForCrdt)) {
                    return false;
                }
                InvalidValueForCrdt invalidValueForCrdt = (InvalidValueForCrdt)other;
                return Intrinsics.areEqual((Object)this.message, (Object)invalidValueForCrdt.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$StoreErrorReason$NoIdPresentInDocument;", "Llive/ditto/DittoError$StoreErrorReason;", "()V", "dittocpp_release"})
        public static final class NoIdPresentInDocument
        extends StoreErrorReason {
            @NotNull
            public static final NoIdPresentInDocument INSTANCE = new NoIdPresentInDocument();

            private NoIdPresentInDocument() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$StoreErrorReason$NonStringKeyInDocument;", "Llive/ditto/DittoError$StoreErrorReason;", "key", "", "([B)V", "getKey", "()[B", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class NonStringKeyInDocument
        extends StoreErrorReason {
            @NotNull
            private final byte[] key;

            public NonStringKeyInDocument(@NotNull byte[] key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                super(null);
                this.key = key;
            }

            @NotNull
            public final byte[] getKey() {
                return this.key;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                Object object = other;
                if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type live.ditto.DittoError.StoreErrorReason.NonStringKeyInDocument");
                NonStringKeyInDocument cfr_ignored_0 = (NonStringKeyInDocument)other;
                return Arrays.equals(this.key, ((NonStringKeyInDocument)other).key);
            }

            public int hashCode() {
                return Arrays.hashCode(this.key);
            }

            @NotNull
            public final byte[] component1() {
                return this.key;
            }

            @NotNull
            public final NonStringKeyInDocument copy(@NotNull byte[] key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new NonStringKeyInDocument(key);
            }

            public static /* synthetic */ NonStringKeyInDocument copy$default(NonStringKeyInDocument nonStringKeyInDocument, byte[] byArray, int n, Object object) {
                if ((n & 1) != 0) {
                    byArray = nonStringKeyInDocument.key;
                }
                return nonStringKeyInDocument.copy(byArray);
            }

            @NotNull
            public String toString() {
                return "NonStringKeyInDocument(key=" + Arrays.toString(this.key) + ")";
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$StoreErrorReason$QueryArgumentsInvalid;", "Llive/ditto/DittoError$StoreErrorReason;", "()V", "dittocpp_release"})
        public static final class QueryArgumentsInvalid
        extends StoreErrorReason {
            @NotNull
            public static final QueryArgumentsInvalid INSTANCE = new QueryArgumentsInvalid();

            private QueryArgumentsInvalid() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$QueryCompilationFailed;", "Llive/ditto/DittoError$StoreErrorReason;", "query", "", "(Ljava/lang/String;)V", "getQuery", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class QueryCompilationFailed
        extends StoreErrorReason {
            @NotNull
            private final String query;

            public QueryCompilationFailed(@NotNull String query) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                super(null);
                this.query = query;
            }

            @NotNull
            public final String getQuery() {
                return this.query;
            }

            @NotNull
            public final String component1() {
                return this.query;
            }

            @NotNull
            public final QueryCompilationFailed copy(@NotNull String query) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                return new QueryCompilationFailed(query);
            }

            public static /* synthetic */ QueryCompilationFailed copy$default(QueryCompilationFailed queryCompilationFailed, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = queryCompilationFailed.query;
                }
                return queryCompilationFailed.copy(string);
            }

            @NotNull
            public String toString() {
                return "QueryCompilationFailed(query=" + this.query + ")";
            }

            public int hashCode() {
                return this.query.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof QueryCompilationFailed)) {
                    return false;
                }
                QueryCompilationFailed queryCompilationFailed = (QueryCompilationFailed)other;
                return Intrinsics.areEqual((Object)this.query, (Object)queryCompilationFailed.query);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$QueryError;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class QueryError
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public QueryError(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final QueryError copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new QueryError(message);
            }

            public static /* synthetic */ QueryError copy$default(QueryError queryError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = queryError.message;
                }
                return queryError.copy(string);
            }

            @NotNull
            public String toString() {
                return "QueryError(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof QueryError)) {
                    return false;
                }
                QueryError queryError = (QueryError)other;
                return Intrinsics.areEqual((Object)this.message, (Object)queryError.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$QueryInvalid;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class QueryInvalid
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public QueryInvalid(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final QueryInvalid copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new QueryInvalid(message);
            }

            public static /* synthetic */ QueryInvalid copy$default(QueryInvalid queryInvalid, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = queryInvalid.message;
                }
                return queryInvalid.copy(string);
            }

            @NotNull
            public String toString() {
                return "QueryInvalid(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof QueryInvalid)) {
                    return false;
                }
                QueryInvalid queryInvalid = (QueryInvalid)other;
                return Intrinsics.areEqual((Object)this.message, (Object)queryInvalid.message);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$StoreErrorReason$QueryNotSupported;", "Llive/ditto/DittoError$StoreErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class QueryNotSupported
        extends StoreErrorReason {
            @NotNull
            private final String message;

            public QueryNotSupported(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final QueryNotSupported copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new QueryNotSupported(message);
            }

            public static /* synthetic */ QueryNotSupported copy$default(QueryNotSupported queryNotSupported, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = queryNotSupported.message;
                }
                return queryNotSupported.copy(string);
            }

            @NotNull
            public String toString() {
                return "QueryNotSupported(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof QueryNotSupported)) {
                    return false;
                }
                QueryNotSupported queryNotSupported = (QueryNotSupported)other;
                return Intrinsics.areEqual((Object)this.message, (Object)queryNotSupported.message);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Llive/ditto/DittoError$TransportErrorReason;", "", "()V", "FailedToDecodeTransportDiagnostics", "IncorrectPlatformTransportConfig", "Llive/ditto/DittoError$TransportErrorReason$FailedToDecodeTransportDiagnostics;", "Llive/ditto/DittoError$TransportErrorReason$IncorrectPlatformTransportConfig;", "dittocpp_release"})
    public static abstract class TransportErrorReason {
        private TransportErrorReason() {
        }

        public /* synthetic */ TransportErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/ditto/DittoError$TransportErrorReason$FailedToDecodeTransportDiagnostics;", "Llive/ditto/DittoError$TransportErrorReason;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "dittocpp_release"})
        public static final class FailedToDecodeTransportDiagnostics
        extends TransportErrorReason {
            @NotNull
            private final Throwable error;

            public FailedToDecodeTransportDiagnostics(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @NotNull
            public final Throwable component1() {
                return this.error;
            }

            @NotNull
            public final FailedToDecodeTransportDiagnostics copy(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new FailedToDecodeTransportDiagnostics(error);
            }

            public static /* synthetic */ FailedToDecodeTransportDiagnostics copy$default(FailedToDecodeTransportDiagnostics failedToDecodeTransportDiagnostics, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = failedToDecodeTransportDiagnostics.error;
                }
                return failedToDecodeTransportDiagnostics.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "FailedToDecodeTransportDiagnostics(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToDecodeTransportDiagnostics)) {
                    return false;
                }
                FailedToDecodeTransportDiagnostics failedToDecodeTransportDiagnostics = (FailedToDecodeTransportDiagnostics)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failedToDecodeTransportDiagnostics.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$TransportErrorReason$IncorrectPlatformTransportConfig;", "Llive/ditto/DittoError$TransportErrorReason;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class IncorrectPlatformTransportConfig
        extends TransportErrorReason {
            @NotNull
            private final String error;

            public IncorrectPlatformTransportConfig(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final String getError() {
                return this.error;
            }

            @NotNull
            public final String component1() {
                return this.error;
            }

            @NotNull
            public final IncorrectPlatformTransportConfig copy(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new IncorrectPlatformTransportConfig(error);
            }

            public static /* synthetic */ IncorrectPlatformTransportConfig copy$default(IncorrectPlatformTransportConfig incorrectPlatformTransportConfig, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = incorrectPlatformTransportConfig.error;
                }
                return incorrectPlatformTransportConfig.copy(string);
            }

            @NotNull
            public String toString() {
                return "IncorrectPlatformTransportConfig(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IncorrectPlatformTransportConfig)) {
                    return false;
                }
                IncorrectPlatformTransportConfig incorrectPlatformTransportConfig = (IncorrectPlatformTransportConfig)other;
                return Intrinsics.areEqual((Object)this.error, (Object)incorrectPlatformTransportConfig.error);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Llive/ditto/DittoError$ValidationErrorReason;", "", "()V", "DepthLimitExceeded", "InternalSubsystemUnavailable", "NotAMap", "SizeLimitExceeded", "UnknownSyncScope", "Llive/ditto/DittoError$ValidationErrorReason$DepthLimitExceeded;", "Llive/ditto/DittoError$ValidationErrorReason$InternalSubsystemUnavailable;", "Llive/ditto/DittoError$ValidationErrorReason$NotAMap;", "Llive/ditto/DittoError$ValidationErrorReason$SizeLimitExceeded;", "Llive/ditto/DittoError$ValidationErrorReason$UnknownSyncScope;", "dittocpp_release"})
    public static abstract class ValidationErrorReason {
        private ValidationErrorReason() {
        }

        public /* synthetic */ ValidationErrorReason(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$ValidationErrorReason$InternalSubsystemUnavailable;", "Llive/ditto/DittoError$ValidationErrorReason;", "()V", "dittocpp_release"})
        public static final class InternalSubsystemUnavailable
        extends ValidationErrorReason {
            @NotNull
            public static final InternalSubsystemUnavailable INSTANCE = new InternalSubsystemUnavailable();

            private InternalSubsystemUnavailable() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$ValidationErrorReason$SizeLimitExceeded;", "Llive/ditto/DittoError$ValidationErrorReason;", "()V", "dittocpp_release"})
        public static final class SizeLimitExceeded
        extends ValidationErrorReason {
            @NotNull
            public static final SizeLimitExceeded INSTANCE = new SizeLimitExceeded();

            private SizeLimitExceeded() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$ValidationErrorReason$DepthLimitExceeded;", "Llive/ditto/DittoError$ValidationErrorReason;", "()V", "dittocpp_release"})
        public static final class DepthLimitExceeded
        extends ValidationErrorReason {
            @NotNull
            public static final DepthLimitExceeded INSTANCE = new DepthLimitExceeded();

            private DepthLimitExceeded() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/ditto/DittoError$ValidationErrorReason$NotAMap;", "Llive/ditto/DittoError$ValidationErrorReason;", "()V", "dittocpp_release"})
        public static final class NotAMap
        extends ValidationErrorReason {
            @NotNull
            public static final NotAMap INSTANCE = new NotAMap();

            private NotAMap() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/DittoError$ValidationErrorReason$UnknownSyncScope;", "Llive/ditto/DittoError$ValidationErrorReason;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "dittocpp_release"})
        public static final class UnknownSyncScope
        extends ValidationErrorReason {
            @NotNull
            private final String message;

            public UnknownSyncScope(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final UnknownSyncScope copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new UnknownSyncScope(message);
            }

            public static /* synthetic */ UnknownSyncScope copy$default(UnknownSyncScope unknownSyncScope, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unknownSyncScope.message;
                }
                return unknownSyncScope.copy(string);
            }

            @NotNull
            public String toString() {
                return "UnknownSyncScope(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnknownSyncScope)) {
                    return false;
                }
                UnknownSyncScope unknownSyncScope = (UnknownSyncScope)other;
                return Intrinsics.areEqual((Object)this.message, (Object)unknownSyncScope.message);
            }
        }
    }
}

