/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\t\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b\u000b\u0010\tJ!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b\u0011\u0010\tJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llive/ditto/transports/DittoSyncPermissions;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "missingBluetoothClientPermissions", "", "", "missingBluetoothClientPermissions$dittocpp_release", "()[Ljava/lang/String;", "missingBluetoothServerPermissions", "missingBluetoothServerPermissions$dittocpp_release", "missingPermissions", "permissions", "", "(Ljava/util/List;)[Ljava/lang/String;", "missingWiFiAwarePermissions", "missingWiFiAwarePermissions$dittocpp_release", "requiredBluetoothClientPermissions", "requiredBluetoothServerPermissions", "requiredPermissions", "requiredWifiAwarePermissions", "Companion", "dittocpp_release"})
public final class DittoSyncPermissions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context context;
    @NotNull
    private static String TAG = "DittoSyncPermissions";

    public DittoSyncPermissions(@Nullable Context context) {
        this.context = context;
    }

    @NotNull
    public final String[] missingPermissions(@NotNull List<String> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        List missing = new ArrayList();
        Context context = this.context;
        if (context != null) {
            Context it = context;
            boolean bl = false;
            for (String permission : permissions) {
                if (!Companion.isMissing(permission, this.context)) continue;
                Log.e((String)TAG, (String)("Missing permission " + permission));
                missing.add(permission);
            }
        }
        Collection $this$toTypedArray$iv = missing;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return stringArray;
    }

    public static /* synthetic */ String[] missingPermissions$default(DittoSyncPermissions dittoSyncPermissions, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = dittoSyncPermissions.requiredPermissions();
        }
        return dittoSyncPermissions.missingPermissions(list);
    }

    @NotNull
    public final String[] missingBluetoothClientPermissions$dittocpp_release() {
        return this.missingPermissions(this.requiredBluetoothClientPermissions());
    }

    @NotNull
    public final String[] missingBluetoothServerPermissions$dittocpp_release() {
        return this.missingPermissions(this.requiredBluetoothServerPermissions());
    }

    @NotNull
    public final String[] missingWiFiAwarePermissions$dittocpp_release() {
        return this.missingPermissions(this.requiredWifiAwarePermissions());
    }

    private final List<String> requiredBluetoothClientPermissions() {
        List required = new ArrayList();
        if (Build.VERSION.SDK_INT >= 31) {
            required.add("android.permission.BLUETOOTH_CONNECT");
            required.add("android.permission.BLUETOOTH_SCAN");
        }
        if (Build.VERSION.SDK_INT <= 30) {
            required.add("android.permission.ACCESS_FINE_LOCATION");
        }
        return required;
    }

    private final List<String> requiredBluetoothServerPermissions() {
        List required = new ArrayList();
        if (Build.VERSION.SDK_INT >= 31) {
            required.add("android.permission.BLUETOOTH_ADVERTISE");
            required.add("android.permission.BLUETOOTH_CONNECT");
        }
        return required;
    }

    private final List<String> requiredWifiAwarePermissions() {
        List required = new ArrayList();
        if (Build.VERSION.SDK_INT >= 33) {
            required.add("android.permission.NEARBY_WIFI_DEVICES");
        } else {
            required.add("android.permission.ACCESS_FINE_LOCATION");
        }
        return required;
    }

    @NotNull
    public final List<String> requiredPermissions() {
        List required = new ArrayList();
        required.addAll((Collection)this.requiredBluetoothClientPermissions());
        required.addAll((Collection)this.requiredBluetoothServerPermissions());
        required.addAll((Collection)this.requiredWifiAwarePermissions());
        return CollectionsKt.distinct((Iterable)required);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Llive/ditto/transports/DittoSyncPermissions$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "isMissing", "", "permission", "context", "Landroid/content/Context;", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMissing(@NotNull String permission, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission) != 0) {
                DittoLog.e$default(this.getTAG(), "Ditto is missing a required permission: " + permission, null, 4, null);
                return true;
            }
            return false;
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public final void setTAG(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            TAG = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

