/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import android.content.Context;
import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.aware.WifiAwareSession;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoLog;
import live.ditto.internal.ffi.FfiResource;
import live.ditto.internal.swig.ffi.ConnectState_t;
import live.ditto.internal.swig.ffi.SWIGTYPE_p_CDitto;
import live.ditto.internal.swig.ffi.WifiAwareRust;
import live.ditto.transports.ClientSearchingParams;
import live.ditto.transports.DittoSyncPermissions;
import live.ditto.transports.PeerState;
import live.ditto.transports.ServerAdvertisingParams;
import live.ditto.transports.WifiAwarePlatform;
import live.ditto.transports.WifiAwarePublisher;
import live.ditto.transports.WifiAwareSubscriber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0001\u0018\u0000 K2\u00020\u0001:\u0001KB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u001fH\u0016J\u001c\u0010/\u001a\u00020-2\b\u00100\u001a\u0004\u0018\u00010\u001f2\b\u00101\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u00102\u001a\u00020-H\u0016J\u001a\u00103\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u001f2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020-H\u0016J\u0006\u00107\u001a\u00020-J\u0018\u00108\u001a\u00020-2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0002J \u00109\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020;H\u0002J\u001a\u0010<\u001a\u00020-2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00160>J\u000e\u0010?\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001fJ\u0006\u0010@\u001a\u00020\u0016J\u0006\u0010A\u001a\u00020\u0016J\b\u0010B\u001a\u00020\u0016H\u0002J\u0006\u0010C\u001a\u00020-J\u0006\u0010D\u001a\u00020-J\u0006\u0010E\u001a\u00020-J$\u0010F\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u001f2\b\u00100\u001a\u0004\u0018\u00010\u001f2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010G\u001a\u00020-H\u0016J\u001a\u0010H\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u001f2\u0006\u00104\u001a\u000205H\u0016J\u0018\u0010I\u001a\u0004\u0018\u00010 2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020 R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Llive/ditto/transports/WifiAwarePlatform;", "Llive/ditto/internal/swig/ffi/WifiAwareRust;", "context", "Landroid/content/Context;", "ditto", "Llive/ditto/internal/swig/ffi/SWIGTYPE_p_CDitto;", "(Landroid/content/Context;Llive/ditto/internal/swig/ffi/SWIGTYPE_p_CDitto;)V", "awareSession", "Landroid/net/wifi/aware/WifiAwareSession;", "getAwareSession", "()Landroid/net/wifi/aware/WifiAwareSession;", "setAwareSession", "(Landroid/net/wifi/aware/WifiAwareSession;)V", "characteristics", "Landroid/net/wifi/aware/Characteristics;", "getCharacteristics$dittocpp_release", "()Landroid/net/wifi/aware/Characteristics;", "setCharacteristics$dittocpp_release", "(Landroid/net/wifi/aware/Characteristics;)V", "clientSearchingParams", "Llive/ditto/transports/ClientSearchingParams;", "closed", "", "getContext", "()Landroid/content/Context;", "getDitto", "()Llive/ditto/internal/swig/ffi/SWIGTYPE_p_CDitto;", "lastResetTimestamp", "", "peerStates", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Llive/ditto/transports/PeerState;", "pendingReset", "resetToken", "", "retryToken", "serverAdvertisingParams", "Llive/ditto/transports/ServerAdvertisingParams;", "transportsAdded", "wifiAwarePublisher", "Llive/ditto/transports/WifiAwarePublisher;", "wifiAwareSubscriber", "Llive/ditto/transports/WifiAwareSubscriber;", "clientCreateNetwork", "", "announce", "clientStartSearching", "hashedAppName", "localAnnounce", "clientStopSearching", "clientUpdatePeer", "status", "Llive/ditto/internal/swig/ffi/ConnectState_t;", "close", "doAttach", "doClientStartSearching", "doServerStartAdvertising", "servicePort", "", "dumpPeerStates", "filter", "Lkotlin/Function1;", "getPeerState", "isAdvertising", "isSearching", "isStale", "queueDelayedReset", "refreshPermissions", "resetWifiAware", "serverStartAdvertising", "serverStopAdvertising", "serverUpdatePeer", "updatePeerState", "state", "Companion", "dittocpp_release"})
@RequiresApi(value=29)
public final class WifiAwarePlatform
extends WifiAwareRust {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final SWIGTYPE_p_CDitto ditto;
    @Nullable
    private WifiAwareSession awareSession;
    private boolean transportsAdded;
    private boolean closed;
    @Nullable
    private WifiAwareSubscriber wifiAwareSubscriber;
    @Nullable
    private WifiAwarePublisher wifiAwarePublisher;
    @NotNull
    private Object retryToken;
    @NotNull
    private Object resetToken;
    @Nullable
    private ClientSearchingParams clientSearchingParams;
    @Nullable
    private ServerAdvertisingParams serverAdvertisingParams;
    @Nullable
    private Characteristics characteristics;
    @NotNull
    private final ConcurrentHashMap<String, PeerState> peerStates;
    private long lastResetTimestamp;
    private boolean pendingReset;
    @NotNull
    private static final String TAG = "WifiAwarePlatform";

    public WifiAwarePlatform(@NotNull Context context, @NotNull SWIGTYPE_p_CDitto ditto) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ditto, (String)"ditto");
        this.context = context;
        this.ditto = ditto;
        this.retryToken = new Object();
        this.resetToken = new Object();
        this.peerStates = new ConcurrentHashMap();
        this.lastResetTimestamp = SystemClock.elapsedRealtime();
        DittoLog.d$default(TAG, "Init", null, 4, null);
        FfiResource.retain(this);
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.wifi.aware")) {
            DittoLog.e$default(TAG, "Device DOES NOT support WiFi Aware, skipping setup", null, 4, null);
        } else {
            DittoLog.d$default(TAG, "Device supports WiFi Aware", null, 4, null);
            this.doAttach();
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final SWIGTYPE_p_CDitto getDitto() {
        return this.ditto;
    }

    @Nullable
    public final WifiAwareSession getAwareSession() {
        return this.awareSession;
    }

    public final void setAwareSession(@Nullable WifiAwareSession wifiAwareSession) {
        this.awareSession = wifiAwareSession;
    }

    @Nullable
    public final Characteristics getCharacteristics$dittocpp_release() {
        return this.characteristics;
    }

    public final void setCharacteristics$dittocpp_release(@Nullable Characteristics characteristics) {
        this.characteristics = characteristics;
    }

    public final boolean isSearching() {
        return this.clientSearchingParams != null;
    }

    public final boolean isAdvertising() {
        return this.serverAdvertisingParams != null;
    }

    @Nullable
    public final PeerState updatePeerState(@NotNull String announce, @NotNull PeerState state) {
        PeerState oldState;
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        PeerState peerState = oldState = this.peerStates.get(announce);
        DittoLog.d$default(TAG, "PeerState(" + announce + ") " + (peerState != null ? peerState.name() : null) + " => " + state.name(), null, 4, null);
        ((Map)this.peerStates).put(announce, state);
        return oldState;
    }

    @NotNull
    public final PeerState getPeerState(@NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        PeerState peerState = this.peerStates.get(announce);
        if (peerState == null) {
            peerState = PeerState.Idle;
        }
        return peerState;
    }

    public final void dumpPeerStates(@NotNull Function1<? super PeerState, Boolean> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Object dump = null;
        dump = "Peer States:\n";
        Map $this$forEach$iv = this.peerStates;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)filter.invoke(it.getValue())).booleanValue()) continue;
            dump = dump + it.getKey() + ": " + it.getValue() + "\n";
        }
        DittoLog.d$default(TAG, dump, null, 4, null);
    }

    private final boolean isStale() {
        boolean bl;
        long now;
        block9: {
            now = SystemClock.elapsedRealtime();
            this.dumpPeerStates((Function1<? super PeerState, Boolean>)((Function1)isStale.1.INSTANCE));
            if (now - this.lastResetTimestamp < 120000L) {
                return false;
            }
            Map $this$any$iv = this.peerStates;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!((PeerState)((Object)it.getValue())).isConnected()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (!bl) {
            Object it;
            WifiAwarePublisher wifiAwarePublisher = this.wifiAwarePublisher;
            if (wifiAwarePublisher != null) {
                it = wifiAwarePublisher;
                boolean bl3 = false;
                long staleness = now - ((WifiAwarePublisher)it).getLatestDisconnectTimestamp();
                DittoLog.d$default(TAG, "publisher staleness: " + staleness, null, 4, null);
                if (now - ((WifiAwarePublisher)it).getLatestDisconnectTimestamp() > 120000L) {
                    DittoLog.w$default(TAG, "Detected a stale publisher.", null, 4, null);
                    return true;
                }
            }
            WifiAwareSubscriber wifiAwareSubscriber = this.wifiAwareSubscriber;
            if (wifiAwareSubscriber != null) {
                it = wifiAwareSubscriber;
                boolean bl4 = false;
                long disconnectStaleness = now - ((WifiAwareSubscriber)it).getLatestDisconnectTimestamp();
                long connectStaleness = now - ((WifiAwareSubscriber)it).getLatestConnectAttemptTimestamp();
                DittoLog.d$default(TAG, "subscriber disconnect staleness: " + disconnectStaleness, null, 4, null);
                DittoLog.d$default(TAG, "subscriber connect freshness: " + connectStaleness, null, 4, null);
                boolean bl5 = connectStaleness + 1L <= 120000L ? 120000L < disconnectStaleness : false;
                if (bl5) {
                    DittoLog.w$default(TAG, "Detected a stale subscriber.", null, 4, null);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void close() {
        DittoLog.d$default(TAG, "WiFi aware shutting down", null, 4, null);
        if (this.closed) {
            DittoLog.d$default(TAG, "Already closed, returning.", null, 4, null);
            return;
        }
        super.close();
        this.closed = true;
        new Handler(this.context.getMainLooper()).removeCallbacksAndMessages(this.retryToken);
        new Handler(this.context.getMainLooper()).removeCallbacksAndMessages(this.resetToken);
        this.clientStopSearching();
        this.serverStopAdvertising();
        this.peerStates.clear();
        WifiAwareSession wifiAwareSession = this.awareSession;
        if (wifiAwareSession != null) {
            wifiAwareSession.close();
        }
        this.awareSession = null;
    }

    public final void doAttach() {
        WifiAwareManager manager2;
        DittoLog.d$default(TAG, "doAttach", null, 4, null);
        String[] permissions = new DittoSyncPermissions(this.context).missingWiFiAwarePermissions$dittocpp_release();
        if (!(permissions.length == 0)) {
            DittoLog.e$default(TAG, "Not all permissions required by Wifi Aware have been granted", null, 4, null);
            for (String permission : permissions) {
                DittoLog.e$default(TAG, "Missing permission: " + permission, null, 4, null);
            }
            new Handler(this.context.getMainLooper()).postDelayed(() -> WifiAwarePlatform.doAttach$lambda-4(this), this.retryToken, 5000L);
            return;
        }
        Object object = this.context.getSystemService("wifiaware");
        WifiAwareManager wifiAwareManager = manager2 = object instanceof WifiAwareManager ? (WifiAwareManager)object : null;
        if (manager2 == null || !manager2.isAvailable()) {
            DittoLog.d$default(TAG, "WiFi Aware not available", null, 4, null);
            return;
        }
        this.characteristics = manager2.getCharacteristics();
        new Handler(this.context.getMainLooper()).removeCallbacksAndMessages(this.retryToken);
        if (this.awareSession != null) {
            DittoLog.d$default(TAG, "doAttach - already attached", null, 4, null);
            return;
        }
        WifiAwarePlatform platform = this;
        manager2.attach(new AttachCallback(platform, this){
            final /* synthetic */ WifiAwarePlatform $platform;
            final /* synthetic */ WifiAwarePlatform this$0;
            {
                this.$platform = $platform;
                this.this$0 = $receiver;
            }

            public void onAttached(@Nullable WifiAwareSession session) {
                DittoLog.d$default("WifiAwarePlatform", "onAttached", null, 4, null);
                if (WifiAwarePlatform.access$getClosed$p(this.$platform)) {
                    DittoLog.w$default("WifiAwarePlatform", "Platform already closed, closing session", null, 4, null);
                    WifiAwareSession wifiAwareSession = session;
                    if (wifiAwareSession != null) {
                        wifiAwareSession.close();
                    }
                    return;
                }
                this.this$0.setAwareSession(session);
                if (!WifiAwarePlatform.access$getTransportsAdded$p(this.$platform)) {
                    this.$platform.addWifiAwareClientTransport(this.this$0.getDitto());
                    this.$platform.addWifiAwareServerAdvertiser(this.this$0.getDitto());
                    WifiAwarePlatform.access$setTransportsAdded$p(this.$platform, true);
                }
                this.this$0.refreshPermissions();
            }

            public void onAttachFailed() {
                DittoLog.w$default("WifiAwarePlatform", "onAttachFailed", null, 4, null);
                if (WifiAwarePlatform.access$getClosed$p(this.$platform)) {
                    return;
                }
                this.this$0.queueDelayedReset();
            }

            public void onAwareSessionTerminated() {
                DittoLog.d$default("WifiAwarePlatform", "onAwareSessionTerminated", null, 4, null);
                if (WifiAwarePlatform.access$getClosed$p(this.$platform)) {
                    return;
                }
                this.this$0.queueDelayedReset();
            }
        }, null);
    }

    public final void queueDelayedReset() {
        DittoLog.w$default(TAG, "queueDelayedReset()", null, 4, null);
        if (this.pendingReset) {
            return;
        }
        this.pendingReset = true;
        DittoLog.w$default(TAG, "reset queued in 5000ms", null, 4, null);
        new Handler(this.context.getMainLooper()).postDelayed(() -> WifiAwarePlatform.queueDelayedReset$lambda-5(this), this.resetToken, 5000L);
    }

    public final void refreshPermissions() {
        DittoLog.d$default(TAG, "refreshPermissions", null, 4, null);
        new Handler(this.context.getMainLooper()).post(() -> WifiAwarePlatform.refreshPermissions$lambda-8(this));
    }

    @Override
    public void clientStartSearching(@Nullable String hashedAppName, @Nullable String localAnnounce) {
        DittoLog.d$default(TAG, "clientStartSearching", null, 4, null);
        if (hashedAppName == null || localAnnounce == null) {
            DittoLog.e$default(TAG, "Unexpected null parameters! hashedAppName: " + hashedAppName + ", localAnnounce: " + localAnnounce, null, 4, null);
            return;
        }
        if (this.isSearching()) {
            return;
        }
        this.clientSearchingParams = new ClientSearchingParams(hashedAppName, localAnnounce);
        this.doClientStartSearching(hashedAppName, localAnnounce);
    }

    private final void doClientStartSearching(String hashedAppName, String localAnnounce) {
        DittoLog.d$default(TAG, "doClientStartSearching", null, 4, null);
        WifiAwareSession localAwareSession = this.awareSession;
        if (localAwareSession == null) {
            new Handler(this.context.getMainLooper()).postDelayed(() -> WifiAwarePlatform.doClientStartSearching$lambda-9(this, hashedAppName, localAnnounce), this.retryToken, 5000L);
            return;
        }
        if (this.wifiAwareSubscriber == null) {
            WifiAwareSubscriber subscriber = new WifiAwareSubscriber(this.context, hashedAppName, localAnnounce, this);
            try {
                subscriber.setup(localAwareSession);
                this.wifiAwareSubscriber = subscriber;
            }
            catch (Exception e) {
                DittoLog.e$default(TAG, String.valueOf(e), null, 4, null);
            }
        }
    }

    @Override
    public synchronized void clientStopSearching() {
        DittoLog.d$default(TAG, "clientStopSearching", null, 4, null);
        WifiAwareSubscriber wifiAwareSubscriber = this.wifiAwareSubscriber;
        if (wifiAwareSubscriber != null) {
            wifiAwareSubscriber.close();
        }
        this.wifiAwareSubscriber = null;
    }

    @Override
    public void clientUpdatePeer(@Nullable String announce, @NotNull ConnectState_t status) {
        block1: {
            ConnectState_t connectState_t;
            block2: {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                DittoLog.d$default(TAG, "clientUpdatePeer(" + announce + ", " + status + ")", null, 4, null);
                if (announce == null) break block1;
                connectState_t = status;
                if (!Intrinsics.areEqual((Object)connectState_t, (Object)ConnectState_t.CONNECT_STATE_DISCONNECTED)) break block2;
                WifiAwareSubscriber wifiAwareSubscriber = this.wifiAwareSubscriber;
                if (wifiAwareSubscriber == null) break block1;
                wifiAwareSubscriber.resetPeer(announce);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)connectState_t, (Object)ConnectState_t.CONNECT_STATE_CONNECTED)) break block1;
            WifiAwareSubscriber wifiAwareSubscriber = this.wifiAwareSubscriber;
            if (wifiAwareSubscriber != null) {
                wifiAwareSubscriber.markPeerConnected(announce);
            }
        }
    }

    public final void resetWifiAware() {
        long now = SystemClock.elapsedRealtime();
        if (now - this.lastResetTimestamp < 7000L) {
            DittoLog.w$default(TAG, "Ignoring request to reset during cooldown after recent reset.", null, 4, null);
            return;
        }
        new Handler(this.context.getMainLooper()).removeCallbacksAndMessages(this.resetToken);
        DittoLog.w$default(TAG, "Resetting WiFi Aware platform.", null, 4, null);
        this.close();
        this.closed = false;
        this.doAttach();
        this.lastResetTimestamp = SystemClock.elapsedRealtime();
        this.pendingReset = false;
    }

    @Override
    public void clientCreateNetwork(@Nullable String announce) {
        if (announce != null) {
            WifiAwareSubscriber wifiAwareSubscriber = this.wifiAwareSubscriber;
            if (wifiAwareSubscriber != null) {
                wifiAwareSubscriber.connect(announce);
            }
        }
        if (this.isStale()) {
            DittoLog.w$default(TAG, "Detected staleness.", null, 4, null);
            new Handler(this.context.getMainLooper()).post(() -> WifiAwarePlatform.clientCreateNetwork$lambda-10(this));
        }
    }

    @Override
    public void serverStartAdvertising(@Nullable String announce, @Nullable String hashedAppName, int servicePort) {
        DittoLog.d$default(TAG, "serverStartAdvertising", null, 4, null);
        if (hashedAppName == null || announce == null) {
            DittoLog.e$default(TAG, "Unexpected null parameters! hashedAppName: " + hashedAppName + ", announce: " + announce, null, 4, null);
            return;
        }
        if (this.isAdvertising()) {
            return;
        }
        this.serverAdvertisingParams = new ServerAdvertisingParams(announce, hashedAppName, servicePort);
        this.doServerStartAdvertising(announce, hashedAppName, servicePort);
    }

    private final void doServerStartAdvertising(String announce, String hashedAppName, int servicePort) {
        DittoLog.d$default(TAG, "doServerStartAdvertising", null, 4, null);
        WifiAwareSession localAwareSession = this.awareSession;
        if (localAwareSession == null) {
            new Handler(this.context.getMainLooper()).postDelayed(() -> WifiAwarePlatform.doServerStartAdvertising$lambda-11(this, announce, hashedAppName, servicePort), this.retryToken, 5000L);
            return;
        }
        if (this.wifiAwarePublisher == null) {
            WifiAwarePublisher publisher = new WifiAwarePublisher(this.context, hashedAppName, servicePort, this);
            try {
                publisher.setup(localAwareSession, announce);
                this.wifiAwarePublisher = publisher;
            }
            catch (Exception e) {
                DittoLog.e$default(TAG, String.valueOf(e), null, 4, null);
            }
        }
    }

    @Override
    public synchronized void serverStopAdvertising() {
        DittoLog.d$default(TAG, "serverStopAdvertising", null, 4, null);
        WifiAwarePublisher wifiAwarePublisher = this.wifiAwarePublisher;
        if (wifiAwarePublisher != null) {
            wifiAwarePublisher.close();
        }
        this.wifiAwarePublisher = null;
    }

    @Override
    public void serverUpdatePeer(@Nullable String announce, @NotNull ConnectState_t status) {
        block1: {
            ConnectState_t connectState_t;
            block2: {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                DittoLog.d$default(TAG, "serverUpdatePeer(" + announce + ", " + status + ")", null, 4, null);
                if (announce == null) break block1;
                connectState_t = status;
                if (!Intrinsics.areEqual((Object)connectState_t, (Object)ConnectState_t.CONNECT_STATE_DISCONNECTED)) break block2;
                WifiAwarePublisher wifiAwarePublisher = this.wifiAwarePublisher;
                if (wifiAwarePublisher == null) break block1;
                wifiAwarePublisher.resetPeer(announce);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)connectState_t, (Object)ConnectState_t.CONNECT_STATE_CONNECTED)) break block1;
            WifiAwarePublisher wifiAwarePublisher = this.wifiAwarePublisher;
            if (wifiAwarePublisher != null) {
                wifiAwarePublisher.markPeerConnected(announce);
            }
        }
    }

    private static final void doAttach$lambda-4(WifiAwarePlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doAttach();
    }

    private static final void queueDelayedReset$lambda-5(WifiAwarePlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.resetWifiAware();
    }

    private static final void refreshPermissions$lambda-8(WifiAwarePlatform this$0) {
        block3: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            new Handler(this$0.context.getMainLooper()).removeCallbacksAndMessages(this$0.retryToken);
            if (this$0.isSearching()) {
                ClientSearchingParams clientSearchingParams = this$0.clientSearchingParams;
                if (clientSearchingParams != null) {
                    it = clientSearchingParams;
                    boolean bl = false;
                    this$0.doClientStartSearching(((ClientSearchingParams)it).getHashedAppName(), ((ClientSearchingParams)it).getLocalAnnounce());
                }
            }
            if (!this$0.isAdvertising()) break block3;
            ServerAdvertisingParams serverAdvertisingParams = this$0.serverAdvertisingParams;
            if (serverAdvertisingParams != null) {
                it = serverAdvertisingParams;
                boolean bl = false;
                this$0.doServerStartAdvertising(((ServerAdvertisingParams)it).getAnnounce(), ((ServerAdvertisingParams)it).getHashedAppName(), ((ServerAdvertisingParams)it).getServicePort());
            }
        }
    }

    private static final void doClientStartSearching$lambda-9(WifiAwarePlatform this$0, String $hashedAppName, String $localAnnounce) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hashedAppName, (String)"$hashedAppName");
        Intrinsics.checkNotNullParameter((Object)$localAnnounce, (String)"$localAnnounce");
        this$0.clientStartSearching($hashedAppName, $localAnnounce);
    }

    private static final void clientCreateNetwork$lambda-10(WifiAwarePlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.resetWifiAware();
    }

    private static final void doServerStartAdvertising$lambda-11(WifiAwarePlatform this$0, String $announce, String $hashedAppName, int $servicePort) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$announce, (String)"$announce");
        Intrinsics.checkNotNullParameter((Object)$hashedAppName, (String)"$hashedAppName");
        this$0.serverStartAdvertising($announce, $hashedAppName, $servicePort);
    }

    public static final /* synthetic */ boolean access$getClosed$p(WifiAwarePlatform $this) {
        return $this.closed;
    }

    public static final /* synthetic */ boolean access$getTransportsAdded$p(WifiAwarePlatform $this) {
        return $this.transportsAdded;
    }

    public static final /* synthetic */ void access$setTransportsAdded$p(WifiAwarePlatform $this, boolean bl) {
        $this.transportsAdded = bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/ditto/transports/WifiAwarePlatform$Companion;", "", "()V", "TAG", "", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

