/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.internal.ffi;

import java.util.concurrent.ConcurrentHashMap;
import live.ditto.internal.ffi.OverReleaseException;

public class FfiResource {
    private static final ConcurrentHashMap<AutoCloseable, Integer> counts = new ConcurrentHashMap();

    private FfiResource() {
    }

    public static int retain(AutoCloseable o) {
        int newCount;
        boolean replacedOrPut = false;
        do {
            Integer oldCount;
            if ((oldCount = counts.get(o)) == null) {
                newCount = 1;
                replacedOrPut = counts.putIfAbsent(o, newCount) == null;
                continue;
            }
            newCount = oldCount + 1;
            replacedOrPut = counts.replace(o, oldCount, newCount);
        } while (!replacedOrPut);
        return newCount;
    }

    public static int release(AutoCloseable o) throws Exception {
        Integer newCount = null;
        boolean replacedOrRemoved = false;
        do {
            Integer oldCount;
            if ((oldCount = counts.get(o)) == null) {
                throw new OverReleaseException();
            }
            if (oldCount == 1) {
                replacedOrRemoved = counts.remove(o, oldCount);
                if (!replacedOrRemoved) continue;
                newCount = 0;
                o.close();
                continue;
            }
            newCount = oldCount - 1;
            replacedOrRemoved = counts.replace(o, oldCount, newCount);
        } while (!replacedOrRemoved);
        return newCount == null ? 0 : newCount;
    }
}

