/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoLog;
import live.ditto.internal.ffi.DittoHandle;
import live.ditto.internal.ffi.FfiResource;
import live.ditto.internal.swig.ffi.SWIGTYPE_p_CDitto;
import live.ditto.transports.AppLifecycleListener;
import live.ditto.transports.BluetoothPlatform;
import live.ditto.transports.DittoBluetoothLeConfig;
import live.ditto.transports.DittoBluetoothManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 02\u00020\u0001:\u00010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020,J\u0006\u0010.\u001a\u00020,J\u0006\u0010/\u001a\u00020,R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0012\u0010%\u001a\u0004\u0018\u00010&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010(\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Llive/ditto/transports/DittoBluetoothManager;", "", "context", "Landroid/content/Context;", "dittoHandleWrapper", "Llive/ditto/internal/ffi/DittoHandle;", "config", "Llive/ditto/transports/DittoBluetoothLeConfig;", "(Landroid/content/Context;Llive/ditto/internal/ffi/DittoHandle;Llive/ditto/transports/DittoBluetoothLeConfig;)V", "bleEnabled", "", "getBleEnabled$dittocpp_release", "()Z", "setBleEnabled$dittocpp_release", "(Z)V", "bleStartedByDitto", "getBleStartedByDitto", "setBleStartedByDitto", "bluetoothPlatform", "Llive/ditto/transports/BluetoothPlatform;", "getBluetoothPlatform$dittocpp_release", "()Llive/ditto/transports/BluetoothPlatform;", "setBluetoothPlatform$dittocpp_release", "(Llive/ditto/transports/BluetoothPlatform;)V", "getConfig", "()Llive/ditto/transports/DittoBluetoothLeConfig;", "getContext", "()Landroid/content/Context;", "inForeground", "getInForeground$dittocpp_release", "setInForeground$dittocpp_release", "lifecycleListener", "Llive/ditto/transports/AppLifecycleListener;", "getLifecycleListener", "()Llive/ditto/transports/AppLifecycleListener;", "lifecycleListener$delegate", "Lkotlin/Lazy;", "mtuRequest", "", "Ljava/lang/Integer;", "platformResets", "receiver", "Landroid/content/BroadcastReceiver;", "close", "", "requestReset", "start", "stop", "Companion", "dittocpp_release"})
public final class DittoBluetoothManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final DittoHandle dittoHandleWrapper;
    @NotNull
    private final DittoBluetoothLeConfig config;
    private boolean bleStartedByDitto;
    @Nullable
    private BluetoothPlatform bluetoothPlatform;
    private boolean inForeground;
    private boolean bleEnabled;
    @Nullable
    private final Integer mtuRequest;
    private int platformResets;
    @NotNull
    private final Lazy lifecycleListener$delegate;
    @Nullable
    private BroadcastReceiver receiver;
    @NotNull
    private static final String TAG = "DittoBluetoothManager";

    public DittoBluetoothManager(@NotNull Context context, @NotNull DittoHandle dittoHandleWrapper, @NotNull DittoBluetoothLeConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dittoHandleWrapper, (String)"dittoHandleWrapper");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.dittoHandleWrapper = dittoHandleWrapper;
        this.config = config;
        this.inForeground = true;
        this.mtuRequest = this.config.getMtuRequest();
        this.lifecycleListener$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppLifecycleListener>(this){
            final /* synthetic */ DittoBluetoothManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AppLifecycleListener invoke() {
                return new AppLifecycleListener(this.this$0);
            }
        }));
        this.receiver = new BroadcastReceiver(this){
            final /* synthetic */ DittoBluetoothManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                String action = intent.getAction();
                if (Intrinsics.areEqual((Object)action, (Object)"android.bluetooth.adapter.action.STATE_CHANGED")) {
                    int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    switch (state) {
                        case 10: {
                            DittoLog.i$default("DittoBluetoothManager", "BluetoothAdapter STATE_OFF", null, 4, null);
                            break;
                        }
                        case 13: {
                            DittoLog.i$default("DittoBluetoothManager", "BluetoothAdapter STATE_TURNING_OFF", null, 4, null);
                            this.this$0.setBleEnabled$dittocpp_release(false);
                            BluetoothPlatform bluetoothPlatform = this.this$0.getBluetoothPlatform$dittocpp_release();
                            if (bluetoothPlatform != null) {
                                bluetoothPlatform.reportDisabled$dittocpp_release();
                            }
                            this.this$0.stop();
                            break;
                        }
                        case 12: {
                            DittoLog.i$default("DittoBluetoothManager", "BluetoothAdapter STATE_ON", null, 4, null);
                            this.this$0.setBleEnabled$dittocpp_release(true);
                            Handler handler = new Handler(context.getMainLooper());
                            handler.postDelayed(() -> receiver.1.onReceive$lambda-0(this.this$0), 500L);
                            break;
                        }
                        case 11: {
                            DittoLog.i$default("DittoBluetoothManager", "BluetoothAdapter STATE_TURNING_ON", null, 4, null);
                        }
                    }
                }
            }

            private static final void onReceive$lambda-0(DittoBluetoothManager this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.start();
            }
        };
        Object object = this.context.getSystemService("bluetooth");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        BluetoothManager m = (BluetoothManager)object;
        BluetoothAdapter adapter = m.getAdapter();
        this.bleEnabled = adapter != null ? adapter.getState() == 12 : false;
        new Handler(this.context.getMainLooper()).post(() -> DittoBluetoothManager._init_$lambda-0(this));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final DittoBluetoothLeConfig getConfig() {
        return this.config;
    }

    public final boolean getBleStartedByDitto() {
        return this.bleStartedByDitto;
    }

    public final void setBleStartedByDitto(boolean bl) {
        this.bleStartedByDitto = bl;
    }

    @Nullable
    public final BluetoothPlatform getBluetoothPlatform$dittocpp_release() {
        return this.bluetoothPlatform;
    }

    public final void setBluetoothPlatform$dittocpp_release(@Nullable BluetoothPlatform bluetoothPlatform) {
        this.bluetoothPlatform = bluetoothPlatform;
    }

    public final boolean getInForeground$dittocpp_release() {
        return this.inForeground;
    }

    public final void setInForeground$dittocpp_release(boolean bl) {
        this.inForeground = bl;
    }

    public final boolean getBleEnabled$dittocpp_release() {
        return this.bleEnabled;
    }

    public final void setBleEnabled$dittocpp_release(boolean bl) {
        this.bleEnabled = bl;
    }

    private final AppLifecycleListener getLifecycleListener() {
        Lazy lazy = this.lifecycleListener$delegate;
        return (AppLifecycleListener)lazy.getValue();
    }

    public final void close() {
        new Handler(this.context.getMainLooper()).post(() -> DittoBluetoothManager.close$lambda-2(this));
        new Handler(this.context.getMainLooper()).post(() -> DittoBluetoothManager.close$lambda-3(this));
    }

    public final void stop() {
        block0: {
            DittoLog.i$default(TAG, "Stopping BLE systems", null, 4, null);
            BluetoothPlatform bluetoothPlatform = this.bluetoothPlatform;
            if (bluetoothPlatform == null) break block0;
            BluetoothPlatform it = bluetoothPlatform;
            boolean bl = false;
            it.close();
            FfiResource.release(it);
            this.bluetoothPlatform = null;
        }
    }

    public final void start() {
        block5: {
            if (!this.bleStartedByDitto) {
                return;
            }
            if (!this.bleEnabled) {
                return;
            }
            DittoLog.i$default(TAG, "Starting BLE systems", null, 4, null);
            if (this.bluetoothPlatform != null) break block5;
            Integer n = this.mtuRequest;
            BluetoothPlatform bluetoothPlat = new BluetoothPlatform(this, n != null ? n : 185);
            FfiResource.retain(bluetoothPlat);
            this.bluetoothPlatform = bluetoothPlat;
            bluetoothPlat.setContext(this.context);
            SWIGTYPE_p_CDitto sWIGTYPE_p_CDitto = this.dittoHandleWrapper.getHandle();
            if (sWIGTYPE_p_CDitto != null) {
                SWIGTYPE_p_CDitto dittoHandle = sWIGTYPE_p_CDitto;
                boolean bl = false;
                BluetoothPlatform bluetoothPlatform = this.bluetoothPlatform;
                if (bluetoothPlatform != null) {
                    bluetoothPlatform.addBleClientTransport(dittoHandle);
                }
                BluetoothPlatform bluetoothPlatform2 = this.bluetoothPlatform;
                if (bluetoothPlatform2 != null) {
                    bluetoothPlatform2.addBleServerTransport(dittoHandle);
                }
            }
        }
    }

    public final void requestReset() {
        this.stop();
        Handler handler = new Handler(this.context.getMainLooper());
        handler.postDelayed(() -> DittoBluetoothManager.requestReset$lambda-6(this), 1000L);
    }

    private static final void _init_$lambda-0(DittoBluetoothManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this$0.getLifecycleListener());
        this$0.context.registerReceiver(this$0.receiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
    }

    private static final void close$lambda-2(DittoBluetoothManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BroadcastReceiver broadcastReceiver = this$0.receiver;
        if (broadcastReceiver != null) {
            BroadcastReceiver it = broadcastReceiver;
            boolean bl = false;
            this$0.context.unregisterReceiver(it);
        }
        this$0.receiver = null;
    }

    private static final void close$lambda-3(DittoBluetoothManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this$0.getLifecycleListener());
    }

    private static final void requestReset$lambda-6(DittoBluetoothManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ++this$0.platformResets;
        DittoLog.w$default(TAG, "Restarting BluetoothPlatform, happened " + this$0.platformResets + " since app start.", null, 4, null);
        this$0.start();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/ditto/transports/DittoBluetoothManager$Companion;", "", "()V", "TAG", "", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

