/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.TransportInfo;
import android.net.wifi.aware.DiscoverySession;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.WifiAwareNetworkInfo;
import android.net.wifi.aware.WifiAwareNetworkSpecifier;
import android.net.wifi.aware.WifiAwareSession;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import java.net.Inet6Address;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import live.ditto.DittoLog;
import live.ditto.internal.swig.ffi.OnlineState_t;
import live.ditto.internal.swig.ffi.TransportCondition_t;
import live.ditto.transports.PeerState;
import live.ditto.transports.WifiAwarePlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 02\u00020\u0001:\u00040123B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020\u0005J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Llive/ditto/transports/WifiAwareSubscriber;", "", "context", "Landroid/content/Context;", "hashedAppName", "", "localAnnounce", "platform", "Llive/ditto/transports/WifiAwarePlatform;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Llive/ditto/transports/WifiAwarePlatform;)V", "connMgr", "Landroid/net/ConnectivityManager;", "getContext", "()Landroid/content/Context;", "discoveredPeers", "Ljava/util/concurrent/ConcurrentHashMap;", "Llive/ditto/transports/WifiAwareSubscriber$DiscoveredPeer;", "discovery", "Llive/ditto/transports/WifiAwareSubscriber$SubscriberDiscoveryCallback;", "discoverySession", "Landroid/net/wifi/aware/DiscoverySession;", "getHashedAppName", "()Ljava/lang/String;", "latestConnectAttemptTimestamp", "", "getLatestConnectAttemptTimestamp", "()J", "setLatestConnectAttemptTimestamp", "(J)V", "latestDisconnectTimestamp", "getLatestDisconnectTimestamp", "setLatestDisconnectTimestamp", "msgIdCounter", "", "getPlatform", "()Llive/ditto/transports/WifiAwarePlatform;", "searchingPrefix", "subscriberToken", "close", "", "connect", "announce", "markPeerConnected", "resetPeer", "", "setup", "awareSession", "Landroid/net/wifi/aware/WifiAwareSession;", "Companion", "DiscoveredPeer", "SubscriberDiscoveryCallback", "SubscriberNetworkCallback", "dittocpp_release"})
@RequiresApi(value=29)
public final class WifiAwareSubscriber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String hashedAppName;
    @NotNull
    private final String localAnnounce;
    @NotNull
    private final WifiAwarePlatform platform;
    @NotNull
    private Object subscriberToken;
    @Nullable
    private SubscriberDiscoveryCallback discovery;
    @Nullable
    private DiscoverySession discoverySession;
    @NotNull
    private final ConnectivityManager connMgr;
    @NotNull
    private final String searchingPrefix;
    private int msgIdCounter;
    @NotNull
    private final ConcurrentHashMap<String, DiscoveredPeer> discoveredPeers;
    private long latestConnectAttemptTimestamp;
    private long latestDisconnectTimestamp;
    @NotNull
    private static final String TAG = "WifiAwareSubscriber";

    public WifiAwareSubscriber(@NotNull Context context, @NotNull String hashedAppName, @NotNull String localAnnounce, @NotNull WifiAwarePlatform platform) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hashedAppName, (String)"hashedAppName");
        Intrinsics.checkNotNullParameter((Object)localAnnounce, (String)"localAnnounce");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.context = context;
        this.hashedAppName = hashedAppName;
        this.localAnnounce = localAnnounce;
        this.platform = platform;
        this.subscriberToken = new Object();
        Object object = this.context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connMgr = (ConnectivityManager)object;
        this.searchingPrefix = "ditto" + this.hashedAppName + "_";
        this.discoveredPeers = new ConcurrentHashMap();
        this.latestConnectAttemptTimestamp = SystemClock.elapsedRealtime();
        this.latestDisconnectTimestamp = SystemClock.elapsedRealtime();
        DittoLog.d$default(TAG, "Init", null, 4, null);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getHashedAppName() {
        return this.hashedAppName;
    }

    @NotNull
    public final WifiAwarePlatform getPlatform() {
        return this.platform;
    }

    public final long getLatestConnectAttemptTimestamp() {
        return this.latestConnectAttemptTimestamp;
    }

    public final void setLatestConnectAttemptTimestamp(long l) {
        this.latestConnectAttemptTimestamp = l;
    }

    public final long getLatestDisconnectTimestamp() {
        return this.latestDisconnectTimestamp;
    }

    public final void setLatestDisconnectTimestamp(long l) {
        this.latestDisconnectTimestamp = l;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void setup(@NotNull WifiAwareSession awareSession) {
        SubscriberDiscoveryCallback disc;
        Intrinsics.checkNotNullParameter((Object)awareSession, (String)"awareSession");
        SubscribeConfig subscribeConfig = new SubscribeConfig.Builder().setServiceName(this.hashedAppName).build();
        Intrinsics.checkNotNullExpressionValue((Object)subscribeConfig, (String)"Builder()\n            .s\u2026ame)\n            .build()");
        SubscribeConfig subscribeConfig2 = subscribeConfig;
        this.discovery = disc = new SubscriberDiscoveryCallback(awareSession, subscribeConfig2);
        awareSession.subscribe(subscribeConfig2, (DiscoverySessionCallback)disc, null);
        DittoLog.d$default(TAG, "Setup done", null, 4, null);
    }

    public final void close() {
        DittoLog.w$default(TAG, "close()", null, 4, null);
        new Handler(this.context.getMainLooper()).removeCallbacksAndMessages(this.subscriberToken);
        Map $this$forEach$iv = this.discoveredPeers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.platform.clientPeerDisappeared((String)it.getKey());
            this.resetPeer((String)it.getKey());
        }
        this.discoveredPeers.clear();
        try {
            DiscoverySession discoverySession = this.discoverySession;
            if (discoverySession != null) {
                discoverySession.close();
            }
        }
        catch (Exception e) {
            DittoLog.e$default(TAG, "Exception while closing discoverySession", null, 4, null);
            DittoLog.e$default(TAG, e, null, 4, null);
        }
        this.discoverySession = null;
        this.platform.clientScanningStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
    }

    public final void connect(@NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        DittoLog.d$default(TAG, "connect(" + announce + ")", null, 4, null);
        this.latestConnectAttemptTimestamp = SystemClock.elapsedRealtime();
        PeerState peerState = this.platform.getPeerState(announce);
        DiscoveredPeer discoveredPeer = this.discoveredPeers.get(announce);
        if (discoveredPeer == null) {
            return;
        }
        DiscoveredPeer peer = discoveredPeer;
        if (peerState.isNetworkReserved()) {
            DittoLog.d$default(TAG, "Peer " + announce + " already connected or connecting. Skipping. (State: " + peerState.name() + ")", null, 4, null);
            this.platform.clientNetworkDidNotCreate(announce);
            return;
        }
        if (this.resetPeer(announce)) {
            DittoLog.w$default(TAG, "Cleared callback for peer on connect() -- shouldn't happen. May be a sign of unintended race condition.", null, 4, null);
        }
        int n = this.msgIdCounter;
        this.msgIdCounter = n + 1;
        int messageId = n;
        DittoLog.d$default(TAG, "Sending connect message \"connect." + this.localAnnounce + "\" to " + peer.getHandle() + " (msgId: " + messageId + ")", null, 4, null);
        try {
            DiscoverySession discoverySession = this.discoverySession;
            if (discoverySession != null) {
                PeerHandle peerHandle = peer.getHandle();
                String string = "connect." + this.localAnnounce;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                discoverySession.sendMessage(peerHandle, messageId, byArray);
            }
        }
        catch (Exception e) {
            DittoLog.e$default(TAG, "Exception while trying to send message.", null, 4, null);
            DittoLog.e$default(TAG, e, null, 4, null);
        }
        this.platform.updatePeerState(announce, PeerState.HelloSent);
        peer.setConnectMsgId(messageId);
        new Handler(this.context.getMainLooper()).postDelayed(() -> WifiAwareSubscriber.connect$lambda-1(this, announce), this.subscriberToken, 5000L + ThreadLocalRandom.current().nextLong(0L, 2000L));
    }

    public final void markPeerConnected(@NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        DittoLog.d$default(TAG, "markPeerConnected(" + announce + ")", null, 4, null);
        this.platform.updatePeerState(announce, PeerState.SubscriptionNetworkConnected);
    }

    public final boolean resetPeer(@NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        DittoLog.d$default(TAG, "resetPeer(" + announce + ")", null, 4, null);
        PeerState currentPeerState = this.platform.getPeerState(announce);
        DiscoveredPeer discoveredPeer = this.discoveredPeers.get(announce);
        if (discoveredPeer == null) {
            return false;
        }
        DiscoveredPeer peer = discoveredPeer;
        ConnectivityManager.NetworkCallback callback = peer.getCallback();
        ((Map)this.discoveredPeers).put(announce, new DiscoveredPeer(peer.getHandle()));
        boolean unregistered = false;
        if (callback != null) {
            DittoLog.d$default(TAG, "resetPeer(" + announce + "): clearing callback for " + announce, null, 4, null);
            this.connMgr.unregisterNetworkCallback(callback);
            unregistered = true;
        }
        if (currentPeerState.isSubscriberSpecific()) {
            if (currentPeerState == PeerState.SubscriptionNetworkConnected) {
                this.latestDisconnectTimestamp = SystemClock.elapsedRealtime();
            }
            this.platform.updatePeerState(announce, PeerState.Idle);
        } else {
            DittoLog.i$default(TAG, "resetPeer(" + announce + "): PeerState not changed since it's set to " + currentPeerState.name() + ".", null, 4, null);
        }
        return unregistered;
    }

    private static final void connect$lambda-1(WifiAwareSubscriber this$0, String $announce) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$announce, (String)"$announce");
        PeerState currentPeerState = this$0.platform.getPeerState($announce);
        if (currentPeerState != PeerState.SubscriptionNetworkConnected) {
            this$0.resetPeer($announce);
            this$0.platform.clientNetworkDidNotCreate($announce);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/ditto/transports/WifiAwareSubscriber$Companion;", "", "()V", "TAG", "", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\fH\u0017J\b\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Llive/ditto/transports/WifiAwareSubscriber$SubscriberDiscoveryCallback;", "Landroid/net/wifi/aware/DiscoverySessionCallback;", "awareSession", "Landroid/net/wifi/aware/WifiAwareSession;", "subscribeConfig", "Landroid/net/wifi/aware/SubscribeConfig;", "(Llive/ditto/transports/WifiAwareSubscriber;Landroid/net/wifi/aware/WifiAwareSession;Landroid/net/wifi/aware/SubscribeConfig;)V", "getAnnounceByMessageId", "", "messageId", "", "onMessageReceived", "", "peerHandle", "Landroid/net/wifi/aware/PeerHandle;", "message", "", "onMessageSendFailed", "onMessageSendSucceeded", "onServiceDiscovered", "serviceSpecificInfo", "matchFilter", "", "onServiceLost", "reason", "onSessionConfigFailed", "onSessionTerminated", "onSubscribeStarted", "session", "Landroid/net/wifi/aware/SubscribeDiscoverySession;", "dittocpp_release"})
    public final class SubscriberDiscoveryCallback
    extends DiscoverySessionCallback {
        @NotNull
        private final WifiAwareSession awareSession;
        @NotNull
        private final SubscribeConfig subscribeConfig;

        public SubscriberDiscoveryCallback(@NotNull WifiAwareSession awareSession, SubscribeConfig subscribeConfig) {
            Intrinsics.checkNotNullParameter((Object)awareSession, (String)"awareSession");
            Intrinsics.checkNotNullParameter((Object)subscribeConfig, (String)"subscribeConfig");
            this.awareSession = awareSession;
            this.subscribeConfig = subscribeConfig;
        }

        public void onMessageReceived(@NotNull PeerHandle peerHandle, @NotNull byte[] message) {
            Intrinsics.checkNotNullParameter((Object)peerHandle, (String)"peerHandle");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String m = new String(message, Charsets.UTF_8);
            DittoLog.d$default(WifiAwareSubscriber.TAG, "onMessageReceived, m " + m, null, 4, null);
            DiscoverySession discoverySession = WifiAwareSubscriber.this.discoverySession;
            if (discoverySession == null) {
                SubscriberDiscoveryCallback $this$onMessageReceived_u24lambda_u2d0 = this;
                boolean bl = false;
                DittoLog.w$default(WifiAwareSubscriber.TAG, "discovery session null", null, 4, null);
                return;
            }
            DiscoverySession currentDiscoverySession = discoverySession;
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)m, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                return;
            }
            if (Intrinsics.areEqual(parts.get(0), (Object)"ready")) {
                String announce = (String)parts.get(1);
                if (((CharSequence)announce).length() == 0) {
                    return;
                }
                DiscoveredPeer peer = (DiscoveredPeer)WifiAwareSubscriber.this.discoveredPeers.get(announce);
                if (peer == null) {
                    DittoLog.e$default(WifiAwareSubscriber.TAG, "Unexpected peer announce received " + announce, null, 4, null);
                    return;
                }
                if (peer.getCallback() != null) {
                    DittoLog.d$default(WifiAwareSubscriber.TAG, "Duplicate " + announce + " ready message, ignoring this ready message.", null, 4, null);
                    return;
                }
                PeerState peerState = WifiAwareSubscriber.this.getPlatform().getPeerState(announce);
                if (peerState.isNetworkReserved()) {
                    DittoLog.d$default(WifiAwareSubscriber.TAG, "Network is already reserved, ignoring this ready message. (announce: " + announce + ")", null, 4, null);
                    return;
                }
                WifiAwareNetworkSpecifier wifiAwareNetworkSpecifier = new WifiAwareNetworkSpecifier.Builder(currentDiscoverySession, peerHandle).setPskPassphrase("dittoditto").build();
                Intrinsics.checkNotNullExpressionValue((Object)wifiAwareNetworkSpecifier, (String)"Builder(currentDiscovery\u2026                 .build()");
                WifiAwareNetworkSpecifier networkSpecifier = wifiAwareNetworkSpecifier;
                NetworkRequest myNetworkRequest = new NetworkRequest.Builder().addTransportType(5).setNetworkSpecifier((NetworkSpecifier)networkSpecifier).build();
                SubscriberNetworkCallback callback = new SubscriberNetworkCallback(peer, announce);
                if (peer.getCallback() != null) {
                    DittoLog.e$default(WifiAwareSubscriber.TAG, "Callback already exited for peer -- shouldn't happen. May be a sign of unintended race condition.", null, 4, null);
                    WifiAwareSubscriber.this.resetPeer(announce);
                }
                peer.setCallback(callback);
                DittoLog.i$default(WifiAwareSubscriber.TAG, "Requesting network (announce: " + announce + ", handle: " + peerHandle + ")", null, 4, null);
                try {
                    WifiAwareSubscriber.this.getPlatform().updatePeerState(announce, PeerState.EstablishingConnection);
                    WifiAwareSubscriber.this.connMgr.requestNetwork(myNetworkRequest, (ConnectivityManager.NetworkCallback)callback);
                }
                catch (Exception e) {
                    DittoLog.e$default(WifiAwareSubscriber.TAG, "Caught an exception when requesting a network, could indicate a leak in registered callbacks.", null, 4, null);
                    DittoLog.e$default(WifiAwareSubscriber.TAG, e, null, 4, null);
                    WifiAwareSubscriber.this.resetPeer(announce);
                }
            }
        }

        private final String getAnnounceByMessageId(int messageId) {
            String string;
            block1: {
                for (Map.Entry e : ((Map)WifiAwareSubscriber.this.discoveredPeers).entrySet()) {
                    boolean bl = false;
                    Integer n = ((DiscoveredPeer)e.getValue()).getConnectMsgId();
                    int n2 = messageId;
                    String string2 = n != null && n == n2 ? (String)e.getKey() : (String)null;
                    if (string2 == null) continue;
                    string = string2;
                    break block1;
                }
                string = null;
            }
            return string;
        }

        public void onMessageSendFailed(int messageId) {
            String announce = this.getAnnounceByMessageId(messageId);
            if (announce != null) {
                WifiAwareSubscriber.this.getPlatform().clientNetworkDidNotCreate(announce);
                DiscoveredPeer discoveredPeer = (DiscoveredPeer)WifiAwareSubscriber.this.discoveredPeers.get(announce);
                if (discoveredPeer != null) {
                    discoveredPeer.setConnectMsgId(null);
                    discoveredPeer.setFailCount(discoveredPeer.getFailCount() + 1);
                    if (discoveredPeer.getFailCount() > 5) {
                        DittoLog.w$default(WifiAwareSubscriber.TAG, "peer " + announce + " cannot be sent to (>5 message send failures)", null, 4, null);
                    }
                }
            }
            DittoLog.w$default(WifiAwareSubscriber.TAG, "onMessageSendFailed (announce: " + announce + ", msgId: " + messageId + ")", null, 4, null);
        }

        public void onMessageSendSucceeded(int messageId) {
            String peerAnnounce = this.getAnnounceByMessageId(messageId);
            DittoLog.d$default(WifiAwareSubscriber.TAG, "onMessageSendSucceeded (announce: " + peerAnnounce + ", messageId: " + messageId + ")", null, 4, null);
        }

        public void onServiceDiscovered(@Nullable PeerHandle peerHandle, @Nullable byte[] serviceSpecificInfo, @Nullable List<byte[]> matchFilter) {
            if (serviceSpecificInfo == null || peerHandle == null) {
                DittoLog.e$default(WifiAwareSubscriber.TAG, "null argument existed when not expected. serviceSpecificInfo: " + serviceSpecificInfo + ", peerHandle: " + peerHandle, null, 4, null);
                return;
            }
            String advertisingInfo = new String(serviceSpecificInfo, Charsets.UTF_8);
            DittoLog.i$default(WifiAwareSubscriber.TAG, "onServiceDiscovered(" + peerHandle + ", " + advertisingInfo + ")", null, 4, null);
            if (!StringsKt.startsWith$default((String)advertisingInfo, (String)WifiAwareSubscriber.this.searchingPrefix, (boolean)false, (int)2, null)) {
                return;
            }
            String string = advertisingInfo.substring(WifiAwareSubscriber.this.searchingPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String announce = string;
            WifiAwareSubscriber.this.getPlatform().clientPeerAppeared(announce);
            ((Map)WifiAwareSubscriber.this.discoveredPeers).put(announce, new DiscoveredPeer(peerHandle));
        }

        public void onServiceLost(@NotNull PeerHandle peerHandle, int reason) {
            String string;
            block2: {
                Intrinsics.checkNotNullParameter((Object)peerHandle, (String)"peerHandle");
                for (Map.Entry e : ((Map)WifiAwareSubscriber.this.discoveredPeers).entrySet()) {
                    boolean bl = false;
                    String string2 = Intrinsics.areEqual((Object)((DiscoveredPeer)e.getValue()).getHandle(), (Object)peerHandle) ? (String)e.getKey() : (String)null;
                    if (string2 == null) continue;
                    string = string2;
                    break block2;
                }
                string = null;
            }
            String peerAnnounce = string;
            DittoLog.w$default(WifiAwareSubscriber.TAG, "onServiceLost (announce: " + peerAnnounce + ", handle: " + peerHandle + ", reason: " + reason + ")", null, 4, null);
            if (peerAnnounce != null) {
                WifiAwareSubscriber.this.discoveredPeers.remove(peerAnnounce);
                WifiAwareSubscriber.this.getPlatform().clientPeerDisappeared(peerAnnounce);
            }
        }

        @SuppressLint(value={"MissingPermission"})
        public void onSessionConfigFailed() {
            DittoLog.e$default(WifiAwareSubscriber.TAG, "onSessionConfigFailed()", null, 4, null);
            SubscriberDiscoveryCallback subscriberDiscoveryCallback = WifiAwareSubscriber.this.discovery;
            if (subscriberDiscoveryCallback == null) {
                SubscriberDiscoveryCallback $this$onSessionConfigFailed_u24lambda_u2d3 = this;
                boolean bl = false;
                DittoLog.w$default(WifiAwareSubscriber.TAG, "discovery callback null", null, 4, null);
                return;
            }
            SubscriberDiscoveryCallback discoveryCallback = subscriberDiscoveryCallback;
            WifiAwareSubscriber.this.getPlatform().clientScanningStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_GENERIC_FAILURE);
            WifiAwareSubscriber.this.getPlatform().queueDelayedReset();
        }

        public void onSessionTerminated() {
            DittoLog.w$default(WifiAwareSubscriber.TAG, "onSessionTerminated()", null, 4, null);
            WifiAwareSubscriber.this.getPlatform().clientScanningStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
        }

        public void onSubscribeStarted(@NotNull SubscribeDiscoverySession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            DittoLog.d$default(WifiAwareSubscriber.TAG, "onSubscribeStarted()", null, 4, null);
            WifiAwareSubscriber.this.getPlatform().clientScanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
            WifiAwareSubscriber.this.discoverySession = (DiscoverySession)session;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llive/ditto/transports/WifiAwareSubscriber$SubscriberNetworkCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "peer", "Llive/ditto/transports/WifiAwareSubscriber$DiscoveredPeer;", "announce", "", "(Llive/ditto/transports/WifiAwareSubscriber;Llive/ditto/transports/WifiAwareSubscriber$DiscoveredPeer;Ljava/lang/String;)V", "onAvailable", "", "network", "Landroid/net/Network;", "onCapabilitiesChanged", "networkCapabilities", "Landroid/net/NetworkCapabilities;", "onLost", "onUnavailable", "tryConnect", "dittocpp_release"})
    public final class SubscriberNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        @NotNull
        private final DiscoveredPeer peer;
        @NotNull
        private final String announce;

        public SubscriberNetworkCallback(@NotNull DiscoveredPeer peer, String announce) {
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
            this.peer = peer;
            this.announce = announce;
        }

        private final void tryConnect() {
            DiscoveredPeer discoveredPeer = (DiscoveredPeer)WifiAwareSubscriber.this.discoveredPeers.get(this.announce);
            if (discoveredPeer == null) {
                SubscriberNetworkCallback $this$tryConnect_u24lambda_u2d0 = this;
                boolean bl = false;
                DittoLog.w$default(WifiAwareSubscriber.TAG, "tryConnect() - Available peer no longer in discoveredPeers list.", null, 4, null);
                return;
            }
            DiscoveredPeer currentPeer = discoveredPeer;
            NetworkCapabilities networkCapabilities = currentPeer.getCapabilities();
            if (networkCapabilities == null) {
                SubscriberNetworkCallback $this$tryConnect_u24lambda_u2d1 = this;
                boolean bl = false;
                DittoLog.d$default(WifiAwareSubscriber.TAG, "tryConnect() - Network capabilities not yet validated, ignoring. (announce: " + $this$tryConnect_u24lambda_u2d1.announce + ")", null, 4, null);
                return;
            }
            NetworkCapabilities capabilities = networkCapabilities;
            if (!currentPeer.getAvailable()) {
                DittoLog.d$default(WifiAwareSubscriber.TAG, "tryConnect() - Current peer not yet marked available, ignoring. (announce: " + this.announce + ")", null, 4, null);
                return;
            }
            TransportInfo transportInfo = capabilities.getTransportInfo();
            Intrinsics.checkNotNull((Object)transportInfo, (String)"null cannot be cast to non-null type android.net.wifi.aware.WifiAwareNetworkInfo");
            WifiAwareNetworkInfo peerAwareInfo = (WifiAwareNetworkInfo)transportInfo;
            Inet6Address peerIpv6 = peerAwareInfo.getPeerIpv6Addr();
            int peerPort = peerAwareInfo.getPort();
            if (peerIpv6 == null) {
                DittoLog.e$default(WifiAwareSubscriber.TAG, "tryConnect() - Peer IPv6 address was null, unexpected. Cannot connect. (announce: " + this.announce + ")", null, 4, null);
                return;
            }
            DittoLog.i$default(WifiAwareSubscriber.TAG, "tryConnect() - Connecting to " + peerIpv6 + " on port " + peerPort, null, 4, null);
            WifiAwareSubscriber.this.getPlatform().clientNetworkDidCreate(this.announce, peerIpv6.getHostAddress(), peerPort);
        }

        public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
            DittoLog.d$default(WifiAwareSubscriber.TAG, "Network onCapabilitiesChanged " + networkCapabilities + " (announce: " + this.announce + ")", null, 4, null);
            if (networkCapabilities.hasCapability(16)) {
                this.peer.setCapabilities(networkCapabilities);
            }
            this.tryConnect();
        }

        public void onAvailable(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DittoLog.i$default(WifiAwareSubscriber.TAG, "Network onAvailable (announce: " + this.announce + ")", null, 4, null);
            this.peer.setAvailable(true);
            this.tryConnect();
        }

        public void onLost(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DittoLog.w$default(WifiAwareSubscriber.TAG, "Network onLost (announce: " + this.announce + ")", null, 4, null);
            DittoLog.d$default(WifiAwareSubscriber.TAG, "clearing existing callbacks for onLost", null, 4, null);
            WifiAwareSubscriber.this.resetPeer(this.announce);
            WifiAwareSubscriber.this.getPlatform().clientNetworkDidNotCreate(this.announce);
        }

        public void onUnavailable() {
            DittoLog.w$default(WifiAwareSubscriber.TAG, "Network onUnavailable (announce: " + this.announce + ")", null, 4, null);
            DittoLog.d$default(WifiAwareSubscriber.TAG, "clearing existing callbacks for onUnavailable", null, 4, null);
            WifiAwareSubscriber.this.resetPeer(this.announce);
            WifiAwareSubscriber.this.getPlatform().clientNetworkDidNotCreate(this.announce);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\u0004\u00a8\u0006&"}, d2={"Llive/ditto/transports/WifiAwareSubscriber$DiscoveredPeer;", "", "handle", "Landroid/net/wifi/aware/PeerHandle;", "(Landroid/net/wifi/aware/PeerHandle;)V", "available", "", "getAvailable", "()Z", "setAvailable", "(Z)V", "callback", "Landroid/net/ConnectivityManager$NetworkCallback;", "getCallback", "()Landroid/net/ConnectivityManager$NetworkCallback;", "setCallback", "(Landroid/net/ConnectivityManager$NetworkCallback;)V", "capabilities", "Landroid/net/NetworkCapabilities;", "getCapabilities", "()Landroid/net/NetworkCapabilities;", "setCapabilities", "(Landroid/net/NetworkCapabilities;)V", "connectMsgId", "", "getConnectMsgId", "()Ljava/lang/Integer;", "setConnectMsgId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "failCount", "getFailCount", "()I", "setFailCount", "(I)V", "getHandle", "()Landroid/net/wifi/aware/PeerHandle;", "setHandle", "dittocpp_release"})
    public static final class DiscoveredPeer {
        @NotNull
        private PeerHandle handle;
        @Nullable
        private ConnectivityManager.NetworkCallback callback;
        @Nullable
        private Integer connectMsgId;
        private int failCount;
        private boolean available;
        @Nullable
        private NetworkCapabilities capabilities;

        public DiscoveredPeer(@NotNull PeerHandle handle) {
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            this.handle = handle;
        }

        @NotNull
        public final PeerHandle getHandle() {
            return this.handle;
        }

        public final void setHandle(@NotNull PeerHandle peerHandle) {
            Intrinsics.checkNotNullParameter((Object)peerHandle, (String)"<set-?>");
            this.handle = peerHandle;
        }

        @Nullable
        public final ConnectivityManager.NetworkCallback getCallback() {
            return this.callback;
        }

        public final void setCallback(@Nullable ConnectivityManager.NetworkCallback networkCallback) {
            this.callback = networkCallback;
        }

        @Nullable
        public final Integer getConnectMsgId() {
            return this.connectMsgId;
        }

        public final void setConnectMsgId(@Nullable Integer n) {
            this.connectMsgId = n;
        }

        public final int getFailCount() {
            return this.failCount;
        }

        public final void setFailCount(int n) {
            this.failCount = n;
        }

        public final boolean getAvailable() {
            return this.available;
        }

        public final void setAvailable(boolean bl) {
            this.available = bl;
        }

        @Nullable
        public final NetworkCapabilities getCapabilities() {
            return this.capabilities;
        }

        public final void setCapabilities(@Nullable NetworkCapabilities networkCapabilities) {
            this.capabilities = networkCapabilities;
        }
    }
}

