/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports.ble;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.AdvertisingSet;
import android.bluetooth.le.AdvertisingSetCallback;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelUuid;
import androidx.annotation.RequiresApi;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import live.ditto.DittoLog;
import live.ditto.internal.swig.ffi.BleDataType_t;
import live.ditto.internal.swig.ffi.BluetoothLeRadioRust;
import live.ditto.internal.swig.ffi.OnlineState_t;
import live.ditto.internal.swig.ffi.SendResult_t;
import live.ditto.internal.swig.ffi.TransportCondition_t;
import live.ditto.internal.swig.ffi.slice_mut_uint8_t;
import live.ditto.transports.DittoSyncPermissions;
import live.ditto.transports.ble.AddService;
import live.ditto.transports.ble.BleExtensionsKt;
import live.ditto.transports.ble.BleServerOperation;
import live.ditto.transports.ble.CommandQueue;
import live.ditto.transports.ble.CommandQueueCallback;
import live.ditto.transports.ble.DisconnectPeripheral;
import live.ditto.transports.ble.ExperimentalBluetoothPlatform;
import live.ditto.transports.ble.ExperimentalBluetoothServer;
import live.ditto.transports.ble.L2capConnection;
import live.ditto.transports.ble.NotifyCharacteristicChanged;
import live.ditto.transports.ble.StartAdvertisingSet;
import live.ditto.transports.ble.StartLegacyAdvertising;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 R2\u00020\u0001:\u0001RB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u00106\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000208\u0018\u000107H\u0002J\n\u00109\u001a\u0004\u0018\u00010:H\u0003J\n\u0010;\u001a\u0004\u0018\u00010<H\u0002J\n\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0010J\b\u0010B\u001a\u00020@H\u0002J\b\u0010C\u001a\u00020@H\u0002J\u0016\u0010D\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u00102\u0006\u0010E\u001a\u00020FJ\u0016\u0010G\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u00102\u0006\u0010E\u001a\u000205J\b\u0010H\u001a\u00020@H\u0002J\u001e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u0002052\u0006\u0010E\u001a\u000205J\u0016\u0010N\u001a\u00020@2\u0006\u00104\u001a\u0002052\u0006\u0010O\u001a\u00020\u0010J\b\u0010P\u001a\u00020@H\u0003J\u0006\u0010Q\u001a\u00020@R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020 0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Llive/ditto/transports/ble/ExperimentalBluetoothServer;", "", "platform", "Llive/ditto/transports/ble/ExperimentalBluetoothPlatform;", "(Llive/ditto/transports/ble/ExperimentalBluetoothPlatform;)V", "adSetCallback", "Landroid/bluetooth/le/AdvertisingSetCallback;", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "getAdapter", "()Landroid/bluetooth/BluetoothAdapter;", "advertiseCallback", "Landroid/bluetooth/le/AdvertiseCallback;", "advertiser", "Landroid/bluetooth/le/BluetoothLeAdvertiser;", "advertisingAnnounce", "", "advertisingSet", "Landroid/bluetooth/le/AdvertisingSet;", "centralMTUs", "Ljava/util/concurrent/ConcurrentHashMap;", "", "commandQueue", "Llive/ditto/transports/ble/CommandQueue;", "Llive/ditto/transports/ble/BleServerOperation;", "getCommandQueue", "()Llive/ditto/transports/ble/CommandQueue;", "commandQueue$delegate", "Lkotlin/Lazy;", "commandQueueCallback", "Llive/ditto/transports/ble/CommandQueueCallback;", "connectedCentrals", "Landroid/bluetooth/BluetoothDevice;", "context", "Landroid/content/Context;", "controlReadChar", "Landroid/bluetooth/BluetoothGattCharacteristic;", "gattServer", "Landroid/bluetooth/BluetoothGattServer;", "<set-?>", "", "isAdvertising", "()Z", "l2capServer", "Landroid/bluetooth/BluetoothServerSocket;", "mainHandler", "Landroid/os/Handler;", "readChar", "serverCallback", "Landroid/bluetooth/BluetoothGattServerCallback;", "serverL2capChannels", "Llive/ditto/transports/ble/L2capConnection;", "serviceUuid", "", "buildAdvertiseData", "Lkotlin/Pair;", "Landroid/bluetooth/le/AdvertiseData;", "buildAdvertisingSet", "Llive/ditto/transports/ble/StartAdvertisingSet;", "buildLegacyAdvertiser", "Llive/ditto/transports/ble/StartLegacyAdvertising;", "buildService", "Llive/ditto/transports/ble/AddService;", "disconnect", "", "address", "doStartAdvertising", "doStopAdvertising", "l2capReceive", "data", "Llive/ditto/internal/swig/ffi/slice_mut_uint8_t;", "l2capSend", "retryAdvertisingAfterDelay", "sendGatt", "Llive/ditto/internal/swig/ffi/SendResult_t;", "sendType", "Llive/ditto/internal/swig/ffi/BleDataType_t;", "centralUuid", "startAdvertising", "localName", "startL2CapThread", "stopAdvertising", "Companion", "dittocpp_release"})
@SuppressLint(value={"MissingPermission"})
public final class ExperimentalBluetoothServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExperimentalBluetoothPlatform platform;
    @NotNull
    private final Context context;
    @NotNull
    private final Handler mainHandler;
    @NotNull
    private final BluetoothAdapter adapter;
    private boolean isAdvertising;
    @Nullable
    private BluetoothGattServer gattServer;
    @Nullable
    private BluetoothLeAdvertiser advertiser;
    @NotNull
    private final ConcurrentHashMap<String, L2capConnection> serverL2capChannels;
    @Nullable
    private BluetoothServerSocket l2capServer;
    @Nullable
    private byte[] serviceUuid;
    @NotNull
    private final ConcurrentHashMap<String, Integer> centralMTUs;
    @NotNull
    private final ConcurrentHashMap<String, BluetoothDevice> connectedCentrals;
    @Nullable
    private AdvertisingSet advertisingSet;
    @NotNull
    private String advertisingAnnounce;
    @NotNull
    private final Lazy commandQueue$delegate;
    private BluetoothGattCharacteristic readChar;
    private BluetoothGattCharacteristic controlReadChar;
    @NotNull
    private CommandQueueCallback<BleServerOperation> commandQueueCallback;
    @NotNull
    private BluetoothGattServerCallback serverCallback;
    @NotNull
    private AdvertiseCallback advertiseCallback;
    @RequiresApi(value=26)
    @NotNull
    private AdvertisingSetCallback adSetCallback;
    @NotNull
    private static String TAG = "ExperimentalBluetoothServer";
    private static final long OPERATION_TIMEOUT_MS = 35000L;

    public ExperimentalBluetoothServer(@NotNull ExperimentalBluetoothPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        this.context = this.platform.getContext$dittocpp_release();
        this.mainHandler = new Handler(this.context.getMainLooper());
        this.adapter = this.platform.getAdapter$dittocpp_release();
        this.serverL2capChannels = new ConcurrentHashMap();
        this.centralMTUs = new ConcurrentHashMap();
        this.connectedCentrals = new ConcurrentHashMap();
        this.advertisingAnnounce = "";
        this.commandQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CommandQueue<BleServerOperation>>(this){
            final /* synthetic */ ExperimentalBluetoothServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CommandQueue<BleServerOperation> invoke() {
                return new CommandQueue<BleServerOperation>(ExperimentalBluetoothServer.access$getMainHandler$p(this.this$0), ExperimentalBluetoothServer.access$getCommandQueueCallback$p(this.this$0), 35000L);
            }
        }));
        this.commandQueueCallback = new CommandQueueCallback<BleServerOperation>(this){
            final /* synthetic */ ExperimentalBluetoothServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNewOperation(@NotNull BleServerOperation operation) {
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                BluetoothGattServer bluetoothGattServer = ExperimentalBluetoothServer.access$getGattServer$p(this.this$0);
                if (bluetoothGattServer == null) {
                    commandQueueCallback.1 $this$onNewOperation_u24lambda_u2d0 = this;
                    boolean bl = false;
                    DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "GATT Server is not initialized, but required to run command.", null, 4, null);
                    return;
                }
                BluetoothGattServer gattServer = bluetoothGattServer;
                BleServerOperation bleServerOperation = operation;
                if (bleServerOperation instanceof DisconnectPeripheral) {
                    BleServerOperation bleServerOperation2 = operation;
                    ExperimentalBluetoothServer experimentalBluetoothServer = this.this$0;
                    DisconnectPeripheral $this$onNewOperation_u24lambda_u2d1 = (DisconnectPeripheral)bleServerOperation2;
                    boolean bl = false;
                    gattServer.cancelConnection($this$onNewOperation_u24lambda_u2d1.getDevice());
                    ExperimentalBluetoothServer.access$getCommandQueue(experimentalBluetoothServer).completePendingCommand();
                } else if (bleServerOperation instanceof NotifyCharacteristicChanged) {
                    BleServerOperation bleServerOperation3 = operation;
                    ExperimentalBluetoothServer experimentalBluetoothServer = this.this$0;
                    NotifyCharacteristicChanged $this$onNewOperation_u24lambda_u2d2 = (NotifyCharacteristicChanged)bleServerOperation3;
                    boolean bl = false;
                    BleExtensionsKt.notifyCharacteristicChangedCompat(gattServer, $this$onNewOperation_u24lambda_u2d2.getDevice(), $this$onNewOperation_u24lambda_u2d2.getCharacteristic(), false, $this$onNewOperation_u24lambda_u2d2.getData());
                    ExperimentalBluetoothServer.access$getCommandQueue(experimentalBluetoothServer).completePendingCommand();
                } else if (bleServerOperation instanceof AddService) {
                    BleServerOperation bleServerOperation4 = operation;
                    ExperimentalBluetoothServer experimentalBluetoothServer = this.this$0;
                    AddService $this$onNewOperation_u24lambda_u2d3 = (AddService)bleServerOperation4;
                    boolean bl = false;
                    if (!gattServer.addService($this$onNewOperation_u24lambda_u2d3.getService())) {
                        ExperimentalBluetoothServer.access$retryAdvertisingAfterDelay(experimentalBluetoothServer);
                        DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "Failed to add service to GATT server", null, 4, null);
                    }
                } else if (bleServerOperation instanceof StartAdvertisingSet) {
                    BluetoothLeAdvertiser advertiser;
                    BleServerOperation bleServerOperation5 = operation;
                    ExperimentalBluetoothServer experimentalBluetoothServer = this.this$0;
                    StartAdvertisingSet $this$onNewOperation_u24lambda_u2d4 = (StartAdvertisingSet)bleServerOperation5;
                    boolean bl = false;
                    if (Build.VERSION.SDK_INT < 26) {
                        DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "StartAdvertisingSet called on unsupported Android version", null, 4, null);
                        ExperimentalBluetoothServer.access$getCommandQueue(experimentalBluetoothServer).completePendingCommand();
                        return;
                    }
                    if (ExperimentalBluetoothServer.access$getAdvertiser$p(experimentalBluetoothServer) == null) {
                        ExperimentalBluetoothServer.access$setAdvertiser$p(experimentalBluetoothServer, experimentalBluetoothServer.getAdapter().getBluetoothLeAdvertiser());
                    }
                    if ((advertiser = ExperimentalBluetoothServer.access$getAdvertiser$p(experimentalBluetoothServer)) == null) {
                        DittoLog.i$default(ExperimentalBluetoothServer.Companion.getTAG(), "Bluetooth advertiser not available, probably disabled", null, 4, null);
                        ExperimentalBluetoothServer.access$getPlatform$p(experimentalBluetoothServer).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(experimentalBluetoothServer){
                            final /* synthetic */ ExperimentalBluetoothServer this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
                            }
                        }));
                        return;
                    }
                    DittoLog.i$default(ExperimentalBluetoothServer.Companion.getTAG(), "Starting modern advertiser.", null, 4, null);
                    advertiser.startAdvertisingSet($this$onNewOperation_u24lambda_u2d4.getAdSetParams(), $this$onNewOperation_u24lambda_u2d4.getAdvertisingData(), $this$onNewOperation_u24lambda_u2d4.getScanResponse(), null, null, 0, 0, ExperimentalBluetoothServer.access$getAdSetCallback$p(experimentalBluetoothServer));
                } else if (bleServerOperation instanceof StartLegacyAdvertising) {
                    BluetoothLeAdvertiser advertiser;
                    BleServerOperation bleServerOperation6 = operation;
                    ExperimentalBluetoothServer experimentalBluetoothServer = this.this$0;
                    StartLegacyAdvertising $this$onNewOperation_u24lambda_u2d5 = (StartLegacyAdvertising)bleServerOperation6;
                    boolean bl = false;
                    if (ExperimentalBluetoothServer.access$getAdvertiser$p(experimentalBluetoothServer) == null) {
                        ExperimentalBluetoothServer.access$setAdvertiser$p(experimentalBluetoothServer, experimentalBluetoothServer.getAdapter().getBluetoothLeAdvertiser());
                    }
                    if ((advertiser = ExperimentalBluetoothServer.access$getAdvertiser$p(experimentalBluetoothServer)) == null) {
                        DittoLog.i$default(ExperimentalBluetoothServer.Companion.getTAG(), "Bluetooth advertiser not available, probably disabled", null, 4, null);
                        ExperimentalBluetoothServer.access$getPlatform$p(experimentalBluetoothServer).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(experimentalBluetoothServer){
                            final /* synthetic */ ExperimentalBluetoothServer this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
                            }
                        }));
                        return;
                    }
                    DittoLog.i$default(ExperimentalBluetoothServer.Companion.getTAG(), "Starting legacy advertiser.", null, 4, null);
                    advertiser.startAdvertising($this$onNewOperation_u24lambda_u2d5.getAdSettings(), $this$onNewOperation_u24lambda_u2d5.getAdvertisingData(), $this$onNewOperation_u24lambda_u2d5.getScanResponse(), ExperimentalBluetoothServer.access$getAdvertiseCallback$p(experimentalBluetoothServer));
                }
            }

            public void onOperationTimeout(@NotNull BleServerOperation operation) {
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                DittoLog.w$default(ExperimentalBluetoothServer.Companion.getTAG(), "Operation timed out after 35000ms: " + operation, null, 4, null);
                ExperimentalBluetoothServer.access$getCommandQueue(this.this$0).completePendingCommand();
            }
        };
        this.serverCallback = new BluetoothGattServerCallback(this){
            final /* synthetic */ ExperimentalBluetoothServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConnectionStateChange(@NotNull BluetoothDevice device, int status, int newState) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                if (status != 0) {
                    DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "Central onConnectionStateChange() failed for " + device.getAddress() + ". Status: " + status, null, 4, null);
                    ExperimentalBluetoothServer.access$getConnectedCentrals$p(this.this$0).remove(device.getAddress());
                    return;
                }
                switch (newState) {
                    case 0: {
                        ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, device){
                            final /* synthetic */ ExperimentalBluetoothServer this$0;
                            final /* synthetic */ BluetoothDevice $device;
                            {
                                this.this$0 = $receiver;
                                this.$device = $device;
                                super(0);
                            }

                            public final void invoke() {
                                ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                                String string = this.$device.getAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                                experimentalBluetoothPlatform.centralUnsubscribed(BleExtensionsKt.toAddressBytes(string));
                            }
                        }));
                        DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "Central disconnected (" + device.getAddress() + ")", null, 4, null);
                        L2capConnection l2capConnection = (L2capConnection)ExperimentalBluetoothServer.access$getServerL2capChannels$p(this.this$0).remove(device.getAddress());
                        if (l2capConnection != null) {
                            l2capConnection.close();
                        }
                        ExperimentalBluetoothServer.access$getConnectedCentrals$p(this.this$0).remove(device.getAddress());
                        ConcurrentHashMap<String, ExperimentalBluetoothPlatform.PlatformType> concurrentHashMap = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).getDeviceLocks$dittocpp_release();
                        String string = device.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                        BleExtensionsKt.computeIfPresentCompat(concurrentHashMap, string, serverCallback.onConnectionStateChange.2.INSTANCE);
                        break;
                    }
                    case 2: {
                        if (ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).getDeviceLocks$dittocpp_release().get(device.getAddress()) == ExperimentalBluetoothPlatform.PlatformType.CLIENT) {
                            DittoLog.v$default(ExperimentalBluetoothServer.Companion.getTAG(), "Ignoring server connected notification for client connection (" + device.getAddress() + ")", null, 4, null);
                            return;
                        }
                        if (!ExperimentalBluetoothServer.access$getConnectedCentrals$p(this.this$0).containsKey(device.getAddress())) {
                            ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).getDeviceLocks$dittocpp_release().putIfAbsent(device.getAddress(), ExperimentalBluetoothPlatform.PlatformType.SERVER);
                            BluetoothGattServer bluetoothGattServer = ExperimentalBluetoothServer.access$getGattServer$p(this.this$0);
                            if (bluetoothGattServer != null) {
                                bluetoothGattServer.connect(device, false);
                            }
                            Map map = ExperimentalBluetoothServer.access$getConnectedCentrals$p(this.this$0);
                            String string = device.getAddress();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                            map.put(string, device);
                            DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "Central connected (" + device.getAddress() + ")", null, 4, null);
                            break;
                        }
                        DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "Received extraneous central connected notification (" + device.getAddress() + ")", null, 4, null);
                    }
                }
            }

            public void onServiceAdded(int status, @NotNull BluetoothGattService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                if (status != 0) {
                    DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "Central onServiceAdded() failed for " + service.getUuid() + ". Status: " + status, null, 4, null);
                    ExperimentalBluetoothServer.access$getMainHandler$p(this.this$0).post(() -> serverCallback.1.onServiceAdded$lambda-0(this.this$0));
                } else {
                    DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "onServiceAdded()", null, 4, null);
                    ExperimentalBluetoothServer.access$getCommandQueue(this.this$0).completePendingCommand();
                }
            }

            public void onCharacteristicReadRequest(@NotNull BluetoothDevice device, int requestId, int offset, @NotNull BluetoothGattCharacteristic characteristic) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "onCharacteristicReadRequest: " + characteristic.getUuid(), null, 4, null);
                BluetoothServerSocket l2capServer = ExperimentalBluetoothServer.access$getL2capServer$p(this.this$0);
                BluetoothGattServer bluetoothGattServer = ExperimentalBluetoothServer.access$getGattServer$p(this.this$0);
                if (bluetoothGattServer == null) {
                    serverCallback.1 $this$onCharacteristicReadRequest_u24lambda_u2d1 = this;
                    boolean bl = false;
                    DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "onCharacteristicReadRequest: GATT Server not initialized", null, 4, null);
                    return;
                }
                BluetoothGattServer gattServer = bluetoothGattServer;
                if (Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)BleExtensionsKt.getCHAR_UUID_PSM()) && l2capServer != null && Build.VERSION.SDK_INT >= 29) {
                    int psm = l2capServer.getPsm();
                    byte msb = (byte)(psm >> 8);
                    byte lsb = (byte)(psm & 0xFF);
                    byte[] byArray = new byte[]{msb, lsb};
                    Pair pair2 = new Pair((Object)0, (Object)byArray);
                    pair = pair2;
                } else {
                    pair = new Pair((Object)257, (Object)new byte[0]);
                }
                Pair pair3 = pair;
                int status = ((Number)pair3.component1()).intValue();
                byte[] bytes = (byte[])pair3.component2();
                ExperimentalBluetoothServer.access$getMainHandler$p(this.this$0).post(() -> serverCallback.1.onCharacteristicReadRequest$lambda-2(gattServer, device, requestId, status, offset, bytes));
            }

            public void onCharacteristicWriteRequest(@NotNull BluetoothDevice device, int requestId, @NotNull BluetoothGattCharacteristic characteristic, boolean preparedWrite, boolean responseNeeded, int offset, @NotNull byte[] value) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (responseNeeded) {
                    ExperimentalBluetoothServer.access$getMainHandler$p(this.this$0).post(() -> serverCallback.1.onCharacteristicWriteRequest$lambda-3(this.this$0, device, requestId, offset, value));
                }
                if (value.length == 0) {
                    return;
                }
                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(characteristic, this.this$0, device, value){
                    final /* synthetic */ BluetoothGattCharacteristic $characteristic;
                    final /* synthetic */ ExperimentalBluetoothServer this$0;
                    final /* synthetic */ BluetoothDevice $device;
                    final /* synthetic */ byte[] $value;
                    {
                        this.$characteristic = $characteristic;
                        this.this$0 = $receiver;
                        this.$device = $device;
                        this.$value = $value;
                        super(0);
                    }

                    public final void invoke() {
                        UUID uUID = this.$characteristic.getUuid();
                        if (Intrinsics.areEqual((Object)uUID, (Object)BleExtensionsKt.getCHAR_UUID_WRITE())) {
                            ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                            String string = this.$device.getAddress();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                            experimentalBluetoothPlatform.receivedFromCentral(BleExtensionsKt.toAddressBytes(string), BleDataType_t.BLE_DATA_TYPE_MESH_DATA, this.$value);
                        } else if (Intrinsics.areEqual((Object)uUID, (Object)BleExtensionsKt.getCHAR_UUID_CONTROL_WRITE())) {
                            ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                            String string = this.$device.getAddress();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                            experimentalBluetoothPlatform.receivedFromCentral(BleExtensionsKt.toAddressBytes(string), BleDataType_t.BLE_DATA_TYPE_CONTROL, this.$value);
                        } else if (Intrinsics.areEqual((Object)uUID, (Object)BleExtensionsKt.getCHAR_UUID_ANNOUNCE())) {
                            ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postDelayedOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$device, this.$value){
                                final /* synthetic */ ExperimentalBluetoothServer this$0;
                                final /* synthetic */ BluetoothDevice $device;
                                final /* synthetic */ byte[] $value;
                                {
                                    this.this$0 = $receiver;
                                    this.$device = $device;
                                    this.$value = $value;
                                    super(0);
                                }

                                public final void invoke() {
                                    boolean l2capAvailable = ExperimentalBluetoothServer.access$getServerL2capChannels$p(this.this$0).containsKey(this.$device.getAddress());
                                    DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "Central finished connecting uuid " + this.$device.getAddress() + ". L2CAP available: " + l2capAvailable, null, 4, null);
                                    ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                                    String string = this.$device.getAddress();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                                    byte[] byArray = BleExtensionsKt.toAddressBytes(string);
                                    Integer n = (Integer)ExperimentalBluetoothServer.access$getCentralMTUs$p(this.this$0).get(this.$device.getAddress());
                                    if (n == null) {
                                        n = 20;
                                    }
                                    experimentalBluetoothPlatform.centralFinishedConnecting(byArray, this.$value, l2capAvailable, ((Number)n).intValue());
                                }
                            }), 100L);
                        }
                    }
                }));
            }

            public void onDescriptorWriteRequest(@NotNull BluetoothDevice device, int requestId, @NotNull BluetoothGattDescriptor descriptor, boolean preparedWrite, boolean responseNeeded, int offset, @NotNull byte[] value) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "Descriptor written", null, 4, null);
                if (responseNeeded) {
                    ExperimentalBluetoothServer.access$getMainHandler$p(this.this$0).post(() -> serverCallback.1.onDescriptorWriteRequest$lambda-4(this.this$0, device, requestId, offset, value));
                }
                boolean subscribed = Arrays.equals(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE, value);
                if (Intrinsics.areEqual((Object)descriptor.getCharacteristic().getUuid(), (Object)BleExtensionsKt.getCHAR_UUID_READ())) {
                    Integer mtu;
                    if (!subscribed) {
                        ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, device){
                            final /* synthetic */ ExperimentalBluetoothServer this$0;
                            final /* synthetic */ BluetoothDevice $device;
                            {
                                this.this$0 = $receiver;
                                this.$device = $device;
                                super(0);
                            }

                            public final void invoke() {
                                ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                                String string = this.$device.getAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                                experimentalBluetoothPlatform.centralUnsubscribed(BleExtensionsKt.toAddressBytes(string));
                            }
                        }));
                    }
                    if ((mtu = (Integer)ExperimentalBluetoothServer.access$getCentralMTUs$p(this.this$0).get(device.getAddress())) != null) {
                        ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, device, mtu){
                            final /* synthetic */ ExperimentalBluetoothServer this$0;
                            final /* synthetic */ BluetoothDevice $device;
                            final /* synthetic */ Integer $mtu;
                            {
                                this.this$0 = $receiver;
                                this.$device = $device;
                                this.$mtu = $mtu;
                                super(0);
                            }

                            public final void invoke() {
                                ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                                String string = this.$device.getAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                                experimentalBluetoothPlatform.centralMtuUpdated(BleExtensionsKt.toAddressBytes(string), this.$mtu);
                            }
                        }));
                    }
                }
            }

            public void onMtuChanged(@NotNull BluetoothDevice device, int mtu) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                Ref.IntRef finalMtu = new Ref.IntRef();
                finalMtu.element = mtu;
                DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "GattServerCallback: MTU changed to " + finalMtu.element, null, 4, null);
                finalMtu.element -= 3;
                Map map = ExperimentalBluetoothServer.access$getCentralMTUs$p(this.this$0);
                String string = device.getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                String string2 = string;
                Integer n = finalMtu.element;
                map.put(string2, n);
                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, device, finalMtu){
                    final /* synthetic */ ExperimentalBluetoothServer this$0;
                    final /* synthetic */ BluetoothDevice $device;
                    final /* synthetic */ Ref.IntRef $finalMtu;
                    {
                        this.this$0 = $receiver;
                        this.$device = $device;
                        this.$finalMtu = $finalMtu;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                        String string = this.$device.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                        experimentalBluetoothPlatform.centralMtuUpdated(BleExtensionsKt.toAddressBytes(string), this.$finalMtu.element);
                    }
                }));
            }

            public void onPhyUpdate(@NotNull BluetoothDevice device, int txPhy, int rxPhy, int status) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                if (status != 0) {
                    DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "onPhyUpdate() failed for " + device.getAddress() + ". Status: " + status, null, 4, null);
                    return;
                }
                String tx = this.phyCodeToString(txPhy);
                String rx = this.phyCodeToString(rxPhy);
                DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "GattServerCallback onPhyUpdate: txPhy " + tx + " rxPhy " + rx, null, 4, null);
            }

            private final String phyCodeToString(int code) {
                if (code == 1) {
                    return "PHY_LE_1M";
                }
                if (code == 2) {
                    return "PHY_LE_2M";
                }
                if (code == 3) {
                    return "PHY_LE_CODED";
                }
                return "PHY Code: " + code;
            }

            public void onNotificationSent(@NotNull BluetoothDevice device, int status) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                if (status != 0) {
                    DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "onNotificationSent() failed for " + device.getAddress() + ". Status: " + status, null, 4, null);
                    return;
                }
                DittoLog.v$default(ExperimentalBluetoothServer.Companion.getTAG(), "Central reported ready-to-send", null, 4, null);
                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postDelayedOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, device){
                    final /* synthetic */ ExperimentalBluetoothServer this$0;
                    final /* synthetic */ BluetoothDevice $device;
                    {
                        this.this$0 = $receiver;
                        this.$device = $device;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothServer.access$getPlatform$p(this.this$0);
                        String string = this.$device.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                        experimentalBluetoothPlatform.centralReadyToSend(BleExtensionsKt.toAddressBytes(string));
                    }
                }), 5L);
            }

            private static final void onServiceAdded$lambda-0(ExperimentalBluetoothServer this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                ExperimentalBluetoothServer.access$getCommandQueue(this$0).clear();
                ExperimentalBluetoothServer.access$getCommandQueue(this$0).completePendingCommand();
                ExperimentalBluetoothServer.access$doStopAdvertising(this$0);
                ExperimentalBluetoothServer.access$retryAdvertisingAfterDelay(this$0);
            }

            private static final void onCharacteristicReadRequest$lambda-2(BluetoothGattServer $gattServer, BluetoothDevice $device, int $requestId, int $status, int $offset, byte[] $bytes) {
                Intrinsics.checkNotNullParameter((Object)$gattServer, (String)"$gattServer");
                Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
                $gattServer.sendResponse($device, $requestId, $status, $offset, $bytes);
            }

            private static final void onCharacteristicWriteRequest$lambda-3(ExperimentalBluetoothServer this$0, BluetoothDevice $device, int $requestId, int $offset, byte[] $value) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                    BluetoothGattServer bluetoothGattServer = ExperimentalBluetoothServer.access$getGattServer$p(this$0);
                    if (bluetoothGattServer == null) break block0;
                    bluetoothGattServer.sendResponse($device, $requestId, 0, $offset, $value);
                }
            }

            private static final void onDescriptorWriteRequest$lambda-4(ExperimentalBluetoothServer this$0, BluetoothDevice $device, int $requestId, int $offset, byte[] $value) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$device, (String)"$device");
                    Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                    BluetoothGattServer bluetoothGattServer = ExperimentalBluetoothServer.access$getGattServer$p(this$0);
                    if (bluetoothGattServer == null) break block0;
                    bluetoothGattServer.sendResponse($device, $requestId, 0, $offset, $value);
                }
            }
        };
        this.advertiseCallback = new AdvertiseCallback(this){
            final /* synthetic */ ExperimentalBluetoothServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStartSuccess(@Nullable AdvertiseSettings settingsInEffect) {
                ExperimentalBluetoothServer.access$getCommandQueue(this.this$0).completePendingCommand();
                DittoLog.i$default(ExperimentalBluetoothServer.Companion.getTAG(), "Legacy advertiser started successfully", null, 4, null);
                DittoLog.v$default(ExperimentalBluetoothServer.Companion.getTAG(), "In-effect settings: " + settingsInEffect, null, 4, null);
                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ExperimentalBluetoothServer this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
                    }
                }));
            }

            public void onStartFailure(int errorCode) {
                ExperimentalBluetoothServer.access$getCommandQueue(this.this$0).completePendingCommand();
                DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check manifest. Error code: " + errorCode + "<https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ExperimentalBluetoothServer this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_PERIPHERAL_PERMISSION);
                    }
                }));
            }
        };
        this.adSetCallback = new AdvertisingSetCallback(this){
            final /* synthetic */ ExperimentalBluetoothServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAdvertisingSetStarted(@Nullable AdvertisingSet advertisingSet, int txPower, int status) {
                if (status == 0) {
                    DittoLog.d$default(ExperimentalBluetoothServer.Companion.getTAG(), "Advertising set started", null, 4, null);
                    ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ ExperimentalBluetoothServer this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
                        }
                    }));
                    ExperimentalBluetoothServer.access$setAdvertisingSet$p(this.this$0, advertisingSet);
                } else {
                    DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "Failed to start advertising set, status: " + status, null, 4, null);
                    ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ ExperimentalBluetoothServer this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_GOING_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_GENERIC_FAILURE);
                        }
                    }));
                }
                ExperimentalBluetoothServer.access$getCommandQueue(this.this$0).completePendingCommand();
            }

            public void onAdvertisingSetStopped(@Nullable AdvertisingSet advertisingSet) {
                DittoLog.e$default(ExperimentalBluetoothServer.Companion.getTAG(), "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check manifest. <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ExperimentalBluetoothServer this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_PERIPHERAL_PERMISSION);
                    }
                }));
            }

            public void onAdvertisingEnabled(@Nullable AdvertisingSet advertisingSet, boolean enable, int status) {
                DittoLog.v$default(ExperimentalBluetoothServer.Companion.getTAG(), "onAdvertisingEnabled(" + advertisingSet + ", " + enable + ", " + status + ")", null, 4, null);
                super.onAdvertisingEnabled(advertisingSet, enable, status);
            }

            public void onScanResponseDataSet(@Nullable AdvertisingSet advertisingSet, int status) {
                DittoLog.v$default(ExperimentalBluetoothServer.Companion.getTAG(), "onScanResponseDataSet(), status " + status, null, 4, null);
                super.onScanResponseDataSet(advertisingSet, status);
            }
        };
    }

    @NotNull
    public final BluetoothAdapter getAdapter() {
        return this.adapter;
    }

    public final boolean isAdvertising() {
        return this.isAdvertising;
    }

    private final CommandQueue<BleServerOperation> getCommandQueue() {
        Lazy lazy = this.commandQueue$delegate;
        return (CommandQueue)lazy.getValue();
    }

    public final synchronized void startAdvertising(@NotNull byte[] serviceUuid, @NotNull String localName) {
        Intrinsics.checkNotNullParameter((Object)serviceUuid, (String)"serviceUuid");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        DittoLog.i$default(TAG, "Starting advertising", null, 4, null);
        this.isAdvertising = true;
        this.serviceUuid = serviceUuid;
        this.advertisingAnnounce = localName;
        this.mainHandler.post(() -> ExperimentalBluetoothServer.startAdvertising$lambda-0(this));
    }

    public final synchronized void stopAdvertising() {
        DittoLog.i$default(TAG, "Stopping advertising", null, 4, null);
        this.isAdvertising = false;
        this.mainHandler.post(() -> ExperimentalBluetoothServer.stopAdvertising$lambda-1(this));
    }

    public final synchronized int l2capReceive(@NotNull String address, @NotNull slice_mut_uint8_t data) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        L2capConnection l2capConnection = this.serverL2capChannels.get(address);
        if (l2capConnection != null) {
            L2capConnection conn = l2capConnection;
            boolean bl = false;
            byte[] byArray = conn.read((int)data.getCapacity());
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl2 = false;
                data.setValue(it);
                return it.length;
            }
            return -2;
        }
        DittoLog.w$default(TAG, "failed to receive from L2CAP", null, 4, null);
        return -1;
    }

    public final synchronized int l2capSend(@NotNull String address, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        L2capConnection l2capConnection = this.serverL2capChannels.get(address);
        if (l2capConnection != null) {
            L2capConnection conn = l2capConnection;
            boolean bl = false;
            if (conn.send(data)) {
                return data.length;
            }
            return 0;
        }
        DittoLog.w$default(TAG, "failed to send to L2CAP", null, 4, null);
        return -1;
    }

    public final void disconnect(@NotNull String address) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            BluetoothDevice bluetoothDevice = this.connectedCentrals.get(address);
            if (bluetoothDevice == null) break block0;
            BluetoothDevice it = bluetoothDevice;
            boolean bl = false;
            this.getCommandQueue().enqueueCommand(new DisconnectPeripheral(it));
        }
    }

    @NotNull
    public final synchronized SendResult_t sendGatt(@NotNull BleDataType_t sendType, @NotNull byte[] centralUuid, @NotNull byte[] data) {
        SendResult_t sendResult_t;
        BluetoothGattCharacteristic characteristic;
        Intrinsics.checkNotNullParameter((Object)sendType, (String)"sendType");
        Intrinsics.checkNotNullParameter((Object)centralUuid, (String)"centralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String address = BleExtensionsKt.toAddressString(centralUuid);
        DittoLog.v$default(TAG, "Asked to notify to central " + address, null, 4, null);
        BluetoothDevice device = this.connectedCentrals.get(BleExtensionsKt.toAddressString(centralUuid));
        if (device == null) {
            SendResult_t sendResult_t2;
            DittoLog.w$default(TAG, "Asked to notify to unknown device", null, 4, null);
            SendResult_t it = sendResult_t2 = new SendResult_t();
            boolean bl = false;
            it.setWait_for_ready(false);
            it.setAccepted(false);
            return sendResult_t2;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic = this.readChar;
        if (bluetoothGattCharacteristic == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readChar");
            bluetoothGattCharacteristic = characteristic = null;
        }
        if (Intrinsics.areEqual((Object)sendType, (Object)BleDataType_t.BLE_DATA_TYPE_CONTROL)) {
            BluetoothGattCharacteristic bluetoothGattCharacteristic2 = this.controlReadChar;
            if (bluetoothGattCharacteristic2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"controlReadChar");
                bluetoothGattCharacteristic2 = null;
            }
            characteristic = bluetoothGattCharacteristic2;
        }
        this.getCommandQueue().enqueueCommand(new NotifyCharacteristicChanged(device, characteristic, false, data));
        SendResult_t it = sendResult_t = new SendResult_t();
        boolean bl = false;
        it.setWait_for_ready(true);
        it.setAccepted(true);
        return sendResult_t;
    }

    private final AddService buildService() {
        if (this.serviceUuid == null) {
            return null;
        }
        byte[] serviceUuid = this.serviceUuid;
        BluetoothGattService service = new BluetoothGattService(BleExtensionsKt.toUuid(serviceUuid), 0);
        this.readChar = new BluetoothGattCharacteristic(BleExtensionsKt.getCHAR_UUID_READ(), 16, 1);
        this.controlReadChar = new BluetoothGattCharacteristic(BleExtensionsKt.getCHAR_UUID_CONTROL_READ(), 16, 1);
        BluetoothGattCharacteristic writeChar = new BluetoothGattCharacteristic(BleExtensionsKt.getCHAR_UUID_WRITE(), 4, 16);
        BluetoothGattCharacteristic controlWriteChar = new BluetoothGattCharacteristic(BleExtensionsKt.getCHAR_UUID_CONTROL_WRITE(), 4, 16);
        BluetoothGattCharacteristic announceChar = new BluetoothGattCharacteristic(BleExtensionsKt.getCHAR_UUID_ANNOUNCE(), 8, 16);
        BluetoothGattDescriptor dataDescriptor = new BluetoothGattDescriptor(BleExtensionsKt.getCCC_DESCRIPTOR_UUID(), 17);
        BluetoothGattDescriptor controlDescriptor = new BluetoothGattDescriptor(BleExtensionsKt.getCCC_DESCRIPTOR_UUID(), 17);
        BluetoothGattCharacteristic bluetoothGattCharacteristic = this.readChar;
        if (bluetoothGattCharacteristic == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readChar");
            bluetoothGattCharacteristic = null;
        }
        if (!bluetoothGattCharacteristic.addDescriptor(dataDescriptor)) {
            return null;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic2 = this.controlReadChar;
        if (bluetoothGattCharacteristic2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlReadChar");
            bluetoothGattCharacteristic2 = null;
        }
        if (!bluetoothGattCharacteristic2.addDescriptor(controlDescriptor)) {
            return null;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic3 = this.readChar;
        if (bluetoothGattCharacteristic3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"readChar");
            bluetoothGattCharacteristic3 = null;
        }
        if (!service.addCharacteristic(bluetoothGattCharacteristic3)) {
            return null;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic4 = this.controlReadChar;
        if (bluetoothGattCharacteristic4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlReadChar");
            bluetoothGattCharacteristic4 = null;
        }
        if (!service.addCharacteristic(bluetoothGattCharacteristic4)) {
            return null;
        }
        if (!service.addCharacteristic(writeChar)) {
            return null;
        }
        if (!service.addCharacteristic(controlWriteChar)) {
            return null;
        }
        if (!service.addCharacteristic(announceChar)) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 29 && !service.addCharacteristic(new BluetoothGattCharacteristic(BleExtensionsKt.getCHAR_UUID_PSM(), 2, 1))) {
            return null;
        }
        return new AddService(service);
    }

    private final void doStartAdvertising() {
        BluetoothGattServer gattServer;
        BluetoothManager bluetoothManager;
        if (this.gattServer != null) {
            return;
        }
        Context context = this.context;
        if (!(new DittoSyncPermissions(context).missingBluetoothServerPermissions$dittocpp_release().length == 0)) {
            DittoLog.e$default(TAG, "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check both AndroidManifest.xml and calls to ActivityCompat.requestPermissions(). <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
            this.platform.postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ExperimentalBluetoothServer this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_PERIPHERAL_PERMISSION);
                }
            }));
            this.retryAdvertisingAfterDelay();
            return;
        }
        Object object = this.context.getSystemService("bluetooth");
        BluetoothManager bluetoothManager2 = bluetoothManager = object instanceof BluetoothManager ? (BluetoothManager)object : null;
        if ((bluetoothManager2 != null ? bluetoothManager2.getAdapter() : null) == null || !bluetoothManager.getAdapter().isMultipleAdvertisementSupported()) {
            BluetoothManager bluetoothManager3;
            BluetoothManager bluetoothManager4 = bluetoothManager;
            DittoLog.e$default(TAG, "BLE hardware issue: manager: " + bluetoothManager + ", adapter: " + (BluetoothAdapter)(bluetoothManager4 != null ? bluetoothManager4.getAdapter() : null) + ", advertisement supported: " + ((bluetoothManager3 = bluetoothManager) != null && (bluetoothManager3 = bluetoothManager3.getAdapter()) != null ? Boolean.valueOf(bluetoothManager3.isMultipleAdvertisementSupported()) : null), null, 4, null);
            this.platform.postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ExperimentalBluetoothServer this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_HARDWARE);
                }
            }));
            return;
        }
        this.gattServer = gattServer = bluetoothManager.openGattServer(context, this.serverCallback);
        if (gattServer == null) {
            DittoLog.w$default(TAG, "BLE is disabled, could not open GATT server", null, 4, null);
            this.platform.postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ExperimentalBluetoothServer this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExperimentalBluetoothServer.access$getPlatform$p(this.this$0).advertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
                }
            }));
            return;
        }
        AddService addService = this.buildService();
        if (addService == null) {
            ExperimentalBluetoothServer $this$doStartAdvertising_u24lambda_u2d8 = this;
            boolean bl = false;
            DittoLog.e$default(TAG, "Failed to build service", null, 4, null);
            return;
        }
        AddService serviceCommand = addService;
        this.getCommandQueue().enqueueCommand(serviceCommand);
        if (Build.VERSION.SDK_INT >= 26) {
            StartAdvertisingSet startAdvertisingSet = this.buildAdvertisingSet();
            if (startAdvertisingSet == null) {
                ExperimentalBluetoothServer $this$doStartAdvertising_u24lambda_u2d9 = this;
                boolean bl = false;
                DittoLog.e$default(TAG, "Failed to build advertising set", null, 4, null);
                return;
            }
            StartAdvertisingSet advertisingSetCommand = startAdvertisingSet;
            this.getCommandQueue().enqueueCommand(advertisingSetCommand);
        } else {
            StartLegacyAdvertising startLegacyAdvertising = this.buildLegacyAdvertiser();
            if (startLegacyAdvertising == null) {
                ExperimentalBluetoothServer $this$doStartAdvertising_u24lambda_u2d10 = this;
                boolean bl = false;
                DittoLog.e$default(TAG, "Failed to build advertiser", null, 4, null);
                return;
            }
            StartLegacyAdvertising advertisingCommand = startLegacyAdvertising;
            this.getCommandQueue().enqueueCommand(advertisingCommand);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.startL2CapThread();
        }
    }

    @RequiresApi(value=29)
    private final void startL2CapThread() {
        new Thread(() -> ExperimentalBluetoothServer.startL2CapThread$lambda-11(this)).start();
    }

    private final void retryAdvertisingAfterDelay() {
        BluetoothGattServer bluetoothGattServer = this.gattServer;
        if (bluetoothGattServer != null) {
            bluetoothGattServer.clearServices();
        }
        BluetoothGattServer bluetoothGattServer2 = this.gattServer;
        if (bluetoothGattServer2 != null) {
            bluetoothGattServer2.close();
        }
        this.gattServer = null;
        this.mainHandler.postDelayed(() -> ExperimentalBluetoothServer.retryAdvertisingAfterDelay$lambda-12(this), 10000L);
    }

    private final StartLegacyAdvertising buildLegacyAdvertiser() {
        Pair<AdvertiseData, AdvertiseData> pair = this.buildAdvertiseData();
        if (pair == null) {
            return null;
        }
        Pair<AdvertiseData, AdvertiseData> pair2 = pair;
        AdvertiseData advertisingData = (AdvertiseData)pair2.component1();
        AdvertiseData scanResponse = (AdvertiseData)pair2.component2();
        AdvertiseSettings settings = new AdvertiseSettings.Builder().setConnectable(true).setTxPowerLevel(this.platform.getManager().getConfig().getAdvertisementPower().legacyPowerLevel$dittocpp_release()).setAdvertiseMode(this.platform.getManager().getConfig().getAdvertisementInterval().legacyAdvertisementInterval$dittocpp_release()).setTimeout(0).build();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
        return new StartLegacyAdvertising(settings, advertisingData, scanResponse);
    }

    @RequiresApi(value=26)
    private final StartAdvertisingSet buildAdvertisingSet() {
        Pair<AdvertiseData, AdvertiseData> pair = this.buildAdvertiseData();
        if (pair == null) {
            return null;
        }
        Pair<AdvertiseData, AdvertiseData> pair2 = pair;
        AdvertiseData advertisingData = (AdvertiseData)pair2.component1();
        AdvertiseData scanResponse = (AdvertiseData)pair2.component2();
        AdvertisingSetParameters adSetParams = new AdvertisingSetParameters.Builder().setConnectable(true).setScannable(true).setLegacyMode(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)adSetParams, (String)"adSetParams");
        return new StartAdvertisingSet(adSetParams, advertisingData, scanResponse);
    }

    private final Pair<AdvertiseData, AdvertiseData> buildAdvertiseData() {
        Object object;
        block3: {
            block2: {
                object = this.serviceUuid;
                if (this.serviceUuid == null) break block2;
                UUID uUID = BleExtensionsKt.toUuid(object);
                object = uUID;
                if (uUID != null) break block3;
            }
            ExperimentalBluetoothServer $this$buildAdvertiseData_u24lambda_u2d13 = this;
            boolean bl = false;
            DittoLog.e$default(TAG, "startAdvertisingSet init issue. serviceUuid: " + $this$buildAdvertiseData_u24lambda_u2d13.serviceUuid, null, 4, null);
            return null;
        }
        Object serviceUuid = object;
        AdvertiseData advertisingData = new AdvertiseData.Builder().addServiceUuid(new ParcelUuid((UUID)serviceUuid)).setIncludeDeviceName(false).build();
        AdvertiseData.Builder builder = new AdvertiseData.Builder().setIncludeDeviceName(false);
        String string = this.advertisingAnnounce;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        AdvertiseData scanResponse = builder.addManufacturerData(0, byArray).build();
        return new Pair((Object)advertisingData, (Object)scanResponse);
    }

    /*
     * WARNING - void declaration
     */
    private final void doStopAdvertising() {
        void $this$mapTo$iv$iv;
        Object it;
        BluetoothLeAdvertiser bluetoothLeAdvertiser = this.advertiser;
        if (bluetoothLeAdvertiser != null) {
            it = bluetoothLeAdvertiser;
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 26) {
                it.stopAdvertisingSet(this.adSetCallback);
            } else {
                it.stopAdvertising(this.advertiseCallback);
            }
            this.advertisingSet = null;
            this.advertiser = null;
        }
        BluetoothGattServer bluetoothGattServer = this.gattServer;
        if (bluetoothGattServer != null) {
            it = bluetoothGattServer;
            boolean bl = false;
            it.clearServices();
            it.close();
            this.gattServer = null;
        }
        BluetoothServerSocket bluetoothServerSocket = this.l2capServer;
        if (bluetoothServerSocket != null) {
            it = bluetoothServerSocket;
            boolean bl = false;
            it.close();
            this.l2capServer = null;
        }
        Map $this$map$iv = this.serverL2capChannels;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ((L2capConnection)it2.getValue()).close();
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.serverL2capChannels.clear();
        this.connectedCentrals.clear();
    }

    private static final void startAdvertising$lambda-0(ExperimentalBluetoothServer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStartAdvertising();
    }

    private static final void stopAdvertising$lambda-1(ExperimentalBluetoothServer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStopAdvertising();
    }

    private static final void startL2CapThread$lambda-11(ExperimentalBluetoothServer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DittoLog.d$default(TAG, "Starting L2CAP listener for the server.", null, 4, null);
        try {
            BluetoothServerSocket listener;
            BluetoothServerSocket bluetoothServerSocket = this$0.adapter.listenUsingInsecureL2capChannel();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothServerSocket, (String)"adapter.listenUsingInsecureL2capChannel()");
            this$0.l2capServer = listener = bluetoothServerSocket;
            while (true) {
                BluetoothSocket socket = listener.accept();
                DittoLog.d$default(TAG, "Opening new L2CAP connection with " + socket.getRemoteDevice().getAddress(), null, 4, null);
                String string = socket.getRemoteDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"socket.remoteDevice.address");
                byte[] uuidBytes = BleExtensionsKt.toAddressBytes(string);
                Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket");
                L2capConnection conn = new L2capConnection(uuidBytes, socket, true, new WeakReference<BluetoothLeRadioRust>(this$0.platform));
                Map map = this$0.serverL2capChannels;
                String string2 = socket.getRemoteDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"socket.remoteDevice.address");
                map.put(string2, conn);
            }
        }
        catch (Exception e) {
            DittoLog.d$default(TAG, "Exited L2cap socket listening loop: " + e, null, 4, null);
            return;
        }
    }

    private static final void retryAdvertisingAfterDelay$lambda-12(ExperimentalBluetoothServer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isAdvertising && this$0.gattServer == null) {
            this$0.doStartAdvertising();
        }
    }

    public static final /* synthetic */ ExperimentalBluetoothPlatform access$getPlatform$p(ExperimentalBluetoothServer $this) {
        return $this.platform;
    }

    public static final /* synthetic */ Handler access$getMainHandler$p(ExperimentalBluetoothServer $this) {
        return $this.mainHandler;
    }

    public static final /* synthetic */ CommandQueueCallback access$getCommandQueueCallback$p(ExperimentalBluetoothServer $this) {
        return $this.commandQueueCallback;
    }

    public static final /* synthetic */ BluetoothGattServer access$getGattServer$p(ExperimentalBluetoothServer $this) {
        return $this.gattServer;
    }

    public static final /* synthetic */ CommandQueue access$getCommandQueue(ExperimentalBluetoothServer $this) {
        return $this.getCommandQueue();
    }

    public static final /* synthetic */ void access$retryAdvertisingAfterDelay(ExperimentalBluetoothServer $this) {
        $this.retryAdvertisingAfterDelay();
    }

    public static final /* synthetic */ BluetoothLeAdvertiser access$getAdvertiser$p(ExperimentalBluetoothServer $this) {
        return $this.advertiser;
    }

    public static final /* synthetic */ void access$setAdvertiser$p(ExperimentalBluetoothServer $this, BluetoothLeAdvertiser bluetoothLeAdvertiser) {
        $this.advertiser = bluetoothLeAdvertiser;
    }

    public static final /* synthetic */ AdvertisingSetCallback access$getAdSetCallback$p(ExperimentalBluetoothServer $this) {
        return $this.adSetCallback;
    }

    public static final /* synthetic */ AdvertiseCallback access$getAdvertiseCallback$p(ExperimentalBluetoothServer $this) {
        return $this.advertiseCallback;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getConnectedCentrals$p(ExperimentalBluetoothServer $this) {
        return $this.connectedCentrals;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getServerL2capChannels$p(ExperimentalBluetoothServer $this) {
        return $this.serverL2capChannels;
    }

    public static final /* synthetic */ BluetoothServerSocket access$getL2capServer$p(ExperimentalBluetoothServer $this) {
        return $this.l2capServer;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCentralMTUs$p(ExperimentalBluetoothServer $this) {
        return $this.centralMTUs;
    }

    public static final /* synthetic */ void access$doStopAdvertising(ExperimentalBluetoothServer $this) {
        $this.doStopAdvertising();
    }

    public static final /* synthetic */ void access$setAdvertisingSet$p(ExperimentalBluetoothServer $this, AdvertisingSet advertisingSet) {
        $this.advertisingSet = advertisingSet;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Llive/ditto/transports/ble/ExperimentalBluetoothServer$Companion;", "", "()V", "OPERATION_TIMEOUT_MS", "", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public final void setTAG(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            TAG = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

