/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports.ble;

import android.bluetooth.BluetoothSocket;
import java.lang.ref.WeakReference;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.internal.swig.ffi.BluetoothLeRadioRust;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Llive/ditto/transports/ble/L2capConnection;", "", "uuidBytes", "", "socket", "Landroid/bluetooth/BluetoothSocket;", "isServer", "", "platform", "Ljava/lang/ref/WeakReference;", "Llive/ditto/internal/swig/ffi/BluetoothLeRadioRust;", "([BLandroid/bluetooth/BluetoothSocket;ZLjava/lang/ref/WeakReference;)V", "incomingChunk", "incomingData", "Ljava/util/concurrent/ArrayBlockingQueue;", "incomingThread", "Ljava/lang/Thread;", "outgoingData", "outgoingThread", "getPlatform", "()Ljava/lang/ref/WeakReference;", "stopping", "close", "", "read", "maxBytes", "", "send", "data", "Companion", "dittocpp_release"})
public final class L2capConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] uuidBytes;
    @NotNull
    private final BluetoothSocket socket;
    private final boolean isServer;
    @NotNull
    private final WeakReference<BluetoothLeRadioRust> platform;
    @NotNull
    private final ArrayBlockingQueue<byte[]> outgoingData;
    @NotNull
    private final ArrayBlockingQueue<byte[]> incomingData;
    @Nullable
    private byte[] incomingChunk;
    private boolean stopping;
    @NotNull
    private Thread outgoingThread;
    @NotNull
    private Thread incomingThread;
    @NotNull
    private static String TAG = "L2capConnection";

    public L2capConnection(@NotNull byte[] uuidBytes, @NotNull BluetoothSocket socket, boolean isServer, @NotNull WeakReference<BluetoothLeRadioRust> platform) {
        Intrinsics.checkNotNullParameter((Object)uuidBytes, (String)"uuidBytes");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter(platform, (String)"platform");
        this.uuidBytes = uuidBytes;
        this.socket = socket;
        this.isServer = isServer;
        this.platform = platform;
        this.outgoingData = new ArrayBlockingQueue(1);
        this.incomingData = new ArrayBlockingQueue(1);
        this.outgoingThread = new Thread(() -> L2capConnection.outgoingThread$lambda-1(this));
        this.incomingThread = new Thread(() -> L2capConnection.incomingThread$lambda-3(this));
        this.outgoingThread.start();
        this.incomingThread.start();
    }

    @NotNull
    public final WeakReference<BluetoothLeRadioRust> getPlatform() {
        return this.platform;
    }

    public final boolean send(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.outgoingData.offer(data);
    }

    @Nullable
    public final byte[] read(int maxBytes) {
        byte[] byArray;
        if (this.incomingChunk == null) {
            this.incomingChunk = this.incomingData.poll();
        }
        if ((byArray = this.incomingChunk) != null) {
            byte[] leftover = byArray;
            boolean bl = false;
            int len = Math.min(maxBytes, leftover.length);
            if (len == leftover.length) {
                this.incomingChunk = null;
                return leftover;
            }
            byte[] byArray2 = leftover;
            int n = 0;
            byte[] toReturn = ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)len);
            byArray2 = leftover;
            n = leftover.length;
            this.incomingChunk = ArraysKt.copyOfRange((byte[])byArray2, (int)len, (int)n);
            return toReturn;
        }
        return null;
    }

    public final void close() {
        this.stopping = true;
        this.socket.close();
        this.outgoingThread.interrupt();
        this.incomingThread.interrupt();
    }

    private static final void outgoingThread$lambda-1(L2capConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            while (!this$0.stopping) {
                BluetoothLeRadioRust it;
                byte[] data = this$0.outgoingData.take();
                this$0.socket.getOutputStream().write(data);
                if ((BluetoothLeRadioRust)this$0.platform.get() == null) continue;
                boolean bl = false;
                if (this$0.isServer) {
                    it.centralL2capReadyToSend(this$0.uuidBytes);
                    continue;
                }
                it.peripheralL2capReadyToSend(this$0.uuidBytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void incomingThread$lambda-3(L2capConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            while (!this$0.stopping) {
                BluetoothLeRadioRust it;
                byte[] buffer = new byte[1024];
                int result = this$0.socket.getInputStream().read(buffer);
                if (result == -1) {
                    return;
                }
                byte[] byArray = buffer;
                int n = 0;
                this$0.incomingData.put(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)result));
                if ((BluetoothLeRadioRust)this$0.platform.get() == null) continue;
                boolean bl = false;
                if (this$0.isServer) {
                    it.centralL2capDataAvailable(this$0.uuidBytes);
                    continue;
                }
                it.peripheralL2capDataAvailable(this$0.uuidBytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llive/ditto/transports/ble/L2capConnection$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public final void setTAG(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            TAG = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

