/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.DiscoverySession;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.PublishDiscoverySession;
import android.net.wifi.aware.WifiAwareNetworkSpecifier;
import android.net.wifi.aware.WifiAwareSession;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import live.ditto.DittoLog;
import live.ditto.internal.swig.ffi.OnlineState_t;
import live.ditto.internal.swig.ffi.TransportCondition_t;
import live.ditto.transports.PeerState;
import live.ditto.transports.WifiAwarePlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 *2\u00020\u0001:\u0004*+,-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0005J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0005H\u0007J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Llive/ditto/transports/WifiAwarePublisher;", "", "context", "Landroid/content/Context;", "hashedAppName", "", "servicePort", "", "platform", "Llive/ditto/transports/WifiAwarePlatform;", "(Landroid/content/Context;Ljava/lang/String;ILlive/ditto/transports/WifiAwarePlatform;)V", "advertisingPrefix", "aware", "Landroid/net/wifi/aware/WifiAwareSession;", "connMgr", "Landroid/net/ConnectivityManager;", "discovery", "Llive/ditto/transports/WifiAwarePublisher$PublisherDiscoveryCallback;", "globalNetworkCallback", "Llive/ditto/transports/WifiAwarePublisher$PublisherNetworkCallback;", "incoming", "Ljava/util/concurrent/ConcurrentHashMap;", "Llive/ditto/transports/WifiAwarePublisher$IncomingPeer;", "latestDisconnectTimestamp", "", "getLatestDisconnectTimestamp", "()J", "setLatestDisconnectTimestamp", "(J)V", "publisherToken", "close", "", "markPeerConnected", "announce", "resetPeer", "", "setup", "awareSession", "myAnnounce", "unregisterNetworkCallback", "callback", "Landroid/net/ConnectivityManager$NetworkCallback;", "Companion", "IncomingPeer", "PublisherDiscoveryCallback", "PublisherNetworkCallback", "dittocpp_release"})
@RequiresApi(value=29)
public final class WifiAwarePublisher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String hashedAppName;
    private final int servicePort;
    @NotNull
    private final WifiAwarePlatform platform;
    @Nullable
    private PublisherDiscoveryCallback discovery;
    @Nullable
    private WifiAwareSession aware;
    @NotNull
    private final ConcurrentHashMap<String, IncomingPeer> incoming;
    @NotNull
    private final ConnectivityManager connMgr;
    @NotNull
    private final String advertisingPrefix;
    @NotNull
    private Object publisherToken;
    @Nullable
    private PublisherNetworkCallback globalNetworkCallback;
    private long latestDisconnectTimestamp;
    @NotNull
    private static final String TAG = "WifiAwarePublisher";

    public WifiAwarePublisher(@NotNull Context context, @NotNull String hashedAppName, int servicePort, @NotNull WifiAwarePlatform platform) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hashedAppName, (String)"hashedAppName");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.context = context;
        this.hashedAppName = hashedAppName;
        this.servicePort = servicePort;
        this.platform = platform;
        this.incoming = new ConcurrentHashMap();
        Object object = this.context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connMgr = (ConnectivityManager)object;
        this.advertisingPrefix = "ditto" + this.hashedAppName + "_";
        this.publisherToken = new Object();
        this.latestDisconnectTimestamp = SystemClock.elapsedRealtime();
        DittoLog.d$default(TAG, "Init hashedAppName = " + this.hashedAppName + " servicePort = " + this.servicePort, null, 4, null);
    }

    public final long getLatestDisconnectTimestamp() {
        return this.latestDisconnectTimestamp;
    }

    public final void setLatestDisconnectTimestamp(long l) {
        this.latestDisconnectTimestamp = l;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void setup(@NotNull WifiAwareSession awareSession, @NotNull String myAnnounce) {
        Intrinsics.checkNotNullParameter((Object)awareSession, (String)"awareSession");
        Intrinsics.checkNotNullParameter((Object)myAnnounce, (String)"myAnnounce");
        String advertisingInfo = this.advertisingPrefix + myAnnounce;
        PublishConfig.Builder builder = new PublishConfig.Builder().setServiceName(this.hashedAppName);
        String string = advertisingInfo;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PublishConfig.Builder builder2 = builder.setServiceSpecificInfo(byArray).setTerminateNotificationEnabled(true);
        if (Build.VERSION.SDK_INT >= 33) {
            Characteristics characteristics = this.platform.getCharacteristics$dittocpp_release();
            boolean bl = characteristics != null ? characteristics.isInstantCommunicationModeSupported() : false;
            if (bl) {
                builder2 = builder2.setInstantCommunicationModeEnabled(true, 2);
            }
        }
        PublishConfig config = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
        PublisherDiscoveryCallback disc = new PublisherDiscoveryCallback(awareSession, config, myAnnounce);
        awareSession.publish(config, (DiscoverySessionCallback)disc, null);
        this.discovery = disc;
        this.aware = awareSession;
    }

    public final void close() {
        new Handler(this.context.getMainLooper()).removeCallbacksAndMessages(this.publisherToken);
        Map $this$forEach$iv = this.incoming;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.resetPeer((String)it.getKey());
        }
        try {
            PublisherDiscoveryCallback publisherDiscoveryCallback = this.discovery;
            if (publisherDiscoveryCallback != null) {
                publisherDiscoveryCallback.close();
            }
        }
        catch (Exception e) {
            DittoLog.e$default(TAG, "Exceptiong while closing discovery session", null, 4, null);
            DittoLog.e$default(TAG, e, null, 4, null);
        }
        this.platform.serverAdvertisingStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
    }

    private final void unregisterNetworkCallback(ConnectivityManager.NetworkCallback callback) {
        try {
            this.connMgr.unregisterNetworkCallback(callback);
        }
        catch (Exception e) {
            DittoLog.w$default(TAG, "Callback already unregistered.", null, 4, null);
        }
    }

    public final void markPeerConnected(@NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        DittoLog.d$default(TAG, "markPeerConnected(" + announce + ")", null, 4, null);
        this.platform.updatePeerState(announce, PeerState.PublishNetworkConnected);
    }

    public final boolean resetPeer(@NotNull String announce) {
        IncomingPeer removed;
        IncomingPeer incomingPeer;
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        DittoLog.d$default(TAG, "resetPeer(" + announce + ")", null, 4, null);
        PeerState currentPeerState = this.platform.getPeerState(announce);
        IncomingPeer incomingPeer2 = this.incoming.remove(announce);
        if (incomingPeer2 != null) {
            IncomingPeer incomingPeer3;
            IncomingPeer peer = incomingPeer3 = incomingPeer2;
            boolean bl = false;
            DittoLog.d$default(TAG, "resetPeer(" + announce + "): clearing callback", null, 4, null);
            this.unregisterNetworkCallback(peer.getCallback());
            incomingPeer = incomingPeer3;
        } else {
            incomingPeer = removed = null;
        }
        if (currentPeerState.isPublisherSpecific()) {
            if (currentPeerState == PeerState.PublishNetworkConnected) {
                this.latestDisconnectTimestamp = SystemClock.elapsedRealtime();
            }
            this.platform.updatePeerState(announce, PeerState.Idle);
        } else {
            DittoLog.i$default(TAG, "resetPeer(" + announce + "): PeerState not changed since it's set to " + currentPeerState.name() + ".", null, 4, null);
        }
        return removed != null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/ditto/transports/WifiAwarePublisher$Companion;", "", "()V", "TAG", "", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llive/ditto/transports/WifiAwarePublisher$IncomingPeer;", "", "callback", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Landroid/net/ConnectivityManager$NetworkCallback;)V", "getCallback", "()Landroid/net/ConnectivityManager$NetworkCallback;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dittocpp_release"})
    public static final class IncomingPeer {
        @NotNull
        private final ConnectivityManager.NetworkCallback callback;

        public IncomingPeer(@NotNull ConnectivityManager.NetworkCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.callback = callback;
        }

        @NotNull
        public final ConnectivityManager.NetworkCallback getCallback() {
            return this.callback;
        }

        @NotNull
        public final ConnectivityManager.NetworkCallback component1() {
            return this.callback;
        }

        @NotNull
        public final IncomingPeer copy(@NotNull ConnectivityManager.NetworkCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            return new IncomingPeer(callback);
        }

        public static /* synthetic */ IncomingPeer copy$default(IncomingPeer incomingPeer, ConnectivityManager.NetworkCallback networkCallback, int n, Object object) {
            if ((n & 1) != 0) {
                networkCallback = incomingPeer.callback;
            }
            return incomingPeer.copy(networkCallback);
        }

        @NotNull
        public String toString() {
            return "IncomingPeer(callback=" + this.callback + ")";
        }

        public int hashCode() {
            return this.callback.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncomingPeer)) {
                return false;
            }
            IncomingPeer incomingPeer = (IncomingPeer)other;
            return Intrinsics.areEqual((Object)this.callback, (Object)incomingPeer.callback);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0017J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\"\u0010 \u001a\b\u0018\u00010!R\u00020\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010#\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Llive/ditto/transports/WifiAwarePublisher$PublisherDiscoveryCallback;", "Landroid/net/wifi/aware/DiscoverySessionCallback;", "awareSession", "Landroid/net/wifi/aware/WifiAwareSession;", "config", "Landroid/net/wifi/aware/PublishConfig;", "myAnnounce", "", "(Llive/ditto/transports/WifiAwarePublisher;Landroid/net/wifi/aware/WifiAwareSession;Landroid/net/wifi/aware/PublishConfig;Ljava/lang/String;)V", "publishSession", "Landroid/net/wifi/aware/PublishDiscoverySession;", "getPublishSession", "()Landroid/net/wifi/aware/PublishDiscoverySession;", "setPublishSession", "(Landroid/net/wifi/aware/PublishDiscoverySession;)V", "close", "", "onMessageReceived", "peerHandle", "Landroid/net/wifi/aware/PeerHandle;", "message", "", "onMessageSendFailed", "messageId", "", "onMessageSendSucceeded", "onPublishStarted", "session", "onServiceLost", "reason", "onSessionConfigFailed", "onSessionTerminated", "requestNetwork", "Llive/ditto/transports/WifiAwarePublisher$PublisherNetworkCallback;", "Llive/ditto/transports/WifiAwarePublisher;", "announce", "dittocpp_release"})
    public final class PublisherDiscoveryCallback
    extends DiscoverySessionCallback {
        @NotNull
        private final WifiAwareSession awareSession;
        @NotNull
        private final PublishConfig config;
        @NotNull
        private final String myAnnounce;
        @Nullable
        private PublishDiscoverySession publishSession;

        public PublisherDiscoveryCallback(@NotNull WifiAwareSession awareSession, @NotNull PublishConfig config, String myAnnounce) {
            Intrinsics.checkNotNullParameter((Object)awareSession, (String)"awareSession");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)myAnnounce, (String)"myAnnounce");
            this.awareSession = awareSession;
            this.config = config;
            this.myAnnounce = myAnnounce;
        }

        @Nullable
        public final PublishDiscoverySession getPublishSession() {
            return this.publishSession;
        }

        public final void setPublishSession(@Nullable PublishDiscoverySession publishDiscoverySession) {
            this.publishSession = publishDiscoverySession;
        }

        public final void close() {
            PublishDiscoverySession publishDiscoverySession = this.publishSession;
            if (publishDiscoverySession != null) {
                publishDiscoverySession.close();
            }
            this.publishSession = null;
        }

        private final PublisherNetworkCallback requestNetwork(PeerHandle peerHandle, String announce) {
            WifiAwareNetworkSpecifier.Builder builder;
            PublishDiscoverySession publishDiscoverySession = this.publishSession;
            if (publishDiscoverySession == null) {
                PublisherDiscoveryCallback $this$requestNetwork_u24lambda_u2d0 = this;
                boolean bl = false;
                DittoLog.w$default(WifiAwarePublisher.TAG, "publish session null", null, 4, null);
                return null;
            }
            PublishDiscoverySession localPublishSession = publishDiscoverySession;
            if (peerHandle != null) {
                builder = new WifiAwareNetworkSpecifier.Builder((DiscoverySession)localPublishSession, peerHandle);
            } else if (Build.VERSION.SDK_INT >= 31) {
                builder = new WifiAwareNetworkSpecifier.Builder(localPublishSession);
            } else {
                DittoLog.e$default(WifiAwarePublisher.TAG, "Requested global network with too low of an Android version", null, 4, null);
                return null;
            }
            WifiAwareNetworkSpecifier.Builder builder2 = builder;
            WifiAwareNetworkSpecifier wifiAwareNetworkSpecifier = builder2.setPskPassphrase("dittoditto").setPort(WifiAwarePublisher.this.servicePort).build();
            Intrinsics.checkNotNullExpressionValue((Object)wifiAwareNetworkSpecifier, (String)"builder\n                \u2026\n                .build()");
            WifiAwareNetworkSpecifier networkSpecifier = wifiAwareNetworkSpecifier;
            NetworkRequest myNetworkRequest = new NetworkRequest.Builder().addTransportType(5).setNetworkSpecifier((NetworkSpecifier)networkSpecifier).build();
            PublisherNetworkCallback callback = new PublisherNetworkCallback(peerHandle, announce);
            DittoLog.d$default(WifiAwarePublisher.TAG, "Requesting network \"" + this.myAnnounce + "\" (peer handle: " + peerHandle + ")", null, 4, null);
            try {
                WifiAwarePublisher.this.connMgr.requestNetwork(myNetworkRequest, (ConnectivityManager.NetworkCallback)callback);
            }
            catch (Exception e) {
                WifiAwarePublisher.this.connMgr.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)callback);
                DittoLog.e$default(WifiAwarePublisher.TAG, "Caught an exception when requesting a network, could indicate a leak in registered callbacks.", null, 4, null);
                DittoLog.e$default(WifiAwarePublisher.TAG, e, null, 4, null);
                return null;
            }
            return callback;
        }

        public void onPublishStarted(@NotNull PublishDiscoverySession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            DittoLog.i$default(WifiAwarePublisher.TAG, "onPublishStarted(session)", null, 4, null);
            WifiAwarePublisher.this.platform.serverAdvertisingStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
            this.publishSession = session;
        }

        public void onMessageReceived(@NotNull PeerHandle peerHandle, @NotNull byte[] message) {
            Intrinsics.checkNotNullParameter((Object)peerHandle, (String)"peerHandle");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String m = new String(message, Charsets.UTF_8);
            DittoLog.d$default(WifiAwarePublisher.TAG, "onMessageReceived(\"" + m + "\", " + peerHandle + ")", null, 4, null);
            PublishDiscoverySession publishDiscoverySession = this.publishSession;
            if (publishDiscoverySession == null) {
                PublisherDiscoveryCallback $this$onMessageReceived_u24lambda_u2d1 = this;
                boolean bl = false;
                DittoLog.w$default(WifiAwarePublisher.TAG, "publish session null", null, 4, null);
                return;
            }
            PublishDiscoverySession localPublishSession = publishDiscoverySession;
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)m, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                return;
            }
            if (Intrinsics.areEqual(parts.get(0), (Object)"connect")) {
                String announce = (String)parts.get(1);
                if (((CharSequence)announce).length() == 0) {
                    return;
                }
                PeerState peerState = WifiAwarePublisher.this.platform.getPeerState(announce);
                if (peerState == PeerState.WaitingForConnection) {
                    DittoLog.d$default(WifiAwarePublisher.TAG, "already holding the incoming connection for " + announce + ", re-sending ready message.", null, 4, null);
                    try {
                        String bl = "ready." + this.myAnnounce;
                        byte[] byArray = bl.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        localPublishSession.sendMessage(peerHandle, 0, byArray);
                    }
                    catch (Exception e) {
                        DittoLog.e$default(WifiAwarePublisher.TAG, "Exception while trying to send message.", null, 4, null);
                        DittoLog.e$default(WifiAwarePublisher.TAG, e, null, 4, null);
                    }
                    return;
                }
                if (peerState.isNetworkReserved()) {
                    DittoLog.d$default(WifiAwarePublisher.TAG, "Peer " + announce + " already connected or connecting. Skipping. (State: " + peerState.name() + ")", null, 4, null);
                    return;
                }
                WifiAwarePublisher.this.platform.updatePeerState(announce, PeerState.WaitingForConnection);
                if (Build.VERSION.SDK_INT >= 31 && WifiAwarePublisher.this.globalNetworkCallback == null) {
                    DittoLog.i$default(WifiAwarePublisher.TAG, "Requesting global network, as one doesn't currently exist.", null, 4, null);
                    WifiAwarePublisher.this.globalNetworkCallback = this.requestNetwork(null, null);
                }
                if (Build.VERSION.SDK_INT < 31) {
                    DittoLog.i$default(WifiAwarePublisher.TAG, "Requesting peer network (their announce: " + announce + ", peerHandle: " + peerHandle + ")", null, 4, null);
                    PublisherNetworkCallback callback = this.requestNetwork(peerHandle, announce);
                    if (callback != null) {
                        ((Map)WifiAwarePublisher.this.incoming).put(announce, new IncomingPeer(callback));
                    } else {
                        WifiAwarePublisher.this.resetPeer(announce);
                    }
                    DittoLog.d$default(WifiAwarePublisher.TAG, "Current incoming: " + WifiAwarePublisher.this.incoming.size(), null, 4, null);
                } else {
                    DittoLog.d$default(WifiAwarePublisher.TAG, "Global network exists, not requesting specific peer network.", null, 4, null);
                }
                String readyMessage = "ready." + this.myAnnounce;
                DittoLog.d$default(WifiAwarePublisher.TAG, "Sending message " + readyMessage, null, 4, null);
                try {
                    PublishDiscoverySession publishDiscoverySession2 = this.publishSession;
                    if (publishDiscoverySession2 != null) {
                        String string = readyMessage;
                        byte[] byArray = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        publishDiscoverySession2.sendMessage(peerHandle, 0, byArray);
                    }
                }
                catch (Exception e) {
                    DittoLog.e$default(WifiAwarePublisher.TAG, "Exception while trying to send message.", null, 4, null);
                    DittoLog.e$default(WifiAwarePublisher.TAG, e, null, 4, null);
                }
                new Handler(WifiAwarePublisher.this.context.getMainLooper()).postDelayed(() -> PublisherDiscoveryCallback.onMessageReceived$lambda-2(WifiAwarePublisher.this, announce), WifiAwarePublisher.this.publisherToken, 5000L + ThreadLocalRandom.current().nextLong(0L, 2000L));
            }
        }

        public void onServiceLost(@NotNull PeerHandle peerHandle, int reason) {
            Intrinsics.checkNotNullParameter((Object)peerHandle, (String)"peerHandle");
            DittoLog.w$default(WifiAwarePublisher.TAG, "onServiceLost, reason: " + reason, null, 4, null);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onSessionConfigFailed() {
            DittoLog.e$default(WifiAwarePublisher.TAG, "onSessionConfigFailed", null, 4, null);
            PublisherDiscoveryCallback publisherDiscoveryCallback = WifiAwarePublisher.this.discovery;
            if (publisherDiscoveryCallback == null) {
                PublisherDiscoveryCallback $this$onSessionConfigFailed_u24lambda_u2d3 = this;
                boolean bl = false;
                DittoLog.w$default(WifiAwarePublisher.TAG, "discovery callback null", null, 4, null);
                return;
            }
            PublisherDiscoveryCallback discoveryCallback = publisherDiscoveryCallback;
            WifiAwarePublisher.this.platform.serverAdvertisingStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_GENERIC_FAILURE);
            WifiAwarePublisher.this.platform.queueDelayedReset();
        }

        public void onSessionTerminated() {
            WifiAwarePublisher.this.platform.serverAdvertisingStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
            DittoLog.w$default(WifiAwarePublisher.TAG, "onSessionTerminated", null, 4, null);
        }

        public void onMessageSendSucceeded(int messageId) {
            DittoLog.d$default(WifiAwarePublisher.TAG, "onMessageSendSucceeded (messageId: " + messageId + ")", null, 4, null);
        }

        public void onMessageSendFailed(int messageId) {
            DittoLog.w$default(WifiAwarePublisher.TAG, "onMessageSendFailed (messageId: " + messageId + ")", null, 4, null);
        }

        private static final void onMessageReceived$lambda-2(WifiAwarePublisher this$0, String $announce) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$announce, (String)"$announce");
            if (this$0.platform.getPeerState($announce) != PeerState.PublishNetworkConnected && this$0.resetPeer($announce)) {
                DittoLog.d$default(WifiAwarePublisher.TAG, "Timing out incoming connection attempt (announce " + $announce + ")", null, 4, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Llive/ditto/transports/WifiAwarePublisher$PublisherNetworkCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "peerHandle", "Landroid/net/wifi/aware/PeerHandle;", "announce", "", "(Llive/ditto/transports/WifiAwarePublisher;Landroid/net/wifi/aware/PeerHandle;Ljava/lang/String;)V", "onAvailable", "", "network", "Landroid/net/Network;", "onBlockedStatusChanged", "blocked", "", "onCapabilitiesChanged", "networkCapabilities", "Landroid/net/NetworkCapabilities;", "onLinkPropertiesChanged", "linkProperties", "Landroid/net/LinkProperties;", "onLosing", "maxMsToLive", "", "onLost", "onUnavailable", "dittocpp_release"})
    public final class PublisherNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        @Nullable
        private final PeerHandle peerHandle;
        @Nullable
        private final String announce;

        public PublisherNetworkCallback(@Nullable PeerHandle peerHandle, String announce) {
            this.peerHandle = peerHandle;
            this.announce = announce;
        }

        public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
            DittoLog.d$default(WifiAwarePublisher.TAG, "Network onCapabilitiesChanged " + networkCapabilities + " (announce: " + this.announce + ", peerHandle: " + this.peerHandle + ")", null, 4, null);
        }

        public void onAvailable(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DittoLog.i$default(WifiAwarePublisher.TAG, "Network onAvailable (announce: " + this.announce + ", peerHandle: " + this.peerHandle + ")", null, 4, null);
        }

        public void onUnavailable() {
            DittoLog.w$default(WifiAwarePublisher.TAG, "Network onUnavailable (announce: " + this.announce + ", peerHandle: " + this.peerHandle + ")", null, 4, null);
            if (this.announce != null) {
                WifiAwarePublisher.this.resetPeer(this.announce);
            } else {
                WifiAwarePublisher.this.unregisterNetworkCallback(this);
                WifiAwarePublisher.this.globalNetworkCallback = null;
            }
        }

        public void onLost(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DittoLog.w$default(WifiAwarePublisher.TAG, "Network onLost (announce: " + this.announce + ", peerHandle: " + this.peerHandle + ")", null, 4, null);
            if (this.announce != null) {
                WifiAwarePublisher.this.resetPeer(this.announce);
            } else {
                WifiAwarePublisher.this.unregisterNetworkCallback(this);
                WifiAwarePublisher.this.globalNetworkCallback = null;
            }
        }

        public void onBlockedStatusChanged(@NotNull Network network, boolean blocked) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DittoLog.d$default(WifiAwarePublisher.TAG, "Network onBlockedStatusChanged (announce: " + this.announce + ", peerHandle: " + this.peerHandle + ")", null, 4, null);
        }

        public void onLinkPropertiesChanged(@NotNull Network network, @NotNull LinkProperties linkProperties) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter((Object)linkProperties, (String)"linkProperties");
            DittoLog.d$default(WifiAwarePublisher.TAG, "Network onLinkPropertiesChanged (announce: " + this.announce + ", peerHandle: " + this.peerHandle + ")", null, 4, null);
        }

        public void onLosing(@NotNull Network network, int maxMsToLive) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            DittoLog.w$default(WifiAwarePublisher.TAG, "Network onLosing (announce: " + this.announce + ", peerHandle: " + this.peerHandle + ")", null, 4, null);
        }
    }
}

