/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports.ble;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattService;
import android.os.Build;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001aP\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015*\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u00162\b\u0010\u0017\u001a\u0004\b\u0002H\u00142\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\u00150\u0019\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u001a\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u00020\u001c*\u00020!2\u0006\u0010\"\u001a\u00020\u001f\u001a\u0014\u0010#\u001a\u0004\u0018\u00010!*\u00020$2\u0006\u0010%\u001a\u00020\u0001\u001a\u0014\u0010&\u001a\u0004\u0018\u00010\u001d*\u00020$2\u0006\u0010%\u001a\u00020\u0001\u001a\n\u0010'\u001a\u00020\u001c*\u00020\u001d\u001a\n\u0010(\u001a\u00020\u001c*\u00020!\u001a\n\u0010)\u001a\u00020\u001c*\u00020!\u001a\n\u0010*\u001a\u00020\u001c*\u00020!\u001a\n\u0010*\u001a\u00020\u001c*\u00020\u001d\u001a\n\u0010+\u001a\u00020\u001c*\u00020!\u001a\n\u0010+\u001a\u00020\u001c*\u00020\u001d\u001a\n\u0010,\u001a\u00020\u001c*\u00020!\u001a,\u0010-\u001a\u00020\u001f*\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0007\u001a\n\u00105\u001a\u000206*\u00020\u001d\u001a*\u00107\u001a\u00020\u0013\"\u0004\b\u0000\u00108*\b\u0012\u0004\u0012\u0002H8092\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u00020\u001c0;\u001a\n\u0010<\u001a\u000204*\u000206\u001a\n\u0010=\u001a\u000206*\u000204\u001a\n\u0010>\u001a\u00020\u0001*\u000204\u001a\n\u0010>\u001a\u00020\u0001*\u000206\u001a$\u0010?\u001a\u00020\u001f*\u00020$2\u0006\u00101\u001a\u00020!2\u0006\u0010@\u001a\u0002042\u0006\u0010A\u001a\u00020\u001fH\u0007\u001a\u001c\u0010B\u001a\u00020\u001f*\u00020$2\u0006\u0010C\u001a\u00020\u001d2\u0006\u0010@\u001a\u000204H\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\"\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0003\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006D"}, d2={"CCC_DESCRIPTOR_UUID", "Ljava/util/UUID;", "getCCC_DESCRIPTOR_UUID", "()Ljava/util/UUID;", "CHAR_UUID_ANNOUNCE", "getCHAR_UUID_ANNOUNCE", "CHAR_UUID_CONTROL_READ", "getCHAR_UUID_CONTROL_READ", "CHAR_UUID_CONTROL_WRITE", "getCHAR_UUID_CONTROL_WRITE", "CHAR_UUID_PSM", "getCHAR_UUID_PSM", "CHAR_UUID_READ", "getCHAR_UUID_READ", "CHAR_UUID_WRITE", "getCHAR_UUID_WRITE", "WRITE_DELAY_MS", "", "computeIfPresentCompat", "", "K", "V", "Ljava/util/concurrent/ConcurrentHashMap;", "key", "computation", "Lkotlin/Function2;", "(Ljava/util/concurrent/ConcurrentHashMap;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "containsPermission", "", "Landroid/bluetooth/BluetoothGattDescriptor;", "permission", "", "containsProperty", "Landroid/bluetooth/BluetoothGattCharacteristic;", "property", "findCharacteristic", "Landroid/bluetooth/BluetoothGatt;", "uuid", "findDescriptor", "isCccd", "isIndicatable", "isNotifiable", "isReadable", "isWritable", "isWritableWithoutResponse", "notifyCharacteristicChangedCompat", "Landroid/bluetooth/BluetoothGattServer;", "device", "Landroid/bluetooth/BluetoothDevice;", "characteristic", "confirm", "value", "", "printProperties", "", "removeIfCompat", "E", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "filter", "Lkotlin/Function1;", "toAddressBytes", "toAddressString", "toUuid", "writeCharacteristicCompat", "payload", "writeType", "writeDescriptorCompat", "descriptor", "dittocpp_release"})
public final class BleExtensionsKt {
    @NotNull
    private static final UUID CCC_DESCRIPTOR_UUID = BleExtensionsKt.toUuid("00002902-0000-1000-8000-00805F9B34FB");
    @NotNull
    private static final UUID CHAR_UUID_WRITE = BleExtensionsKt.toUuid("21098FDF-EEBF-4A35-8A90-FA7E31F54635");
    @NotNull
    private static final UUID CHAR_UUID_CONTROL_WRITE = BleExtensionsKt.toUuid("CA1E82B6-749A-4ED1-A3E4-75E587CA58BE");
    @NotNull
    private static final UUID CHAR_UUID_READ = BleExtensionsKt.toUuid("95F293B1-1923-470F-B8EB-7612679B1EDF");
    @NotNull
    private static final UUID CHAR_UUID_CONTROL_READ = BleExtensionsKt.toUuid("4C5B8FF9-AF58-41E2-A705-43E6250D8903");
    @NotNull
    private static final UUID CHAR_UUID_ANNOUNCE = BleExtensionsKt.toUuid("B69BEE36-D205-48FC-9D71-7DACD797BB7A");
    @NotNull
    private static final UUID CHAR_UUID_PSM = BleExtensionsKt.toUuid("0FE9EE12-1604-4FA7-938A-7C3AD185B6F6");
    public static final long WRITE_DELAY_MS = 5L;

    @NotNull
    public static final UUID getCCC_DESCRIPTOR_UUID() {
        return CCC_DESCRIPTOR_UUID;
    }

    @NotNull
    public static final UUID getCHAR_UUID_WRITE() {
        return CHAR_UUID_WRITE;
    }

    @NotNull
    public static final UUID getCHAR_UUID_CONTROL_WRITE() {
        return CHAR_UUID_CONTROL_WRITE;
    }

    @NotNull
    public static final UUID getCHAR_UUID_READ() {
        return CHAR_UUID_READ;
    }

    @NotNull
    public static final UUID getCHAR_UUID_CONTROL_READ() {
        return CHAR_UUID_CONTROL_READ;
    }

    @NotNull
    public static final UUID getCHAR_UUID_ANNOUNCE() {
        return CHAR_UUID_ANNOUNCE;
    }

    @NotNull
    public static final UUID getCHAR_UUID_PSM() {
        return CHAR_UUID_PSM;
    }

    @Nullable
    public static final BluetoothGattCharacteristic findCharacteristic(@NotNull BluetoothGatt $this$findCharacteristic, @NotNull UUID uuid) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$findCharacteristic, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            List list = $this$findCharacteristic.getServices();
            if (list == null) break block3;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                Object v1;
                block2: {
                    BluetoothGattService service = (BluetoothGattService)element$iv;
                    boolean bl = false;
                    List list2 = service.getCharacteristics();
                    if (list2 == null) continue;
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        BluetoothGattCharacteristic characteristic = (BluetoothGattCharacteristic)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)uuid)) continue;
                        v1 = element$iv2;
                        break block2;
                    }
                    v1 = null;
                }
                if ((bluetoothGattCharacteristic = (BluetoothGattCharacteristic)v1) == null) continue;
                BluetoothGattCharacteristic matchingCharacteristic = bluetoothGattCharacteristic;
                boolean bl = false;
                return matchingCharacteristic;
            }
        }
        return null;
    }

    @Nullable
    public static final BluetoothGattDescriptor findDescriptor(@NotNull BluetoothGatt $this$findDescriptor, @NotNull UUID uuid) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$findDescriptor, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            List list = $this$findDescriptor.getServices();
            if (list == null) break block4;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothGattService service = (BluetoothGattService)element$iv;
                boolean bl = false;
                List list2 = service.getCharacteristics();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"service.characteristics");
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    BluetoothGattDescriptor bluetoothGattDescriptor;
                    Object v2;
                    block3: {
                        BluetoothGattCharacteristic characteristic = (BluetoothGattCharacteristic)element$iv2;
                        boolean bl2 = false;
                        List list3 = characteristic.getDescriptors();
                        if (list3 == null) continue;
                        Iterable $this$firstOrNull$iv = list3;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv3 : $this$firstOrNull$iv) {
                            BluetoothGattDescriptor descriptor = (BluetoothGattDescriptor)element$iv3;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)descriptor.getUuid(), (Object)uuid)) continue;
                            v2 = element$iv3;
                            break block3;
                        }
                        v2 = null;
                    }
                    if ((bluetoothGattDescriptor = (BluetoothGattDescriptor)v2) == null) continue;
                    BluetoothGattDescriptor matchingDescriptor = bluetoothGattDescriptor;
                    boolean bl4 = false;
                    return matchingDescriptor;
                }
            }
        }
        return null;
    }

    @SuppressLint(value={"MissingPermission"})
    public static final int writeCharacteristicCompat(@NotNull BluetoothGatt $this$writeCharacteristicCompat, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] payload, int writeType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$writeCharacteristicCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        characteristic.setWriteType(writeType);
        if (Build.VERSION.SDK_INT >= 33) {
            n = $this$writeCharacteristicCompat.writeCharacteristic(characteristic, payload, writeType);
        } else {
            characteristic.setValue(payload);
            n = $this$writeCharacteristicCompat.writeCharacteristic(characteristic) ? 0 : Integer.MAX_VALUE;
        }
        return n;
    }

    @SuppressLint(value={"MissingPermission"})
    public static final int writeDescriptorCompat(@NotNull BluetoothGatt $this$writeDescriptorCompat, @NotNull BluetoothGattDescriptor descriptor, @NotNull byte[] payload) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$writeDescriptorCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (Build.VERSION.SDK_INT >= 33) {
            n = $this$writeDescriptorCompat.writeDescriptor(descriptor, payload);
        } else {
            descriptor.setValue(payload);
            n = $this$writeDescriptorCompat.writeDescriptor(descriptor) ? 0 : Integer.MAX_VALUE;
        }
        return n;
    }

    @SuppressLint(value={"MissingPermission"})
    public static final int notifyCharacteristicChangedCompat(@NotNull BluetoothGattServer $this$notifyCharacteristicChangedCompat, @NotNull BluetoothDevice device, @NotNull BluetoothGattCharacteristic characteristic, boolean confirm, @NotNull byte[] value) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$notifyCharacteristicChangedCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Build.VERSION.SDK_INT >= 33) {
            n = $this$notifyCharacteristicChangedCompat.notifyCharacteristicChanged(device, characteristic, confirm, value);
        } else {
            characteristic.setValue(value);
            n = $this$notifyCharacteristicChangedCompat.notifyCharacteristicChanged(device, characteristic, confirm) ? 0 : Integer.MAX_VALUE;
        }
        return n;
    }

    public static final boolean isReadable(@NotNull BluetoothGattCharacteristic $this$isReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$isReadable, (String)"<this>");
        return BleExtensionsKt.containsProperty($this$isReadable, 2);
    }

    public static final boolean isWritable(@NotNull BluetoothGattCharacteristic $this$isWritable) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"<this>");
        return BleExtensionsKt.containsProperty($this$isWritable, 8);
    }

    public static final boolean isWritableWithoutResponse(@NotNull BluetoothGattCharacteristic $this$isWritableWithoutResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritableWithoutResponse, (String)"<this>");
        return BleExtensionsKt.containsProperty($this$isWritableWithoutResponse, 4);
    }

    public static final boolean isIndicatable(@NotNull BluetoothGattCharacteristic $this$isIndicatable) {
        Intrinsics.checkNotNullParameter((Object)$this$isIndicatable, (String)"<this>");
        return BleExtensionsKt.containsProperty($this$isIndicatable, 32);
    }

    public static final boolean isNotifiable(@NotNull BluetoothGattCharacteristic $this$isNotifiable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotifiable, (String)"<this>");
        return BleExtensionsKt.containsProperty($this$isNotifiable, 16);
    }

    public static final boolean containsProperty(@NotNull BluetoothGattCharacteristic $this$containsProperty, int property) {
        Intrinsics.checkNotNullParameter((Object)$this$containsProperty, (String)"<this>");
        return ($this$containsProperty.getProperties() & property) != 0;
    }

    @NotNull
    public static final String printProperties(@NotNull BluetoothGattDescriptor $this$printProperties) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$printProperties, (String)"<this>");
        List $this$printProperties_u24lambda_u2d7 = list = (List)new ArrayList();
        boolean bl = false;
        if (BleExtensionsKt.isReadable($this$printProperties)) {
            $this$printProperties_u24lambda_u2d7.add("READABLE");
        }
        if (BleExtensionsKt.isWritable($this$printProperties)) {
            $this$printProperties_u24lambda_u2d7.add("WRITABLE");
        }
        if ($this$printProperties_u24lambda_u2d7.isEmpty()) {
            $this$printProperties_u24lambda_u2d7.add("EMPTY");
        }
        return CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
    }

    public static final boolean isReadable(@NotNull BluetoothGattDescriptor $this$isReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$isReadable, (String)"<this>");
        return BleExtensionsKt.containsPermission($this$isReadable, 1);
    }

    public static final boolean isWritable(@NotNull BluetoothGattDescriptor $this$isWritable) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"<this>");
        return BleExtensionsKt.containsPermission($this$isWritable, 16);
    }

    public static final boolean containsPermission(@NotNull BluetoothGattDescriptor $this$containsPermission, int permission) {
        Intrinsics.checkNotNullParameter((Object)$this$containsPermission, (String)"<this>");
        return ($this$containsPermission.getPermissions() & permission) != 0;
    }

    public static final boolean isCccd(@NotNull BluetoothGattDescriptor $this$isCccd) {
        Intrinsics.checkNotNullParameter((Object)$this$isCccd, (String)"<this>");
        return StringsKt.equals((String)$this$isCccd.getUuid().toString(), (String)CCC_DESCRIPTOR_UUID.toString(), (boolean)true);
    }

    @NotNull
    public static final UUID toUuid(@NotNull byte[] $this$toUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$toUuid, (String)"<this>");
        ByteBuffer bb = ByteBuffer.wrap($this$toUuid);
        return new UUID(bb.getLong(), bb.getLong());
    }

    @NotNull
    public static final String toAddressString(@NotNull byte[] $this$toAddressString) {
        Intrinsics.checkNotNullParameter((Object)$this$toAddressString, (String)"<this>");
        String string = "%02X:%02X:%02X:%02X:%02X:%02X";
        Object[] objectArray = new Object[]{$this$toAddressString[0], $this$toAddressString[1], $this$toAddressString[2], $this$toAddressString[3], $this$toAddressString[4], $this$toAddressString[5]};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @NotNull
    public static final byte[] toAddressBytes(@NotNull String $this$toAddressBytes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toAddressBytes, (String)"<this>");
        CharSequence charSequence = $this$toAddressBytes;
        Regex regex = new Regex(":");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray;
        byte[] uuid = new byte[16];
        for (int i = 0; i < 16; ++i) {
            if (i > 5) {
                uuid[i] = 0;
                continue;
            }
            int hex = Integer.parseInt(parts[i], 16);
            uuid[i] = (byte)hex;
        }
        return uuid;
    }

    @NotNull
    public static final UUID toUuid(@NotNull String $this$toUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$toUuid, (String)"<this>");
        UUID uUID = UUID.fromString($this$toUuid);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(this)");
        return uUID;
    }

    public static final <E> void removeIfCompat(@NotNull ConcurrentLinkedQueue<E> $this$removeIfCompat, @NotNull Function1<? super E, Boolean> filter) {
        Intrinsics.checkNotNullParameter($this$removeIfCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        if (Build.VERSION.SDK_INT >= 24) {
            $this$removeIfCompat.removeIf(arg_0 -> BleExtensionsKt.removeIfCompat$lambda-9(filter, arg_0));
        } else {
            for (Object object : $this$removeIfCompat) {
                if (!((Boolean)filter.invoke(object)).booleanValue()) continue;
                $this$removeIfCompat.remove(object);
            }
        }
    }

    public static final <K, V> void computeIfPresentCompat(@NotNull ConcurrentHashMap<K, V> $this$computeIfPresentCompat, @NotNull K key, @NotNull Function2<? super K, ? super V, ? extends V> computation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$computeIfPresentCompat, (String)"<this>");
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter(computation, (String)"computation");
                if (Build.VERSION.SDK_INT < 24) break block2;
                $this$computeIfPresentCompat.computeIfPresent(key, (arg_0, arg_1) -> BleExtensionsKt.computeIfPresentCompat$lambda-10(computation, arg_0, arg_1));
                break block3;
            }
            V v = $this$computeIfPresentCompat.get(key);
            if (v == null) break block3;
            V value = v;
            boolean bl = false;
            Object computed = computation.invoke(key, value);
            if (computed == null) {
                $this$computeIfPresentCompat.remove(key);
            } else {
                ((Map)$this$computeIfPresentCompat).put(key, computed);
            }
        }
    }

    private static final boolean removeIfCompat$lambda-9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object computeIfPresentCompat$lambda-10(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0, p1);
    }
}

