/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports.ble;

import android.os.Handler;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoLog;
import live.ditto.transports.ble.CommandQueueCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001dB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0006\u0010\u0016\u001a\u00020\u0014J\u0013\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Llive/ditto/transports/ble/CommandQueue;", "T", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "handler", "Landroid/os/Handler;", "callbacks", "Llive/ditto/transports/ble/CommandQueueCallback;", "operationTimeout", "", "(Landroid/os/Handler;Llive/ditto/transports/ble/CommandQueueCallback;J)V", "operationTimeoutRunnable", "Ljava/lang/Runnable;", "pendingOperation", "getPendingOperation", "()Ljava/lang/Object;", "setPendingOperation", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "pendingOperationStart", "clear", "", "clearOperationTimer", "completePendingCommand", "enqueueCommand", "operation", "runNextOperation", "startOperationTimer", "toString", "", "Companion", "dittocpp_release"})
public final class CommandQueue<T>
extends ConcurrentLinkedQueue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Handler handler;
    @NotNull
    private final CommandQueueCallback<T> callbacks;
    private final long operationTimeout;
    @Nullable
    private volatile T pendingOperation;
    private volatile long pendingOperationStart;
    @Nullable
    private volatile Runnable operationTimeoutRunnable;
    @NotNull
    public static final String TAG = "CommandQueue";

    public CommandQueue(@NotNull Handler handler, @NotNull CommandQueueCallback<T> callbacks, long operationTimeout) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        this.handler = handler;
        this.callbacks = callbacks;
        this.operationTimeout = operationTimeout;
    }

    @Nullable
    public final T getPendingOperation() {
        return this.pendingOperation;
    }

    public final void setPendingOperation(@Nullable T t) {
        this.pendingOperation = t;
    }

    public final synchronized void enqueueCommand(T operation) {
        DittoLog.v$default(TAG, "Enqueueing " + operation + ". Pending op: " + this.pendingOperation, null, 4, null);
        this.add(operation);
        this.handler.post(() -> CommandQueue.enqueueCommand$lambda-0(this));
    }

    private final void runNextOperation() {
        if (this.pendingOperation != null) {
            DittoLog.e$default(TAG, "runNextOperation() called when an operation is pending! Aborting. Pending: " + this.pendingOperation + ", expected next: " + this.peek(), null, 4, null);
            return;
        }
        Object e = this.poll();
        if (e == null) {
            CommandQueue $this$runNextOperation_u24lambda_u2d1 = this;
            boolean bl = false;
            DittoLog.v$default(TAG, "Operation queue empty, returning", null, 4, null);
            return;
        }
        Object operation = e;
        this.pendingOperation = operation;
        this.startOperationTimer();
        this.pendingOperationStart = System.currentTimeMillis();
        DittoLog.v$default(TAG, "Running operation " + operation, null, 4, null);
        this.callbacks.onNewOperation(operation);
    }

    public final synchronized void completePendingCommand() {
        DittoLog.v$default(TAG, "End of " + this.pendingOperation + ", finished in " + (System.currentTimeMillis() - this.pendingOperationStart) + "ms", null, 4, null);
        this.handler.post(() -> CommandQueue.completePendingCommand$lambda-2(this));
    }

    @Override
    public synchronized void clear() {
        this.pendingOperation = null;
        this.pendingOperationStart = 0L;
        this.clearOperationTimer();
        super.clear();
    }

    private final synchronized void startOperationTimer() {
        Runnable operationTimeoutRunnable;
        this.clearOperationTimer();
        Runnable runnable = this.operationTimeoutRunnable = (operationTimeoutRunnable = () -> CommandQueue.startOperationTimer$lambda-3(this));
        Intrinsics.checkNotNull((Object)runnable);
        this.handler.postDelayed(runnable, this.operationTimeout);
    }

    private final synchronized void clearOperationTimer() {
        Runnable runnable = this.operationTimeoutRunnable;
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            this.handler.removeCallbacks(it);
            DittoLog.v$default(TAG, "cleared out operation timer", null, 4, null);
        }
        this.operationTimeoutRunnable = null;
    }

    @Override
    @NotNull
    public String toString() {
        return "CommandQueue(" + CollectionsKt.joinToString$default((Iterable)this, null, null, null, (int)0, null, null, (int)63, null) + ")";
    }

    private static final void enqueueCommand$lambda-0(CommandQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.pendingOperation == null) {
            this$0.runNextOperation();
        }
    }

    private static final void completePendingCommand$lambda-2(CommandQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.pendingOperation = null;
        this$0.clearOperationTimer();
        if (!((Collection)this$0).isEmpty()) {
            this$0.runNextOperation();
        }
    }

    private static final void startOperationTimer$lambda-3(CommandQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object t = this$0.pendingOperation;
        if (t == null) {
            return;
        }
        Object pendingOperation = t;
        this$0.callbacks.onOperationTimeout(pendingOperation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/ditto/transports/ble/CommandQueue$Companion;", "", "()V", "TAG", "", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

