/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports.ble;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelUuid;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import live.ditto.DittoLog;
import live.ditto.internal.swig.ffi.BleDataType_t;
import live.ditto.internal.swig.ffi.BluetoothLeRadioRust;
import live.ditto.internal.swig.ffi.ConnectState_t;
import live.ditto.internal.swig.ffi.OnlineState_t;
import live.ditto.internal.swig.ffi.SendResult_t;
import live.ditto.internal.swig.ffi.TransportCondition_t;
import live.ditto.internal.swig.ffi.slice_mut_uint8_t;
import live.ditto.transports.DittoSyncPermissions;
import live.ditto.transports.ble.BleClientOperation;
import live.ditto.transports.ble.BleExtensionsKt;
import live.ditto.transports.ble.CharacteristicRead;
import live.ditto.transports.ble.CharacteristicWrite;
import live.ditto.transports.ble.CommandQueue;
import live.ditto.transports.ble.CommandQueueCallback;
import live.ditto.transports.ble.Connect;
import live.ditto.transports.ble.ConnectL2CapSocket;
import live.ditto.transports.ble.DescriptorRead;
import live.ditto.transports.ble.DescriptorWrite;
import live.ditto.transports.ble.DisableNotifications;
import live.ditto.transports.ble.Disconnect;
import live.ditto.transports.ble.EnableNotifications;
import live.ditto.transports.ble.ExperimentalBluetoothClient;
import live.ditto.transports.ble.ExperimentalBluetoothPlatform;
import live.ditto.transports.ble.L2capConnection;
import live.ditto.transports.ble.MtuRequest;
import live.ditto.transports.ble.Prefer2MPhy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u0000 I2\u00020\u0001:\u0001IB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0016H\u0002J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\u0006\u00101\u001a\u00020-J\u000e\u00102\u001a\u00020-2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020-2\u0006\u00103\u001a\u000204J\u0010\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\u0015H\u0002J\b\u00108\u001a\u00020-H\u0002J\b\u00109\u001a\u00020-H\u0002J\u0016\u0010:\u001a\u00020\u00182\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020-J\u001e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u000204J\u0016\u0010B\u001a\u00020\u00182\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u000204J\b\u0010C\u001a\u00020-H\u0002J\u0016\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020\u0007J\b\u0010G\u001a\u00020-H\u0002J\u0006\u0010H\u001a\u00020-R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001c@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Llive/ditto/transports/ble/ExperimentalBluetoothClient;", "", "platform", "Llive/ditto/transports/ble/ExperimentalBluetoothPlatform;", "(Llive/ditto/transports/ble/ExperimentalBluetoothPlatform;)V", "clientL2capChannels", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Llive/ditto/transports/ble/L2capConnection;", "commandCallback", "Llive/ditto/transports/ble/CommandQueueCallback;", "Llive/ditto/transports/ble/BleClientOperation;", "commandQueue", "Llive/ditto/transports/ble/CommandQueue;", "getCommandQueue", "()Llive/ditto/transports/ble/CommandQueue;", "commandQueue$delegate", "Lkotlin/Lazy;", "context", "Landroid/content/Context;", "deviceGattMap", "Landroid/bluetooth/BluetoothDevice;", "Landroid/bluetooth/BluetoothGatt;", "deviceStates", "", "gattCallback", "Landroid/bluetooth/BluetoothGattCallback;", "isScanning", "", "mainHandler", "Landroid/os/Handler;", "peripheralMTUs", "retryTimeoutRunnable", "Ljava/lang/Runnable;", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "scanningAnnounce", "scanningTimeoutRunnable", "<set-?>", "shouldScan", "getShouldScan$dittocpp_release", "()Z", "use2MPhy", "uuidDeviceMap", "cleanupDisconnectedGatt", "", "gatt", "clearScanTimer", "clearScanningRetry", "close", "connect", "peripheralUuid", "", "disconnect", "disconnectDevice", "device", "doStartScanning", "doStopScanning", "readL2cap", "data", "Llive/ditto/internal/swig/ffi/slice_mut_uint8_t;", "restartScan", "sendGatt", "Llive/ditto/internal/swig/ffi/SendResult_t;", "sendType", "Llive/ditto/internal/swig/ffi/BleDataType_t;", "sendL2cap", "startScanTimer", "startScanning", "serviceUuidBytes", "announce", "startScanningRetryTimer", "stopScanning", "Companion", "dittocpp_release"})
@SuppressLint(value={"MissingPermission"})
public final class ExperimentalBluetoothClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExperimentalBluetoothPlatform platform;
    private boolean shouldScan;
    @NotNull
    private final Context context;
    @NotNull
    private final Handler mainHandler;
    @NotNull
    private final ConcurrentHashMap<String, BluetoothDevice> uuidDeviceMap;
    @NotNull
    private final ConcurrentHashMap<BluetoothDevice, BluetoothGatt> deviceGattMap;
    @NotNull
    private final ConcurrentHashMap<BluetoothDevice, Integer> deviceStates;
    @NotNull
    private final ConcurrentHashMap<String, L2capConnection> clientL2capChannels;
    @NotNull
    private String scanningAnnounce;
    @NotNull
    private final Lazy commandQueue$delegate;
    @NotNull
    private final ConcurrentHashMap<String, Integer> peripheralMTUs;
    private boolean isScanning;
    private boolean use2MPhy;
    @Nullable
    private volatile Runnable scanningTimeoutRunnable;
    @Nullable
    private volatile Runnable retryTimeoutRunnable;
    @NotNull
    private final CommandQueueCallback<BleClientOperation> commandCallback;
    @NotNull
    private final ScanCallback scanCallback;
    @NotNull
    private BluetoothGattCallback gattCallback;
    @NotNull
    private static final String TAG = "ExperimentalBluetoothClient";
    private static final long CONNECTION_CALLBACK_TIMEOUT_MS = 35000L;
    private static final long SCAN_RESTART_INTERVAL_MS = 180000L;
    private static final long SCAN_PERMISSIONS_RETRY_WAIT_MS = 10000L;
    private static final long SCAN_START_AFTER_STOP_WAIT_MS = 1000L;

    public ExperimentalBluetoothClient(@NotNull ExperimentalBluetoothPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        this.context = this.platform.getContext$dittocpp_release();
        this.mainHandler = new Handler(this.context.getMainLooper());
        this.uuidDeviceMap = new ConcurrentHashMap();
        this.deviceGattMap = new ConcurrentHashMap();
        this.deviceStates = new ConcurrentHashMap();
        this.clientL2capChannels = new ConcurrentHashMap();
        this.scanningAnnounce = "";
        this.commandQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CommandQueue<BleClientOperation>>(this){
            final /* synthetic */ ExperimentalBluetoothClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CommandQueue<BleClientOperation> invoke() {
                return new CommandQueue<BleClientOperation>(ExperimentalBluetoothClient.access$getMainHandler$p(this.this$0), ExperimentalBluetoothClient.access$getCommandCallback$p(this.this$0), 35000L);
            }
        }));
        this.peripheralMTUs = new ConcurrentHashMap();
        this.commandCallback = new CommandQueueCallback<BleClientOperation>(this){
            final /* synthetic */ ExperimentalBluetoothClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNewOperation(@NotNull BleClientOperation operation) {
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                if (operation instanceof Connect) {
                    BleClientOperation bleClientOperation = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    Connect $this$onNewOperation_u24lambda_u2d1 = (Connect)bleClientOperation;
                    boolean bl = false;
                    if (ExperimentalBluetoothClient.access$getPlatform$p(experimentalBluetoothClient).getDeviceLocks$dittocpp_release().putIfAbsent($this$onNewOperation_u24lambda_u2d1.getDevice().getAddress(), ExperimentalBluetoothPlatform.PlatformType.CLIENT) == ExperimentalBluetoothPlatform.PlatformType.SERVER) {
                        DittoLog.i$default("ExperimentalBluetoothClient", "Ignoring connect request for " + $this$onNewOperation_u24lambda_u2d1.getDevice().getAddress() + ", as that device is currently reserved by the server", null, 4, null);
                        ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                    } else {
                        String cacheWarning = $this$onNewOperation_u24lambda_u2d1.getDevice().getType() == 0 ? " (not in Android's cache, more likely to fail)" : "";
                        DittoLog.i$default("ExperimentalBluetoothClient", "Connecting to " + $this$onNewOperation_u24lambda_u2d1.getDevice().getAddress() + cacheWarning, null, 4, null);
                        ExperimentalBluetoothClient.access$getMainHandler$p(experimentalBluetoothClient).postDelayed(() -> commandCallback.1.onNewOperation$lambda-1$lambda-0($this$onNewOperation_u24lambda_u2d1, experimentalBluetoothClient), 100L);
                    }
                    return;
                }
                BluetoothGatt gatt = (BluetoothGatt)ExperimentalBluetoothClient.access$getDeviceGattMap$p(this.this$0).get(operation.getDevice());
                if (gatt == null) {
                    DittoLog.d$default("ExperimentalBluetoothClient", "Not connected to " + operation.getDevice().getAddress() + "! Skipping operation.", null, 4, null);
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                    return;
                }
                BleClientOperation bleClientOperation = operation;
                if (bleClientOperation instanceof Disconnect) {
                    Disconnect $this$onNewOperation_u24lambda_u2d2 = (Disconnect)operation;
                    boolean bl = false;
                    DittoLog.d$default("ExperimentalBluetoothClient", "Disconnecting from " + $this$onNewOperation_u24lambda_u2d2.getDevice().getAddress(), null, 4, null);
                    gatt.disconnect();
                } else if (bleClientOperation instanceof CharacteristicWrite) {
                    Unit unit;
                    BleClientOperation bleClientOperation2 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    CharacteristicWrite $this$onNewOperation_u24lambda_u2d6 = (CharacteristicWrite)bleClientOperation2;
                    boolean bl = false;
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = BleExtensionsKt.findCharacteristic(gatt, $this$onNewOperation_u24lambda_u2d6.getCharacteristicUuid());
                    if (bluetoothGattCharacteristic != null) {
                        BluetoothGattCharacteristic characteristic = bluetoothGattCharacteristic;
                        boolean bl2 = false;
                        int result = BleExtensionsKt.writeCharacteristicCompat(gatt, characteristic, $this$onNewOperation_u24lambda_u2d6.getPayload(), $this$onNewOperation_u24lambda_u2d6.getWriteType());
                        boolean bl3 = false;
                        if (result == 201) {
                            DittoLog.d$default("ExperimentalBluetoothClient", "Characteristic Write request was busy, retrying.", null, 4, null);
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).enqueueCommand(operation);
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        } else if (result != 0) {
                            DittoLog.e$default("ExperimentalBluetoothClient", "Failed to write characteristic " + characteristic + ", status code " + result + ". Disconnecting.", null, 4, null);
                            ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, $this$onNewOperation_u24lambda_u2d6.getDevice());
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        ExperimentalBluetoothClient $this$onNewOperation_u24lambda_u2d6_u24lambda_u2d5 = experimentalBluetoothClient;
                        boolean bl4 = false;
                        DittoLog.e$default("ExperimentalBluetoothClient", "Cannot find " + $this$onNewOperation_u24lambda_u2d6.getCharacteristicUuid() + " to write to. Disconnecting.", null, 4, null);
                        ExperimentalBluetoothClient.access$disconnectDevice($this$onNewOperation_u24lambda_u2d6_u24lambda_u2d5, $this$onNewOperation_u24lambda_u2d6.getDevice());
                        ExperimentalBluetoothClient.access$getCommandQueue($this$onNewOperation_u24lambda_u2d6_u24lambda_u2d5).completePendingCommand();
                    }
                } else if (bleClientOperation instanceof CharacteristicRead) {
                    Unit unit;
                    BleClientOperation bleClientOperation3 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    CharacteristicRead $this$onNewOperation_u24lambda_u2d9 = (CharacteristicRead)bleClientOperation3;
                    boolean bl = false;
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = BleExtensionsKt.findCharacteristic(gatt, $this$onNewOperation_u24lambda_u2d9.getCharacteristicUuid());
                    if (bluetoothGattCharacteristic != null) {
                        BluetoothGattCharacteristic characteristic = bluetoothGattCharacteristic;
                        boolean bl5 = false;
                        if (!gatt.readCharacteristic(characteristic)) {
                            DittoLog.e$default("ExperimentalBluetoothClient", "Failed to read characteristic " + characteristic + ". Disconnecting.", null, 4, null);
                            ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, $this$onNewOperation_u24lambda_u2d9.getDevice());
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        ExperimentalBluetoothClient $this$onNewOperation_u24lambda_u2d9_u24lambda_u2d8 = experimentalBluetoothClient;
                        boolean bl6 = false;
                        DittoLog.e$default("ExperimentalBluetoothClient", "Cannot find " + $this$onNewOperation_u24lambda_u2d9.getCharacteristicUuid() + " to read from. Disconnecting.", null, 4, null);
                        ExperimentalBluetoothClient.access$disconnectDevice($this$onNewOperation_u24lambda_u2d9_u24lambda_u2d8, $this$onNewOperation_u24lambda_u2d9.getDevice());
                        ExperimentalBluetoothClient.access$getCommandQueue($this$onNewOperation_u24lambda_u2d9_u24lambda_u2d8).completePendingCommand();
                    }
                } else if (bleClientOperation instanceof DescriptorWrite) {
                    Unit unit;
                    BleClientOperation bleClientOperation4 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    DescriptorWrite $this$onNewOperation_u24lambda_u2d13 = (DescriptorWrite)bleClientOperation4;
                    boolean bl = false;
                    BluetoothGattDescriptor bluetoothGattDescriptor = BleExtensionsKt.findDescriptor(gatt, $this$onNewOperation_u24lambda_u2d13.getDescriptorUuid());
                    if (bluetoothGattDescriptor != null) {
                        BluetoothGattDescriptor descriptor = bluetoothGattDescriptor;
                        boolean bl7 = false;
                        int result = BleExtensionsKt.writeDescriptorCompat(gatt, descriptor, $this$onNewOperation_u24lambda_u2d13.getPayload());
                        boolean bl8 = false;
                        if (result == 201) {
                            DittoLog.d$default("ExperimentalBluetoothClient", "Characteristic Write request was busy, retrying.", null, 4, null);
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).enqueueCommand(operation);
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        } else if (result != 0) {
                            DittoLog.e$default("ExperimentalBluetoothClient", "Failed to write descriptor " + descriptor + ", status code " + result + ". Disconnecting.", null, 4, null);
                            ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, $this$onNewOperation_u24lambda_u2d13.getDevice());
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        ExperimentalBluetoothClient $this$onNewOperation_u24lambda_u2d13_u24lambda_u2d12 = experimentalBluetoothClient;
                        boolean bl9 = false;
                        DittoLog.e$default("ExperimentalBluetoothClient", "Cannot find " + $this$onNewOperation_u24lambda_u2d13.getDescriptorUuid() + " to write to. Disconnecting.", null, 4, null);
                        ExperimentalBluetoothClient.access$disconnectDevice($this$onNewOperation_u24lambda_u2d13_u24lambda_u2d12, $this$onNewOperation_u24lambda_u2d13.getDevice());
                        ExperimentalBluetoothClient.access$getCommandQueue($this$onNewOperation_u24lambda_u2d13_u24lambda_u2d12).completePendingCommand();
                    }
                } else if (bleClientOperation instanceof DescriptorRead) {
                    BleClientOperation bleClientOperation5 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    DescriptorRead $this$onNewOperation_u24lambda_u2d16 = (DescriptorRead)bleClientOperation5;
                    boolean bl = false;
                    BluetoothGattDescriptor bluetoothGattDescriptor = BleExtensionsKt.findDescriptor(gatt, $this$onNewOperation_u24lambda_u2d16.getDescriptorUuid());
                    if (bluetoothGattDescriptor != null) {
                        BluetoothGattDescriptor descriptor = bluetoothGattDescriptor;
                        boolean bl10 = false;
                        if (!gatt.readDescriptor(descriptor)) {
                            DittoLog.e$default("ExperimentalBluetoothClient", "Failed to read descriptor " + descriptor + ". Disconnecting.", null, 4, null);
                            ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, $this$onNewOperation_u24lambda_u2d16.getDevice());
                            ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        }
                        gatt.readDescriptor(descriptor);
                    } else {
                        ExperimentalBluetoothClient $this$onNewOperation_u24lambda_u2d16_u24lambda_u2d15 = experimentalBluetoothClient;
                        boolean bl11 = false;
                        DittoLog.e$default("ExperimentalBluetoothClient", "Cannot find " + $this$onNewOperation_u24lambda_u2d16.getDescriptorUuid() + " to read from. Disconnecting.", null, 4, null);
                        ExperimentalBluetoothClient.access$disconnectDevice($this$onNewOperation_u24lambda_u2d16_u24lambda_u2d15, $this$onNewOperation_u24lambda_u2d16.getDevice());
                        ExperimentalBluetoothClient.access$getCommandQueue($this$onNewOperation_u24lambda_u2d16_u24lambda_u2d15).completePendingCommand();
                    }
                } else if (bleClientOperation instanceof EnableNotifications) {
                    byte[] byArray;
                    BluetoothGattDescriptor cccDescriptor;
                    BluetoothGattCharacteristic characteristic;
                    BleClientOperation bleClientOperation6 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    EnableNotifications $this$onNewOperation_u24lambda_u2d18 = (EnableNotifications)bleClientOperation6;
                    boolean bl = false;
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic = BleExtensionsKt.findCharacteristic(gatt, $this$onNewOperation_u24lambda_u2d18.getCharacteristicUuid());
                    Object object = cccDescriptor = bluetoothGattCharacteristic != null ? bluetoothGattCharacteristic.getDescriptor(BleExtensionsKt.getCCC_DESCRIPTOR_UUID()) : null;
                    if (cccDescriptor == null) {
                        DittoLog.w$default("ExperimentalBluetoothClient", $this$onNewOperation_u24lambda_u2d18.getCharacteristicUuid() + " doesn't exist or doesn't support notifications. Disconnecting.", null, 4, null);
                        BluetoothDevice bluetoothDevice = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                        ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, bluetoothDevice);
                        ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        return;
                    }
                    if (BleExtensionsKt.isIndicatable(characteristic)) {
                        byArray = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
                    } else if (BleExtensionsKt.isNotifiable(characteristic)) {
                        byArray = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
                    } else {
                        DittoLog.e$default("ExperimentalBluetoothClient", characteristic.getUuid() + " doesn't support notifications/indications. Disconnecting.", null, 4, null);
                        BluetoothDevice bluetoothDevice = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                        ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, bluetoothDevice);
                        ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        return;
                    }
                    byte[] payload = byArray;
                    if (!gatt.setCharacteristicNotification(characteristic, true)) {
                        DittoLog.e$default("ExperimentalBluetoothClient", "setCharacteristicNotification failed for " + characteristic.getUuid() + ". Disconnecting.", null, 4, null);
                        BluetoothDevice bluetoothDevice = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                        ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, bluetoothDevice);
                        ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"payload");
                    int result = BleExtensionsKt.writeDescriptorCompat(gatt, cccDescriptor, payload);
                    boolean bl12 = false;
                    if (result != 0) {
                        DittoLog.e$default("ExperimentalBluetoothClient", "Failed to set notifications for " + $this$onNewOperation_u24lambda_u2d18.getCharacteristicUuid() + ", status code " + result + ". Disconnecting.", null, 4, null);
                        BluetoothDevice bluetoothDevice = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                        ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, bluetoothDevice);
                        ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                    }
                } else if (bleClientOperation instanceof DisableNotifications) {
                    Unit unit;
                    BleClientOperation bleClientOperation7 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    DisableNotifications $this$onNewOperation_u24lambda_u2d24 = (DisableNotifications)bleClientOperation7;
                    boolean bl = false;
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = BleExtensionsKt.findCharacteristic(gatt, $this$onNewOperation_u24lambda_u2d24.getCharacteristicUuid());
                    if (bluetoothGattCharacteristic != null) {
                        Unit unit2;
                        BluetoothGattDescriptor bluetoothGattDescriptor;
                        BluetoothGattCharacteristic characteristic = bluetoothGattCharacteristic;
                        boolean bl13 = false;
                        BluetoothGattDescriptor bluetoothGattDescriptor2 = bluetoothGattDescriptor = characteristic.getDescriptor(BleExtensionsKt.getCCC_DESCRIPTOR_UUID());
                        if (bluetoothGattDescriptor2 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)bluetoothGattDescriptor2, (String)"getDescriptor(CCC_DESCRIPTOR_UUID)");
                            BluetoothGattDescriptor cccDescriptor = bluetoothGattDescriptor;
                            boolean bl14 = false;
                            if (!gatt.setCharacteristicNotification(characteristic, false)) {
                                DittoLog.e$default("ExperimentalBluetoothClient", "setCharacteristicNotification failed for " + characteristic.getUuid(), null, 4, null);
                                BluetoothDevice bluetoothDevice = gatt.getDevice();
                                Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                                ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, bluetoothDevice);
                                ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE, (String)"DISABLE_NOTIFICATION_VALUE");
                            int result = BleExtensionsKt.writeDescriptorCompat(gatt, cccDescriptor, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                            boolean bl15 = false;
                            if (result != 0) {
                                DittoLog.e$default("ExperimentalBluetoothClient", "Failed to set notifications for " + $this$onNewOperation_u24lambda_u2d24.getCharacteristicUuid() + ", status code " + result, null, 4, null);
                                BluetoothDevice bluetoothDevice = gatt.getDevice();
                                Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                                ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, bluetoothDevice);
                                ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                            }
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if (unit2 == null) {
                            ExperimentalBluetoothClient $this$onNewOperation_u24lambda_u2d24_u24lambda_u2d22_u24lambda_u2d21 = experimentalBluetoothClient;
                            boolean bl16 = false;
                            DittoLog.e$default("ExperimentalBluetoothClient", characteristic.getUuid() + " doesn't contain the CCC descriptor!", null, 4, null);
                            BluetoothDevice bluetoothDevice = gatt.getDevice();
                            Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                            ExperimentalBluetoothClient.access$disconnectDevice($this$onNewOperation_u24lambda_u2d24_u24lambda_u2d22_u24lambda_u2d21, bluetoothDevice);
                            ExperimentalBluetoothClient.access$getCommandQueue($this$onNewOperation_u24lambda_u2d24_u24lambda_u2d22_u24lambda_u2d21).completePendingCommand();
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        ExperimentalBluetoothClient $this$onNewOperation_u24lambda_u2d24_u24lambda_u2d23 = experimentalBluetoothClient;
                        boolean bl17 = false;
                        DittoLog.e$default("ExperimentalBluetoothClient", "Cannot find " + $this$onNewOperation_u24lambda_u2d24.getCharacteristicUuid() + "! Failed to disable notifications.", null, 4, null);
                        BluetoothDevice bluetoothDevice = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                        ExperimentalBluetoothClient.access$disconnectDevice($this$onNewOperation_u24lambda_u2d24_u24lambda_u2d23, bluetoothDevice);
                        ExperimentalBluetoothClient.access$getCommandQueue($this$onNewOperation_u24lambda_u2d24_u24lambda_u2d23).completePendingCommand();
                    }
                } else if (bleClientOperation instanceof MtuRequest) {
                    BleClientOperation bleClientOperation8 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    MtuRequest $this$onNewOperation_u24lambda_u2d25 = (MtuRequest)bleClientOperation8;
                    boolean bl = false;
                    if (!gatt.requestMtu($this$onNewOperation_u24lambda_u2d25.getMtu())) {
                        DittoLog.e$default("ExperimentalBluetoothClient", "Failed to request MTU of " + $this$onNewOperation_u24lambda_u2d25.getMtu() + " for " + gatt.getDevice().getAddress() + ".", null, 4, null);
                        BluetoothDevice bluetoothDevice = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                        ExperimentalBluetoothClient.access$disconnectDevice(experimentalBluetoothClient, bluetoothDevice);
                        ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                    }
                } else if (bleClientOperation instanceof Prefer2MPhy) {
                    if (Build.VERSION.SDK_INT < 26) {
                        DittoLog.d$default("ExperimentalBluetoothClient", "Skipping Prefer2MPhy, not supported by this Android version", null, 4, null);
                        ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                        return;
                    }
                    gatt.setPreferredPhy(2, 2, 0);
                    if (Build.VERSION.SDK_INT == 33) {
                        ExperimentalBluetoothClient.access$getMainHandler$p(this.this$0).postDelayed(() -> commandCallback.1.onNewOperation$lambda-26(this.this$0, operation), 200L);
                    }
                } else if (bleClientOperation instanceof ConnectL2CapSocket) {
                    BleClientOperation bleClientOperation9 = operation;
                    ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                    ConnectL2CapSocket $this$onNewOperation_u24lambda_u2d29 = (ConnectL2CapSocket)bleClientOperation9;
                    boolean bl = false;
                    if (Build.VERSION.SDK_INT < 29) {
                        DittoLog.e$default("ExperimentalBluetoothClient", "ConnectL2CapSocket command received on incompatible device", null, 4, null);
                        ExperimentalBluetoothClient.access$getCommandQueue(experimentalBluetoothClient).completePendingCommand();
                        return;
                    }
                    ExperimentalBluetoothClient.access$getPlatform$p(experimentalBluetoothClient).getL2capHandler$dittocpp_release().post(() -> commandCallback.1.onNewOperation$lambda-29$lambda-28($this$onNewOperation_u24lambda_u2d29, gatt, experimentalBluetoothClient));
                }
            }

            public void onOperationTimeout(@NotNull BleClientOperation operation) {
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, operation.getDevice());
                if ((BleClientOperation)ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof Connect) {
                    BluetoothGatt gatt = (BluetoothGatt)ExperimentalBluetoothClient.access$getDeviceGattMap$p(this.this$0).get(operation.getDevice());
                    if (gatt != null) {
                        DittoLog.e$default("ExperimentalBluetoothClient", "Triggered fallback connection callback timeout for " + operation.getDevice().getAddress() + ", this shouldn't happen.", null, 4, null);
                        ExperimentalBluetoothClient.access$getGattCallback$p(this.this$0).onConnectionStateChange(gatt, 62, 0);
                    }
                } else {
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                }
            }

            private static final void onNewOperation$lambda-1$lambda-0(Connect $this_with, ExperimentalBluetoothClient this$0) {
                Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                BluetoothGatt gatt = $this_with.getDevice().connectGatt($this_with.getContext(), false, ExperimentalBluetoothClient.access$getGattCallback$p(this$0), 2);
                ExperimentalBluetoothClient.access$getGattCallback$p(this$0).onConnectionStateChange(gatt, 0, 1);
            }

            private static final void onNewOperation$lambda-26(ExperimentalBluetoothClient this$0, BleClientOperation $operation) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
                if (Intrinsics.areEqual(ExperimentalBluetoothClient.access$getCommandQueue(this$0).getPendingOperation(), (Object)$operation)) {
                    ExperimentalBluetoothClient.access$getCommandQueue(this$0).completePendingCommand();
                }
            }

            private static final void onNewOperation$lambda-29$lambda-28(ConnectL2CapSocket $this_with, BluetoothGatt $gatt, ExperimentalBluetoothClient this$0) {
                Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                try {
                    BluetoothSocket bluetoothSocket = $this_with.getDevice().createInsecureL2capChannel($this_with.getPsm());
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothSocket, (String)"device.createInsecureL2capChannel(psm)");
                    BluetoothSocket socket = bluetoothSocket;
                    boolean $i$f$measureTimeMillis = false;
                    long start$iv = System.currentTimeMillis();
                    boolean bl = false;
                    socket.connect();
                    long connectTimeMs = System.currentTimeMillis() - start$iv;
                    DittoLog.d$default("ExperimentalBluetoothClient", "L2CAP client: connected to remote channel for address " + $gatt.getDevice().getAddress() + " in " + connectTimeMs + " ms", null, 4, null);
                    String string = $this_with.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
                    byte[] uuidBytes = BleExtensionsKt.toAddressBytes(string);
                    L2capConnection conn = new L2capConnection(uuidBytes, socket, false, new WeakReference<BluetoothLeRadioRust>(ExperimentalBluetoothClient.access$getPlatform$p(this$0)));
                    Map map = ExperimentalBluetoothClient.access$getClientL2capChannels$p(this$0);
                    String string2 = $gatt.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gatt.device.address");
                    map.put(string2, conn);
                }
                catch (Exception e) {
                    DittoLog.d$default("ExperimentalBluetoothClient", "L2CAP client: exception connecting to " + $gatt.getDevice().getAddress() + " remote psm " + e, null, 4, null);
                }
                ExperimentalBluetoothClient.access$getCommandQueue(this$0).completePendingCommand();
            }
        };
        this.scanCallback = new ScanCallback(this){
            final /* synthetic */ ExperimentalBluetoothClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @NotNull ScanResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                BluetoothAdapter adapter = ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).getAdapter$dittocpp_release();
                if (adapter.getState() == 12) {
                    String string;
                    Charset charset;
                    Object object;
                    String string2 = result.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.device.address");
                    byte[] uuid = BleExtensionsKt.toAddressBytes(string2);
                    ScanRecord scanRecord = result.getScanRecord();
                    if (scanRecord == null) {
                        return;
                    }
                    ScanRecord record = scanRecord;
                    String localName = record.getDeviceName();
                    byte[] manuData = record.getManufacturerSpecificData(0);
                    float rssi = result.getRssi();
                    if (manuData != null) {
                        object = manuData;
                        Charset charset2 = Charset.defaultCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"defaultCharset()");
                        charset = charset2;
                        string = new String((byte[])object, charset);
                    } else {
                        string = localName;
                    }
                    String announce = string;
                    ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, uuid, announce, rssi){
                        final /* synthetic */ ExperimentalBluetoothClient this$0;
                        final /* synthetic */ byte[] $uuid;
                        final /* synthetic */ String $announce;
                        final /* synthetic */ float $rssi;
                        {
                            this.this$0 = $receiver;
                            this.$uuid = $uuid;
                            this.$announce = $announce;
                            this.$rssi = $rssi;
                            super(0);
                        }

                        public final void invoke() {
                            ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).advertisementHeard(this.$uuid, this.$announce, this.$rssi);
                        }
                    }));
                    if (!ExperimentalBluetoothClient.access$getUuidDeviceMap$p(this.this$0).containsKey(result.getDevice().getAddress())) {
                        DittoLog.d$default("ExperimentalBluetoothClient", "Scan result: Found " + result.getDevice().getAddress() + " (" + localName + ", " + result.getDevice().getName() + ")", null, 4, null);
                    } else {
                        DittoLog.v$default("ExperimentalBluetoothClient", "Scan result: Duplicate advertisement for " + result.getDevice().getAddress() + " (" + localName + ", " + result.getDevice().getName() + ")", null, 4, null);
                    }
                    Map map = ExperimentalBluetoothClient.access$getUuidDeviceMap$p(this.this$0);
                    String string3 = result.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"result.device.address");
                    object = string3;
                    BluetoothDevice bluetoothDevice = result.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"result.device");
                    charset = bluetoothDevice;
                    map.put(object, charset);
                }
            }

            public void onScanFailed(int errorCode) {
                DittoLog.e$default("ExperimentalBluetoothClient", "Ditto Bluetooth LE sync is restricted due to missing Bluetooth or ACCESS_FINE_LOCATION permissions. Please check both manifest and call to ActivityCompat.requestPermissions(). <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
                ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ExperimentalBluetoothClient this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_CENTRAL_PERMISSION);
                    }
                }));
                ExperimentalBluetoothClient.access$startScanningRetryTimer(this.this$0);
            }

            public void onBatchScanResults(@NotNull List<ScanResult> results) {
                Intrinsics.checkNotNullParameter(results, (String)"results");
                DittoLog.e$default("ExperimentalBluetoothClient", "Received BLE batch scan results unexpectedly", null, 4, null);
            }
        };
        this.gattCallback = new BluetoothGattCallback(this){
            final /* synthetic */ ExperimentalBluetoothClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConnectionStateChange(@NotNull BluetoothGatt gatt, int status, int newState) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                if (status != 0) {
                    DittoLog.w$default("ExperimentalBluetoothClient", "onConnectionStateChange: status " + status + " encountered for " + gatt.getDevice().getAddress() + "! Disconnecting the GATT.", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                    if (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof Connect) {
                        ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                    }
                }
                Map map = ExperimentalBluetoothClient.access$getDeviceStates$p(this.this$0);
                BluetoothDevice bluetoothDevice = gatt.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                Object object = bluetoothDevice;
                Integer n = newState;
                map.put(object, n);
                switch (newState) {
                    case 2: {
                        if (Intrinsics.areEqual((Object)gatt, ExperimentalBluetoothClient.access$getDeviceGattMap$p(this.this$0).get(gatt.getDevice()))) {
                            DittoLog.w$default("ExperimentalBluetoothClient", "Received multiple STATE_CONNECTED events for the same GATT object", null, 4, null);
                            return;
                        }
                        if (gatt.getDevice().getBondState() != 10) {
                            DittoLog.w$default("ExperimentalBluetoothClient", "Device is in a bonded state, which is unexpected and will cause problems", null, 4, null);
                        }
                        BluetoothGatt bluetoothGatt = ExperimentalBluetoothClient.access$getDeviceGattMap$p(this.this$0).replace(gatt.getDevice(), gatt);
                        if (bluetoothGatt != null) {
                            n = bluetoothGatt;
                            ExperimentalBluetoothClient experimentalBluetoothClient = this.this$0;
                            Integer it = n;
                            boolean bl = false;
                            DittoLog.w$default("ExperimentalBluetoothClient", "Cleaning up a second extraneous BluetoothGatt for " + it.getDevice().getAddress(), null, 4, null);
                            ExperimentalBluetoothClient.access$getMainHandler$p(experimentalBluetoothClient).post(() -> gattCallback.1.onConnectionStateChange$lambda-1$lambda-0((BluetoothGatt)it));
                        }
                        DittoLog.d$default("ExperimentalBluetoothClient", "Connected to remote peripheral " + gatt.getDevice().getAddress() + ", discovering services", null, 4, null);
                        object = ExperimentalBluetoothClient.access$getDeviceGattMap$p(this.this$0);
                        BluetoothDevice bluetoothDevice2 = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice2, (String)"gatt.device");
                        object.put(bluetoothDevice2, gatt);
                        if (ExperimentalBluetoothClient.access$getUse2MPhy$p(this.this$0)) {
                            CommandQueue commandQueue2 = ExperimentalBluetoothClient.access$getCommandQueue(this.this$0);
                            BluetoothDevice bluetoothDevice3 = gatt.getDevice();
                            Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice3, (String)"gatt.device");
                            commandQueue2.enqueueCommand(new Prefer2MPhy(bluetoothDevice3));
                        }
                        ExperimentalBluetoothClient.access$getMainHandler$p(this.this$0).post(() -> gattCallback.1.onConnectionStateChange$lambda-2(gatt, this.this$0));
                        break;
                    }
                    case 0: {
                        ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, gatt){
                            final /* synthetic */ ExperimentalBluetoothClient this$0;
                            final /* synthetic */ BluetoothGatt $gatt;
                            {
                                this.this$0 = $receiver;
                                this.$gatt = $gatt;
                                super(0);
                            }

                            public final void invoke() {
                                ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothClient.access$getPlatform$p(this.this$0);
                                String string = this.$gatt.getDevice().getAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                                experimentalBluetoothPlatform.connectionStateChanged(BleExtensionsKt.toAddressBytes(string), ConnectState_t.CONNECT_STATE_DISCONNECTED, false, 0);
                            }
                        }));
                        DittoLog.d$default("ExperimentalBluetoothClient", "Disconnected event for " + gatt.getDevice().getAddress(), null, 4, null);
                        ExperimentalBluetoothClient.access$cleanupDisconnectedGatt(this.this$0, gatt);
                        if (!(ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof Disconnect)) break;
                        BleClientOperation bleClientOperation = (BleClientOperation)ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation();
                        if (!Intrinsics.areEqual((Object)(bleClientOperation != null ? bleClientOperation.getDevice() : null), (Object)gatt.getDevice())) break;
                        ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                        break;
                    }
                    case 3: {
                        ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, gatt){
                            final /* synthetic */ ExperimentalBluetoothClient this$0;
                            final /* synthetic */ BluetoothGatt $gatt;
                            {
                                this.this$0 = $receiver;
                                this.$gatt = $gatt;
                                super(0);
                            }

                            public final void invoke() {
                                ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothClient.access$getPlatform$p(this.this$0);
                                String string = this.$gatt.getDevice().getAddress();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                                experimentalBluetoothPlatform.connectionStateChanged(BleExtensionsKt.toAddressBytes(string), ConnectState_t.CONNECT_STATE_DISCONNECTING, false, 0);
                            }
                        }));
                        DittoLog.d$default("ExperimentalBluetoothClient", "Disconnecting from remote peripheral " + gatt.getDevice().getAddress(), null, 4, null);
                    }
                }
            }

            public void onServicesDiscovered(@NotNull BluetoothGatt gatt, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                DittoLog.d$default("ExperimentalBluetoothClient", "onServicesDiscovered(" + gatt.getDevice().getAddress() + ", " + status + ")", null, 4, null);
                if (status != 0) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "onServicesDiscovered: status " + status + " encountered for " + gatt.getDevice().getAddress() + "! Disconnecting GATT.", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                }
                CommandQueue commandQueue2 = ExperimentalBluetoothClient.access$getCommandQueue(this.this$0);
                BluetoothDevice bluetoothDevice = gatt.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                commandQueue2.enqueueCommand(new EnableNotifications(bluetoothDevice, BleExtensionsKt.getCHAR_UUID_READ()));
                CommandQueue commandQueue3 = ExperimentalBluetoothClient.access$getCommandQueue(this.this$0);
                BluetoothDevice bluetoothDevice2 = gatt.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice2, (String)"gatt.device");
                commandQueue3.enqueueCommand(new EnableNotifications(bluetoothDevice2, BleExtensionsKt.getCHAR_UUID_CONTROL_READ()));
                if (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof Connect) {
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                }
            }

            public void onCharacteristicWrite(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                if (status != 0) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "Characteristic write failed for " + characteristic.getUuid() + ", status: " + status + ". Disconnecting from " + gatt.getDevice().getAddress() + ".", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                    if (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof CharacteristicWrite) {
                        ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                    }
                    return;
                }
                if (Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)BleExtensionsKt.getCHAR_UUID_ANNOUNCE())) {
                    String string = gatt.getDevice().getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                    byte[] peripheral = BleExtensionsKt.toAddressBytes(string);
                    boolean l2capAvailable = ExperimentalBluetoothClient.access$getClientL2capChannels$p(this.this$0).containsKey(gatt.getDevice().getAddress());
                    DittoLog.i$default("ExperimentalBluetoothClient", "Finished connection procedure for " + gatt.getDevice().getAddress() + " (L2CAP " + (!l2capAvailable ? "un" : "") + "available)", null, 4, null);
                    ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, peripheral, l2capAvailable, gatt){
                        final /* synthetic */ ExperimentalBluetoothClient this$0;
                        final /* synthetic */ byte[] $peripheral;
                        final /* synthetic */ boolean $l2capAvailable;
                        final /* synthetic */ BluetoothGatt $gatt;
                        {
                            this.this$0 = $receiver;
                            this.$peripheral = $peripheral;
                            this.$l2capAvailable = $l2capAvailable;
                            this.$gatt = $gatt;
                            super(0);
                        }

                        public final void invoke() {
                            ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothClient.access$getPlatform$p(this.this$0);
                            Integer n = (Integer)ExperimentalBluetoothClient.access$getPeripheralMTUs$p(this.this$0).get(this.$gatt.getDevice().getAddress());
                            if (n == null) {
                                n = 20;
                            }
                            experimentalBluetoothPlatform.connectionStateChanged(this.$peripheral, ConnectState_t.CONNECT_STATE_CONNECTED, this.$l2capAvailable, ((Number)n).intValue());
                        }
                    }));
                }
                ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postDelayedOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, gatt){
                    final /* synthetic */ ExperimentalBluetoothClient this$0;
                    final /* synthetic */ BluetoothGatt $gatt;
                    {
                        this.this$0 = $receiver;
                        this.$gatt = $gatt;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothClient.access$getPlatform$p(this.this$0);
                        String string = this.$gatt.getDevice().getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                        experimentalBluetoothPlatform.peripheralReadyToSend(BleExtensionsKt.toAddressBytes(string));
                    }
                }), 5L);
                if (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof CharacteristicWrite) {
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                }
            }

            public void onDescriptorRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattDescriptor descriptor, int status, @NotNull byte[] value) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DittoLog.w$default("ExperimentalBluetoothClient", "onDescriptorRead(" + gatt.getDevice().getAddress() + ", " + descriptor + ", " + status + ") unused but received.", null, 4, null);
            }

            public void onDescriptorRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattDescriptor descriptor, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                byte[] byArray = descriptor.getValue();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                this.onDescriptorRead(gatt, descriptor, status, byArray);
            }

            public void onCharacteristicRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                byte[] byArray = characteristic.getValue();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                this.onCharacteristicRead(gatt, characteristic, byArray, status);
            }

            public void onCharacteristicRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (status != 0) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "Characteristic read failed for " + characteristic.getUuid() + ", status: " + status + ". Disconnecting from " + gatt.getDevice().getAddress() + ".", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                } else if (Build.VERSION.SDK_INT >= 29 && Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)BleExtensionsKt.getCHAR_UUID_PSM()) && value.length == 2) {
                    int msb = UInt.constructor-impl((int)(UByte.constructor-impl((byte)value[0]) & 0xFF));
                    int lsb = UInt.constructor-impl((int)(UByte.constructor-impl((byte)value[1]) & 0xFF));
                    int psm = UInt.constructor-impl((int)(UInt.constructor-impl((int)(msb << 8)) + lsb));
                    CommandQueue commandQueue2 = ExperimentalBluetoothClient.access$getCommandQueue(this.this$0);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    commandQueue2.enqueueCommand(new ConnectL2CapSocket(bluetoothDevice, psm));
                    this.writeOurAnnounceToGatt(gatt);
                }
                if (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof CharacteristicRead) {
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                }
            }

            public void onCharacteristicChanged(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                BluetoothDevice device = (BluetoothDevice)ExperimentalBluetoothClient.access$getUuidDeviceMap$p(this.this$0).get(gatt.getDevice().getAddress());
                BluetoothGatt existingGatt = (BluetoothGatt)((Map)ExperimentalBluetoothClient.access$getDeviceGattMap$p(this.this$0)).get(device);
                if (!Intrinsics.areEqual((Object)existingGatt, (Object)gatt)) {
                    DittoLog.w$default("ExperimentalBluetoothClient", "onCharacteristicChanged received with second extraneous GATT (" + gatt.getDevice().getAddress() + "). Disconnecting the new one.", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                    return;
                }
                if (value.length == 0) {
                    return;
                }
                String string = gatt.getDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                byte[] peripheral = BleExtensionsKt.toAddressBytes(string);
                ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(characteristic, this.this$0, peripheral, value){
                    final /* synthetic */ BluetoothGattCharacteristic $characteristic;
                    final /* synthetic */ ExperimentalBluetoothClient this$0;
                    final /* synthetic */ byte[] $peripheral;
                    final /* synthetic */ byte[] $value;
                    {
                        this.$characteristic = $characteristic;
                        this.this$0 = $receiver;
                        this.$peripheral = $peripheral;
                        this.$value = $value;
                        super(0);
                    }

                    public final void invoke() {
                        UUID uUID = this.$characteristic.getUuid();
                        if (Intrinsics.areEqual((Object)uUID, (Object)BleExtensionsKt.getCHAR_UUID_READ())) {
                            ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).receivedFromPeripheral(this.$peripheral, BleDataType_t.BLE_DATA_TYPE_MESH_DATA, this.$value);
                        } else if (Intrinsics.areEqual((Object)uUID, (Object)BleExtensionsKt.getCHAR_UUID_CONTROL_READ())) {
                            ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).receivedFromPeripheral(this.$peripheral, BleDataType_t.BLE_DATA_TYPE_CONTROL, this.$value);
                        } else {
                            DittoLog.w$default("ExperimentalBluetoothClient", "Unexpectedly received characteristic changed for " + this.$characteristic.getUuid(), null, 4, null);
                        }
                    }
                }));
            }

            public void onDescriptorWrite(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattDescriptor descriptor, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                DittoLog.d$default("ExperimentalBluetoothClient", "onDescriptorWrite(" + descriptor + ", " + status + ")", null, 4, null);
                if (status != 0) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "onDescriptorWrite failed. status " + status + ", char_uuid " + descriptor.getCharacteristic().getUuid() + ". Disconnecting from " + gatt.getDevice().getAddress() + ".", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                } else if (Intrinsics.areEqual((Object)descriptor.getCharacteristic().getUuid(), (Object)BleExtensionsKt.getCHAR_UUID_CONTROL_READ())) {
                    DittoLog.v$default("ExperimentalBluetoothClient", "Finished control read descriptor write for " + gatt.getDevice().getAddress() + ".", null, 4, null);
                    if (Build.VERSION.SDK_INT >= 29 && BleExtensionsKt.findCharacteristic(gatt, BleExtensionsKt.getCHAR_UUID_PSM()) != null) {
                        CommandQueue commandQueue2 = ExperimentalBluetoothClient.access$getCommandQueue(this.this$0);
                        BluetoothDevice bluetoothDevice = gatt.getDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                        commandQueue2.enqueueCommand(new CharacteristicRead(bluetoothDevice, BleExtensionsKt.getCHAR_UUID_PSM()));
                    } else {
                        this.writeOurAnnounceToGatt(gatt);
                    }
                }
                if (BleExtensionsKt.isCccd(descriptor) && (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof EnableNotifications || ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof DisableNotifications)) {
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                } else if (!BleExtensionsKt.isCccd(descriptor) && ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof DescriptorWrite) {
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                }
            }

            public void onReadRemoteRssi(@NotNull BluetoothGatt gatt, int rssi, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
            }

            private final void writeOurAnnounceToGatt(BluetoothGatt gatt) {
                BluetoothGattCharacteristic announceChar = BleExtensionsKt.findCharacteristic(gatt, BleExtensionsKt.getCHAR_UUID_ANNOUNCE());
                if (announceChar != null) {
                    DittoLog.d$default("ExperimentalBluetoothClient", "Writing announce string", null, 4, null);
                    CommandQueue commandQueue2 = ExperimentalBluetoothClient.access$getCommandQueue(this.this$0);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    UUID uUID = BleExtensionsKt.getCHAR_UUID_ANNOUNCE();
                    byte[] byArray = ExperimentalBluetoothClient.access$getScanningAnnounce$p(this.this$0).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    commandQueue2.enqueueCommand(new CharacteristicWrite(bluetoothDevice, uUID, 2, byArray));
                } else {
                    DittoLog.w$default("ExperimentalBluetoothClient", "Unable to find ANNOUNCE characteristic on peripheral", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                }
            }

            public void onMtuChanged(@NotNull BluetoothGatt gatt, int rawMtu, int status) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                int mtu = rawMtu - 3;
                if (status != 0) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "onMtuChanged() failed for " + gatt.getDevice().getAddress() + ", status " + status, null, 4, null);
                }
                DittoLog.d$default("ExperimentalBluetoothClient", "MTU changed to " + mtu, null, 4, null);
                Map map = ExperimentalBluetoothClient.access$getPeripheralMTUs$p(this.this$0);
                String string = gatt.getDevice().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                String string2 = string;
                Integer n = mtu;
                map.put(string2, n);
                ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, gatt, mtu){
                    final /* synthetic */ ExperimentalBluetoothClient this$0;
                    final /* synthetic */ BluetoothGatt $gatt;
                    final /* synthetic */ int $mtu;
                    {
                        this.this$0 = $receiver;
                        this.$gatt = $gatt;
                        this.$mtu = $mtu;
                        super(0);
                    }

                    public final void invoke() {
                        ExperimentalBluetoothPlatform experimentalBluetoothPlatform = ExperimentalBluetoothClient.access$getPlatform$p(this.this$0);
                        String string = this.$gatt.getDevice().getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gatt.device.address");
                        experimentalBluetoothPlatform.peripheralMtuUpdated(BleExtensionsKt.toAddressBytes(string), this.$mtu);
                    }
                }));
                if (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof MtuRequest) {
                    T t = ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation();
                    Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type live.ditto.transports.ble.MtuRequest");
                    if (Intrinsics.areEqual((Object)((MtuRequest)t).getDevice(), (Object)gatt.getDevice())) {
                        ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                    }
                }
            }

            public void onServiceChanged(@NotNull BluetoothGatt gatt) {
                Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
                DittoLog.d$default("ExperimentalBluetoothClient", "onServiceChanged for " + gatt.getDevice().getAddress() + ", re-discovering services", null, 4, null);
                if (!gatt.discoverServices()) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "Failed to begin service discovery for device " + gatt.getDevice().getAddress() + ", disconnecting", null, 4, null);
                    BluetoothDevice bluetoothDevice = gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this.this$0, bluetoothDevice);
                }
            }

            public void onPhyUpdate(@Nullable BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
                if (status != 0) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "Update phy failed, status: " + status, null, 4, null);
                } else {
                    DittoLog.d$default("ExperimentalBluetoothClient", "Phy updated: tx = " + txPhy + ", rx = " + rxPhy, null, 4, null);
                }
                if (ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).getPendingOperation() instanceof Prefer2MPhy) {
                    ExperimentalBluetoothClient.access$getCommandQueue(this.this$0).completePendingCommand();
                }
            }

            public void onPhyRead(@Nullable BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
                DittoLog.w$default("ExperimentalBluetoothClient", "onPhyRead() triggered, but not used by platform", null, 4, null);
            }

            private static final void onConnectionStateChange$lambda-1$lambda-0(BluetoothGatt $it) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                $it.close();
            }

            private static final void onConnectionStateChange$lambda-2(BluetoothGatt $gatt, ExperimentalBluetoothClient this$0) {
                Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (!$gatt.discoverServices()) {
                    DittoLog.e$default("ExperimentalBluetoothClient", "Failed to begin service discovery for device " + $gatt.getDevice().getAddress() + ", disconnecting.", null, 4, null);
                    BluetoothDevice bluetoothDevice = $gatt.getDevice();
                    Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"gatt.device");
                    ExperimentalBluetoothClient.access$disconnectDevice(this$0, bluetoothDevice);
                }
            }
        };
    }

    public final boolean getShouldScan$dittocpp_release() {
        return this.shouldScan;
    }

    private final CommandQueue<BleClientOperation> getCommandQueue() {
        Lazy lazy = this.commandQueue$delegate;
        return (CommandQueue)lazy.getValue();
    }

    public final synchronized void connect(@NotNull byte[] peripheralUuid) {
        BluetoothDevice device;
        String address;
        block12: {
            block11: {
                boolean bl;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
                    address = BleExtensionsKt.toAddressString(peripheralUuid);
                    device = this.uuidDeviceMap.get(address);
                    BluetoothGatt gatt = (BluetoothGatt)((Map)this.deviceGattMap).get(device);
                    if (gatt != null) {
                        DittoLog.d$default(TAG, "Peripheral " + address + " already has active GATT, ignoring", null, 4, null);
                        return;
                    }
                    Iterable $this$any$iv = this.getCommandQueue();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            BleClientOperation it = (BleClientOperation)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof Connect && Intrinsics.areEqual((Object)it.getDevice(), (Object)device))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) break block11;
                if (!(this.getCommandQueue().getPendingOperation() instanceof Connect)) break block12;
                BleClientOperation bleClientOperation = this.getCommandQueue().getPendingOperation();
                if (!Intrinsics.areEqual((Object)(bleClientOperation != null ? bleClientOperation.getDevice() : null), (Object)device)) break block12;
            }
            DittoLog.d$default(TAG, "Peripheral " + address + " already existing Connect request queued, ignoring", null, 4, null);
            return;
        }
        if (device != null) {
            DittoLog.d$default(TAG, "Queuing request to connect to " + address + ".", null, 4, null);
            this.getCommandQueue().enqueueCommand(new Connect(device, this.context));
        } else {
            DittoLog.w$default(TAG, "Request to " + address + " failed, as it's not in the BLE known devices", null, 4, null);
        }
    }

    public final void disconnect(@NotNull byte[] peripheralUuid) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        String addressString = BleExtensionsKt.toAddressString(peripheralUuid);
        DittoLog.w$default(TAG, "Disconnect requested for peripheral uuid " + addressString, null, 4, null);
        BluetoothDevice device = this.uuidDeviceMap.get(addressString);
        if (device != null) {
            this.disconnectDevice(device);
        }
    }

    public final synchronized void startScanning(@NotNull byte[] serviceUuidBytes, @NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)serviceUuidBytes, (String)"serviceUuidBytes");
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        DittoLog.i$default(TAG, "Asked to start scanning", null, 4, null);
        this.platform.setServiceUuid$dittocpp_release(BleExtensionsKt.toUuid(serviceUuidBytes));
        this.scanningAnnounce = announce;
        this.shouldScan = true;
        this.mainHandler.post(() -> ExperimentalBluetoothClient.startScanning$lambda-1(this));
    }

    public final synchronized void stopScanning() {
        this.shouldScan = false;
        this.mainHandler.post(() -> ExperimentalBluetoothClient.stopScanning$lambda-2(this));
    }

    public final synchronized void close() {
        this.doStopScanning();
        this.clearScanningRetry();
        this.clearScanTimer();
        Map $this$forEach$iv = this.clientL2capChannels;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            ((L2capConnection)it.getValue()).close();
        }
        this.clientL2capChannels.clear();
        this.uuidDeviceMap.clear();
        this.deviceGattMap.clear();
        this.getCommandQueue().clear();
    }

    @NotNull
    public final synchronized SendResult_t sendGatt(@NotNull BleDataType_t sendType, @NotNull byte[] peripheralUuid, @NotNull byte[] data) {
        SendResult_t sendResult_t;
        BluetoothGattCharacteristic meshDataChar;
        Intrinsics.checkNotNullParameter((Object)sendType, (String)"sendType");
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String address = BleExtensionsKt.toAddressString(peripheralUuid);
        DittoLog.v$default(TAG, "Asked to write to peripheral " + address, null, 4, null);
        BluetoothDevice device = this.uuidDeviceMap.get(BleExtensionsKt.toAddressString(peripheralUuid));
        if (device == null) {
            SendResult_t sendResult_t2;
            DittoLog.w$default(TAG, "Asked to write to unknown device", null, 4, null);
            SendResult_t it = sendResult_t2 = new SendResult_t();
            boolean bl = false;
            it.setWait_for_ready(false);
            it.setAccepted(false);
            return sendResult_t2;
        }
        BluetoothGatt gatt = this.deviceGattMap.get(device);
        if (gatt == null) {
            SendResult_t it;
            DittoLog.w$default(TAG, "Asked to write to unknown Gatt", null, 4, null);
            SendResult_t it2 = it = new SendResult_t();
            boolean bl = false;
            it2.setWait_for_ready(false);
            it2.setAccepted(false);
            return it;
        }
        UUID charUuid = BleExtensionsKt.getCHAR_UUID_WRITE();
        if (Intrinsics.areEqual((Object)sendType, (Object)BleDataType_t.BLE_DATA_TYPE_CONTROL)) {
            charUuid = BleExtensionsKt.getCHAR_UUID_CONTROL_WRITE();
        }
        if ((meshDataChar = BleExtensionsKt.findCharacteristic(gatt, charUuid)) == null) {
            SendResult_t sendResult_t3;
            DittoLog.w$default(TAG, "Asked to write to a Gatt that didn't have the Write char", null, 4, null);
            SendResult_t it = sendResult_t3 = new SendResult_t();
            boolean bl = false;
            it.setWait_for_ready(false);
            it.setAccepted(false);
            return sendResult_t3;
        }
        this.getCommandQueue().enqueueCommand(new CharacteristicWrite(device, charUuid, 1, data));
        SendResult_t it = sendResult_t = new SendResult_t();
        boolean bl = false;
        it.setWait_for_ready(true);
        it.setAccepted(true);
        return sendResult_t;
    }

    public final synchronized int readL2cap(@NotNull byte[] peripheralUuid, @NotNull slice_mut_uint8_t data) {
        int n;
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String address = BleExtensionsKt.toAddressString(peripheralUuid);
        L2capConnection conn = this.clientL2capChannels.get(address);
        if (conn == null) {
            DittoLog.w$default(TAG, "readL2capFromPeripheral called for " + address + " without open L2CAP connection", null, 4, null);
            return -1;
        }
        byte[] incomingData = conn.read((int)data.getCapacity());
        if (incomingData != null) {
            data.setValue(incomingData);
            n = incomingData.length;
        } else {
            n = -2;
        }
        return n;
    }

    public final synchronized int sendL2cap(@NotNull byte[] peripheralUuid, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String address = BleExtensionsKt.toAddressString(peripheralUuid);
        L2capConnection conn = this.clientL2capChannels.get(address);
        if (conn == null) {
            DittoLog.w$default(TAG, "sendL2capFromPeripheral called for " + address + " without open L2CAP connection", null, 4, null);
            return -1;
        }
        return conn.send(data) ? data.length : 0;
    }

    public final synchronized void restartScan() {
        DittoLog.i$default(TAG, "Restarting scan", null, 4, null);
        this.doStopScanning();
        this.mainHandler.postDelayed(() -> ExperimentalBluetoothClient.restartScan$lambda-8(this), 1000L);
    }

    private final void doStartScanning() {
        ScanSettings scanSettings;
        Context context = this.context;
        UUID serviceUuid = this.platform.getServiceUuid$dittocpp_release();
        BluetoothAdapter adapter = this.platform.getAdapter$dittocpp_release();
        if (!this.shouldScan || this.isScanning || serviceUuid == null) {
            DittoLog.e$default(TAG, "doStartScanning() called missing prerequisites. isScanning: " + this.isScanning + ", shouldScan: " + this.shouldScan + ", serviceUuid: " + serviceUuid, null, 4, null);
            return;
        }
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            DittoLog.i$default(TAG, "Android Bluetooth not starting scanning because hardware is disabled", null, 4, null);
            this.platform.postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ExperimentalBluetoothClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
                }
            }));
        }
        if (!(new DittoSyncPermissions(context).missingBluetoothClientPermissions$dittocpp_release().length == 0)) {
            DittoLog.e$default(TAG, "Ditto Bluetooth LE sync is restricted due to missing Bluetooth permissions. Please check both AndroidManifest.xml and calls to ActivityCompat.requestPermissions(). <https://docs.ditto.live/android/installation#android-platform-permissions>", null, 4, null);
            this.platform.postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ExperimentalBluetoothClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_NO_BLE_CENTRAL_PERMISSION);
                }
            }));
            DittoLog.i$default(TAG, "retrying BLE scanning after delay.", null, 4, null);
            this.startScanningRetryTimer();
            return;
        }
        ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUuid)).build();
        ArrayList<ScanFilter> filterList = new ArrayList<ScanFilter>();
        filterList.add(filter);
        ScanSettings.Builder builder = new ScanSettings.Builder().setReportDelay(0L).setCallbackType(1).setMatchMode(1).setScanMode(1).setNumOfMatches(1);
        if (Build.VERSION.SDK_INT >= 26) {
            if (adapter.isLe2MPhySupported()) {
                this.use2MPhy = true;
            }
            scanSettings = builder.setPhy(1).setLegacy(false).build();
        } else {
            scanSettings = builder.build();
        }
        ScanSettings settings = scanSettings;
        adapter.getBluetoothLeScanner().startScan((List)filterList, settings, this.scanCallback);
        this.startScanTimer();
        this.isScanning = true;
        this.platform.postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ExperimentalBluetoothClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).scanningStateChanged(OnlineState_t.ONLINE_STATE_ONLINE, TransportCondition_t.TRANSPORT_CONDITION_OK);
            }
        }));
        DittoLog.i$default(TAG, "Started Bluetooth scan", null, 4, null);
    }

    private final void doStopScanning() {
        if (!this.isScanning) {
            DittoLog.w$default(TAG, "doStopScanning called, but scan is not running", null, 4, null);
            return;
        }
        BluetoothAdapter adapter = this.platform.getAdapter$dittocpp_release();
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            this.platform.postOnDitto$dittocpp_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ExperimentalBluetoothClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExperimentalBluetoothClient.access$getPlatform$p(this.this$0).scanningStateChanged(OnlineState_t.ONLINE_STATE_OFFLINE, TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
                }
            }));
            return;
        }
        this.clearScanTimer();
        try {
            scanner.stopScan(this.scanCallback);
        }
        catch (Exception e) {
            DittoLog.e$default(TAG, "Exception caught when stopping scan: " + e, null, 4, null);
        }
        DittoLog.i$default(TAG, "Stopped scanning", null, 4, null);
        this.isScanning = false;
    }

    private final synchronized void disconnectDevice(BluetoothDevice device) {
        this.getCommandQueue().enqueueCommand(new Disconnect(device));
    }

    private final synchronized void cleanupDisconnectedGatt(BluetoothGatt gatt) {
        BluetoothDevice device = gatt.getDevice();
        this.deviceGattMap.remove(gatt.getDevice());
        this.mainHandler.post(() -> ExperimentalBluetoothClient.cleanupDisconnectedGatt$lambda-9(gatt));
        this.uuidDeviceMap.remove(device.getAddress());
        L2capConnection l2capConnection = this.clientL2capChannels.remove(device.getAddress());
        if (l2capConnection != null) {
            l2capConnection.close();
        }
        BleExtensionsKt.removeIfCompat((ConcurrentLinkedQueue)this.getCommandQueue(), (Function1)new Function1<BleClientOperation, Boolean>(device){
            final /* synthetic */ BluetoothDevice $device;
            {
                this.$device = $device;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BleClientOperation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getDevice(), (Object)this.$device);
            }
        });
        ConcurrentHashMap<String, ExperimentalBluetoothPlatform.PlatformType> concurrentHashMap = this.platform.getDeviceLocks$dittocpp_release();
        String string = device.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.address");
        BleExtensionsKt.computeIfPresentCompat(concurrentHashMap, string, cleanupDisconnectedGatt.3.INSTANCE);
        BleClientOperation bleClientOperation = this.getCommandQueue().getPendingOperation();
        if (Intrinsics.areEqual((Object)(bleClientOperation != null ? bleClientOperation.getDevice() : null), (Object)device)) {
            this.getCommandQueue().completePendingCommand();
        }
    }

    private final void startScanTimer() {
        this.clearScanTimer();
        Runnable runnable = this.scanningTimeoutRunnable = () -> ExperimentalBluetoothClient.startScanTimer$lambda-10(this);
        Intrinsics.checkNotNull((Object)runnable);
        this.mainHandler.postDelayed(runnable, 180000L);
    }

    private final void clearScanTimer() {
        block0: {
            Runnable runnable = this.scanningTimeoutRunnable;
            if (runnable == null) break block0;
            Runnable it = runnable;
            boolean bl = false;
            this.mainHandler.removeCallbacks(it);
            this.scanningTimeoutRunnable = null;
            DittoLog.v$default(TAG, "Cleared scan timeout task", null, 4, null);
        }
    }

    private final void startScanningRetryTimer() {
        Runnable timeoutRunnable;
        Runnable runnable = this.retryTimeoutRunnable = (timeoutRunnable = () -> ExperimentalBluetoothClient.startScanningRetryTimer$lambda-12(this));
        Intrinsics.checkNotNull((Object)runnable);
        this.mainHandler.postDelayed(runnable, 10000L);
    }

    private final void clearScanningRetry() {
        block0: {
            Runnable runnable = this.retryTimeoutRunnable;
            if (runnable == null) break block0;
            Runnable it = runnable;
            boolean bl = false;
            this.mainHandler.removeCallbacks(it);
            DittoLog.v$default(TAG, "cleared out scanning retry timer", null, 4, null);
            this.retryTimeoutRunnable = null;
        }
    }

    private static final void startScanning$lambda-1(ExperimentalBluetoothClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStartScanning();
    }

    private static final void stopScanning$lambda-2(ExperimentalBluetoothClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doStopScanning();
    }

    private static final void restartScan$lambda-8(ExperimentalBluetoothClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.shouldScan) {
            this$0.doStartScanning();
        }
    }

    private static final void cleanupDisconnectedGatt$lambda-9(BluetoothGatt $gatt) {
        Intrinsics.checkNotNullParameter((Object)$gatt, (String)"$gatt");
        $gatt.close();
    }

    private static final void startScanTimer$lambda-10(ExperimentalBluetoothClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DittoLog.d$default(TAG, "Scan timeout reached", null, 4, null);
        this$0.restartScan();
    }

    private static final void startScanningRetryTimer$lambda-12(ExperimentalBluetoothClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.shouldScan) {
            this$0.doStartScanning();
        }
    }

    public static final /* synthetic */ ExperimentalBluetoothPlatform access$getPlatform$p(ExperimentalBluetoothClient $this) {
        return $this.platform;
    }

    public static final /* synthetic */ Handler access$getMainHandler$p(ExperimentalBluetoothClient $this) {
        return $this.mainHandler;
    }

    public static final /* synthetic */ CommandQueueCallback access$getCommandCallback$p(ExperimentalBluetoothClient $this) {
        return $this.commandCallback;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDeviceGattMap$p(ExperimentalBluetoothClient $this) {
        return $this.deviceGattMap;
    }

    public static final /* synthetic */ CommandQueue access$getCommandQueue(ExperimentalBluetoothClient $this) {
        return $this.getCommandQueue();
    }

    public static final /* synthetic */ void access$disconnectDevice(ExperimentalBluetoothClient $this, BluetoothDevice device) {
        $this.disconnectDevice(device);
    }

    public static final /* synthetic */ BluetoothGattCallback access$getGattCallback$p(ExperimentalBluetoothClient $this) {
        return $this.gattCallback;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getClientL2capChannels$p(ExperimentalBluetoothClient $this) {
        return $this.clientL2capChannels;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getUuidDeviceMap$p(ExperimentalBluetoothClient $this) {
        return $this.uuidDeviceMap;
    }

    public static final /* synthetic */ void access$startScanningRetryTimer(ExperimentalBluetoothClient $this) {
        $this.startScanningRetryTimer();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDeviceStates$p(ExperimentalBluetoothClient $this) {
        return $this.deviceStates;
    }

    public static final /* synthetic */ boolean access$getUse2MPhy$p(ExperimentalBluetoothClient $this) {
        return $this.use2MPhy;
    }

    public static final /* synthetic */ void access$cleanupDisconnectedGatt(ExperimentalBluetoothClient $this, BluetoothGatt gatt) {
        $this.cleanupDisconnectedGatt(gatt);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPeripheralMTUs$p(ExperimentalBluetoothClient $this) {
        return $this.peripheralMTUs;
    }

    public static final /* synthetic */ String access$getScanningAnnounce$p(ExperimentalBluetoothClient $this) {
        return $this.scanningAnnounce;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Llive/ditto/transports/ble/ExperimentalBluetoothClient$Companion;", "", "()V", "CONNECTION_CALLBACK_TIMEOUT_MS", "", "SCAN_PERMISSIONS_RETRY_WAIT_MS", "SCAN_RESTART_INTERVAL_MS", "SCAN_START_AFTER_STOP_WAIT_MS", "TAG", "", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

