/*
 * Decompiled with CFR 0.152.
 */
package live.ditto.transports.ble;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.os.Handler;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.ditto.DittoLog;
import live.ditto.internal.swig.ffi.BleDataType_t;
import live.ditto.internal.swig.ffi.BluetoothLeRadioRust;
import live.ditto.internal.swig.ffi.OnlineState_t;
import live.ditto.internal.swig.ffi.SendResult_t;
import live.ditto.internal.swig.ffi.TransportCondition_t;
import live.ditto.internal.swig.ffi.slice_mut_uint8_t;
import live.ditto.transports.ble.BleExtensionsKt;
import live.ditto.transports.ble.DittoBluetoothManager;
import live.ditto.transports.ble.ExperimentalBluetoothClient;
import live.ditto.transports.ble.ExperimentalBluetoothPlatform;
import live.ditto.transports.ble.ExperimentalBluetoothServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0001\u0018\u0000 W2\u00020\u0001:\u0002WXB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002012\u0006\u00103\u001a\u000204H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000207H\u0016J \u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002042\u0006\u0010>\u001a\u000204H\u0016J#\u0010?\u001a\u0002012\f\u0010@\u001a\b\u0012\u0004\u0012\u0002010A2\u0006\u0010B\u001a\u00020CH\u0000\u00a2\u0006\u0002\bDJ\u001b\u0010E\u001a\u0002012\f\u0010@\u001a\b\u0012\u0004\u0012\u0002010AH\u0000\u00a2\u0006\u0002\bFJ\u0018\u0010G\u001a\u00020H2\u0006\u0010=\u001a\u0002042\u0006\u0010>\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020H2\u0006\u00103\u001a\u0002042\u0006\u0010>\u001a\u00020IH\u0016J\u0006\u0010K\u001a\u000201J\u0006\u0010L\u001a\u000201J\u0018\u0010M\u001a\u00020H2\u0006\u0010=\u001a\u0002042\u0006\u0010>\u001a\u000204H\u0016J\u0018\u0010N\u001a\u00020H2\u0006\u00103\u001a\u0002042\u0006\u0010>\u001a\u000204H\u0016J\u0018\u0010O\u001a\u0002012\u0006\u0010(\u001a\u0002042\u0006\u0010P\u001a\u00020\u0017H\u0016J\u0018\u0010Q\u001a\u0002012\u0006\u0010R\u001a\u0002042\u0006\u0010S\u001a\u00020\u0017H\u0016J\b\u0010T\u001a\u000201H\u0016J\b\u0010U\u001a\u000201H\u0016J \u0010V\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u00103\u001a\u0002042\u0006\u0010>\u001a\u000204H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010!\u001a\u00020\u001c8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010 \u001a\u0004\b\"\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006Y"}, d2={"Llive/ditto/transports/ble/ExperimentalBluetoothPlatform;", "Llive/ditto/internal/swig/ffi/BluetoothLeRadioRust;", "manager", "Llive/ditto/transports/ble/DittoBluetoothManager;", "context", "Landroid/content/Context;", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "(Llive/ditto/transports/ble/DittoBluetoothManager;Landroid/content/Context;Landroid/bluetooth/BluetoothAdapter;)V", "getAdapter$dittocpp_release", "()Landroid/bluetooth/BluetoothAdapter;", "setAdapter$dittocpp_release", "(Landroid/bluetooth/BluetoothAdapter;)V", "client", "Llive/ditto/transports/ble/ExperimentalBluetoothClient;", "getClient$dittocpp_release", "()Llive/ditto/transports/ble/ExperimentalBluetoothClient;", "getContext$dittocpp_release", "()Landroid/content/Context;", "setContext$dittocpp_release", "(Landroid/content/Context;)V", "deviceLocks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Llive/ditto/transports/ble/ExperimentalBluetoothPlatform$PlatformType;", "getDeviceLocks$dittocpp_release", "()Ljava/util/concurrent/ConcurrentHashMap;", "dittoHandler", "Landroid/os/Handler;", "getDittoHandler", "()Landroid/os/Handler;", "dittoHandler$delegate", "Lkotlin/Lazy;", "l2capHandler", "getL2capHandler$dittocpp_release", "l2capHandler$delegate", "getManager", "()Llive/ditto/transports/ble/DittoBluetoothManager;", "server", "Llive/ditto/transports/ble/ExperimentalBluetoothServer;", "serviceUuid", "Ljava/util/UUID;", "getServiceUuid$dittocpp_release", "()Ljava/util/UUID;", "setServiceUuid$dittocpp_release", "(Ljava/util/UUID;)V", "appIsInForeground", "", "close", "", "connectPeripheral", "peripheralUuid", "", "disconnectPeripheral", "getAdvertisingState", "Llive/ditto/internal/swig/ffi/OnlineState_t;", "getScanningState", "notifyToCentral", "Llive/ditto/internal/swig/ffi/SendResult_t;", "sendType", "Llive/ditto/internal/swig/ffi/BleDataType_t;", "centralUuid", "data", "postDelayedOnDitto", "fn", "Lkotlin/Function0;", "delay", "", "postDelayedOnDitto$dittocpp_release", "postOnDitto", "postOnDitto$dittocpp_release", "readL2capFromCentral", "", "Llive/ditto/internal/swig/ffi/slice_mut_uint8_t;", "readL2capFromPeripheral", "refreshPermissions", "reportDisabled", "sendL2capToCentral", "sendL2capToPeripheral", "startAdvertising", "localName", "startScanning", "serviceUuidBytes", "announce", "stopAdvertising", "stopScanning", "writeToPeripheral", "Companion", "PlatformType", "dittocpp_release"})
@SuppressLint(value={"MissingPermission"})
public final class ExperimentalBluetoothPlatform
extends BluetoothLeRadioRust {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DittoBluetoothManager manager;
    @NotNull
    private Context context;
    @NotNull
    private BluetoothAdapter adapter;
    @NotNull
    private final Lazy dittoHandler$delegate;
    @NotNull
    private final Lazy l2capHandler$delegate;
    @NotNull
    private final ExperimentalBluetoothClient client;
    @NotNull
    private final ExperimentalBluetoothServer server;
    @NotNull
    private final ConcurrentHashMap<String, PlatformType> deviceLocks;
    @Nullable
    private UUID serviceUuid;
    @NotNull
    private static final String TAG = "ExperimentalBluetoothPlatform";
    public static final long WRITE_DELAY_MS = 5L;
    public static final int BLE_ADVANCED_SUPPORT_VERSION = 26;
    public static final int L2CAP_SUPPORTED_VERSION = 29;

    public ExperimentalBluetoothPlatform(@NotNull DittoBluetoothManager manager2, @NotNull Context context, @NotNull BluetoothAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.manager = manager2;
        this.context = context;
        this.adapter = adapter;
        this.dittoHandler$delegate = LazyKt.lazy((Function0)dittoHandler.2.INSTANCE);
        this.l2capHandler$delegate = LazyKt.lazy((Function0)l2capHandler.2.INSTANCE);
        this.client = new ExperimentalBluetoothClient(this);
        this.server = new ExperimentalBluetoothServer(this);
        this.deviceLocks = new ConcurrentHashMap();
    }

    @NotNull
    public final DittoBluetoothManager getManager() {
        return this.manager;
    }

    @NotNull
    public final Context getContext$dittocpp_release() {
        return this.context;
    }

    public final void setContext$dittocpp_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @NotNull
    public final BluetoothAdapter getAdapter$dittocpp_release() {
        return this.adapter;
    }

    public final void setAdapter$dittocpp_release(@NotNull BluetoothAdapter bluetoothAdapter) {
        Intrinsics.checkNotNullParameter((Object)bluetoothAdapter, (String)"<set-?>");
        this.adapter = bluetoothAdapter;
    }

    private final Handler getDittoHandler() {
        Lazy lazy = this.dittoHandler$delegate;
        return (Handler)lazy.getValue();
    }

    @NotNull
    public final Handler getL2capHandler$dittocpp_release() {
        Lazy lazy = this.l2capHandler$delegate;
        return (Handler)lazy.getValue();
    }

    @NotNull
    public final ExperimentalBluetoothClient getClient$dittocpp_release() {
        return this.client;
    }

    @NotNull
    public final ConcurrentHashMap<String, PlatformType> getDeviceLocks$dittocpp_release() {
        return this.deviceLocks;
    }

    @Nullable
    public final UUID getServiceUuid$dittocpp_release() {
        return this.serviceUuid;
    }

    public final void setServiceUuid$dittocpp_release(@Nullable UUID uUID) {
        this.serviceUuid = uUID;
    }

    @Override
    public void connectPeripheral(@NotNull byte[] peripheralUuid) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        this.client.connect(peripheralUuid);
    }

    @Override
    public void disconnectPeripheral(@NotNull byte[] peripheralUuid) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        this.client.disconnect(peripheralUuid);
    }

    @Override
    @NotNull
    public OnlineState_t getAdvertisingState() {
        OnlineState_t onlineState_t;
        if (this.server.isAdvertising()) {
            OnlineState_t onlineState_t2 = OnlineState_t.ONLINE_STATE_ONLINE;
            onlineState_t = onlineState_t2;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t2, (String)"ONLINE_STATE_ONLINE");
        } else {
            OnlineState_t onlineState_t3 = OnlineState_t.ONLINE_STATE_GOING_OFFLINE;
            onlineState_t = onlineState_t3;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t3, (String)"ONLINE_STATE_GOING_OFFLINE");
        }
        return onlineState_t;
    }

    @Override
    @NotNull
    public OnlineState_t getScanningState() {
        OnlineState_t onlineState_t;
        if (this.client.getShouldScan$dittocpp_release()) {
            OnlineState_t onlineState_t2 = OnlineState_t.ONLINE_STATE_ONLINE;
            onlineState_t = onlineState_t2;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t2, (String)"ONLINE_STATE_ONLINE");
        } else {
            OnlineState_t onlineState_t3 = OnlineState_t.ONLINE_STATE_GOING_OFFLINE;
            onlineState_t = onlineState_t3;
            Intrinsics.checkNotNullExpressionValue((Object)onlineState_t3, (String)"ONLINE_STATE_GOING_OFFLINE");
        }
        return onlineState_t;
    }

    @Override
    public void startAdvertising(@NotNull byte[] serviceUuid, @NotNull String localName) {
        Intrinsics.checkNotNullParameter((Object)serviceUuid, (String)"serviceUuid");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        this.server.startAdvertising(serviceUuid, localName);
    }

    @Override
    public void startScanning(@NotNull byte[] serviceUuidBytes, @NotNull String announce) {
        Intrinsics.checkNotNullParameter((Object)serviceUuidBytes, (String)"serviceUuidBytes");
        Intrinsics.checkNotNullParameter((Object)announce, (String)"announce");
        this.client.startScanning(serviceUuidBytes, announce);
    }

    @Override
    public void stopAdvertising() {
        this.server.stopAdvertising();
    }

    @Override
    public void stopScanning() {
        this.client.stopScanning();
    }

    @Override
    @NotNull
    public synchronized SendResult_t writeToPeripheral(@NotNull BleDataType_t sendType, @NotNull byte[] peripheralUuid, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)sendType, (String)"sendType");
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.client.sendGatt(sendType, peripheralUuid, data);
    }

    @Override
    @NotNull
    public synchronized SendResult_t notifyToCentral(@NotNull BleDataType_t sendType, @NotNull byte[] centralUuid, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)sendType, (String)"sendType");
        Intrinsics.checkNotNullParameter((Object)centralUuid, (String)"centralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.server.sendGatt(sendType, centralUuid, data);
    }

    @Override
    public int readL2capFromPeripheral(@NotNull byte[] peripheralUuid, @NotNull slice_mut_uint8_t data) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.client.readL2cap(peripheralUuid, data);
    }

    @Override
    public int sendL2capToPeripheral(@NotNull byte[] peripheralUuid, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)peripheralUuid, (String)"peripheralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.client.sendL2cap(peripheralUuid, data);
    }

    @Override
    public int readL2capFromCentral(@NotNull byte[] centralUuid, @NotNull slice_mut_uint8_t data) {
        Intrinsics.checkNotNullParameter((Object)centralUuid, (String)"centralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.server.l2capReceive(BleExtensionsKt.toAddressString(centralUuid), data);
    }

    @Override
    public int sendL2capToCentral(@NotNull byte[] centralUuid, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)centralUuid, (String)"centralUuid");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.server.l2capSend(BleExtensionsKt.toAddressString(centralUuid), data);
    }

    @Override
    public boolean appIsInForeground() {
        return this.manager.getInForeground$dittocpp_release();
    }

    @Override
    public void close() {
        DittoLog.i$default(TAG, "Closing.", null, 4, null);
        super.close();
        this.stopScanning();
        this.stopAdvertising();
        this.client.close();
        this.getDittoHandler().getLooper().quitSafely();
        this.dropBleServerTransport();
        this.dropBleClientTransport();
    }

    public final void reportDisabled() {
        this.getDittoHandler().post(() -> ExperimentalBluetoothPlatform.reportDisabled$lambda-0(this));
        this.advertisingStateChanged(this.getAdvertisingState(), TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
    }

    public final void refreshPermissions() {
        new Handler(this.context.getMainLooper()).post(() -> ExperimentalBluetoothPlatform.refreshPermissions$lambda-1(this));
    }

    public final void postOnDitto$dittocpp_release(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        if (!this.getDittoHandler().getLooper().getThread().isAlive()) {
            DittoLog.w$default(TAG, "Ditto handler thread isn't alive, could not post. This is fine if this is during Ditto's shutdown.", null, 4, null);
            return;
        }
        this.getDittoHandler().post(() -> ExperimentalBluetoothPlatform.postOnDitto$lambda-2(fn));
    }

    public final void postDelayedOnDitto$dittocpp_release(@NotNull Function0<Unit> fn, long delay) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        if (!this.getDittoHandler().getLooper().getThread().isAlive()) {
            DittoLog.w$default(TAG, "Ditto handler thread isn't alive, could not post. This is fine if this is during Ditto's shutdown.", null, 4, null);
            return;
        }
        this.getDittoHandler().postDelayed(() -> ExperimentalBluetoothPlatform.postDelayedOnDitto$lambda-3(fn), delay);
    }

    private static final void reportDisabled$lambda-0(ExperimentalBluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scanningStateChanged(this$0.getScanningState(), TransportCondition_t.TRANSPORT_CONDITION_BLE_DISABLED);
    }

    private static final void refreshPermissions$lambda-1(ExperimentalBluetoothPlatform this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.client.restartScan();
    }

    private static final void postOnDitto$lambda-2(Function0 $fn) {
        Intrinsics.checkNotNullParameter((Object)$fn, (String)"$fn");
        $fn.invoke();
    }

    private static final void postDelayedOnDitto$lambda-3(Function0 $fn) {
        Intrinsics.checkNotNullParameter((Object)$fn, (String)"$fn");
        $fn.invoke();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Llive/ditto/transports/ble/ExperimentalBluetoothPlatform$Companion;", "", "()V", "BLE_ADVANCED_SUPPORT_VERSION", "", "L2CAP_SUPPORTED_VERSION", "TAG", "", "WRITE_DELAY_MS", "", "dittocpp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Llive/ditto/transports/ble/ExperimentalBluetoothPlatform$PlatformType;", "", "(Ljava/lang/String;I)V", "CLIENT", "SERVER", "dittocpp_release"})
    public static final class PlatformType
    extends Enum<PlatformType> {
        public static final /* enum */ PlatformType CLIENT = new PlatformType();
        public static final /* enum */ PlatformType SERVER = new PlatformType();
        private static final /* synthetic */ PlatformType[] $VALUES;

        public static PlatformType[] values() {
            return (PlatformType[])$VALUES.clone();
        }

        public static PlatformType valueOf(String value) {
            return Enum.valueOf(PlatformType.class, value);
        }

        static {
            $VALUES = platformTypeArray = new PlatformType[]{PlatformType.CLIENT, PlatformType.SERVER};
        }
    }
}

