/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Optional;
import live.lingting.virtual.currency.core.Contract;
import live.lingting.virtual.currency.core.model.Account;
import live.lingting.virtual.currency.core.model.TransactionInfo;
import live.lingting.virtual.currency.core.model.TransferParams;
import live.lingting.virtual.currency.core.model.TransferResult;

public interface PlatformService<G> {
    public Optional<TransactionInfo> getTransactionByHash(String var1) throws Exception;

    public Integer getDecimalsByContract(Contract var1) throws Exception;

    public BigInteger getBalanceByAddressAndContract(String var1, Contract var2) throws Exception;

    default public BigDecimal getNumberByAddressAndContract(String address, Contract contract) throws Exception {
        return this.getNumberByBalanceAndContract(this.getBalanceByAddressAndContract(address, contract), contract);
    }

    default public BigDecimal getNumberByBalanceAndContract(BigInteger balance, Contract contract) throws Exception {
        return this.getNumberByBalanceAndContract(balance, contract, MathContext.UNLIMITED);
    }

    public BigDecimal getNumberByBalanceAndContract(BigInteger var1, Contract var2, MathContext var3) throws Exception;

    default public BigInteger valueToBalanceByContract(BigDecimal value, Contract contract) throws Exception {
        return value.multiply(BigDecimal.TEN.pow(this.getDecimalsByContract(contract))).toBigInteger();
    }

    default public TransferResult transfer(Account from, String to, Contract contract, BigDecimal value) throws Exception {
        return this.transfer(from, to, contract, value, new TransferParams());
    }

    public G transactionGenerate(Account var1, String var2, Contract var3, BigDecimal var4, TransferParams var5) throws Exception;

    public G transactionSign(G var1) throws Exception;

    public TransferResult transactionBroadcast(G var1) throws Exception;

    default public TransferResult transfer(Account from, String to, Contract contract, BigDecimal value, TransferParams params) throws Exception {
        return this.transactionBroadcast(this.transactionSign(this.transactionGenerate(from, to, contract, value, params)));
    }

    public boolean validate(String var1);
}

