/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core.bip;

import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;

public class Bip32 {
    public static final String PATH_ROOT_FLAG = "m";
    public static final String PATH_SPLIT_FLAG = "/";
    public static final String PATH_HARDENED_SUFFIX = "'";
    private final DeterministicKey key;
    private final Map<ChildNumber, Bip32> map = new ConcurrentHashMap<ChildNumber, Bip32>();

    private Bip32(DeterministicKey key) {
        this.key = key;
    }

    public static Bip32 create(DeterministicKey key) {
        return new Bip32(key);
    }

    public static Bip32 create(String extKey, NetworkParameters np) {
        return Bip32.create(DeterministicKey.deserializeB58((String)extKey, (NetworkParameters)np));
    }

    public Bip32 getByChildNumber(ChildNumber child) {
        if (this.map.containsKey(child)) {
            return this.map.get(child);
        }
        Bip32 node = Bip32.create(HDKeyDerivation.deriveChildKey((DeterministicKey)this.key, (ChildNumber)child));
        this.map.put(child, node);
        return node;
    }

    public Bip32 getBipByPath(String path) {
        List<ChildNumber> list = this.getChildListByPath(path);
        if (CollectionUtil.isEmpty(list)) {
            return this;
        }
        Bip32 node = this;
        for (ChildNumber child : list) {
            node = node.getByChildNumber(child);
        }
        return node;
    }

    public DeterministicKey getKeyByPath(String path) {
        return this.getBipByPath(path).getKey();
    }

    public List<ChildNumber> getChildListByPath(String path) {
        path = path.replaceAll("\\s", "");
        String[] split = path.split(PATH_SPLIT_FLAG);
        ArrayList<ChildNumber> list = new ArrayList<ChildNumber>(split.length);
        for (String nodeStr : split) {
            if (nodeStr.equals(PATH_ROOT_FLAG)) continue;
            list.add(this.getChildByNode(nodeStr));
        }
        return list;
    }

    public ChildNumber getChildByNode(String nodeStr) {
        if (nodeStr.endsWith(PATH_HARDENED_SUFFIX)) {
            return new ChildNumber(Integer.parseInt(nodeStr.substring(0, nodeStr.length() - 1)), true);
        }
        return new ChildNumber(Integer.parseInt(nodeStr), false);
    }

    public String getExtPublicKey(NetworkParameters np) {
        return this.getKey().serializePubB58(np);
    }

    public String getExtPublic(NetworkParameters np) {
        return this.getExtPublicKey(np);
    }

    public String getExtPrivate(NetworkParameters np) {
        return this.getKey().serializePrivB58(np);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.key, ((Bip32)o).key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public DeterministicKey getKey() {
        return this.key;
    }
}

