/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core.jsonrpc.http;

import cn.hutool.http.HttpRequest;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import live.lingting.virtual.currency.core.jsonrpc.JsonRpc;
import live.lingting.virtual.currency.core.jsonrpc.JsonRpcException;
import live.lingting.virtual.currency.core.jsonrpc.http.model.JsonRpcRequest;
import live.lingting.virtual.currency.core.jsonrpc.http.model.JsonRpcResponse;
import live.lingting.virtual.currency.core.util.JacksonUtils;

public class HttpJsonRpc
implements JsonRpc {
    public static final String CONTENT_TYPE = "application/json-rpc";
    private final ObjectMapper mapper;
    private final String url;
    private final Map<String, String> headers;

    public HttpJsonRpc(ObjectMapper mapper, String url, Map<String, String> headers) {
        this.url = url;
        this.mapper = mapper;
        this.headers = headers;
    }

    public static HttpJsonRpc of(String url) {
        return HttpJsonRpc.of(url, Collections.emptyMap());
    }

    public static HttpJsonRpc of(String url, Map<String, String> headers) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        return HttpJsonRpc.of(mapper, url, headers);
    }

    public static HttpJsonRpc of(ObjectMapper mapper, String url, Map<String, String> headers) {
        return new HttpJsonRpc(mapper, url, headers);
    }

    public void config(Consumer<ObjectMapper> consumer) {
        consumer.accept(this.mapper);
    }

    @Override
    public <T> T invoke(String method, Class<T> t, Object ... args) throws JsonRpcException {
        return this.invoke(method, t, Collections.emptyMap(), args);
    }

    public <T> T invoke(String method, Class<T> t, Map<String, String> extHeaders, Object ... args) throws JsonRpcException {
        HttpRequest post = ((HttpRequest)((HttpRequest)HttpRequest.post((String)this.url).contentType(CONTENT_TYPE).addHeaders(this.headers)).addHeaders(extHeaders)).body(JsonRpcRequest.of(method, args).toString());
        String json = post.execute().body();
        JsonRpcResponse response = JacksonUtils.toObj(json, JsonRpcResponse.class);
        if (response.getError() != null) {
            throw new JsonRpcException(response.getError());
        }
        if (response.getResult() == null) {
            return null;
        }
        if (t.isAssignableFrom(String.class)) {
            return (T)response.getResult();
        }
        return JacksonUtils.toObj(JacksonUtils.toJson(response.getResult()), t);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

