/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.TimeZone;
import live.lingting.virtual.currency.core.Contract;
import live.lingting.virtual.currency.core.enums.TransactionStatus;
import live.lingting.virtual.currency.core.enums.VirtualCurrencyPlatform;

public class TransactionInfo {
    private String hash;
    private BigInteger block;
    private String from;
    private String to;
    private BigDecimal value;
    private TransactionStatus status;
    private Contract contract;
    private VirtualCurrencyPlatform virtualCurrencyPlatform;
    private LocalDateTime time;
    private Boolean btc;
    private BtcInfo btcInfo;

    public Boolean getBtc() {
        return this.btcInfo != null;
    }

    public LocalDateTime getTime() {
        return this.getTimeByZone(ZoneId.systemDefault());
    }

    public TransactionInfo setTime(LocalDateTime time) {
        this.time = time;
        return this;
    }

    public TransactionInfo setTime(long time) {
        return this.setTime(LocalDateTime.ofEpochSecond(time, 0, ZoneOffset.UTC));
    }

    public LocalDateTime getTimeByUtc() {
        return this.time;
    }

    public LocalDateTime getTimeByZone(ZoneId zoneId) {
        if (this.time == null) {
            return null;
        }
        return this.time.plusSeconds(TimeZone.getTimeZone(zoneId).getRawOffset() / 1000);
    }

    public String getHash() {
        return this.hash;
    }

    public BigInteger getBlock() {
        return this.block;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    public Contract getContract() {
        return this.contract;
    }

    public VirtualCurrencyPlatform getVirtualCurrencyPlatform() {
        return this.virtualCurrencyPlatform;
    }

    public BtcInfo getBtcInfo() {
        return this.btcInfo;
    }

    public TransactionInfo setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public TransactionInfo setBlock(BigInteger block) {
        this.block = block;
        return this;
    }

    public TransactionInfo setFrom(String from) {
        this.from = from;
        return this;
    }

    public TransactionInfo setTo(String to) {
        this.to = to;
        return this;
    }

    public TransactionInfo setValue(BigDecimal value) {
        this.value = value;
        return this;
    }

    public TransactionInfo setStatus(TransactionStatus status) {
        this.status = status;
        return this;
    }

    public TransactionInfo setContract(Contract contract) {
        this.contract = contract;
        return this;
    }

    public TransactionInfo setVirtualCurrencyPlatform(VirtualCurrencyPlatform virtualCurrencyPlatform) {
        this.virtualCurrencyPlatform = virtualCurrencyPlatform;
        return this;
    }

    public TransactionInfo setBtc(Boolean btc) {
        this.btc = btc;
        return this;
    }

    public TransactionInfo setBtcInfo(BtcInfo btcInfo) {
        this.btcInfo = btcInfo;
        return this;
    }

    public static class BtcInfo {
        private Map<String, BigDecimal> in;
        private Map<String, BigDecimal> out;
        private BigDecimal fee;

        public Map<String, BigDecimal> getIn() {
            return this.in;
        }

        public Map<String, BigDecimal> getOut() {
            return this.out;
        }

        public BigDecimal getFee() {
            return this.fee;
        }

        public BtcInfo setIn(Map<String, BigDecimal> in) {
            this.in = in;
            return this;
        }

        public BtcInfo setOut(Map<String, BigDecimal> out) {
            this.out = out;
            return this;
        }

        public BtcInfo setFee(BigDecimal fee) {
            this.fee = fee;
            return this;
        }

        public BtcInfo() {
        }

        public BtcInfo(Map<String, BigDecimal> in, Map<String, BigDecimal> out, BigDecimal fee) {
            this.in = in;
            this.out = out;
            this.fee = fee;
        }
    }
}

