/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core.model;

import live.lingting.virtual.currency.core.model.TransactionGenerate;

public class TransferResult {
    private Boolean success;
    private String hash;
    private String code;
    private String message;
    private Throwable exception;

    public static TransferResult success(String hash) {
        return new TransferResult().setSuccess(true).setHash(hash);
    }

    public static TransferResult failed(String message) {
        return TransferResult.failed(message, null);
    }

    public static TransferResult failed(Throwable e) {
        return TransferResult.failed(e.getMessage(), e);
    }

    public static TransferResult failed(String message, Throwable e) {
        return new TransferResult().setSuccess(false).setMessage(message).setException(e);
    }

    public static TransferResult failed(TransactionGenerate generate) {
        return TransferResult.failed(generate.getMessage(), generate.getException());
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getHash() {
        return this.hash;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public TransferResult setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public TransferResult setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public TransferResult setCode(String code) {
        this.code = code;
        return this;
    }

    public TransferResult setMessage(String message) {
        this.message = message;
        return this;
    }

    public TransferResult setException(Throwable exception) {
        this.exception = exception;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferResult)) {
            return false;
        }
        TransferResult other = (TransferResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "TransferResult(success=" + this.getSuccess() + ", hash=" + this.getHash() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", exception=" + this.getException() + ")";
    }
}

