/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core.util;

import cn.hutool.core.util.StrUtil;
import java.math.BigInteger;
import live.lingting.virtual.currency.core.Contract;
import org.bouncycastle.util.encoders.Hex;

public class AbiUtils {
    public static final String REMOVE_ZERO_REG_STR = "^(0+)";

    public static String[] stringToArrayBy64(String str) {
        return StrUtil.cut((CharSequence)str, (int)64);
    }

    public static String[] stringToArrayBy64(String prefix, String str) {
        if (str.startsWith(prefix)) {
            str = str.substring(prefix.length());
        }
        return AbiUtils.stringToArrayBy64(str);
    }

    public static String removePreZero(String str) {
        return str.replaceAll(REMOVE_ZERO_REG_STR, "");
    }

    public static String addZeroTo64InPre(String str) {
        return StrUtil.padPre((CharSequence)str, (int)64, (CharSequence)"0");
    }

    public static String encodeUint256Params(BigInteger uint) {
        return AbiUtils.addZeroTo64InPre(Hex.toHexString((byte[])uint.toByteArray()));
    }

    public static Contract createContract(String hash) {
        return AbiUtils.createContract(hash, null);
    }

    public static Contract createContract(final String hash, final Integer decimals) {
        return new Contract(){

            @Override
            public String getHash() {
                return hash;
            }

            @Override
            public Integer getDecimals() {
                return decimals;
            }
        };
    }

    private AbiUtils() {
    }
}

