/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import live.lingting.virtual.currency.core.Endpoints;
import live.lingting.virtual.currency.core.enums.HttpMethod;
import live.lingting.virtual.currency.core.model.HttpHeader;

public class HttpUtils {
    public static String get(Endpoints endpoints, String suffix, HttpHeader ... headers) {
        return HttpUtils.get(endpoints.getHttpUrl(suffix), headers);
    }

    public static String get(String url, HttpHeader ... headers) {
        return HttpUtils.request(url, "", HttpMethod.GET, headers);
    }

    public static String post(Endpoints endpoints, String suffix, HttpHeader ... headers) {
        return HttpUtils.post(endpoints.getHttpUrl(suffix), headers);
    }

    public static String post(Endpoints endpoints, String suffix, String body, HttpHeader ... headers) {
        return HttpUtils.post(endpoints.getHttpUrl(suffix), body, headers);
    }

    public static String post(String url, HttpHeader ... headers) {
        return HttpUtils.post(url, "", headers);
    }

    public static String post(String url, String body, HttpHeader ... headers) {
        return HttpUtils.request(url, body, HttpMethod.POST, headers);
    }

    public static String request(String url, String body, HttpMethod method, HttpHeader ... headers) {
        HttpRequest request;
        if (method == HttpMethod.GET) {
            request = HttpRequest.get((String)url);
        } else {
            request = HttpRequest.post((String)url);
            if (StrUtil.isNotBlank((CharSequence)body)) {
                request.body(body);
            }
        }
        for (HttpHeader header : headers) {
            request.header(header.getName(), header.getValue());
        }
        return request.execute().body();
    }
}

