/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.crypto.tuweniTypes;

import com.google.common.base.Preconditions;
import org.tron.tronj.crypto.tuweniTypes.Bytes;

final class BytesValues {
    static final int MAX_UNSIGNED_SHORT = 65535;
    static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    static final long MAX_UNSIGNED_LONG = Long.MAX_VALUE;

    private BytesValues() {
    }

    static Bytes fromHexString(CharSequence str, int destSize, boolean lenient) {
        return Bytes.wrap(BytesValues.fromRawHexString(str, destSize, lenient));
    }

    static byte[] fromRawHexString(CharSequence str, int destSize, boolean lenient) {
        int len = str.length();
        CharSequence hex = str;
        if (len >= 2 && str.charAt(0) == '0' && str.charAt(1) == 'x') {
            hex = str.subSequence(2, len);
            len -= 2;
        }
        int idxShift = 0;
        if (len % 2 != 0) {
            if (!lenient) {
                throw new IllegalArgumentException("Invalid odd-length hex binary representation");
            }
            hex = "0" + hex;
            ++len;
            idxShift = 1;
        }
        int size = len / 2;
        if (destSize < 0) {
            destSize = size;
        } else {
            Preconditions.checkArgument((size <= destSize ? 1 : 0) != 0, (String)"Hex value is too large: expected at most %s bytes but got %s", (int)destSize, (int)size);
        }
        byte[] out = new byte[destSize];
        int destOffset = destSize - size;
        for (int i = 0; i < len; i += 2) {
            int h = BytesValues.hexToBin(hex.charAt(i));
            int l = BytesValues.hexToBin(hex.charAt(i + 1));
            if (h == -1) {
                throw new IllegalArgumentException(String.format("Illegal character '%c' found at index %d in hex binary representation", Character.valueOf(hex.charAt(i)), i - idxShift));
            }
            if (l == -1) {
                throw new IllegalArgumentException(String.format("Illegal character '%c' found at index %d in hex binary representation", Character.valueOf(hex.charAt(i + 1)), i + 1 - idxShift));
            }
            out[destOffset + i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        return 'a' <= ch && ch <= 'f' ? ch - 97 + 10 : -1;
    }
}

