/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.crypto.tuweniTypes;

import com.google.common.base.Preconditions;
import io.vertx.core.buffer.Buffer;
import org.tron.tronj.crypto.tuweniTypes.BufferWrappingBytes;
import org.tron.tronj.crypto.tuweniTypes.Bytes;
import org.tron.tronj.crypto.tuweniTypes.MutableBytes;

final class MutableBufferWrappingBytes
extends BufferWrappingBytes
implements MutableBytes {
    MutableBufferWrappingBytes(Buffer buffer) {
        super(buffer);
    }

    MutableBufferWrappingBytes(Buffer buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    @Override
    public void set(int i, byte b) {
        this.buffer.setByte(i, b);
    }

    @Override
    public void setInt(int i, int value) {
        this.buffer.setInt(i, value);
    }

    @Override
    public void setLong(int i, long value) {
        this.buffer.setLong(i, value);
    }

    @Override
    public MutableBytes mutableSlice(int i, int length) {
        int size = this.size();
        if (i == 0 && length == size) {
            return this;
        }
        if (length == 0) {
            return MutableBytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)size);
        Preconditions.checkArgument((i + length <= size ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has size %s and has only %s bytes from %s", (Object)length, (Object)size, (Object)(size - i), (Object)i);
        return new MutableBufferWrappingBytes(this.buffer.slice(i, i + length));
    }

    @Override
    public Bytes copy() {
        return Bytes.wrap(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return MutableBytes.wrap(this.toArray());
    }
}

