/*
 * Decompiled with CFR 0.152.
 */
package lt.velykis.maven.pdetarget;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.AbstractDependencyFilterMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Mojo(name="add-pom-dependencies", threadSafe=false, defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class AddPomDependenciesMojo
extends AbstractDependencyFilterMojo {
    @Parameter(property="pde.target.outputFile")
    private File outputFile;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDirectory;
    @Parameter(property="pde.target.baseDefinition", required=true)
    private File baseDefinition;
    @Parameter(property="pde.target.excludeP2", defaultValue="true")
    private boolean excludeP2;
    @Component
    private BuildContext buildContext;

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new P2Filter(this.excludeP2);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildContext == null) {
            this.buildContext = new DefaultBuildContext();
        }
        File outputXmlFile = this.getOutputFile();
        if (!this.baseDefinition.isFile()) {
            throw new MojoFailureException("Invalid base target definition file: " + this.baseDefinition);
        }
        if (this.buildContext.hasDelta(this.baseDefinition) || !outputXmlFile.exists()) {
            try {
                this.addPomDependencies(this.baseDefinition, outputXmlFile);
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Target definition generation failed: " + e.getMessage(), e);
            }
        }
    }

    private void addPomDependencies(File baseDefinition, File outputXmlFile) throws MojoExecutionException, MojoFailureException, ParserConfigurationException, SAXException, IOException, XPathExpressionException, TransformerException {
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        parser.setErrorHandler(new DefaultHandler());
        Document doc = parser.parse(baseDefinition);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("/target/locations", doc.getDocumentElement(), XPathConstants.NODESET);
        if (nodes.getLength() == 0) {
            throw new MojoFailureException("<locations> node cannot be found in base target definition " + baseDefinition.toString());
        }
        Element locationsNode = (Element)nodes.item(0);
        Node firstChild = locationsNode.getFirstChild();
        Collection<Artifact> pomDependencies = this.resolveDependencies();
        Set<String> artifactDirs = this.getArtifactDirs(pomDependencies);
        for (String dir : artifactDirs) {
            Element depLocationNode = this.createMavenArtifactLocation(doc, dir);
            locationsNode.insertBefore(depLocationNode, firstChild);
        }
        this.writeXmlFile(doc, outputXmlFile);
    }

    private Collection<Artifact> resolveDependencies() throws MojoExecutionException {
        return this.getResolvedDependencies(true);
    }

    private Set<String> getArtifactDirs(Collection<? extends Artifact> artifacts) throws IOException {
        LinkedHashSet<String> artifactDirs = new LinkedHashSet<String>();
        for (Artifact artifact : artifacts) {
            File artifactFile = artifact.getFile();
            String artifactDir = artifactFile.getParentFile().getCanonicalPath();
            artifactDirs.add(artifactDir);
        }
        return artifactDirs;
    }

    private Element createMavenArtifactLocation(Document doc, String artifactDir) throws IOException {
        Element locNode = doc.createElement("location");
        locNode.setAttribute("path", artifactDir);
        locNode.setAttribute("type", "Directory");
        return locNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmlFile(Document doc, File outputXmlFile) throws TransformerException, IOException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (!outputXmlFile.getParentFile().exists()) {
            outputXmlFile.getParentFile().mkdirs();
        }
        OutputStream outputXmlStream = this.buildContext.newFileOutputStream(outputXmlFile);
        try {
            StreamResult output = new StreamResult(outputXmlStream);
            DOMSource input = new DOMSource(doc);
            transformer.transform(input, output);
        }
        finally {
            outputXmlStream.close();
        }
    }

    private File getOutputFile() {
        return this.outputFile != null ? this.outputFile : this.createOutputFileName();
    }

    private File createOutputFileName() {
        String baseDefinitionName = this.baseDefinition.getName();
        int extIndex = baseDefinitionName.lastIndexOf(".");
        if (extIndex >= 0) {
            baseDefinitionName = baseDefinitionName.substring(0, extIndex);
        }
        String outputDefinitionName = baseDefinitionName + "-pde.target";
        return new File(this.buildDirectory, outputDefinitionName);
    }

    private static class P2Filter
    extends AbstractArtifactsFilter {
        private final boolean filterP2;

        public P2Filter(boolean filterP2) {
            this.filterP2 = filterP2;
        }

        public Set<?> filter(Set artifacts) throws ArtifactFilterException {
            if (!this.filterP2) {
                return artifacts;
            }
            HashSet<Artifact> filtered = new HashSet<Artifact>();
            for (Object artifactObj : artifacts) {
                if (((Artifact)artifactObj).getGroupId().startsWith("p2.")) continue;
                filtered.add((Artifact)artifactObj);
            }
            return filtered;
        }
    }
}

