/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.zephyr.mojo;

import java.io.IOException;
import lv.ctco.zephyr.Config;
import lv.ctco.zephyr.ZephyrSyncService;
import lv.ctco.zephyr.enums.ConfigProperty;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="sync")
public class ZephyrSyncMojo
extends AbstractMojo
implements Config.Loader {
    @Parameter(required=true)
    private String username;
    @Parameter(required=true)
    private String password;
    @Parameter(required=true)
    private String reportType;
    @Parameter(required=true)
    private String projectKey;
    @Parameter(required=true)
    private String releaseVersion;
    @Parameter(required=true)
    private String testCycle;
    @Parameter(required=true)
    private String jiraUrl;
    @Parameter(required=true)
    private String reportPath;
    @Parameter(defaultValue="false")
    private Boolean orderedSteps;
    @Parameter(defaultValue="true")
    private Boolean forceStoryLink;
    @Parameter(defaultValue="false")
    private Boolean generateTestCaseUniqueId;
    @Parameter
    private String severityAttribute;
    @Parameter(defaultValue="true")
    private Boolean autoCreateTestCycle;
    @Parameter
    private String assignee;
    @Parameter
    private String linkType;
    @Parameter
    private String linkDirection;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Config config = new Config((Config.Loader)this);
        ZephyrSyncService syncService = new ZephyrSyncService(config);
        try {
            syncService.execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot sync test results into zephyr", (Exception)e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void execute(Config config) {
        config.setValue(ConfigProperty.USERNAME, this.username);
        config.setValue(ConfigProperty.PASSWORD, this.password);
        config.setValue(ConfigProperty.REPORT_TYPE, this.reportType);
        config.setValue(ConfigProperty.PROJECT_KEY, this.projectKey);
        config.setValue(ConfigProperty.RELEASE_VERSION, this.releaseVersion);
        config.setValue(ConfigProperty.TEST_CYCLE, this.testCycle);
        config.setValue(ConfigProperty.JIRA_URL, this.jiraUrl);
        config.setValue(ConfigProperty.REPORT_PATH, this.reportPath);
        config.setValue(ConfigProperty.ORDERED_STEPS, this.orderedSteps);
        config.setValue(ConfigProperty.FORCE_STORY_LINK, this.forceStoryLink);
        config.setValue(ConfigProperty.GENERATE_TEST_CASE_UNIQUE_ID, this.generateTestCaseUniqueId);
        config.setValue(ConfigProperty.SEVERITY, this.severityAttribute);
        config.setValue(ConfigProperty.AUTO_CREATE_TEST_CYCLE, this.autoCreateTestCycle);
        config.setValue(ConfigProperty.ASSIGNEE, this.assignee);
        config.setValue(ConfigProperty.LINK_TYPE, this.linkType);
        config.setValue(ConfigProperty.LINK_DIRECTION, this.linkDirection);
    }
}

