/*
 * Decompiled with CFR 0.152.
 */
package maps.hudson.plugin.xfpanel;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.ViewDescriptor;
import hudson.tasks.test.AbstractTestResultAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFPanelView
extends ListView {
    private XFColors colors;
    private Integer numColumns;

    @DataBoundConstructor
    public XFPanelView(String name, Integer numColumns) {
        super(name);
        this.numColumns = numColumns != null ? numColumns : 1;
    }

    public XFColors getColors() {
        if (this.colors == null) {
            this.colors = XFColors.DEFAULT;
        }
        return this.colors;
    }

    public Collection<XFPanelEntry> sort(Collection<Job<?, ?>> jobs) {
        if (jobs != null) {
            ArrayList<XFPanelEntry> entries = new ArrayList<XFPanelEntry>();
            for (Job<?, ?> job : jobs) {
                entries.add(new XFPanelEntry(job));
            }
            return entries;
        }
        return Collections.emptyList();
    }

    public Integer getNumColumns() {
        return this.numColumns;
    }

    public static final class XFColors {
        private String okBG;
        private String okFG;
        private String failedBG;
        private String failedFG;
        private String brokenBG;
        private String brokenFG;
        private String otherBG;
        private String otherFG;
        public static final XFColors DEFAULT = new XFColors("#7E7EFF", "#FFFFFF", "#FFC130", "#FFFFFF", "#FF0000", "#FFFFFF", "#CCCCCC", "#FFFFFF");

        public XFColors(String okBG, String okFG, String failedBG, String failedFG, String brokenBG, String brokenFG, String otherBG, String otherFG) {
            this.okBG = okBG;
            this.okFG = okFG;
            this.failedBG = failedBG;
            this.failedFG = failedFG;
            this.brokenBG = brokenBG;
            this.brokenFG = brokenFG;
            this.otherBG = otherBG;
            this.otherFG = otherFG;
        }

        public String getOkBG() {
            return this.okBG;
        }

        public String getOkFG() {
            return this.okFG;
        }

        public String getFailedBG() {
            return this.failedBG;
        }

        public String getFailedFG() {
            return this.failedFG;
        }

        public String getBrokenBG() {
            return this.brokenBG;
        }

        public String getBrokenFG() {
            return this.brokenFG;
        }

        public String getOtherBG() {
            return this.otherBG;
        }

        public String getOtherFG() {
            return this.otherFG;
        }
    }

    public static final class XFPanelViewDescriptor
    extends ViewDescriptor {
        public String getDisplayName() {
            return "eXtreme Feedback Panel";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class XFPanelEntry {
        private Job<?, ?> job;
        private String backgroundColor;
        private String color;
        private Boolean broken;
        private Boolean building = false;

        public XFPanelEntry(Job<?, ?> job) {
            this.job = job;
            this.findStatus();
        }

        public Job<?, ?> getJob() {
            return this.job;
        }

        public String getName() {
            return this.job.getName().toUpperCase();
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public String getColor() {
            return this.color;
        }

        public Boolean getBroken() {
            return this.broken;
        }

        public Boolean getBuilding() {
            return this.building;
        }

        public String getUrl() {
            return this.job.getUrl() + "lastBuild";
        }

        public List<Run<?, ?>> getBuildsInProgress() {
            ArrayList runs = new ArrayList();
            Run run = this.job.getLastBuild();
            if (run.isBuilding()) {
                runs.add(run);
            }
            for (Run prev = run.getPreviousBuildInProgress(); prev != null; prev = prev.getPreviousBuildInProgress()) {
                runs.add(prev);
            }
            return runs;
        }

        public int getTestCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getTotalCount() : 0;
            }
            return 0;
        }

        public int getFailCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getFailCount() : 0;
            }
            return 0;
        }

        public int getSuccessCount() {
            return this.getTestCount() - this.getFailCount();
        }

        public String getDiff() {
            Run<?, ?> previous;
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null && (previous = this.getLastSuccessfulFrom(run)) != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                AbstractTestResultAction prevTests = (AbstractTestResultAction)previous.getAction(AbstractTestResultAction.class);
                if (tests != null && prevTests != null) {
                    int currentSuccess = tests.getTotalCount() - tests.getFailCount();
                    int prevSuccess = prevTests.getTotalCount() - prevTests.getFailCount();
                    return Functions.getDiffString((int)(currentSuccess - prevSuccess));
                }
            }
            return "";
        }

        private Run<?, ?> getLastSuccessfulFrom(Run<?, ?> run) {
            Run r;
            for (r = run.getPreviousBuild(); r != null && (r.isBuilding() || r.getResult() == null || r.getResult().isWorseThan(Result.UNSTABLE)); r = r.getPreviousBuild()) {
            }
            return r;
        }

        public String getCulprit() {
            Run run = this.job.getLastBuild();
            String culprit = " - ";
            if (run instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                Iterator it = build.getCulprits().iterator();
                while (it.hasNext()) {
                    culprit = ((User)it.next()).getFullName().toUpperCase();
                }
            }
            return culprit;
        }

        public String getDiffColor() {
            String diff = this.getDiff().trim();
            if (diff.length() > 0) {
                if (diff.startsWith("-")) {
                    return "#FF0000";
                }
                return "#00FF00";
            }
            return "#FFFFFF";
        }

        public String getSuccessPercentage() {
            if (this.getTestCount() > 0) {
                Double perc = (double)this.getSuccessCount() / ((double)this.getTestCount() * 1.0);
                return NumberFormat.getPercentInstance().format(perc);
            }
            return "";
        }

        private void findStatus() {
            switch (this.job.getIconColor()) {
                case BLUE_ANIME: {
                    this.building = true;
                }
                case BLUE: {
                    this.backgroundColor = XFPanelView.this.getColors().getOkBG();
                    this.color = XFPanelView.this.colors.getOkFG();
                    this.broken = false;
                    break;
                }
                case YELLOW_ANIME: {
                    this.building = true;
                }
                case YELLOW: {
                    this.backgroundColor = XFPanelView.this.getColors().getFailedBG();
                    this.color = XFPanelView.this.colors.getFailedFG();
                    this.broken = false;
                    break;
                }
                case RED_ANIME: {
                    this.building = true;
                }
                case RED: {
                    this.backgroundColor = XFPanelView.this.getColors().getBrokenBG();
                    this.color = XFPanelView.this.colors.getBrokenFG();
                    this.broken = true;
                    break;
                }
                case GREY_ANIME: 
                case DISABLED_ANIME: {
                    this.building = true;
                }
                default: {
                    this.backgroundColor = XFPanelView.this.getColors().getOtherBG();
                    this.color = XFPanelView.this.colors.getOtherFG();
                    this.broken = true;
                }
            }
        }
    }
}

