/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Generator
extends Task {
    private static final String FILE_SEP = System.getProperty("file.separator");
    private String myGendocs = null;
    private String myDocsDest = null;
    private String myImgmap = null;
    private String myDateFormat = null;
    private String myEncoding = null;
    private String myUnknownfile = null;
    private String myFolderfile = null;
    private String myBackfile = null;
    private String myRss = null;
    private String myUrl = null;
    private String myName = null;
    private String myLogo = null;
    private Properties myImgmapProps = new Properties();
    private List myFiles = new ArrayList();

    public void execute() throws BuildException {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        File docsDestRoot = new File(this.myDocsDest + FILE_SEP + "files");
        File genDocsRoot = new File(this.myGendocs + FILE_SEP + "files");
        this.myImgmapProps = new Properties();
        try {
            this.myImgmapProps.load(new FileInputStream(new File(this.myImgmap)));
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
        this.createIndexFile(docsDestRoot, genDocsRoot, 0);
    }

    private void createIndexFile(File docsDestFolder, File genDocsFolder, int level) {
        String imgPath = this.getImgPath(level);
        String indexFile = genDocsFolder.getAbsolutePath() + FILE_SEP + "index.xml";
        try {
            File[] children;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document report = db.newDocument();
            DocumentFragment document = report.createDocumentFragment();
            Element rootElement = report.createElement("document");
            Element table = this.createTableHeader(rootElement, report, imgPath, level);
            if (level > 0) {
                this.addBack(table, report, imgPath);
            }
            if ((children = docsDestFolder.listFiles()) != null) {
                int i;
                for (i = 0; i < children.length; ++i) {
                    if (!children[i].isDirectory()) continue;
                    String tmpPath = children[i].getAbsolutePath().substring(this.myDocsDest.length() + 1);
                    File genDocsFolderCreated = new File(this.myGendocs + FILE_SEP + tmpPath);
                    genDocsFolderCreated.mkdir();
                    this.createIndexFile(children[i], genDocsFolderCreated, level + 1);
                    this.addFolder(table, report, imgPath, children[i].getName());
                }
                for (i = 0; i < children.length; ++i) {
                    if (children[i].isDirectory()) continue;
                    this.addFile(table, report, imgPath, children[i]);
                    if (!this.rss()) continue;
                    this.myFiles.add(children[i]);
                }
            }
            if (this.rss()) {
                this.generateRssFile();
            }
            document.appendChild(rootElement);
            DOMSource domSource = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(indexFile));
            TransformerFactory tFact = TransformerFactory.newInstance();
            Transformer trans = tFact.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("encoding", this.myEncoding);
            trans.transform(domSource, result);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException(t);
        }
    }

    private boolean rss() {
        return this.myRss != null && this.myRss.trim().equals("true");
    }

    private void generateRssFile() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document report = db.newDocument();
            DocumentFragment document = report.createDocumentFragment();
            Element rootElement = report.createElement("rss");
            rootElement.setAttribute("version", "0.92");
            Element channelElement = report.createElement("channel");
            rootElement.appendChild(channelElement);
            Element titleElement = report.createElement("title");
            channelElement.appendChild(titleElement);
            Text titleText = report.createTextNode("Files for " + this.myName);
            titleElement.appendChild(titleText);
            Element descElement = report.createElement("description");
            channelElement.appendChild(descElement);
            Text descText = report.createTextNode("Files for " + this.myName);
            descElement.appendChild(descText);
            Element linkElement = report.createElement("link");
            channelElement.appendChild(linkElement);
            Text linkText = report.createTextNode(this.myUrl + "/files/index.html");
            linkElement.appendChild(linkText);
            if (this.myLogo != null && !this.myLogo.trim().equals("")) {
                Element imageElement = report.createElement("image");
                channelElement.appendChild(imageElement);
                Element imageTitleElement = report.createElement("title");
                imageElement.appendChild(imageTitleElement);
                Text imageTitleText = report.createTextNode(this.myName);
                imageTitleElement.appendChild(imageTitleText);
                Element imageLinkElement = report.createElement("link");
                imageElement.appendChild(imageLinkElement);
                Text imageLinkText = report.createTextNode(this.myUrl);
                imageLinkElement.appendChild(imageLinkText);
                Element imageUrlElement = report.createElement("url");
                imageElement.appendChild(imageUrlElement);
                Text imageUrlText = report.createTextNode(this.myLogo);
                imageUrlElement.appendChild(imageUrlText);
            }
            Element itemElement = report.createElement("item");
            channelElement.appendChild(itemElement);
            String myDesc = this.getDesc();
            Element itemTitleElement = report.createElement("title");
            itemElement.appendChild(itemTitleElement);
            Text itemTitleText = report.createTextNode(myDesc);
            itemTitleElement.appendChild(itemTitleText);
            Element itemDescElement = report.createElement("description");
            itemElement.appendChild(itemDescElement);
            Text itemDescText = report.createTextNode(myDesc);
            itemDescElement.appendChild(itemDescText);
            Element itemLinkElement = report.createElement("link");
            itemElement.appendChild(itemLinkElement);
            Text itemLinkText = report.createTextNode(this.myUrl + "/files/index.html");
            itemLinkElement.appendChild(itemLinkText);
            document.appendChild(rootElement);
            DOMSource domSource = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(this.myDocsDest + FILE_SEP + "files/files.rss"));
            TransformerFactory tFact = TransformerFactory.newInstance();
            Transformer trans = tFact.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("encoding", this.myEncoding);
            trans.transform(domSource, result);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException(t);
        }
    }

    private String getDesc() {
        long high = 0L;
        Iterator iter = this.myFiles.iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            if (file.lastModified() <= high) continue;
            high = file.lastModified();
        }
        Date highest = new Date(high);
        return "Files last updated: " + new SimpleDateFormat(this.myDateFormat).format(highest);
    }

    private Element createTableHeader(Element root, Document document, String imgPath, int level) {
        Element bodyElement = document.createElement("body");
        root.appendChild(bodyElement);
        Element sectionElement = document.createElement("section");
        sectionElement.setAttribute("name", "Files");
        bodyElement.appendChild(sectionElement);
        Element pElement = document.createElement("p");
        sectionElement.appendChild(pElement);
        Text pText = document.createTextNode("Generated report based on files found in the files src folder in this project");
        pElement.appendChild(pText);
        if (this.rss()) {
            Element rsspElement = document.createElement("p");
            sectionElement.appendChild(rsspElement);
            Text rsspText = document.createTextNode("Get the RSS feed of the last changes ");
            rsspElement.appendChild(rsspText);
            Element aElement = document.createElement("a");
            rsspElement.appendChild(aElement);
            aElement.setAttribute("href", this.getRootPath(level) + "files.rss");
            Element imgElement = document.createElement("img");
            imgElement.setAttribute("src", imgPath + "rss.png");
            aElement.appendChild(imgElement);
        }
        Element tableElement = document.createElement("table");
        sectionElement.appendChild(tableElement);
        Element trElement = document.createElement("tr");
        tableElement.appendChild(trElement);
        Element th1Element = document.createElement("th");
        Element th2Element = document.createElement("th");
        Element th3Element = document.createElement("th");
        trElement.appendChild(th1Element);
        trElement.appendChild(th2Element);
        trElement.appendChild(th3Element);
        Text th1Text = document.createTextNode("File");
        Text th2Text = document.createTextNode("Type");
        Text th3Text = document.createTextNode("Last Modified");
        th1Element.appendChild(th1Text);
        th2Element.appendChild(th2Text);
        th3Element.appendChild(th3Text);
        return tableElement;
    }

    private void addBack(Element tableElement, Document document, String imgPath) {
        Element trElement = document.createElement("tr");
        tableElement.appendChild(trElement);
        Element tdElement = document.createElement("td");
        tdElement.setAttribute("colspan", "3");
        trElement.appendChild(tdElement);
        Element imgElement = document.createElement("img");
        imgElement.setAttribute("src", imgPath + this.myBackfile);
        tdElement.appendChild(imgElement);
        Element aElement = document.createElement("a");
        aElement.setAttribute("href", "../");
        Text aText = document.createTextNode("../");
        aElement.appendChild(aText);
        tdElement.appendChild(aElement);
    }

    private void addFolder(Element tableElement, Document document, String imgPath, String folderName) {
        Element trElement = document.createElement("tr");
        tableElement.appendChild(trElement);
        Element tdElement = document.createElement("td");
        tdElement.setAttribute("colspan", "3");
        trElement.appendChild(tdElement);
        Element imgElement = document.createElement("img");
        imgElement.setAttribute("src", imgPath + this.myFolderfile);
        tdElement.appendChild(imgElement);
        Element aElement = document.createElement("a");
        aElement.setAttribute("href", folderName);
        Text aText = document.createTextNode(folderName);
        aElement.appendChild(aText);
        tdElement.appendChild(aElement);
    }

    private void addFile(Element tableElement, Document document, String imgPath, File file) {
        String fileName = file.getName();
        String filetype = "-";
        if (fileName.indexOf(46) != -1) {
            filetype = fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        Element trElement = document.createElement("tr");
        tableElement.appendChild(trElement);
        Element tdElement1 = document.createElement("td");
        trElement.appendChild(tdElement1);
        Element imgElement = document.createElement("img");
        imgElement.setAttribute("src", imgPath + this.getImgFilename(fileName));
        tdElement1.appendChild(imgElement);
        Element aElement = document.createElement("a");
        aElement.setAttribute("href", fileName);
        aElement.setAttribute("target", "_blank");
        Text aText = null;
        aText = fileName.indexOf(46) != -1 ? document.createTextNode(fileName.substring(0, fileName.lastIndexOf(46))) : document.createTextNode(fileName);
        aElement.appendChild(aText);
        tdElement1.appendChild(aElement);
        Element tdElement2 = document.createElement("td");
        Text td2Text = document.createTextNode(filetype);
        tdElement2.appendChild(td2Text);
        trElement.appendChild(tdElement2);
        Element tdElement3 = document.createElement("td");
        Text td3Text = document.createTextNode(this.formatDate(file.lastModified()));
        tdElement3.appendChild(td3Text);
        trElement.appendChild(tdElement3);
    }

    private String getImgPath(int level) {
        StringBuffer result = new StringBuffer(this.getRootPath(level));
        result.append("../images/");
        return result.toString();
    }

    private String getRootPath(int level) {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < level; ++i) {
            result.append("../");
        }
        return result.toString();
    }

    private String getImgFilename(String name) {
        Iterator<Object> iter = this.myImgmapProps.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!name.endsWith(key)) continue;
            return this.myImgmapProps.getProperty(key);
        }
        return this.myUnknownfile;
    }

    private String formatDate(long date) {
        return new SimpleDateFormat(this.myDateFormat).format(new Date(date));
    }

    public void setDateFormat(String string) {
        this.myDateFormat = string;
    }

    public void setEncoding(String string) {
        this.myEncoding = string;
    }

    public void setGendocs(String string) {
        this.myGendocs = string;
    }

    public void setImgmap(String string) {
        this.myImgmap = string;
    }

    public void setBackfile(String string) {
        this.myBackfile = string;
    }

    public void setFolderfile(String string) {
        this.myFolderfile = string;
    }

    public void setUnknownfile(String string) {
        this.myUnknownfile = string;
    }

    public void setRss(String string) {
        this.myRss = string;
    }

    public void setDocsDest(String string) {
        this.myDocsDest = string;
    }

    public void setUrl(String string) {
        this.myUrl = string;
    }

    public void setLogo(String string) {
        this.myLogo = string;
    }

    public void setName(String string) {
        this.myName = string;
    }
}

