/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.xhtml;

import java.io.File;
import java.io.IOException;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class ValidatorHandler
implements ErrorHandler,
EntityResolver {
    private int errorsFound;
    private XMLWriter out;

    ValidatorHandler() {
    }

    public void setOut(XMLWriter writer) {
        this.out = writer;
    }

    public void init(File file) {
        this.errorsFound = 0;
    }

    public int getErrors() {
        return this.errorsFound;
    }

    public void error(SAXParseException exception) {
        ++this.errorsFound;
        this.doLog(exception, 0);
    }

    public final void fatalError(SAXParseException exception) {
        this.error(exception);
    }

    public final void warning(SAXParseException exception) {
        this.error(exception);
    }

    private void doLog(SAXParseException e, int logLevel) {
        DefaultElement error = new DefaultElement("error");
        error.addAttribute("line", "" + e.getLineNumber());
        error.addAttribute("col", "" + e.getColumnNumber());
        error.addAttribute("level", "" + logLevel);
        error.addText(e.getMessage());
        this.writeToLog((Element)error);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.indexOf(".dtd") != -1) {
            DefaultElement dtd = new DefaultElement("dtd");
            dtd.addAttribute("publicId", publicId);
            dtd.addAttribute("systemId", systemId);
            this.writeToLog((Element)dtd);
        }
        return null;
    }

    private void writeToLog(Element element) {
        try {
            this.out.write(element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

