/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFactory;
import org.apache.maven.changelog.ChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.executor.ProjectExecutor;
import org.apache.maven.project.Developer;

public class ChangeLog
extends ProjectExecutor {
    private String range;
    private File base;
    private File output;
    private Collection entries;
    private String clFactoryClass = "org.apache.maven.cvslib.CvsChangeLogFactory";

    public void setFactory(String factoryClassName) {
        this.clFactoryClass = factoryClassName;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getRange() {
        return this.range;
    }

    public void setBasedir(File base) {
        this.base = base;
    }

    public File getBasedir() {
        return this.base;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void doExecute() throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (this.output == null) {
            throw new NullPointerException("output must be set");
        }
        this.generateEntries();
        this.replaceAuthorIdWithName();
        this.createDocument();
    }

    private void generateEntries() throws IOException {
        ChangeLogFactory factory = this.createFactory();
        ChangeLogGenerator generator = factory.createGenerator();
        ChangeLogParser parser = factory.createParser();
        generator.init(this);
        parser.init(this);
        try {
            this.setEntries(generator.getEntries(parser));
            this.log("ChangeLog found: " + this.getEntries().size() + " entries");
            Object var5_4 = null;
            parser.cleanup();
            generator.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            parser.cleanup();
            generator.cleanup();
            throw throwable;
        }
    }

    private ChangeLogFactory createFactory() throws IOException {
        try {
            Class<?> clazz = Class.forName(this.clFactoryClass);
            return (ChangeLogFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Cannot find class " + this.clFactoryClass + " " + cnfe.toString());
        }
        catch (IllegalAccessException iae) {
            throw new IOException("Cannot access class " + this.clFactoryClass + " " + iae.toString());
        }
        catch (InstantiationException ie) {
            throw new IOException("Cannot instantiate class " + this.clFactoryClass + " " + ie.toString());
        }
    }

    private Properties getUserList() {
        Properties userList = new Properties();
        List developers = this.getMavenProject().getDevelopers();
        Developer developer = null;
        Iterator i = developers.iterator();
        while (i.hasNext()) {
            developer = (Developer)i.next();
            ((Hashtable)userList).put(developer.getId(), developer.getName());
        }
        return userList;
    }

    private void replaceAuthorIdWithName() {
        Properties userList = this.getUserList();
        ChangeLogEntry entry = null;
        Iterator i = this.getEntries().iterator();
        while (i.hasNext()) {
            entry = (ChangeLogEntry)i.next();
            if (!((Hashtable)userList).containsKey(entry.getAuthor())) continue;
            entry.setAuthor(userList.getProperty(entry.getAuthor()));
        }
    }

    private void createDocument() throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), this.getOutputEncoding()));
        out.println(this.toXML());
        out.flush();
        out.close();
    }

    private String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"").append(this.getOutputEncoding()).append("\" ?>\n").append("<document>\n").append("<properties><title>Change Log</title></properties>\n").append("<body>\n").append("<section name=\"Change Log\"/>\n").append("<changelog>\n");
        Iterator i = this.getEntries().iterator();
        while (i.hasNext()) {
            buffer.append(((ChangeLogEntry)i.next()).toXML());
        }
        buffer.append("</changelog>\n").append("</body>\n").append("</document>\n");
        return buffer.toString();
    }

    public Collection getEntries() {
        if (this.entries == null) {
            this.entries = Arrays.asList(new Object[0]);
        }
        return this.entries;
    }

    public void setEntries(Collection entries) {
        this.entries = entries;
    }
}

