/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cvslib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.util.AsyncStreamReader;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;

class CvsChangeLogGenerator
implements ChangeLogGenerator,
ExecuteStreamHandler {
    private ChangeLog changeLogExecutor;
    private AsyncStreamReader errorReader;
    private InputStream in;
    private File base;
    private String dateRange;
    private ChangeLogParser clParser;
    private Collection entries;

    CvsChangeLogGenerator() {
    }

    public void init(ChangeLog changeLog) {
        this.changeLogExecutor = changeLog;
        this.base = this.changeLogExecutor.getBasedir();
        if (this.changeLogExecutor.getRange() != null) {
            this.setDateRange(this.changeLogExecutor.getRange());
        }
    }

    private void setDateRange(String numDaysString) {
        int days = Integer.parseInt(numDaysString);
        Date before = new Date(System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L);
        Date to = new Date(System.currentTimeMillis() + 86400000L);
        SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
        this.dateRange = "-d " + outputDate.format(before) + "<" + outputDate.format(to);
    }

    public Collection getEntries(ChangeLogParser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser cannot be null");
        }
        if (this.base == null) {
            throw new NullPointerException("basedir must be set");
        }
        if (!this.base.exists()) {
            throw new FileNotFoundException("Cannot find base dir " + this.base.getAbsolutePath());
        }
        this.clParser = parser;
        try {
            Execute exe = new Execute((ExecuteStreamHandler)this);
            exe.setCommandline(this.getCvsLogCommand().getCommandline());
            exe.setAntRun(this.changeLogExecutor.getProject());
            exe.setWorkingDirectory(this.base);
            exe.execute();
            String errors = this.errorReader.toString().trim();
            if (errors.length() > 0) {
                this.changeLogExecutor.log(errors);
            }
        }
        catch (IOException ioe) {
            if (ioe.getMessage().indexOf("CreateProcess") != -1 || ioe.getMessage().indexOf("cvs: not found") != -1) {
                this.changeLogExecutor.log("Unable to find cvs executable. Changelog will be empty");
            }
            throw ioe;
        }
        return this.entries;
    }

    public void cleanup() {
    }

    private Commandline getCvsLogCommand() {
        Commandline command = new Commandline();
        command.setExecutable("cvs");
        command.createArgument().setValue("log");
        if (this.dateRange != null) {
            command.createArgument().setValue(this.dateRange);
        }
        return command;
    }

    public void stop() {
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public void setProcessErrorStream(InputStream is) {
        this.errorReader = new CvsAsyncErrorReader(is);
    }

    public void setProcessOutputStream(InputStream is) {
        this.in = is;
    }

    public void start() throws IOException {
        this.errorReader.start();
        this.entries = this.clParser.parse(this.in);
    }

    private static class CvsAsyncErrorReader
    extends AsyncStreamReader {
        public CvsAsyncErrorReader(InputStream anInputStream) {
            super(anInputStream);
        }

        protected boolean okToConsume(String line) {
            return !line.startsWith("cvs server: Logging");
        }
    }
}

