/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFactory;
import org.apache.maven.changelog.ChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.project.Developer;

public class ChangeLog {
    private String range;
    private String dateFormat;
    private File base;
    private String clFactoryClass = "org.apache.maven.cvslib.CvsChangeLogFactory";
    private String connection;
    private List developers;
    private Collection entries;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$changelog$ChangeLog == null ? (class$org$apache$maven$changelog$ChangeLog = ChangeLog.class$("org.apache.maven.changelog.ChangeLog")) : class$org$apache$maven$changelog$ChangeLog));
    private File output;
    private String outputEncoding;
    static /* synthetic */ Class class$org$apache$maven$changelog$ChangeLog;

    public void setFactory(String factoryClassName) {
        this.clFactoryClass = factoryClassName;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getRange() {
        return this.range;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setBasedir(File base) {
        this.base = base;
    }

    public File getBasedir() {
        return this.base;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public String getRepositoryConnection() {
        return this.connection;
    }

    public void setRepositoryConnection(String aString) {
        this.connection = aString;
    }

    public void doExecute() throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (this.output == null) {
            throw new NullPointerException("output must be set");
        }
        this.generateEntries();
        this.replaceAuthorIdWithName();
        this.createDocument();
    }

    private void generateEntries() throws IOException {
        ChangeLogFactory factory = this.createFactory();
        ChangeLogGenerator generator = factory.createGenerator();
        ChangeLogParser parser = factory.createParser();
        generator.init(this);
        parser.init(this);
        try {
            this.setEntries(generator.getEntries(parser));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("ChangeLog found: " + this.getEntries().size() + " entries"));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            parser.cleanup();
            generator.cleanup();
        }
    }

    private ChangeLogFactory createFactory() throws IOException {
        try {
            Class<?> clazz = Class.forName(this.clFactoryClass);
            return (ChangeLogFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Cannot find class " + this.clFactoryClass + " " + cnfe.toString());
        }
        catch (IllegalAccessException iae) {
            throw new IOException("Cannot access class " + this.clFactoryClass + " " + iae.toString());
        }
        catch (InstantiationException ie) {
            throw new IOException("Cannot instantiate class " + this.clFactoryClass + " " + ie.toString());
        }
    }

    private Properties getUserList() {
        Properties userList = new Properties();
        Developer developer = null;
        Iterator i = this.getDevelopers().iterator();
        while (i.hasNext()) {
            developer = (Developer)i.next();
            ((Hashtable)userList).put(developer.getId(), developer.getName());
        }
        return userList;
    }

    private void replaceAuthorIdWithName() {
        Properties userList = this.getUserList();
        ChangeLogEntry entry = null;
        Iterator i = this.getEntries().iterator();
        while (i.hasNext()) {
            entry = (ChangeLogEntry)i.next();
            if (!((Hashtable)userList).containsKey(entry.getAuthor())) continue;
            entry.setAuthor(userList.getProperty(entry.getAuthor()));
        }
    }

    private void createDocument() throws FileNotFoundException, UnsupportedEncodingException {
        File dir = this.output.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), this.getOutputEncoding()));
        out.println(this.toXML());
        out.flush();
        out.close();
    }

    private String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"").append(this.getOutputEncoding()).append("\" ?>\n").append("<changelog>\n");
        Iterator i = this.getEntries().iterator();
        while (i.hasNext()) {
            buffer.append(((ChangeLogEntry)i.next()).toXML());
        }
        buffer.append("</changelog>\n");
        return buffer.toString();
    }

    public Collection getEntries() {
        if (this.entries == null) {
            this.entries = Arrays.asList(new Object[0]);
        }
        return this.entries;
    }

    public void setEntries(Collection entries) {
        this.entries = entries;
    }

    public List getDevelopers() {
        return this.developers;
    }

    public void setDevelopers(List developers) {
        this.developers = developers;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

