/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cvslib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.util.StringUtils;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.CommandFactory;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CvsConnection {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$cvslib$CvsConnection == null ? (class$org$apache$maven$cvslib$CvsConnection = CvsConnection.class$("org.apache.maven.cvslib.CvsConnection")) : class$org$apache$maven$cvslib$CvsConnection));
    private String repository;
    private String localPath;
    private Connection connection;
    private Client client;
    private GlobalOptions globalOptions;
    static /* synthetic */ Class class$org$apache$maven$cvslib$CvsConnection;

    public void executeCommand(Command command) throws CommandException, AuthenticationException {
        this.client.executeCommand(command, this.globalOptions);
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        this.globalOptions = globalOptions;
    }

    private void connect(CVSRoot root, String password) throws IllegalArgumentException, AuthenticationException, CommandAbortedException {
        this.connection = ConnectionFactory.getConnection((CVSRoot)root);
        if ("pserver".equals(root.getMethod())) {
            ((PServerConnection)this.connection).setEncodedPassword(password);
        }
        this.connection.open();
        this.client = new Client(this.connection, (AdminHandler)new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
    }

    private void addListener(CVSListener listener) {
        if (this.client != null) {
            this.client.getEventManager().addCVSListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getCVSRoot(String workingDir) {
        String root;
        block14: {
            BufferedReader r;
            block13: {
                root = null;
                r = null;
                if (workingDir == null) {
                    workingDir = System.getProperty("user.dir");
                }
                File f = new File(workingDir);
                File rootFile = new File(f, "CVS/Root");
                if (!rootFile.exists()) break block13;
                r = new BufferedReader(new FileReader(rootFile));
                root = r.readLine();
            }
            Object var6_6 = null;
            try {
                if (r != null) {
                    r.close();
                }
                break block14;
            }
            catch (IOException e) {
                System.err.println("Warning: could not close CVS/Root file!");
            }
            break block14;
            {
                catch (IOException iOException) {
                    Object var6_7 = null;
                    try {
                        if (r != null) {
                            r.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        System.err.println("Warning: could not close CVS/Root file!");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Warning: could not close CVS/Root file!");
                }
                throw throwable;
            }
        }
        if (root == null) {
            root = System.getProperty("cvs.root");
        }
        return root;
    }

    private static int processGlobalOptions(String[] args, GlobalOptions globalOptions) {
        String getOptString = globalOptions.getOptString();
        GetOpt go = new GetOpt(args, getOptString);
        int ch = -1;
        boolean usagePrint = false;
        while ((ch = go.getopt()) != -1) {
            boolean success = globalOptions.setCVSCommand((char)ch, go.optArgGet());
            if (success) continue;
            usagePrint = true;
        }
        return go.optIndexGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String lookupPassword(String cvsRoot) {
        block12: {
            passFile = new File(System.getProperty("cvs.passfile", System.getProperty("user.home") + "/.cvspass"));
            reader = null;
            password = null;
            try {
                reader = new BufferedReader(new FileReader(passFile));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("/")) {
                        cvspass = StringUtils.split((String)line, (int)32);
                        if (cvspass.size() < 3 || !CvsConnection.compareCvsRoot(cvsRoot, (String)cvspass.get(1))) continue;
                        password = (String)cvspass.get(2);
                    } else {
                        if (!line.startsWith(cvsRoot)) continue;
                        password = line.substring(cvsRoot.length() + 1);
                    }
                    break;
                }
            }
            catch (IOException e) {
                CvsConnection.LOG.warn((Object)("Could not read password for '" + cvsRoot + "' from '" + passFile + "'"), (Throwable)e);
                var5_7 = null;
                var7_9 = null;
                if (reader == null) return var5_7;
                try {
                    reader.close();
                    return var5_7;
                }
                catch (IOException e) {
                    CvsConnection.LOG.error((Object)"Warning: could not close password file.");
                }
                return var5_7;
            }
            var7_8 = null;
            if (reader == null) break block12;
            {
                catch (Throwable var6_14) {
                    var7_10 = null;
                    if (reader == null) throw var6_14;
                    ** try [egrp 2[TRYBLOCK] [4 : 224->231)] { 
lbl38:
                    // 1 sources

                    reader.close();
                    throw var6_14;
lbl40:
                    // 1 sources

                    catch (IOException e) {
                        CvsConnection.LOG.error((Object)"Warning: could not close password file.");
                    }
                    throw var6_14;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 224->231)] { 
lbl44:
                // 1 sources

                reader.close();
lbl46:
                // 1 sources

                catch (IOException e) {}
                CvsConnection.LOG.error((Object)"Warning: could not close password file.");
            }
        }
        if (password != null) return password;
        CvsConnection.LOG.error((Object)("Didn't find password for CVSROOT '" + cvsRoot + "'."));
        return password;
    }

    static boolean compareCvsRoot(String cvsRoot, String target) {
        String s1 = CvsConnection.completeCvsRootPort(cvsRoot);
        String s2 = CvsConnection.completeCvsRootPort(target);
        return s1 != null && s1.equals(s2);
    }

    private static String completeCvsRootPort(String cvsRoot) {
        String result = cvsRoot;
        int idx = cvsRoot.indexOf(58);
        for (int i = 0; i < 2 && idx != -1; ++i) {
            idx = cvsRoot.indexOf(58, idx + 1);
        }
        if (idx != -1 && cvsRoot.charAt(idx + 1) == '/') {
            StringBuffer sb = new StringBuffer();
            sb.append(cvsRoot.substring(0, idx + 1));
            sb.append("2401");
            sb.append(cvsRoot.substring(idx + 1));
            result = sb.toString();
        }
        return result;
    }

    public static boolean processCommand(String[] args, String localPath, CVSListener listener) throws Exception {
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCVSRoot(CvsConnection.getCVSRoot(localPath));
        int commandIndex = -1;
        try {
            commandIndex = CvsConnection.processGlobalOptions(args, globalOptions);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Invalid argument: " + e));
            return false;
        }
        if (globalOptions.getCVSRoot() == null) {
            LOG.error((Object)"No CVS root is set. Check your <repository> information in the POM.");
            return false;
        }
        CVSRoot root = null;
        String cvsRoot = globalOptions.getCVSRoot();
        try {
            root = CVSRoot.parse((String)cvsRoot);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Incorrect format for CVSRoot: " + cvsRoot + "\nThe correct format is: " + "[:method:][[user][:password]@][hostname:[port]]/path/to/repository" + "\nwhere \"method\" is pserver."));
            return false;
        }
        String command = args[commandIndex];
        Command c = null;
        try {
            c = CommandFactory.getDefault().createCommand(command, args, ++commandIndex, globalOptions, localPath);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Illegal argument: " + e.getMessage()));
            return false;
        }
        String password = null;
        if ("pserver".equals(root.getMethod())) {
            password = root.getPassword();
            if (password != null) {
                password = StandardScrambler.getInstance().scramble(password);
            } else {
                password = CvsConnection.lookupPassword(cvsRoot);
                if (password == null) {
                    password = StandardScrambler.getInstance().scramble("");
                }
            }
        }
        CvsConnection cvsCommand = new CvsConnection();
        cvsCommand.setGlobalOptions(globalOptions);
        cvsCommand.setRepository(root.getRepository());
        cvsCommand.setLocalPath(localPath);
        cvsCommand.connect(root, password);
        cvsCommand.addListener(listener);
        cvsCommand.executeCommand(c);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

