/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cvslib;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.AbstractChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.cvslib.CvsConnection;
import org.apache.maven.cvslib.CvsLogListener;
import org.apache.maven.util.AsyncStreamReader;
import org.apache.maven.util.RepositoryUtils;
import org.apache.tools.ant.types.Commandline;
import org.netbeans.lib.cvsclient.event.CVSListener;

class CvsChangeLogGenerator
extends AbstractChangeLogGenerator {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$cvslib$CvsChangeLogGenerator == null ? (class$org$apache$maven$cvslib$CvsChangeLogGenerator = CvsChangeLogGenerator.class$("org.apache.maven.cvslib.CvsChangeLogGenerator")) : class$org$apache$maven$cvslib$CvsChangeLogGenerator));
    public static final int POS_SCM = 0;
    public static final int POS_SCM_TYPE = 1;
    public static final int POS_SCM_SUBTYPE = 2;
    public static final int POS_SCM_USERHOST = 3;
    public static final int POS_SCM_PATH = 4;
    public static final int POS_SCM_MODULE = 5;
    static /* synthetic */ Class class$org$apache$maven$cvslib$CvsChangeLogGenerator;

    CvsChangeLogGenerator() {
    }

    public Collection getEntries(ChangeLogParser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser cannot be null");
        }
        if (this.base == null) {
            throw new NullPointerException("basedir must be set");
        }
        if (!this.base.exists()) {
            throw new FileNotFoundException("Cannot find base dir " + this.base.getAbsolutePath());
        }
        this.clParser = parser;
        String[] args = this.getScmLogCommand().getArguments();
        CvsLogListener logListener = new CvsLogListener();
        try {
            CvsConnection.processCommand(args, this.changeLogExecutor.getBasedir().toString(), (CVSListener)logListener);
            this.entries = this.clParser.parse(new ByteArrayInputStream(logListener.getStdout().toString().getBytes()));
        }
        catch (IllegalArgumentException iae) {
            this.entries = super.getEntries(parser);
        }
        catch (Exception e) {
            LOG.error((Object)"Error processing command", (Throwable)e);
        }
        return this.entries;
    }

    protected Commandline getScmLogCommand() {
        String[] tokens = RepositoryUtils.splitSCMConnection(this.getConnection());
        if (!tokens[1].equals("cvs")) {
            throw new IllegalArgumentException("repository connection string does not specify 'cvs' as the scm" + System.getProperty("line.separator") + "If using another scm, maven.changelog.factory" + " must be set." + System.getProperty("line.separator") + "See the maven changelog plugin documentation" + " for correct settings.");
        }
        Commandline command = new Commandline();
        command.setExecutable("cvs");
        command.createArgument().setValue("-d");
        String connectionBuffer = "";
        connectionBuffer = tokens[2].equalsIgnoreCase("local") ? tokens[4] : (tokens[2].equalsIgnoreCase("lserver") ? tokens[3] + ":" + tokens[4] : ":" + tokens[2] + ":" + tokens[3] + ":" + tokens[4]);
        command.createArgument().setValue(connectionBuffer.toString());
        command.createArgument().setValue("log");
        if (this.dateRange != null) {
            command.createArgument().setValue(this.dateRange);
        } else if (this.tag != null) {
            command.createArgument().setValue(this.tag);
        }
        return command;
    }

    protected String getScmDateArgument(Date before, Date to) {
        SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
        String cmd = outputDate.format(before) + "<" + outputDate.format(to);
        if (System.getProperty("os.name").startsWith("Windows")) {
            cmd = "\"" + cmd + "\"";
        }
        return "-d " + cmd;
    }

    protected String getScmTagArgument(String tagStart, String tagEnd) {
        return "-r" + tagStart + "::" + (tagEnd != null ? tagEnd : "");
    }

    protected void handleParserException(IOException ioe) throws IOException {
        if (ioe.getMessage().indexOf("CreateProcess") != -1 || ioe.getMessage().indexOf("cvs: not found") != -1) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Unable to find cvs executable. Please check that it is in your path, and avoid using spaces in the path name. Changelog will be empty");
            }
        } else {
            throw ioe;
        }
    }

    public void setProcessErrorStream(InputStream is) {
        this.errorReader = new CvsAsyncErrorReader(is);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CvsAsyncErrorReader
    extends AsyncStreamReader {
        public CvsAsyncErrorReader(InputStream anInputStream) {
            super(anInputStream);
        }

        protected boolean okToConsume(String line) {
            return !line.startsWith("cvs server: Logging");
        }
    }
}

