/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.starteamlib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogParser;

class StarteamChangeLogParser
implements ChangeLogParser {
    private static final SimpleDateFormat ENTRY_KEY_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private SimpleDateFormat localFormat = new SimpleDateFormat();
    private Map entries = new TreeMap(Collections.reverseOrder());
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$starteamlib$StarteamChangeLogGenerator == null ? (class$org$apache$maven$starteamlib$StarteamChangeLogGenerator = StarteamChangeLogParser.class$("org.apache.maven.starteamlib.StarteamChangeLogGenerator")) : class$org$apache$maven$starteamlib$StarteamChangeLogGenerator));
    private static final int GET_FILE = 1;
    private static final int GET_AUTHOR = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final String START_FILE = "History for: ";
    private static final String END_FILE = "=============================================================================";
    private static final String START_REVISION = "----------------------------";
    private static final String REVISION_TAG = "Branch Revision: ";
    private static final String AUTHOR_TAG = "Author: ";
    private static final String DATE_TAG = " Date: ";
    private int status = 1;
    private ChangeLogEntry currentLogEntry = null;
    private ChangeLogFile currentFile = null;
    private ChangeLog changeLog = null;
    private Date beforeDate;
    private Date toDate;
    private boolean testMode = false;
    static /* synthetic */ Class class$org$apache$maven$starteamlib$StarteamChangeLogGenerator;

    public void init(ChangeLog changeLog) {
        this.changeLog = changeLog;
        if (changeLog.getRange() != null && changeLog.getRange().length() != 0) {
            this.setDateRange(changeLog.getRange());
        }
        if (changeLog.getDateFormat() != null) {
            this.localFormat = new SimpleDateFormat(changeLog.getDateFormat());
        }
    }

    public void cleanup() {
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void setDateFormatInFile(String dateFormat) {
        this.localFormat = new SimpleDateFormat(dateFormat);
    }

    public Collection parse(InputStream anInputStream) throws IOException {
        BufferedReader stream = new BufferedReader(new InputStreamReader(anInputStream));
        String line = null;
        block6: while ((line = stream.readLine()) != null) {
            switch (this.getStatus()) {
                case 1: {
                    this.processGetFile(line);
                    continue block6;
                }
                case 4: {
                    this.processGetRevision(line);
                    continue block6;
                }
                case 2: {
                    this.processGetAuthor(line);
                    continue block6;
                }
                case 3: {
                    this.processGetComment(line);
                    continue block6;
                }
            }
            throw new IllegalStateException("Unknown state: " + this.status);
        }
        return this.entries.values();
    }

    private void addEntry(ChangeLogEntry entry, ChangeLogFile file) {
        if (entry.getAuthor() == null) {
            return;
        }
        if (!this.testMode && this.beforeDate != null && this.toDate != null && (entry.getDate().before(this.beforeDate) || entry.getDate().after(this.toDate))) {
            return;
        }
        String key = ENTRY_KEY_TIMESTAMP_FORMAT.format(entry.getDate()) + entry.getAuthor() + entry.getComment();
        if (!this.entries.containsKey(key)) {
            entry.addFile(file);
            this.entries.put(key, entry);
        } else {
            ChangeLogEntry existingEntry = (ChangeLogEntry)this.entries.get(key);
            existingEntry.addFile(file);
        }
    }

    private void processGetFile(String line) {
        if (line.startsWith(START_FILE)) {
            this.setCurrentLogEntry(new ChangeLogEntry());
            this.setCurrentFile(new ChangeLogFile(line.substring(START_FILE.length(), line.length())));
            this.setStatus(4);
        }
    }

    private void processGetRevision(String line) {
        int pos = line.indexOf(REVISION_TAG);
        if (pos != -1) {
            this.getCurrentFile().setRevision(line.substring(pos + REVISION_TAG.length()));
            this.setStatus(2);
        } else if (line.startsWith(END_FILE)) {
            this.setStatus(1);
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
        }
    }

    private void processGetAuthor(String line) {
        if (line.startsWith(AUTHOR_TAG)) {
            int posDateTag = line.indexOf(DATE_TAG);
            String author = line.substring(AUTHOR_TAG.length(), posDateTag);
            this.getCurrentLogEntry().setAuthor(author);
            String date = line.substring(posDateTag + DATE_TAG.length());
            this.getCurrentLogEntry().setDate(this.parseDate(date));
            this.setStatus(3);
        }
    }

    private void processGetComment(String line) {
        if (line.startsWith(START_REVISION)) {
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
            this.setCurrentLogEntry(new ChangeLogEntry());
            this.setCurrentFile(new ChangeLogFile(this.getCurrentFile().getName()));
            this.setStatus(4);
        } else if (line.startsWith(END_FILE)) {
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
            this.setStatus(1);
        } else {
            this.getCurrentLogEntry().setComment(this.getCurrentLogEntry().getComment() + line + "\n");
        }
    }

    private ChangeLogFile getCurrentFile() {
        return this.currentFile;
    }

    private void setCurrentFile(ChangeLogFile currentFile) {
        this.currentFile = currentFile;
    }

    private ChangeLogEntry getCurrentLogEntry() {
        return this.currentLogEntry;
    }

    private void setCurrentLogEntry(ChangeLogEntry currentLogEntry) {
        this.currentLogEntry = currentLogEntry;
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private Date parseDate(String date) {
        try {
            return this.localFormat.parse(date.toString());
        }
        catch (ParseException e) {
            LOG.error((Object)"ParseException Caught", (Throwable)e);
            return null;
        }
    }

    private void setDateRange(String numDaysString) {
        int days = Integer.parseInt(numDaysString);
        this.beforeDate = new Date(System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L);
        this.toDate = new Date(System.currentTimeMillis() + 86400000L);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

