/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFactory;
import org.apache.maven.changelog.ChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.changelog.ChangeLogSet;
import org.apache.maven.project.Developer;

public class ChangeLog {
    private String type;
    private String range;
    private String date;
    private String tag;
    private String markerStart;
    private String markerEnd;
    private String dateFormat;
    private File base;
    private String clFactoryClass = null;
    private static final Map FACTORIES = new HashMap();
    private String connection;
    private List developers;
    private Collection sets;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$changelog$ChangeLog == null ? (class$org$apache$maven$changelog$ChangeLog = ChangeLog.class$("org.apache.maven.changelog.ChangeLog")) : class$org$apache$maven$changelog$ChangeLog));
    private File output;
    private String outputEncoding;
    private String commentFormat;
    static /* synthetic */ Class class$org$apache$maven$changelog$ChangeLog;

    public void setFactory(String factoryClassName) {
        this.clFactoryClass = factoryClassName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type == null) {
            this.type = "range";
        }
        return this.type;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getRange() {
        return this.range;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDate() {
        return this.date;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setMarkerStart(String marker) {
        this.markerStart = marker;
    }

    public String getMarkerStart() {
        return this.markerStart;
    }

    public void setMarkerEnd(String marker) {
        this.markerEnd = marker;
    }

    public String getMarkerEnd() {
        return this.markerEnd;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setBasedir(File base) {
        this.base = base;
    }

    public File getBasedir() {
        return this.base;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public String getRepositoryConnection() {
        return this.connection;
    }

    public void setRepositoryConnection(String aString) {
        this.connection = aString;
    }

    public void doExecute() throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (this.output == null) {
            throw new NullPointerException("output must be set");
        }
        this.generateSets();
        this.replaceAuthorIdWithName();
        this.createDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSets() throws IOException {
        ChangeLogFactory factory = this.createFactory();
        String markers = "";
        markers = this.getType().equalsIgnoreCase("tag") ? this.getTag() : (this.getType().equalsIgnoreCase("date") ? this.getDate() : this.getRange());
        StringTokenizer tokens = new StringTokenizer(markers, ",");
        this.sets = new ArrayList(tokens.countTokens());
        String end = tokens.nextToken();
        do {
            String logEnd;
            String logStart;
            Collection entries;
            String start = end;
            end = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            this.setMarkerStart(start);
            this.setMarkerEnd(end);
            ChangeLogParser parser = factory.createParser();
            if (this.getDateFormat() != null) {
                parser.setDateFormatInFile(this.getDateFormat());
            }
            parser.init(this);
            ChangeLogGenerator generator = factory.createGenerator();
            generator.init(this);
            try {
                entries = generator.getEntries(parser);
                logStart = generator.getLogStart();
                logEnd = generator.getLogEnd();
            }
            catch (IOException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            finally {
                generator.cleanup();
                parser.cleanup();
            }
            if (entries == null) {
                entries = Collections.EMPTY_LIST;
            }
            this.sets.add(new ChangeLogSet(entries, logStart, logEnd));
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)("ChangeSet between " + logStart + " and " + logEnd + ": " + entries.size() + " entries"));
        } while (end != null);
    }

    private ChangeLogFactory createFactory() throws IOException {
        if (this.clFactoryClass == null) {
            if (this.connection == null || this.connection.length() < 7 || !this.connection.startsWith("scm:")) {
                LOG.warn((Object)"Connection does not appear valid");
            } else {
                this.clFactoryClass = (String)FACTORIES.get(this.connection.substring(4, 7));
            }
            if (this.clFactoryClass == null) {
                LOG.warn((Object)("Could not derive factory from connection: using CVS (valid factories are: " + FACTORIES.keySet() + ")"));
                this.clFactoryClass = "org.apache.maven.cvslib.CvsChangeLogFactory";
            }
        }
        try {
            Class<?> clazz = Class.forName(this.clFactoryClass);
            return (ChangeLogFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Cannot find class " + this.clFactoryClass + " " + cnfe.toString());
        }
        catch (IllegalAccessException iae) {
            throw new IOException("Cannot access class " + this.clFactoryClass + " " + iae.toString());
        }
        catch (InstantiationException ie) {
            throw new IOException("Cannot instantiate class " + this.clFactoryClass + " " + ie.toString());
        }
    }

    private Properties getUserList() {
        Properties userList = new Properties();
        Developer developer = null;
        Iterator i = this.getDevelopers().iterator();
        while (i.hasNext()) {
            developer = (Developer)i.next();
            userList.put(developer.getId(), developer.getName());
        }
        return userList;
    }

    private void replaceAuthorIdWithName() {
        Properties userList = this.getUserList();
        ChangeLogEntry entry = null;
        Iterator iSets = this.getChangeSets().iterator();
        while (iSets.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)iSets.next();
            Iterator iEntries = set.getEntries().iterator();
            while (iEntries.hasNext()) {
                entry = (ChangeLogEntry)iEntries.next();
                if (!userList.containsKey(entry.getAuthor())) continue;
                entry.setAuthor(userList.getProperty(entry.getAuthor()));
            }
        }
    }

    private void createDocument() throws FileNotFoundException, UnsupportedEncodingException {
        File dir = this.output.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), this.getOutputEncoding()));
        out.println(this.toXML());
        out.flush();
        out.close();
    }

    private String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"").append(this.getOutputEncoding()).append("\" ?>\n").append("<changelog>\n");
        Iterator i = this.getChangeSets().iterator();
        while (i.hasNext()) {
            buffer.append(((ChangeLogSet)i.next()).toXML());
        }
        buffer.append("</changelog>\n");
        return buffer.toString();
    }

    public Collection getChangeSets() {
        if (this.sets == null) {
            this.sets = Collections.EMPTY_LIST;
        }
        return this.sets;
    }

    public void setChangeSets(Collection sets) {
        this.sets = sets;
    }

    public List getDevelopers() {
        return this.developers;
    }

    public void setDevelopers(List developers) {
        this.developers = developers;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getCommentFormat() {
        return this.commentFormat;
    }

    public void setCommentFormat(String commentFormat) {
        this.commentFormat = commentFormat;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FACTORIES.put("cvs", "org.apache.maven.cvslib.CvsChangeLogFactory");
        FACTORIES.put("svn", "org.apache.maven.svnlib.SvnChangeLogFactory");
        FACTORIES.put("clearcase", "org.apache.maven.clearcaselib.ClearcaseChangeLogFactory");
        FACTORIES.put("perforce", "org.apache.maven.perforcelib.PerforceChangeLogFactory");
        FACTORIES.put("starteam", "org.apache.maven.starteamlib.StarteamChangeLogFactory");
        FACTORIES.put("vss", "org.apache.maven.vsslib.VssChangeLogFactory");
    }
}

