/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dist;

import org.apache.maven.MavenException;
import org.apache.maven.project.Project;
import org.apache.maven.repository.ArtifactTypeHandler;

public class DistributionArtifactTypeHandler
implements ArtifactTypeHandler {
    public String constructRepositoryDirectoryPath(String type, Project project) throws MavenException {
        StringBuffer path = new StringBuffer();
        path.append(project.getArtifactDirectory());
        path.append("/distributions/");
        return path.toString();
    }

    public String constructRepositoryFullPath(String type, Project project, String version) throws MavenException {
        StringBuffer path = new StringBuffer(this.constructRepositoryDirectoryPath(type, project));
        path.append(project.getArtifactId());
        path.append("-");
        path.append(version);
        if (!type.startsWith("distribution")) {
            throw new MavenException("Type is not a distribution (is " + type + ")");
        }
        String subtype = type.substring(12);
        if (subtype.startsWith("-src")) {
            path.append("-src");
            subtype = subtype.substring(4);
        }
        if (subtype.equals("-targz")) {
            path.append(".tar.gz");
        } else if (subtype.equals("-tarbz2")) {
            path.append(".tar.bz2");
        } else if (subtype.equals("-zip")) {
            path.append(".zip");
        } else {
            throw new MavenException("Unrecognised distribution type (is " + type + ")");
        }
        return path.toString();
    }
}

