/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.maven.model.Branch;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.PackageGroup;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.SourceModification;
import org.apache.maven.model.UnitTest;
import org.apache.maven.model.Version;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenXpp3Reader {
    private boolean addDefaultEntities = true;

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private Branch parseBranch(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Branch branch = new Branch();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("tag")) {
                branch.setTag(parser.nextText().trim());
                continue;
            }
            parser.nextText();
        }
        return branch;
    }

    private Build parseBuild(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Build build = new Build();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("nagEmailAddress")) {
                build.setNagEmailAddress(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("sourceDirectory")) {
                build.setSourceDirectory(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("unitTestSourceDirectory")) {
                build.setUnitTestSourceDirectory(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("aspectSourceDirectory")) {
                build.setAspectSourceDirectory(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("integrationUnitTestSourceDirectory")) {
                build.setIntegrationUnitTestSourceDirectory(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("sourceModifications")) {
                ArrayList<SourceModification> sourceModifications = new ArrayList<SourceModification>();
                build.setSourceModifications(sourceModifications);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("sourceModification")) {
                        sourceModifications.add(this.parseSourceModification("sourceModification", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("unitTest")) {
                build.setUnitTest(this.parseUnitTest("unitTest", parser));
                continue;
            }
            if (parser.getName().equals("defaultGoal")) {
                build.setDefaultGoal(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("resources")) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                build.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return build;
    }

    private BuildBase parseBuildBase(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        BuildBase buildBase = new BuildBase();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("defaultGoal")) {
                buildBase.setDefaultGoal(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("resources")) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                buildBase.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return buildBase;
    }

    private Contributor parseContributor(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Contributor contributor = new Contributor();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("name")) {
                contributor.setName(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("email")) {
                contributor.setEmail(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("url")) {
                contributor.setUrl(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("organization")) {
                contributor.setOrganization(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("organizationUrl")) {
                contributor.setOrganizationUrl(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("roles")) {
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("timezone")) {
                contributor.setTimezone(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    contributor.addProperty(key, value);
                }
                continue;
            }
            parser.nextText();
        }
        return contributor;
    }

    private Dependency parseDependency(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Dependency dependency = new Dependency();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("id")) {
                dependency.setId(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("groupId")) {
                dependency.setGroupId(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                dependency.setArtifactId(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("version")) {
                dependency.setVersion(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("url")) {
                dependency.setUrl(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("jar")) {
                dependency.setJar(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("type")) {
                dependency.setType(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    dependency.addProperty(key, value);
                }
                continue;
            }
            parser.nextText();
        }
        return dependency;
    }

    private Developer parseDeveloper(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Developer developer = new Developer();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("id")) {
                developer.setId(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("name")) {
                developer.setName(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("email")) {
                developer.setEmail(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("url")) {
                developer.setUrl(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("organization")) {
                developer.setOrganization(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("organizationUrl")) {
                developer.setOrganizationUrl(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("roles")) {
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("timezone")) {
                developer.setTimezone(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    developer.addProperty(key, value);
                }
                continue;
            }
            parser.nextText();
        }
        return developer;
    }

    private FileSet parseFileSet(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        FileSet fileSet = new FileSet();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("directory")) {
                fileSet.setDirectory(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return fileSet;
    }

    private License parseLicense(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        License license = new License();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("name")) {
                license.setName(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("url")) {
                license.setUrl(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("distribution")) {
                license.setDistribution(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("comments")) {
                license.setComments(parser.nextText().trim());
                continue;
            }
            parser.nextText();
        }
        return license;
    }

    private MailingList parseMailingList(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        MailingList mailingList = new MailingList();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("name")) {
                mailingList.setName(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("subscribe")) {
                mailingList.setSubscribe(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("unsubscribe")) {
                mailingList.setUnsubscribe(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("post")) {
                mailingList.setPost(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("archive")) {
                mailingList.setArchive(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("otherArchives")) {
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("otherArchive")) {
                        otherArchives.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return mailingList;
    }

    private Model parseModel(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Model model = new Model();
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals(tagName)) {
                    // empty if block
                }
                if (parser.getName().equals("extend")) {
                    model.setExtend(parser.nextText().trim());
                } else if (parser.getName().equals("pomVersion")) {
                    model.setPomVersion(parser.nextText().trim());
                } else if (parser.getName().equals("id")) {
                    model.setId(parser.nextText().trim());
                } else if (parser.getName().equals("groupId")) {
                    model.setGroupId(parser.nextText().trim());
                } else if (parser.getName().equals("artifactId")) {
                    model.setArtifactId(parser.nextText().trim());
                } else if (parser.getName().equals("name")) {
                    model.setName(parser.nextText().trim());
                } else if (parser.getName().equals("currentVersion")) {
                    model.setCurrentVersion(parser.nextText().trim());
                } else if (parser.getName().equals("shortDescription")) {
                    model.setShortDescription(parser.nextText().trim());
                } else if (parser.getName().equals("description")) {
                    model.setDescription(parser.nextText().trim());
                } else if (parser.getName().equals("url")) {
                    model.setUrl(parser.nextText().trim());
                } else if (parser.getName().equals("logo")) {
                    model.setLogo(parser.nextText().trim());
                } else if (parser.getName().equals("issueTrackingUrl")) {
                    model.setIssueTrackingUrl(parser.nextText().trim());
                } else if (parser.getName().equals("inceptionYear")) {
                    model.setInceptionYear(parser.nextText().trim());
                } else if (parser.getName().equals("gumpRepositoryId")) {
                    model.setGumpRepositoryId(parser.nextText().trim());
                } else if (parser.getName().equals("siteAddress")) {
                    model.setSiteAddress(parser.nextText().trim());
                } else if (parser.getName().equals("siteDirectory")) {
                    model.setSiteDirectory(parser.nextText().trim());
                } else if (parser.getName().equals("distributionSite")) {
                    model.setDistributionSite(parser.nextText().trim());
                } else if (parser.getName().equals("distributionDirectory")) {
                    model.setDistributionDirectory(parser.nextText().trim());
                } else if (parser.getName().equals("mailingLists")) {
                    ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                    model.setMailingLists(mailingLists);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("mailingList")) {
                            mailingLists.add(this.parseMailingList("mailingList", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("developers")) {
                    ArrayList<Developer> developers = new ArrayList<Developer>();
                    model.setDevelopers(developers);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("developer")) {
                            developers.add(this.parseDeveloper("developer", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("contributors")) {
                    ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                    model.setContributors(contributors);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("contributor")) {
                            contributors.add(this.parseContributor("contributor", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("licenses")) {
                    ArrayList<License> licenses = new ArrayList<License>();
                    model.setLicenses(licenses);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("license")) {
                            licenses.add(this.parseLicense("license", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("versions")) {
                    ArrayList<Version> versions = new ArrayList<Version>();
                    model.setVersions(versions);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("version")) {
                            versions.add(this.parseVersion("version", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("branches")) {
                    ArrayList<Branch> branches = new ArrayList<Branch>();
                    model.setBranches(branches);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("branch")) {
                            branches.add(this.parseBranch("branch", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("packageGroups")) {
                    ArrayList<PackageGroup> packageGroups = new ArrayList<PackageGroup>();
                    model.setPackageGroups(packageGroups);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("packageGroup")) {
                            packageGroups.add(this.parsePackageGroup("packageGroup", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("reports")) {
                    ArrayList<String> reports = new ArrayList<String>();
                    model.setReports(reports);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("report")) {
                            reports.add(parser.nextText().trim());
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("repository")) {
                    model.setRepository(this.parseRepository("repository", parser));
                } else if (parser.getName().equals("organization")) {
                    model.setOrganization(this.parseOrganization("organization", parser));
                } else if (parser.getName().equals("properties")) {
                    while (parser.nextTag() == 2) {
                        String key = parser.getName();
                        String value = parser.nextText().trim();
                        model.addProperty(key, value);
                    }
                } else if (parser.getName().equals("package")) {
                    model.setPackageName(parser.nextText().trim());
                } else if (parser.getName().equals("build")) {
                    model.setBuild(this.parseBuild("build", parser));
                } else if (parser.getName().equals("dependencies")) {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    model.setDependencies(dependencies);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("dependency")) {
                            dependencies.add(this.parseDependency("dependency", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                }
            }
            eventType = parser.next();
        }
        return model;
    }

    private ModelBase parseModelBase(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ModelBase modelBase = new ModelBase();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("dependencies")) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                modelBase.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return modelBase;
    }

    private Organization parseOrganization(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Organization organization = new Organization();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("name")) {
                organization.setName(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("url")) {
                organization.setUrl(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("logo")) {
                organization.setLogo(parser.nextText().trim());
                continue;
            }
            parser.nextText();
        }
        return organization;
    }

    private PackageGroup parsePackageGroup(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PackageGroup packageGroup = new PackageGroup();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("title")) {
                packageGroup.setTitle(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("packages")) {
                packageGroup.setPackages(parser.nextText().trim());
                continue;
            }
            parser.nextText();
        }
        return packageGroup;
    }

    private PatternSet parsePatternSet(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PatternSet patternSet = new PatternSet();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return patternSet;
    }

    private PluginConfiguration parsePluginConfiguration(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        while (parser.nextTag() == 2) {
            if (!parser.getName().equals(tagName)) continue;
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PluginContainer pluginContainer = new PluginContainer();
        while (parser.nextTag() == 2) {
            if (!parser.getName().equals(tagName)) continue;
        }
        return pluginContainer;
    }

    private Repository parseRepository(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Repository repository = new Repository();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("connection")) {
                repository.setConnection(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("developerConnection")) {
                repository.setDeveloperConnection(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("url")) {
                repository.setUrl(parser.nextText().trim());
                continue;
            }
            parser.nextText();
        }
        return repository;
    }

    private Resource parseResource(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Resource resource = new Resource();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("targetPath")) {
                resource.setTargetPath(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("filtering")) {
                resource.setFiltering(new Boolean(parser.nextText().trim()));
                continue;
            }
            if (parser.getName().equals("directory")) {
                resource.setDirectory(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return resource;
    }

    private SourceModification parseSourceModification(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        SourceModification sourceModification = new SourceModification();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("className")) {
                sourceModification.setClassName(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("property")) {
                sourceModification.setProperty(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("directory")) {
                sourceModification.setDirectory(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                sourceModification.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                sourceModification.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return sourceModification;
    }

    private UnitTest parseUnitTest(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        UnitTest unitTest = new UnitTest();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("resources")) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                unitTest.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                unitTest.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                unitTest.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(parser.nextText().trim());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return unitTest;
    }

    private Version parseVersion(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Version version = new Version();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) {
                // empty if block
            }
            if (parser.getName().equals("name")) {
                version.setName(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("tag")) {
                version.setTag(parser.nextText().trim());
                continue;
            }
            if (parser.getName().equals("id")) {
                version.setId(parser.nextText().trim());
                continue;
            }
            parser.nextText();
        }
        return version;
    }

    public Model read(Reader reader) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
        return this.parseModel("project", (XmlPullParser)parser);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

