/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.maven.model.Branch;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.PackageGroup;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.SourceModification;
import org.apache.maven.model.UnitTest;
import org.apache.maven.model.Version;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MavenXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, Model project) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.writeModel(project, "project", this.serializer);
    }

    private void writeBranch(Branch branch, String tagName, XmlSerializer serializer) throws IOException {
        if (branch != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (branch.getTag() != null) {
                serializer.startTag(this.NAMESPACE, "tag").text(branch.getTag()).endTag(this.NAMESPACE, "tag");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeBuild(Build build, String tagName, XmlSerializer serializer) throws IOException {
        if (build != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (build.getNagEmailAddress() != null) {
                serializer.startTag(this.NAMESPACE, "nagEmailAddress").text(build.getNagEmailAddress()).endTag(this.NAMESPACE, "nagEmailAddress");
            }
            if (build.getSourceDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "sourceDirectory").text(build.getSourceDirectory()).endTag(this.NAMESPACE, "sourceDirectory");
            }
            if (build.getUnitTestSourceDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "unitTestSourceDirectory").text(build.getUnitTestSourceDirectory()).endTag(this.NAMESPACE, "unitTestSourceDirectory");
            }
            if (build.getAspectSourceDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "aspectSourceDirectory").text(build.getAspectSourceDirectory()).endTag(this.NAMESPACE, "aspectSourceDirectory");
            }
            if (build.getIntegrationUnitTestSourceDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "integrationUnitTestSourceDirectory").text(build.getIntegrationUnitTestSourceDirectory()).endTag(this.NAMESPACE, "integrationUnitTestSourceDirectory");
            }
            if (build.getSourceModifications() != null && build.getSourceModifications().size() > 0) {
                serializer.startTag(this.NAMESPACE, "sourceModifications");
                iter = build.getSourceModifications().iterator();
                while (iter.hasNext()) {
                    SourceModification sourceModification = (SourceModification)iter.next();
                    this.writeSourceModification(sourceModification, "sourceModification", serializer);
                }
                serializer.endTag(this.NAMESPACE, "sourceModifications");
            }
            if (build.getUnitTest() != null) {
                this.writeUnitTest(build.getUnitTest(), "unitTest", serializer);
            }
            if (build.getDefaultGoal() != null) {
                serializer.startTag(this.NAMESPACE, "defaultGoal").text(build.getDefaultGoal()).endTag(this.NAMESPACE, "defaultGoal");
            }
            if (build.getResources() != null && build.getResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "resources");
                iter = build.getResources().iterator();
                while (iter.hasNext()) {
                    Resource resource = (Resource)iter.next();
                    this.writeResource(resource, "resource", serializer);
                }
                serializer.endTag(this.NAMESPACE, "resources");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeBuildBase(BuildBase buildBase, String tagName, XmlSerializer serializer) throws IOException {
        if (buildBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (buildBase.getDefaultGoal() != null) {
                serializer.startTag(this.NAMESPACE, "defaultGoal").text(buildBase.getDefaultGoal()).endTag(this.NAMESPACE, "defaultGoal");
            }
            if (buildBase.getResources() != null && buildBase.getResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "resources");
                Iterator iter = buildBase.getResources().iterator();
                while (iter.hasNext()) {
                    Resource resource = (Resource)iter.next();
                    this.writeResource(resource, "resource", serializer);
                }
                serializer.endTag(this.NAMESPACE, "resources");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeContributor(Contributor contributor, String tagName, XmlSerializer serializer) throws IOException {
        if (contributor != null) {
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (contributor.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(contributor.getName()).endTag(this.NAMESPACE, "name");
            }
            if (contributor.getEmail() != null) {
                serializer.startTag(this.NAMESPACE, "email").text(contributor.getEmail()).endTag(this.NAMESPACE, "email");
            }
            if (contributor.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(contributor.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (contributor.getOrganization() != null) {
                serializer.startTag(this.NAMESPACE, "organization").text(contributor.getOrganization()).endTag(this.NAMESPACE, "organization");
            }
            if (contributor.getOrganizationUrl() != null) {
                serializer.startTag(this.NAMESPACE, "organizationUrl").text(contributor.getOrganizationUrl()).endTag(this.NAMESPACE, "organizationUrl");
            }
            if (contributor.getRoles() != null && contributor.getRoles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "roles");
                iter = contributor.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "role").text(role).endTag(this.NAMESPACE, "role");
                }
                serializer.endTag(this.NAMESPACE, "roles");
            }
            if (contributor.getTimezone() != null) {
                serializer.startTag(this.NAMESPACE, "timezone").text(contributor.getTimezone()).endTag(this.NAMESPACE, "timezone");
            }
            if (contributor.getProperties() != null && ((Hashtable)contributor.getProperties()).size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = ((Hashtable)contributor.getProperties()).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)((Hashtable)contributor.getProperties()).get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDependency(Dependency dependency, String tagName, XmlSerializer serializer) throws IOException {
        if (dependency != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (dependency.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(dependency.getId()).endTag(this.NAMESPACE, "id");
            }
            if (dependency.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(dependency.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (dependency.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(dependency.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (dependency.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(dependency.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (dependency.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(dependency.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (dependency.getJar() != null) {
                serializer.startTag(this.NAMESPACE, "jar").text(dependency.getJar()).endTag(this.NAMESPACE, "jar");
            }
            if (dependency.getType() != null && !dependency.getType().equals("jar")) {
                serializer.startTag(this.NAMESPACE, "type").text(dependency.getType()).endTag(this.NAMESPACE, "type");
            }
            if (dependency.getProperties() != null && ((Hashtable)dependency.getProperties()).size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                Iterator iter = ((Hashtable)dependency.getProperties()).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)((Hashtable)dependency.getProperties()).get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDeveloper(Developer developer, String tagName, XmlSerializer serializer) throws IOException {
        if (developer != null) {
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (developer.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(developer.getId()).endTag(this.NAMESPACE, "id");
            }
            if (developer.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(developer.getName()).endTag(this.NAMESPACE, "name");
            }
            if (developer.getEmail() != null) {
                serializer.startTag(this.NAMESPACE, "email").text(developer.getEmail()).endTag(this.NAMESPACE, "email");
            }
            if (developer.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(developer.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (developer.getOrganization() != null) {
                serializer.startTag(this.NAMESPACE, "organization").text(developer.getOrganization()).endTag(this.NAMESPACE, "organization");
            }
            if (developer.getOrganizationUrl() != null) {
                serializer.startTag(this.NAMESPACE, "organizationUrl").text(developer.getOrganizationUrl()).endTag(this.NAMESPACE, "organizationUrl");
            }
            if (developer.getRoles() != null && developer.getRoles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "roles");
                iter = developer.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "role").text(role).endTag(this.NAMESPACE, "role");
                }
                serializer.endTag(this.NAMESPACE, "roles");
            }
            if (developer.getTimezone() != null) {
                serializer.startTag(this.NAMESPACE, "timezone").text(developer.getTimezone()).endTag(this.NAMESPACE, "timezone");
            }
            if (developer.getProperties() != null && ((Hashtable)developer.getProperties()).size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = ((Hashtable)developer.getProperties()).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)((Hashtable)developer.getProperties()).get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (fileSet.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeLicense(License license, String tagName, XmlSerializer serializer) throws IOException {
        if (license != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (license.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(license.getName()).endTag(this.NAMESPACE, "name");
            }
            if (license.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(license.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (license.getDistribution() != null) {
                serializer.startTag(this.NAMESPACE, "distribution").text(license.getDistribution()).endTag(this.NAMESPACE, "distribution");
            }
            if (license.getComments() != null) {
                serializer.startTag(this.NAMESPACE, "comments").text(license.getComments()).endTag(this.NAMESPACE, "comments");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMailingList(MailingList mailingList, String tagName, XmlSerializer serializer) throws IOException {
        if (mailingList != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (mailingList.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(mailingList.getName()).endTag(this.NAMESPACE, "name");
            }
            if (mailingList.getSubscribe() != null) {
                serializer.startTag(this.NAMESPACE, "subscribe").text(mailingList.getSubscribe()).endTag(this.NAMESPACE, "subscribe");
            }
            if (mailingList.getUnsubscribe() != null) {
                serializer.startTag(this.NAMESPACE, "unsubscribe").text(mailingList.getUnsubscribe()).endTag(this.NAMESPACE, "unsubscribe");
            }
            if (mailingList.getPost() != null) {
                serializer.startTag(this.NAMESPACE, "post").text(mailingList.getPost()).endTag(this.NAMESPACE, "post");
            }
            if (mailingList.getArchive() != null) {
                serializer.startTag(this.NAMESPACE, "archive").text(mailingList.getArchive()).endTag(this.NAMESPACE, "archive");
            }
            if (mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0) {
                serializer.startTag(this.NAMESPACE, "otherArchives");
                Iterator iter = mailingList.getOtherArchives().iterator();
                while (iter.hasNext()) {
                    String otherArchive = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "otherArchive").text(otherArchive).endTag(this.NAMESPACE, "otherArchive");
                }
                serializer.endTag(this.NAMESPACE, "otherArchives");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeModel(Model model, String tagName, XmlSerializer serializer) throws IOException {
        if (model != null) {
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (model.getExtend() != null) {
                serializer.startTag(this.NAMESPACE, "extend").text(model.getExtend()).endTag(this.NAMESPACE, "extend");
            }
            if (model.getPomVersion() != null) {
                serializer.startTag(this.NAMESPACE, "pomVersion").text(model.getPomVersion()).endTag(this.NAMESPACE, "pomVersion");
            }
            if (model.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(model.getId()).endTag(this.NAMESPACE, "id");
            }
            if (model.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(model.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (model.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(model.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (model.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(model.getName()).endTag(this.NAMESPACE, "name");
            }
            if (model.getCurrentVersion() != null) {
                serializer.startTag(this.NAMESPACE, "currentVersion").text(model.getCurrentVersion()).endTag(this.NAMESPACE, "currentVersion");
            }
            if (model.getShortDescription() != null) {
                serializer.startTag(this.NAMESPACE, "shortDescription").text(model.getShortDescription()).endTag(this.NAMESPACE, "shortDescription");
            }
            if (model.getDescription() != null) {
                serializer.startTag(this.NAMESPACE, "description").text(model.getDescription()).endTag(this.NAMESPACE, "description");
            }
            if (model.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(model.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (model.getLogo() != null) {
                serializer.startTag(this.NAMESPACE, "logo").text(model.getLogo()).endTag(this.NAMESPACE, "logo");
            }
            if (model.getIssueTrackingUrl() != null) {
                serializer.startTag(this.NAMESPACE, "issueTrackingUrl").text(model.getIssueTrackingUrl()).endTag(this.NAMESPACE, "issueTrackingUrl");
            }
            if (model.getInceptionYear() != null) {
                serializer.startTag(this.NAMESPACE, "inceptionYear").text(model.getInceptionYear()).endTag(this.NAMESPACE, "inceptionYear");
            }
            if (model.getGumpRepositoryId() != null) {
                serializer.startTag(this.NAMESPACE, "gumpRepositoryId").text(model.getGumpRepositoryId()).endTag(this.NAMESPACE, "gumpRepositoryId");
            }
            if (model.getSiteAddress() != null) {
                serializer.startTag(this.NAMESPACE, "siteAddress").text(model.getSiteAddress()).endTag(this.NAMESPACE, "siteAddress");
            }
            if (model.getSiteDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "siteDirectory").text(model.getSiteDirectory()).endTag(this.NAMESPACE, "siteDirectory");
            }
            if (model.getDistributionSite() != null) {
                serializer.startTag(this.NAMESPACE, "distributionSite").text(model.getDistributionSite()).endTag(this.NAMESPACE, "distributionSite");
            }
            if (model.getDistributionDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "distributionDirectory").text(model.getDistributionDirectory()).endTag(this.NAMESPACE, "distributionDirectory");
            }
            if (model.getMailingLists() != null && model.getMailingLists().size() > 0) {
                serializer.startTag(this.NAMESPACE, "mailingLists");
                iter = model.getMailingLists().iterator();
                while (iter.hasNext()) {
                    MailingList mailingList = (MailingList)iter.next();
                    this.writeMailingList(mailingList, "mailingList", serializer);
                }
                serializer.endTag(this.NAMESPACE, "mailingLists");
            }
            if (model.getDevelopers() != null && model.getDevelopers().size() > 0) {
                serializer.startTag(this.NAMESPACE, "developers");
                iter = model.getDevelopers().iterator();
                while (iter.hasNext()) {
                    Developer developer = (Developer)iter.next();
                    this.writeDeveloper(developer, "developer", serializer);
                }
                serializer.endTag(this.NAMESPACE, "developers");
            }
            if (model.getContributors() != null && model.getContributors().size() > 0) {
                serializer.startTag(this.NAMESPACE, "contributors");
                iter = model.getContributors().iterator();
                while (iter.hasNext()) {
                    Contributor contributor = (Contributor)iter.next();
                    this.writeContributor(contributor, "contributor", serializer);
                }
                serializer.endTag(this.NAMESPACE, "contributors");
            }
            if (model.getLicenses() != null && model.getLicenses().size() > 0) {
                serializer.startTag(this.NAMESPACE, "licenses");
                iter = model.getLicenses().iterator();
                while (iter.hasNext()) {
                    License license = (License)iter.next();
                    this.writeLicense(license, "license", serializer);
                }
                serializer.endTag(this.NAMESPACE, "licenses");
            }
            if (model.getVersions() != null && model.getVersions().size() > 0) {
                serializer.startTag(this.NAMESPACE, "versions");
                iter = model.getVersions().iterator();
                while (iter.hasNext()) {
                    Version version = (Version)iter.next();
                    this.writeVersion(version, "version", serializer);
                }
                serializer.endTag(this.NAMESPACE, "versions");
            }
            if (model.getBranches() != null && model.getBranches().size() > 0) {
                serializer.startTag(this.NAMESPACE, "branches");
                iter = model.getBranches().iterator();
                while (iter.hasNext()) {
                    Branch branch = (Branch)iter.next();
                    this.writeBranch(branch, "branch", serializer);
                }
                serializer.endTag(this.NAMESPACE, "branches");
            }
            if (model.getPackageGroups() != null && model.getPackageGroups().size() > 0) {
                serializer.startTag(this.NAMESPACE, "packageGroups");
                iter = model.getPackageGroups().iterator();
                while (iter.hasNext()) {
                    PackageGroup packageGroup = (PackageGroup)iter.next();
                    this.writePackageGroup(packageGroup, "packageGroup", serializer);
                }
                serializer.endTag(this.NAMESPACE, "packageGroups");
            }
            if (model.getReports() != null && model.getReports().size() > 0) {
                serializer.startTag(this.NAMESPACE, "reports");
                iter = model.getReports().iterator();
                while (iter.hasNext()) {
                    String report = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "report").text(report).endTag(this.NAMESPACE, "report");
                }
                serializer.endTag(this.NAMESPACE, "reports");
            }
            if (model.getRepository() != null) {
                this.writeRepository(model.getRepository(), "repository", serializer);
            }
            if (model.getOrganization() != null) {
                this.writeOrganization(model.getOrganization(), "organization", serializer);
            }
            if (model.getProperties() != null && ((Hashtable)model.getProperties()).size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = ((Hashtable)model.getProperties()).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)((Hashtable)model.getProperties()).get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            if (model.getPackageName() != null) {
                serializer.startTag(this.NAMESPACE, "package").text(model.getPackageName()).endTag(this.NAMESPACE, "package");
            }
            if (model.getBuild() != null) {
                this.writeBuild(model.getBuild(), "build", serializer);
            }
            if (model.getDependencies() != null && model.getDependencies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencies");
                iter = model.getDependencies().iterator();
                while (iter.hasNext()) {
                    Dependency dependency = (Dependency)iter.next();
                    this.writeDependency(dependency, "dependency", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencies");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeModelBase(ModelBase modelBase, String tagName, XmlSerializer serializer) throws IOException {
        if (modelBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencies");
                Iterator iter = modelBase.getDependencies().iterator();
                while (iter.hasNext()) {
                    Dependency dependency = (Dependency)iter.next();
                    this.writeDependency(dependency, "dependency", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencies");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeOrganization(Organization organization, String tagName, XmlSerializer serializer) throws IOException {
        if (organization != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (organization.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(organization.getName()).endTag(this.NAMESPACE, "name");
            }
            if (organization.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(organization.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (organization.getLogo() != null) {
                serializer.startTag(this.NAMESPACE, "logo").text(organization.getLogo()).endTag(this.NAMESPACE, "logo");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePackageGroup(PackageGroup packageGroup, String tagName, XmlSerializer serializer) throws IOException {
        if (packageGroup != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (packageGroup.getTitle() != null) {
                serializer.startTag(this.NAMESPACE, "title").text(packageGroup.getTitle()).endTag(this.NAMESPACE, "title");
            }
            if (packageGroup.getPackages() != null) {
                serializer.startTag(this.NAMESPACE, "packages").text(packageGroup.getPackages()).endTag(this.NAMESPACE, "packages");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePatternSet(PatternSet patternSet, String tagName, XmlSerializer serializer) throws IOException {
        if (patternSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = patternSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = patternSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginConfiguration != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginContainer(PluginContainer pluginContainer, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginContainer != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repository.getConnection() != null) {
                serializer.startTag(this.NAMESPACE, "connection").text(repository.getConnection()).endTag(this.NAMESPACE, "connection");
            }
            if (repository.getDeveloperConnection() != null) {
                serializer.startTag(this.NAMESPACE, "developerConnection").text(repository.getDeveloperConnection()).endTag(this.NAMESPACE, "developerConnection");
            }
            if (repository.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repository.getUrl()).endTag(this.NAMESPACE, "url");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeResource(Resource resource, String tagName, XmlSerializer serializer) throws IOException {
        if (resource != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (resource.getTargetPath() != null) {
                serializer.startTag(this.NAMESPACE, "targetPath").text(resource.getTargetPath()).endTag(this.NAMESPACE, "targetPath");
            }
            if (resource.isFiltering()) {
                serializer.startTag(this.NAMESPACE, "filtering").text(String.valueOf(resource.isFiltering())).endTag(this.NAMESPACE, "filtering");
            }
            if (resource.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(resource.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (resource.getIncludes() != null && resource.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = resource.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (resource.getExcludes() != null && resource.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = resource.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSourceModification(SourceModification sourceModification, String tagName, XmlSerializer serializer) throws IOException {
        if (sourceModification != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (sourceModification.getClassName() != null) {
                serializer.startTag(this.NAMESPACE, "className").text(sourceModification.getClassName()).endTag(this.NAMESPACE, "className");
            }
            if (sourceModification.getProperty() != null) {
                serializer.startTag(this.NAMESPACE, "property").text(sourceModification.getProperty()).endTag(this.NAMESPACE, "property");
            }
            if (sourceModification.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(sourceModification.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (sourceModification.getIncludes() != null && sourceModification.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = sourceModification.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (sourceModification.getExcludes() != null && sourceModification.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = sourceModification.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeUnitTest(UnitTest unitTest, String tagName, XmlSerializer serializer) throws IOException {
        if (unitTest != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (unitTest.getResources() != null && unitTest.getResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "resources");
                iter = unitTest.getResources().iterator();
                while (iter.hasNext()) {
                    Resource resource = (Resource)iter.next();
                    this.writeResource(resource, "resource", serializer);
                }
                serializer.endTag(this.NAMESPACE, "resources");
            }
            if (unitTest.getIncludes() != null && unitTest.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = unitTest.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (unitTest.getExcludes() != null && unitTest.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = unitTest.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeVersion(Version version, String tagName, XmlSerializer serializer) throws IOException {
        if (version != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (version.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(version.getName()).endTag(this.NAMESPACE, "name");
            }
            if (version.getTag() != null) {
                serializer.startTag(this.NAMESPACE, "tag").text(version.getTag()).endTag(this.NAMESPACE, "tag");
            }
            if (version.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(version.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

