/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;

public class Dependency
implements Serializable {
    private String id;
    private String groupId;
    private String artifactId;
    private String version;
    private String url;
    private String jar;
    private String type = "jar";
    private Properties properties;

    public void addProperty(String key, String value) {
        ((Hashtable)this.getProperties()).put(key, value);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getId() {
        return this.id;
    }

    public String getJar() {
        return this.jar;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.groupId + "/" + this.type + "s:" + this.artifactId + "-" + this.version;
    }

    public String getKey() {
        return this.getId() + ":" + this.getType();
    }

    public String getArtifactDirectory() {
        return this.getGroupId();
    }

    public String getArtifact() {
        if (this.getJar() != null) {
            return this.getJar();
        }
        return this.getArtifactId() + "-" + this.getVersion() + "." + this.getExtension();
    }

    public String getExtension() {
        if ("ejb".equals(this.getType()) || "plugin".equals(this.getType()) || "aspect".equals(this.getType()) || "uberjar".equals(this.getType())) {
            return "jar";
        }
        return this.getType();
    }

    public boolean isAddedToClasspath() {
        return "jar".equals(this.getType()) || "ejb".equals(this.getType()) || "sar".equals(this.getType());
    }

    public boolean isPlugin() {
        return "plugin".equals(this.getType());
    }

    public String getProperty(String property) {
        return this.getProperties().getProperty(property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency d = (Dependency)o;
        return this.getId().equals(d.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

