/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Dependency implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field url
     */
    private String url;

    /**
     * Field jar
     */
    private String jar;

    /**
     * Field type
     */
    private String type = "jar";

    /**
     * Field properties
     */
    private java.util.Properties properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Get 
     *             The unique id for an artifact produced by the
     * project group, e.g.
     *             <code>maven-artifact</code>.
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             The project group that produced the dependency,
     * e.g.
     *             <code>org.apache.maven</code>.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *               <strong>Deprecated</strong>. Please use
     * <code>groupId</code> and
     *               <code>artifactId</code> together instead.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             Literal name of the artifact in the repository.
     * Used to override the calculated artifact name.
     *           
     */
    public String getJar()
    {
        return this.jar;
    } //-- String getJar() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Get 
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it usually represents the extension
     * on
     *             the filename of the dependency, that is not
     * always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, and <code>plugin</code>.
     *             A dependency of type <code>plugin</code> is
     * loaded as a Maven plugin and not added to the project
     *             build classpath.
     *           
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get 
     *             This url will be provided to the user if the jar
     * file cannot be downloaded
     *             from the central repository.
     *           
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Get 
     *             The version of the dependency, e.g.
     * <code>3.2.1</code>. In Maven 2, this can also be
     *             specified as a range of versions.
     *           
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Set 
     *             The unique id for an artifact produced by the
     * project group, e.g.
     *             <code>maven-artifact</code>.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             The project group that produced the dependency,
     * e.g.
     *             <code>org.apache.maven</code>.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *               <strong>Deprecated</strong>. Please use
     * <code>groupId</code> and
     *               <code>artifactId</code> together instead.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             Literal name of the artifact in the repository.
     * Used to override the calculated artifact name.
     *           
     * 
     * @param jar
     */
    public void setJar(String jar)
    {
        this.jar = jar;
    } //-- void setJar(String) 

    /**
     * Set 
     *             Properties about the dependency. Various plugins
     * allow you to 
     *             mark dependencies with properties. For example
     * the war plugin looks for a
     *             <code>war.bundle</code> property, and if found
     * will include the 
     *             dependency in <code>WEB-INF/lib</code>.
     *           
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 

    /**
     * Set 
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it usually represents the extension
     * on
     *             the filename of the dependency, that is not
     * always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, and <code>plugin</code>.
     *             A dependency of type <code>plugin</code> is
     * loaded as a Maven plugin and not added to the project
     *             build classpath.
     *           
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Set 
     *             This url will be provided to the user if the jar
     * file cannot be downloaded
     *             from the central repository.
     *           
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Set 
     *             The version of the dependency, e.g.
     * <code>3.2.1</code>. In Maven 2, this can also be
     *             specified as a range of versions.
     *           
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            public String toString()
            {
                return groupId + "/" + type + "s:" + artifactId + "-" + version;
            }
          
            public String getKey()
            {
                return getId() + ":" + getType();
            }

            public String getArtifactDirectory()
            {
                return getGroupId();
            }
        
            public String getArtifact()
            {
                // If the jar name has been explicty set then use that. This
                // is when the <jar/> element is explicity used in the POM.
                if ( getJar() != null)
                {
                    return getJar();
                }

                String artifact;

                if ("ejb-client".equals(getType())) {
                  artifact = getArtifactId() + "-" + getVersion() + "-client." + getExtension();
                } else {
                  artifact = getArtifactId() + "-" + getVersion() + "." + getExtension();
                }

                return artifact;
            }

            public String getTypeDirectory()
            {
                String path;
                if (getType().equals("ejb-client")) {
                    path = "ejbs";
                } else {
                    path = getType() + "s";
                }
               return path;
            }
        
            public String getExtension()
            {
                if ("ejb".equals(getType()) || "ejb-client".equals(getType()) || "plugin".equals(getType()) || "aspect".equals(getType()) || "uberjar".equals(getType())) return "jar";
                return getType();
            }
        
            public boolean isAddedToClasspath()
            {
                return ("jar".equals(getType()) || "ejb".equals(getType()) || "ejb-client".equals(getType()) || "sar".equals(getType()));
            }
        
            public boolean isPlugin()
            {
                return ("plugin".equals(getType()));
            }
        
            public String getProperty( String property )
            {
                return getProperties().getProperty( property );
            }

            public boolean equals( Object o )
            {
                if ( this == o )
                {
                    return true;
                }
            
                if ( !( o instanceof Dependency ) )
                {
                    return false;
                }
            
                Dependency d  = (Dependency) o;
                return getId().equals( d.getId() );
            }
            
            public int hashCode()
            {
                return getId().hashCode();
            }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
