/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This element describes all of the mailing lists
 * associated with
 *         a project. The auto-generated site references this
 * information.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class MailingList implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field subscribe
     */
    private String subscribe;

    /**
     * Field unsubscribe
     */
    private String unsubscribe;

    /**
     * Field post
     */
    private String post;

    /**
     * Field archive
     */
    private String archive;

    /**
     * Field otherArchives
     */
    private java.util.List otherArchives;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addOtherArchive
     * 
     * @param string
     */
    public void addOtherArchive(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "MailingList.addOtherArchives(string) parameter must be instanceof " + String.class.getName() );
        }
        getOtherArchives().add( string );
    } //-- void addOtherArchive(String) 

    /**
     * Get 
     *             The link to a URL where you can browse the
     * mailing list archive.
     *           
     */
    public String getArchive()
    {
        return this.archive;
    } //-- String getArchive() 

    /**
     * Get The name of the mailing list.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method getOtherArchives
     */
    public java.util.List getOtherArchives()
    {
        if ( this.otherArchives == null )
        {
            this.otherArchives = new java.util.ArrayList();
        }
        
        return this.otherArchives;
    } //-- java.util.List getOtherArchives() 

    /**
     * Get 
     *             The email address or link that can be used to
     * post to
     *             the mailing list.  If this is an email address,
     * a
     *             <code>mailto:</code> link will automatically be
     * created
     *             when the documentation is created.
     *           
     */
    public String getPost()
    {
        return this.post;
    } //-- String getPost() 

    /**
     * Get 
     *             The email address or link that can be used to
     * subscribe to the mailing list.
     *             If this is an email address, a
     *             <code>mailto:</code> link will automatically be
     * created when
     *             the documentation is created.
     *           
     */
    public String getSubscribe()
    {
        return this.subscribe;
    } //-- String getSubscribe() 

    /**
     * Get 
     *             The email address or link that can be used to
     * unsubscribe to
     *             the mailing list.  If this is an email address,
     * a
     *             <code>mailto:</code> link will automatically be
     * created
     *             when the documentation is created.
     *           
     */
    public String getUnsubscribe()
    {
        return this.unsubscribe;
    } //-- String getUnsubscribe() 

    /**
     * Method removeOtherArchive
     * 
     * @param string
     */
    public void removeOtherArchive(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "MailingList.removeOtherArchives(string) parameter must be instanceof " + String.class.getName() );
        }
        getOtherArchives().remove( string );
    } //-- void removeOtherArchive(String) 

    /**
     * Set 
     *             The link to a URL where you can browse the
     * mailing list archive.
     *           
     * 
     * @param archive
     */
    public void setArchive(String archive)
    {
        this.archive = archive;
    } //-- void setArchive(String) 

    /**
     * Set The name of the mailing list.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             The link to alternate URLs where you can browse
     * the list archive.
     *           
     * 
     * @param otherArchives
     */
    public void setOtherArchives(java.util.List otherArchives)
    {
        this.otherArchives = otherArchives;
    } //-- void setOtherArchives(java.util.List) 

    /**
     * Set 
     *             The email address or link that can be used to
     * post to
     *             the mailing list.  If this is an email address,
     * a
     *             <code>mailto:</code> link will automatically be
     * created
     *             when the documentation is created.
     *           
     * 
     * @param post
     */
    public void setPost(String post)
    {
        this.post = post;
    } //-- void setPost(String) 

    /**
     * Set 
     *             The email address or link that can be used to
     * subscribe to the mailing list.
     *             If this is an email address, a
     *             <code>mailto:</code> link will automatically be
     * created when
     *             the documentation is created.
     *           
     * 
     * @param subscribe
     */
    public void setSubscribe(String subscribe)
    {
        this.subscribe = subscribe;
    } //-- void setSubscribe(String) 

    /**
     * Set 
     *             The email address or link that can be used to
     * unsubscribe to
     *             the mailing list.  If this is an email address,
     * a
     *             <code>mailto:</code> link will automatically be
     * created
     *             when the documentation is created.
     *           
     * 
     * @param unsubscribe
     */
    public void setUnsubscribe(String unsubscribe)
    {
        this.unsubscribe = unsubscribe;
    } //-- void setUnsubscribe(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
